/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchtext;

import ghidra.app.plugin.core.searchtext.iterators.SearchAddressIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ListingDisplaySearchAddressIterator {
    private Address lastAddress;
    private Map<SearchAddressIterator, Address> lastAddressMap = new HashMap<SearchAddressIterator, Address>();
    private boolean forward;

    ListingDisplaySearchAddressIterator(Address startAddress, List<SearchAddressIterator> iterators, boolean forward) {
        this.forward = forward;
        this.updateLastAddress(startAddress);
        for (SearchAddressIterator iterator : iterators) {
            this.lastAddressMap.put(iterator, null);
        }
    }

    private void updateLastAddress(Address startAddress) {
        if (startAddress == null) {
            return;
        }
        if (this.forward) {
            if (startAddress.getOffset() > 0L) {
                this.lastAddress = startAddress.subtract(1L);
            }
        } else {
            AddressSpace addressSpace = startAddress.getAddressSpace();
            Address maxAddress = addressSpace.getMaxAddress();
            long maxOffset = maxAddress.getOffset();
            long startOffset = startAddress.getOffset();
            long result = startOffset + 1L;
            if (result > startOffset && result < maxOffset) {
                this.lastAddress = startAddress.add(1L);
            }
        }
    }

    boolean hasNext() {
        Address address = this.getAlreadyFoundNextAddress();
        if (address != null) {
            return true;
        }
        this.maybePushIteratorsForward();
        for (SearchAddressIterator iterator : this.lastAddressMap.keySet()) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return this.getAlreadyFoundNextAddress() != null;
    }

    private Address getAlreadyFoundNextAddress() {
        ArrayList<Address> addresses = new ArrayList<Address>();
        Collection<Address> values = this.lastAddressMap.values();
        for (Address address : values) {
            if (address == null) continue;
            addresses.add(address);
        }
        Collections.sort(addresses);
        if (!this.forward) {
            Collections.reverse(addresses);
        }
        for (Address address : addresses) {
            if (!this.isGreaterThanLastAddress(address)) continue;
            return address;
        }
        return null;
    }

    Address next() {
        Address address;
        this.lastAddress = address = this.maybePushIteratorsForward();
        return address;
    }

    private Address maybePushIteratorsForward() {
        Set<SearchAddressIterator> keys = this.lastAddressMap.keySet();
        for (SearchAddressIterator iterator : keys) {
            Address current = this.lastAddressMap.get(iterator);
            if (this.isGreaterThanLastAddress(current)) continue;
            Address address = this.movePastLastAddress(iterator);
            this.lastAddressMap.put(iterator, address);
        }
        return this.getAlreadyFoundNextAddress();
    }

    private Address movePastLastAddress(SearchAddressIterator iterator) {
        while (iterator.hasNext()) {
            Address address = iterator.next();
            if (!this.isGreaterThanLastAddress(address)) continue;
            return address;
        }
        return null;
    }

    private boolean isGreaterThanLastAddress(Address address) {
        if (address == null) {
            return false;
        }
        if (this.lastAddress == null) {
            return true;
        }
        if (this.forward) {
            return this.lastAddress.compareTo((Object)address) < 0;
        }
        return this.lastAddress.compareTo((Object)address) > 0;
    }
}

