/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.StackDepthFieldLocation;
import java.awt.Color;
import java.math.BigInteger;

public class StackDepthFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Stack Depth";
    private Address lastEntry = null;
    private CallDepthChangeInfo depth = null;
    private long lastModNumber = -1L;

    public StackDepthFieldFactory() {
        super(FIELD_NAME);
    }

    private StackDepthFieldFactory(FieldFormatModel model, HighlightProvider hsProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hsProvider, displayOptions, fieldOptions);
        this.color = displayOptions.getColor(OptionsGui.BYTES.getColorOptionName(), OptionsGui.BYTES.getDefaultColor());
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel newModel, HighlightProvider highlightProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new StackDepthFieldFactory(newModel, highlightProvider, (Options)displayOptions, (Options)fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Instruction)) {
            return null;
        }
        Instruction cu = (Instruction)obj;
        Function func = cu.getProgram().getListing().getFunctionContaining(cu.getMinAddress());
        if (func == null) {
            return null;
        }
        long modNumber = func.getProgram().getModificationNumber() ^ (long)cu.getProgram().hashCode();
        if (!func.getEntryPoint().equals((Object)this.lastEntry) || modNumber != this.lastModNumber) {
            this.lastModNumber = modNumber;
            this.depth = new CallDepthChangeInfo(func);
            this.lastEntry = func.getEntryPoint();
        }
        int depthChange = this.depth.getDepth(cu.getMinAddress());
        Object depthString = this.getDepthString(depthChange, cu.isInDelaySlot());
        AttributedString as = new AttributedString((String)depthString, Color.BLUE, this.getMetrics());
        Integer overrideDepth = CallDepthChangeInfo.getStackDepthChange(cu.getProgram(), cu.getMinAddress());
        if (overrideDepth != null) {
            String grows = func.getStackFrame().growsNegative() ? " - " : " + ";
            depthString = (String)depthString + grows + Integer.toString(overrideDepth, 16);
            as = new AttributedString((String)depthString, Color.RED, this.getMetrics());
        }
        TextFieldElement text = new TextFieldElement(as, 0, 0);
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)text, this.startX + varWidth, this.width, this.hlProvider);
    }

    private String getDepthString(int depthChange, boolean isInDelaySlot) {
        if (isInDelaySlot) {
            return "";
        }
        Object stringDepth = "- ? -";
        if (depthChange != Integer.MAX_VALUE && depthChange != 0x7FFFFFFE) {
            String filler;
            stringDepth = depthChange > 0 ? "-" + Integer.toString(depthChange, 16) : Integer.toString(-depthChange, 16);
            int len = ((String)stringDepth).length();
            String string = filler = depthChange < 0 ? "000" : "   ";
            if (len < 3) {
                stringDepth = filler.substring(len) + (String)stringDepth;
            }
        }
        return stringDepth;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (loc instanceof StackDepthFieldLocation) {
            StackDepthFieldLocation stackDepthLoc = (StackDepthFieldLocation)loc;
            return new FieldLocation(index, fieldNum, 0, stackDepthLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof Instruction) || row < 0 || col < 0) {
            return null;
        }
        Instruction instr = (Instruction)obj;
        return new StackDepthFieldLocation(instr.getProgram(), instr.getMinAddress(), col);
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4;
    }
}

