/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import docking.widgets.list.GListCellRenderer;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.util.MessageType;
import ghidra.util.data.DataTypeParser;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;

public class CreateTypeDefDialog
extends DialogComponentProvider {
    private final DataTypeManagerPlugin plugin;
    private final Category category;
    private JTextField nameTextField;
    private DataTypeSelectionEditor dataTypeEditor;
    private GhidraComboBox<DataTypeManager> dataTypeManagerBox;
    private boolean isCancelled;
    private final TreePath selectedTreePath;

    CreateTypeDefDialog(DataTypeManagerPlugin plugin, Category category, TreePath treePath) {
        super("Create TypeDef", true, true, true, false);
        this.plugin = plugin;
        this.category = category;
        this.selectedTreePath = treePath;
        this.addWorkPanel(this.createWorkPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    private JComponent createWorkPanel() {
        DataTypeTreeNode dataTypeTreeNode;
        ArchiveNode archiveNode;
        DataTypeManager manager;
        DataTypeManager[] dataTypeManagers;
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        panel.add((Component)new GLabel("Category:"));
        panel.add((Component)new GLabel(this.category.getCategoryPath().getPath()));
        this.nameTextField = new JTextField(15);
        panel.add((Component)new GLabel("Name:"));
        panel.add(this.nameTextField);
        this.dataTypeEditor = new DataTypeSelectionEditor((ServiceProvider)this.plugin.getTool(), DataTypeParser.AllowedDataTypes.ALL);
        panel.add((Component)new GLabel("Data type:"));
        panel.add(this.dataTypeEditor.getEditorComponent());
        this.dataTypeEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                CreateTypeDefDialog.this.setStatusText("");
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                CreateTypeDefDialog.this.setStatusText("");
            }
        });
        this.dataTypeEditor.setDefaultSelectedTreePath(this.selectedTreePath);
        this.dataTypeManagerBox = new GhidraComboBox();
        this.dataTypeManagerBox.setRenderer((ListCellRenderer)GListCellRenderer.createDefaultCellTextRenderer(dtm -> dtm.getName()));
        for (DataTypeManager manager2 : dataTypeManagers = this.plugin.getDataTypeManagers()) {
            if (manager2 instanceof BuiltInDataTypeManager) continue;
            this.dataTypeManagerBox.addToModel((Object)manager2);
        }
        DataTypeManager itemToSelect = null;
        Object lastPathComponent = this.selectedTreePath.getLastPathComponent();
        if (lastPathComponent instanceof DataTypeTreeNode && this.dataTypeManagerBox.containsItem((Object)(manager = (archiveNode = (dataTypeTreeNode = (DataTypeTreeNode)((Object)lastPathComponent)).getArchiveNode()).getArchive().getDataTypeManager()))) {
            itemToSelect = manager;
        }
        this.dataTypeManagerBox.setSelectedItem(itemToSelect);
        panel.add((Component)new GLabel("Archive:"));
        panel.add((Component)this.dataTypeManagerBox);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        return panel;
    }

    protected void okCallback() {
        String name = this.nameTextField.getText();
        if (name == null || name.isEmpty()) {
            this.setStatusText("Name required", MessageType.ERROR);
            return;
        }
        if (!DataUtilities.isValidDataTypeName((String)name)) {
            this.setStatusText("Invalidate data type name: " + name, MessageType.ERROR);
            return;
        }
        String dtTextValue = this.dataTypeEditor.getCellEditorValueAsText();
        if (dtTextValue == null || dtTextValue.isEmpty()) {
            this.setStatusText("Data type required" + dtTextValue, MessageType.ERROR);
            return;
        }
        try {
            if (!this.dataTypeEditor.validateUserSelection()) {
                this.setStatusText("Invalidate data type: " + dtTextValue, MessageType.ERROR);
                return;
            }
        }
        catch (InvalidDataTypeException e) {
            this.setStatusText("Invalidate data type: " + dtTextValue, MessageType.ERROR);
            return;
        }
        DataType dataType = this.getDataType();
        if (!DataTypeManagerPlugin.isValidTypeDefBaseType(this.getComponent(), dataType)) {
            this.setStatusText("Data type cannot be source of a typedef: " + dataType.getName(), MessageType.ERROR);
            return;
        }
        DataTypeManager manager = (DataTypeManager)this.dataTypeManagerBox.getSelectedItem();
        if (manager == null) {
            this.setStatusText("Must select an archive", MessageType.ERROR);
            return;
        }
        this.clearStatusText();
        this.close();
    }

    protected void cancelCallback() {
        super.cancelCallback();
        this.isCancelled = true;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    String getTypeDefName() {
        if (this.isCancelled) {
            return null;
        }
        return this.nameTextField.getText();
    }

    DataType getDataType() {
        DataType dataType = (DataType)this.dataTypeEditor.getCellEditorValue();
        if (dataType instanceof FunctionDefinition) {
            DataTypeManager dataTypeManager = dataType.getDataTypeManager();
            dataType = PointerDataType.getPointer((DataType)dataType, (DataTypeManager)dataTypeManager);
        }
        return dataType;
    }

    DataTypeManager getDataTypeManager() {
        return (DataTypeManager)this.dataTypeManagerBox.getSelectedItem();
    }
}

