/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clear;

import ghidra.program.model.symbol.SourceType;
import java.util.HashSet;
import java.util.Set;

public class ClearOptions {
    private boolean code;
    private boolean symbols;
    private boolean comments;
    private boolean properties;
    private boolean functions;
    private boolean registers;
    private boolean equates;
    private boolean userReferences;
    private boolean analysisReferences;
    private boolean importReferences;
    private boolean defaultReferences;
    private boolean bookmarks;

    public ClearOptions() {
        this(true);
    }

    public ClearOptions(boolean defaultClearValue) {
        this(defaultClearValue, defaultClearValue, defaultClearValue, defaultClearValue, defaultClearValue, defaultClearValue, defaultClearValue, defaultClearValue, defaultClearValue, defaultClearValue, defaultClearValue, defaultClearValue);
    }

    private ClearOptions(boolean code, boolean symbols, boolean comments, boolean properties, boolean functions, boolean registers, boolean equates, boolean userReferences, boolean analysisReferences, boolean importReferences, boolean defaultReferences, boolean bookmarks) {
        this.code = code;
        this.symbols = symbols;
        this.comments = comments;
        this.properties = properties;
        this.functions = functions;
        this.registers = registers;
        this.equates = equates;
        this.userReferences = userReferences;
        this.analysisReferences = analysisReferences;
        this.importReferences = importReferences;
        this.defaultReferences = defaultReferences;
        this.bookmarks = bookmarks;
    }

    public void setClearCode(boolean code) {
        this.code = code;
    }

    public void setClearSymbols(boolean symbols) {
        this.symbols = symbols;
    }

    public void setClearComments(boolean comments) {
        this.comments = comments;
    }

    public void setClearProperties(boolean properties) {
        this.properties = properties;
    }

    public void setClearFunctions(boolean functions) {
        this.functions = functions;
    }

    public void setClearRegisters(boolean registers) {
        this.registers = registers;
    }

    public void setClearEquates(boolean equates) {
        this.equates = equates;
    }

    public void setClearUserReferences(boolean userReferences) {
        this.userReferences = userReferences;
    }

    public void setClearAnalysisReferences(boolean analysisReferences) {
        this.analysisReferences = analysisReferences;
    }

    public void setClearImportReferences(boolean importReferences) {
        this.importReferences = importReferences;
    }

    public void setClearDefaultReferences(boolean defaultReferences) {
        this.defaultReferences = defaultReferences;
    }

    public void setClearBookmarks(boolean bookmarks) {
        this.bookmarks = bookmarks;
    }

    boolean clearCode() {
        return this.code;
    }

    boolean clearComments() {
        return this.comments;
    }

    boolean clearProperties() {
        return this.properties;
    }

    boolean clearSymbols() {
        return this.symbols;
    }

    boolean clearFunctions() {
        return this.functions;
    }

    boolean clearRegisters() {
        return this.registers;
    }

    boolean clearEquates() {
        return this.equates;
    }

    boolean clearUserReferences() {
        return this.userReferences;
    }

    boolean clearAnalysisReferences() {
        return this.analysisReferences;
    }

    boolean clearImportReferences() {
        return this.importReferences;
    }

    boolean clearDefaultReferences() {
        return this.defaultReferences;
    }

    boolean clearBookmarks() {
        return this.bookmarks;
    }

    Set<SourceType> getReferenceSourceTypesToClear() {
        HashSet<SourceType> sourceTypesToClear = new HashSet<SourceType>();
        if (this.clearUserReferences()) {
            sourceTypesToClear.add(SourceType.USER_DEFINED);
        }
        if (this.clearDefaultReferences()) {
            sourceTypesToClear.add(SourceType.DEFAULT);
        }
        if (this.clearImportReferences()) {
            sourceTypesToClear.add(SourceType.IMPORTED);
        }
        if (this.clearAnalysisReferences()) {
            sourceTypesToClear.add(SourceType.ANALYSIS);
        }
        return sourceTypesToClear;
    }

    boolean clearAny() {
        return this.code || this.symbols || this.comments || this.properties || this.functions || this.registers || this.equates || this.userReferences || this.analysisReferences || this.importReferences || this.defaultReferences || this.bookmarks;
    }
}

