/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.util.HashMap;
import java.util.Map;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;

final class RendererCSS {
    private static Map<String, Float> UNIT_FACTOR = new HashMap<String, Float>();

    RendererCSS() {
    }

    public static int getTopMargin(Element element, int defaultValue) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.top, defaultValue);
    }

    public static int getBottomMargin(Element element, int defaultValue) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.bottom, defaultValue);
    }

    public static int getLeftMargin(Element element, int defaultValue) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.left, defaultValue);
    }

    public static int getRightMargin(Element element, int defaultValue) {
        return RendererCSS.getMargin(RendererCSS.get(element), Side.right, defaultValue);
    }

    private static String get(Element element) {
        return element.getAttributeValue("style");
    }

    private static int getMargin(String css, Side side, int defaultValue) {
        if (css == null) {
            return defaultValue;
        }
        String[] styles = css.split(";");
        for (int i = 0; i < styles.length; ++i) {
            styles[i] = styles[i].toLowerCase().trim();
        }
        int margin = RendererCSS.getStyleValue(styles, side, "margin");
        int padding = RendererCSS.getStyleValue(styles, side, "padding");
        if (margin == -1) {
            return padding != -1 ? padding : defaultValue;
        }
        return padding != -1 ? margin + padding : margin;
    }

    private static int getStyleValue(String[] styles, Side side, String styleName) {
        int combinedStyleValue = -1;
        for (int i = 0; i < styles.length; ++i) {
            String styleValue;
            int colonPos;
            String style = styles[i];
            if (style.length() <= styleName.length() + 1 || !style.startsWith(styleName) || (colonPos = style.indexOf(58)) == -1 || (styleValue = style.substring(colonPos + 1).trim()).length() == 0) continue;
            boolean explicitSide = false;
            int styleNameEnd = styleName.length();
            if (style.charAt(styleName.length()) == '-' && style.startsWith(side.name(), styleName.length() + 1)) {
                explicitSide = true;
                styleNameEnd = styleName.length() + 1 + side.name().length();
                if (style.length() <= styleNameEnd + 1) continue;
            }
            if (styleNameEnd != colonPos && !Segment.isWhiteSpace(style.charAt(styleNameEnd))) continue;
            if (!explicitSide) {
                String[] styleValueItems = styleValue.split("\\s+");
                int itemIndex = side.ordinal();
                int itemCount = styleValueItems.length;
                if (itemCount == 0) continue;
                if (itemCount == 1) {
                    itemIndex = 0;
                } else if (itemCount == 2) {
                    itemIndex = side.ordinal() % 2;
                } else if (itemCount == 3 && side == Side.left) {
                    itemIndex = 1;
                }
                styleValue = styleValueItems[itemIndex].trim();
            }
            int value = 0;
            if (styleValue.length() == 0 || styleValue.charAt(styleValue.length() - 1) == '%' || styleValue.equals("auto") || styleValue.equals("inherit")) continue;
            if (styleValue.length() < 3) {
                if (!styleValue.equals("0")) {
                    continue;
                }
            } else {
                float rawValue;
                Float unitFactor = UNIT_FACTOR.get(styleValue.substring(styleValue.length() - 2));
                if (unitFactor == null) continue;
                try {
                    rawValue = Float.parseFloat(styleValue.substring(0, styleValue.length() - 2));
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                value = Math.round(rawValue * unitFactor.floatValue());
            }
            if (explicitSide) {
                return value;
            }
            combinedStyleValue = value;
        }
        return combinedStyleValue;
    }

    static {
        UNIT_FACTOR.put("em", Float.valueOf(1.0f));
        UNIT_FACTOR.put("ex", Float.valueOf(1.0f));
        UNIT_FACTOR.put("px", Float.valueOf(0.125f));
        UNIT_FACTOR.put("in", Float.valueOf(8.0f));
        UNIT_FACTOR.put("cm", Float.valueOf(3.0f));
        UNIT_FACTOR.put("mm", Float.valueOf(0.3f));
        UNIT_FACTOR.put("pt", Float.valueOf(0.1f));
        UNIT_FACTOR.put("pc", Float.valueOf(1.2f));
    }

    private static enum Side {
        top,
        right,
        bottom,
        left;

    }
}

