/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import net.htmlparser.jericho.ParseText;

class CharSequenceParseText
implements ParseText {
    private final CharSequence charSequence;

    CharSequenceParseText(CharSequence charSequence) {
        this.charSequence = charSequence;
    }

    @Override
    public final char charAt(int index) {
        char ch = this.internalCharAt(index);
        if (ch == '\uffff' && this.atEndOfStream()) {
            throw new IndexOutOfBoundsException();
        }
        return ch;
    }

    private char internalCharAt(int index) {
        char ch = this.charSequence.charAt(index);
        return ch >= 'A' && ch <= 'Z' ? (char)(ch ^ 0x20) : ch;
    }

    @Override
    public final boolean containsAt(String str, int pos) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = this.internalCharAt(pos + i);
            if (ch == '\uffff' && this.atEndOfStream()) {
                return false;
            }
            if (str.charAt(i) == ch) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int indexOf(char searchChar, int fromIndex) {
        return this.indexOf(searchChar, fromIndex, -1);
    }

    @Override
    public final int indexOf(char searchChar, int fromIndex, int breakAtIndex) {
        int i;
        int actualBreakAtIndex = breakAtIndex == -1 || breakAtIndex > this.getEnd() ? this.getEnd() : breakAtIndex;
        int n = i = fromIndex < 0 ? 0 : fromIndex;
        while (i < actualBreakAtIndex) {
            char ch = this.internalCharAt(i);
            if (ch == searchChar) {
                return i;
            }
            if (ch == '\uffff' && this.atEndOfStream()) break;
            ++i;
        }
        return -1;
    }

    protected boolean atEndOfStream() {
        return false;
    }

    @Override
    public final int indexOf(String searchString, int fromIndex) {
        return this.indexOf(searchString, fromIndex, -1);
    }

    @Override
    public final int indexOf(String searchString, int fromIndex, int breakAtIndex) {
        char ch;
        int i;
        if (searchString.length() == 1) {
            return this.indexOf(searchString.charAt(0), fromIndex, breakAtIndex);
        }
        if (searchString.length() == 0) {
            return fromIndex;
        }
        char firstChar = searchString.charAt(0);
        int lastPossibleBreakAtIndex = this.getEnd() - searchString.length() + 1;
        int actualBreakAtIndex = breakAtIndex == -1 || breakAtIndex > lastPossibleBreakAtIndex ? lastPossibleBreakAtIndex : breakAtIndex;
        int n = i = fromIndex < 0 ? 0 : fromIndex;
        while (!(i >= actualBreakAtIndex || (ch = this.internalCharAt(i)) == '\uffff' && this.atEndOfStream())) {
            block6: {
                if (ch == firstChar) {
                    for (int j = 1; j < searchString.length(); ++j) {
                        char ch2 = this.internalCharAt(j + i);
                        if (!(ch == '\uffff' && this.atEndOfStream() || searchString.charAt(j) != ch2)) {
                            continue;
                        }
                        break block6;
                    }
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(char searchChar, int fromIndex) {
        return this.lastIndexOf(searchChar, fromIndex, -1);
    }

    @Override
    public final int lastIndexOf(char searchChar, int fromIndex, int breakAtIndex) {
        int i;
        int n = i = fromIndex > this.getEnd() ? this.getEnd() : fromIndex;
        while (i > breakAtIndex) {
            if (this.internalCharAt(i) == searchChar) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(String searchString, int fromIndex) {
        return this.lastIndexOf(searchString, fromIndex, -1);
    }

    @Override
    public final int lastIndexOf(String searchString, int fromIndex, int breakAtIndex) {
        if (searchString.length() == 1) {
            return this.lastIndexOf(searchString.charAt(0), fromIndex, breakAtIndex);
        }
        if (searchString.length() == 0) {
            return fromIndex;
        }
        int rightIndex = this.getEnd() - searchString.length();
        if (breakAtIndex > rightIndex) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        int lastCharIndex = searchString.length() - 1;
        char lastChar = searchString.charAt(lastCharIndex);
        int actualBreakAtPos = breakAtIndex + lastCharIndex;
        block0: for (int i = fromIndex + lastCharIndex; i > actualBreakAtPos; --i) {
            if (this.internalCharAt(i) != lastChar) continue;
            int startIndex = i - lastCharIndex;
            for (int j = lastCharIndex - 1; j >= 0; --j) {
                if (searchString.charAt(j) != this.internalCharAt(j + startIndex)) continue block0;
            }
            return startIndex;
        }
        return -1;
    }

    @Override
    public final int length() {
        return this.charSequence.length();
    }

    @Override
    public final CharSequence subSequence(int begin, int end) {
        return this.substring(begin, end);
    }

    @Override
    public final String toString() {
        return this.charSequence.toString();
    }

    protected int getEnd() {
        return this.charSequence.length();
    }

    protected String substring(int begin, int end) {
        return this.charSequence.subSequence(begin, end).toString().toLowerCase();
    }
}

