/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Compression.LZ;

import java.io.IOException;
import java.io.OutputStream;

public class OutWindow {
    byte[] _buffer;
    byte[] _buffer2 = null;
    int _bufferPos2 = 0;
    int _pos;
    int _windowSize = 0;
    int _streamPos;
    OutputStream _stream;
    long _processedSize;

    public void Create(int n) {
        if (n < 1) {
            n = 1;
        }
        if (this._buffer == null || this._windowSize != n) {
            this._buffer = new byte[n];
        }
        this._windowSize = n;
        this._pos = 0;
        this._streamPos = 0;
    }

    public void SetStream(OutputStream outputStream) throws IOException {
        this.ReleaseStream();
        this._stream = outputStream;
    }

    public void ReleaseStream() throws IOException {
        this.Flush();
        this._stream = null;
    }

    public void SetMemStream(byte[] byArray) {
        this._buffer2 = byArray;
        this._bufferPos2 = 0;
    }

    public void Init() {
        this.Init(false);
    }

    public void Init(boolean bl) {
        this._processedSize = 0L;
        if (!bl) {
            this._streamPos = 0;
            this._pos = 0;
        }
    }

    public void Flush() throws IOException {
        int n = this._pos - this._streamPos;
        if (n == 0) {
            return;
        }
        if (this._stream != null) {
            this._stream.write(this._buffer, this._streamPos, n);
        }
        if (this._buffer2 != null) {
            System.arraycopy(this._buffer, this._streamPos, this._buffer2, this._bufferPos2, n);
            this._bufferPos2 += n;
        }
        if (this._pos >= this._windowSize) {
            this._pos = 0;
        }
        this._streamPos = this._pos;
    }

    public void CopyBlock(int n, int n2) throws IOException {
        int n3 = this._pos - n - 1;
        if (n3 < 0) {
            n3 += this._windowSize;
        }
        while (n2 != 0) {
            if (n3 >= this._windowSize) {
                n3 = 0;
            }
            this._buffer[this._pos++] = this._buffer[n3++];
            ++this._processedSize;
            if (this._pos >= this._windowSize) {
                this.Flush();
            }
            --n2;
        }
    }

    public void PutByte(byte by) throws IOException {
        this._buffer[this._pos++] = by;
        ++this._processedSize;
        if (this._pos >= this._windowSize) {
            this.Flush();
        }
    }

    public void WriteByte(int n) throws IOException {
        this._buffer[this._pos++] = (byte)n;
        ++this._processedSize;
        if (this._pos >= this._windowSize) {
            this.Flush();
        }
    }

    public byte GetByte(int n) {
        int n2 = this._pos - n - 1;
        if (n2 < 0) {
            n2 += this._windowSize;
        }
        return this._buffer[n2];
    }

    public long GetProcessedSize() {
        return this._processedSize;
    }
}

