/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Common;

import java.io.IOException;
import java.io.InputStream;

public class InBuffer {
    int _bufferPos;
    int _bufferLimit;
    byte[] _bufferBase;
    InputStream _stream = null;
    long _processedSize;
    int _bufferSize;
    boolean _wasFinished;

    public void Create(int n) {
        if (n < 1) {
            n = 1;
        }
        if (this._bufferBase != null && this._bufferSize == n) {
            return;
        }
        this.Free();
        this._bufferSize = n;
        this._bufferBase = new byte[n];
    }

    void Free() {
        this._bufferBase = null;
    }

    public void SetStream(InputStream inputStream) {
        this._stream = inputStream;
    }

    public void Init() {
        this._processedSize = 0L;
        this._bufferPos = 0;
        this._bufferLimit = 0;
        this._wasFinished = false;
    }

    public void ReleaseStream() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
        this._stream = null;
    }

    public int read() throws IOException {
        if (this._bufferPos >= this._bufferLimit) {
            return this.ReadBlock2();
        }
        return this._bufferBase[this._bufferPos++] & 0xFF;
    }

    public boolean ReadBlock() throws IOException {
        if (this._wasFinished) {
            return false;
        }
        this._processedSize += (long)this._bufferPos;
        int n = this._stream.read(this._bufferBase, 0, this._bufferSize);
        if (n == -1) {
            n = 0;
        }
        this._bufferPos = 0;
        this._bufferLimit = n;
        this._wasFinished = n == 0;
        return !this._wasFinished;
    }

    public int ReadBlock2() throws IOException {
        if (!this.ReadBlock()) {
            return -1;
        }
        return this._bufferBase[this._bufferPos++] & 0xFF;
    }

    public long GetProcessedSize() {
        return this._processedSize + (long)this._bufferPos;
    }

    public boolean WasFinished() {
        return this._wasFinished;
    }
}

