/*
 * Decompiled with CFR 0.152.
 */
package example;

import com.pff.PSTActivity;
import com.pff.PSTAttachment;
import com.pff.PSTContact;
import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTFolder;
import com.pff.PSTMessage;
import com.pff.PSTMessageStore;
import com.pff.PSTRss;
import com.pff.PSTTask;
import example.EmailTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TestGui
implements ActionListener {
    private PSTFile pstFile;
    private EmailTableModel emailTableModel;
    private JTextPane emailText;
    private JPanel emailPanel;
    private JPanel attachPanel;
    private JLabel attachLabel;
    private JTextField attachText;
    private PSTMessage selectedMessage;
    private JFrame f = new JFrame("PST Browser");

    public TestGui() throws PSTException, IOException {
        try {
            String filename = "Outlook-new.pst";
            filename = "G:\\From old Tower\\pff\\java\\Old Email.pst";
            this.pstFile = new PSTFile(filename);
        }
        catch (Exception err) {
            err.printStackTrace();
            System.exit(1);
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.pstFile.getMessageStore());
        try {
            this.buildTree(top, this.pstFile.getRootFolder());
        }
        catch (Exception err) {
            err.printStackTrace();
            System.exit(1);
        }
        final JTree folderTree = new JTree(top){

            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode nodeValue = (DefaultMutableTreeNode)value;
                if (nodeValue.getUserObject() instanceof PSTFolder) {
                    PSTFolder folderValue = (PSTFolder)nodeValue.getUserObject();
                    return folderValue.getDescriptorNodeId() + " - " + folderValue.getDisplayName() + " " + folderValue.getAssociateContentCount() + "";
                }
                if (nodeValue.getUserObject() instanceof PSTMessageStore) {
                    PSTMessageStore folderValue = (PSTMessageStore)nodeValue.getUserObject();
                    return folderValue.getDisplayName();
                }
                return value.toString();
            }
        };
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(renderer.getDefaultClosedIcon());
        folderTree.setCellRenderer(renderer);
        folderTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)folderTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node.getUserObject() instanceof PSTFolder) {
                    PSTFolder folderValue = (PSTFolder)node.getUserObject();
                    try {
                        TestGui.this.selectFolder(folderValue);
                    }
                    catch (Exception err) {
                        System.out.println("unable to change folder");
                        err.printStackTrace();
                    }
                }
            }
        });
        JScrollPane treePane = new JScrollPane(folderTree);
        JScrollPane emailTablePanel = null;
        try {
            this.emailTableModel = new EmailTableModel(this.pstFile.getRootFolder(), this.pstFile);
            final JTable emailTable = new JTable(this.emailTableModel);
            emailTablePanel = new JScrollPane(emailTable);
            emailTable.setFillsViewportHeight(true);
            ListSelectionModel selectionModel = emailTable.getSelectionModel();
            selectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    JTable source = emailTable;
                    TestGui.this.selectedMessage = TestGui.this.emailTableModel.getMessageAtRow(source.getSelectedRow());
                    if (TestGui.this.selectedMessage instanceof PSTContact) {
                        PSTContact contact = (PSTContact)TestGui.this.selectedMessage;
                        TestGui.this.emailText.setText(contact.toString());
                    } else if (TestGui.this.selectedMessage instanceof PSTTask) {
                        PSTTask task = (PSTTask)TestGui.this.selectedMessage;
                        TestGui.this.emailText.setText(task.toString());
                    } else if (TestGui.this.selectedMessage instanceof PSTActivity) {
                        PSTActivity journalEntry = (PSTActivity)TestGui.this.selectedMessage;
                        TestGui.this.emailText.setText(journalEntry.toString());
                    } else if (TestGui.this.selectedMessage instanceof PSTRss) {
                        PSTRss rss = (PSTRss)TestGui.this.selectedMessage;
                        TestGui.this.emailText.setText(rss.toString());
                    } else if (TestGui.this.selectedMessage != null) {
                        TestGui.this.emailText.setText(TestGui.this.selectedMessage.getBody());
                    }
                    TestGui.this.setAttachmentText();
                    TestGui.this.emailText.setCaretPosition(0);
                }
            });
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        this.f.setJMenuBar(this.createMenu());
        this.emailText = new JTextPane();
        this.emailText.setFont(new Font("Monospaced", 0, 12));
        this.emailPanel = new JPanel(new BorderLayout());
        this.attachPanel = new JPanel(new BorderLayout());
        this.attachLabel = new JLabel("Attachments:");
        this.attachText = new JTextField("");
        this.attachText.setEditable(false);
        this.attachPanel.add((Component)this.attachLabel, "West");
        this.attachPanel.add((Component)this.attachText, "Center");
        this.emailPanel.add((Component)this.attachPanel, "North");
        this.emailPanel.add((Component)this.emailText, "Center");
        JSplitPane emailSplitPane = new JSplitPane(0, emailTablePanel, new JScrollPane(this.emailPanel));
        emailSplitPane.setOneTouchExpandable(true);
        emailSplitPane.setDividerLocation(0.25);
        JSplitPane primaryPane = new JSplitPane(1, treePane, emailSplitPane);
        primaryPane.setOneTouchExpandable(true);
        primaryPane.setDividerLocation(0.3);
        this.f.add(primaryPane);
        this.f.setDefaultCloseOperation(2);
        this.f.setVisible(true);
        this.f.setExtendedState(this.f.getExtendedState() | 6);
    }

    private void buildTree(DefaultMutableTreeNode top, PSTFolder theFolder) {
        try {
            Vector<PSTFolder> children = theFolder.getSubFolders();
            for (PSTFolder folder : children) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(folder);
                if (folder.getSubFolders().size() > 0) {
                    this.buildTree(node, folder);
                }
                top.add(node);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            System.exit(1);
        }
    }

    void setAttachmentText() {
        StringBuffer s = new StringBuffer();
        try {
            if (this.selectedMessage != null) {
                int numAttach = this.selectedMessage.getNumberOfAttachments();
                for (int x = 0; x < numAttach; ++x) {
                    PSTAttachment attach = this.selectedMessage.getAttachment(x);
                    String filename = attach.getLongFilename();
                    if (filename.isEmpty()) {
                        filename = attach.getFilename();
                    }
                    if (filename.isEmpty()) continue;
                    if (x != 0) {
                        s.append(", ");
                    }
                    s.append(filename);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.attachText.setText(s.toString());
    }

    void selectFolder(PSTFolder folder) throws IOException, PSTException {
        this.emailTableModel.setFolder(folder);
    }

    public JMenuBar createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Save Attachments", 83);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menuBar;
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText() == "Save Attachments") {
            this.saveAttachments();
        }
    }

    private void saveAttachments() {
        if (this.selectedMessage != null) {
            int numAttach = this.selectedMessage.getNumberOfAttachments();
            if (numAttach == 0) {
                JOptionPane.showMessageDialog(this.f, "Email has no attachments");
                return;
            }
            try {
                for (int x = 0; x < numAttach; ++x) {
                    PSTAttachment attach = this.selectedMessage.getAttachment(x);
                    InputStream attachmentStream = attach.getFileInputStream();
                    String filename = attach.getLongFilename();
                    if (filename.isEmpty()) {
                        filename = attach.getFilename();
                    }
                    JFileChooser chooser = new JFileChooser();
                    chooser.setSelectedFile(new File(filename));
                    int r = chooser.showSaveDialog(this.f);
                    if (r == 0) {
                        int count;
                        FileOutputStream out = new FileOutputStream(chooser.getSelectedFile());
                        int bufferSize = 8176;
                        byte[] buffer = new byte[bufferSize];
                        do {
                            count = attachmentStream.read(buffer);
                            out.write(buffer, 0, count);
                        } while (count == bufferSize);
                        out.close();
                    }
                    attachmentStream.close();
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.f, "Failed writing to file");
            }
            catch (PSTException pste) {
                JOptionPane.showMessageDialog(this.f, "Error in PST file");
            }
        }
    }

    public static void main(String[] args) throws PSTException, IOException {
        new TestGui();
    }
}

