/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats.plot;

import java.util.ArrayList;

public class GoogleLineChart {
    boolean stacked = false;
    int width = 1200;
    int height = 800;
    String title = "";
    String vAxis = "";
    String hAxis = "";
    ArrayList<String> columnTitltes;
    ArrayList<String> xLables;
    ArrayList<ArrayList<String>> columns;
    String id;

    public GoogleLineChart(String title) {
        this.title = title;
        this.init();
    }

    public GoogleLineChart(String title, int width, int height) {
        this.title = title;
        this.width = width;
        this.height = height;
        this.init();
    }

    public void addColumn(String colTitle, ArrayList<String> columnValues) {
        this.columns.add(columnValues);
        this.columnTitltes.add(colTitle);
    }

    public void addColumn(String colTitle, int[] columnValues) {
        ArrayList<String> columnValuesStr = new ArrayList<String>();
        for (int cv : columnValues) {
            columnValuesStr.add("" + cv);
        }
        this.columns.add(columnValuesStr);
        this.columnTitltes.add(colTitle);
    }

    String getValue(int i, int j) {
        if (j >= this.columns.size()) {
            return null;
        }
        ArrayList<String> col = this.columns.get(j);
        if (i >= col.size()) {
            return null;
        }
        return col.get(i);
    }

    String getXLabel(int idx) {
        if (idx >= this.xLables.size()) {
            return null;
        }
        return this.xLables.get(idx);
    }

    void init() {
        this.columnTitltes = new ArrayList();
        this.xLables = new ArrayList();
        this.columns = new ArrayList();
        this.id = "chart_" + Double.toString(Math.random()).substring(2);
    }

    int maxColumnLength() {
        int size2 = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            size2 = Math.max(size2, this.columns.get(i).size());
        }
        return size2;
    }

    public void sethAxis(String hAxis) {
        this.hAxis = hAxis;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setvAxis(String vAxis) {
        this.vAxis = vAxis;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setxLables(ArrayList<String> xLables) {
        this.xLables = xLables;
    }

    public String toStringHtmlBody() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div id=\"visualization_" + this.id + "\" style=\"width: " + this.width + "px; height: " + this.height + "px;\"></div>\n");
        return sb.toString();
    }

    public String toStringHtmlHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("<script type=\"text/javascript\" src=\"http://www.google.com/jsapi\"></script>");
        sb.append("<script type=\"text/javascript\"> google.load('visualization', '1', {packages: ['corechart']}); </script>\n");
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("\tfunction draw_" + this.id + "() {\n");
        sb.append("\t\tvar data = google.visualization.arrayToDataTable([\n");
        sb.append("\t[ '' , ");
        int i = 0;
        for (String ct : this.columnTitltes) {
            sb.append((i > 0 ? "," : "") + "'" + ct + "'");
            ++i;
        }
        sb.append("]\n");
        int maxLen = this.maxColumnLength();
        for (i = 0; i < maxLen; ++i) {
            String lab = this.getXLabel(i);
            if (lab != null) {
                lab = "'" + lab + "'";
            }
            sb.append("\t,[ " + lab);
            for (int j = 0; j < this.columns.size(); ++j) {
                sb.append("," + this.getValue(i, j));
            }
            sb.append("]\n");
        }
        sb.append("\t\t]);\n");
        sb.append("\t\tvar ac = new google.visualization.AreaChart(document.getElementById('visualization_" + this.id + "'));\n");
        sb.append("\t\tac.draw(data, { title : '" + this.title + "', isStacked: " + this.stacked + ", width: " + this.width + ", height: " + this.height + ", vAxis: {title: \"" + this.vAxis + "\"}, hAxis: {title: \"" + this.hAxis + "\"} });\n");
        sb.append("\t\t}\n");
        sb.append("\tgoogle.setOnLoadCallback(draw_" + this.id + ");\n");
        sb.append("</script>\n");
        sb.append("\n");
        return sb.toString();
    }
}

