/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationProteinInteraction
extends TestCasesIntegrationBase {
    @Test
    public void test_01_within_protein_interactions() {
        Gpr.debug("Test");
        List<VcfEntry> vcfEntries = this.snpEffect("testHg19Pdb", "tests/test_interaction_01.vcf", null, null);
        HashMap<String, Boolean> expectedIds = new HashMap<String, Boolean>();
        expectedIds.put("1A12:A_25-A_136:NM_001048199.2", false);
        expectedIds.put("1A12:B_25-B_136:NM_001048199.2", false);
        expectedIds.put("1A12:C_25-C_136:NM_001048199.2", false);
        expectedIds.put("1A12:A_25-A_136:NM_001269.4", false);
        expectedIds.put("1A12:B_25-B_136:NM_001269.4", false);
        expectedIds.put("1A12:C_25-C_136:NM_001269.4", false);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            int countPi = 0;
            for (VcfEffect veff : ve.getVcfEffects()) {
                String id;
                if (this.verbose) {
                    System.out.println("\t" + (Object)((Object)veff.getEffectType()) + "\t" + veff);
                }
                if (veff.getEffectType() != EffectType.PROTEIN_STRUCTURAL_INTERACTION_LOCUS) continue;
                if (this.verbose) {
                    System.out.println("FOUND\t" + (Object)((Object)veff.getEffectType()) + "\t" + veff);
                }
                if (expectedIds.containsKey(id = veff.getFeatureId())) {
                    ++countPi;
                    expectedIds.put(id, true);
                    continue;
                }
                if (!this.verbose) continue;
                System.err.println("Found additional ID '" + id + "'");
            }
            Assert.assertTrue("No protein interaction effect found", countPi > 0);
            for (String id : expectedIds.keySet()) {
                Assert.assertTrue("Interaction not found: " + id, (Boolean)expectedIds.get(id));
            }
        }
    }

    @Test
    public void test_02_protein_protein_interactions() {
        Gpr.debug("Test");
        List<VcfEntry> vcfEntries = this.snpEffect("testHg19Pdb", "tests/test_interaction_02.vcf", null, null);
        HashMap<String, Boolean> expectedIds = new HashMap<String, Boolean>();
        expectedIds.put("4OVU:A_7-B_479:NM_006218.2-NM_181523.2", false);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            int countPi = 0;
            for (VcfEffect veff : ve.getVcfEffects()) {
                String id;
                if (this.verbose) {
                    System.out.println("\t" + (Object)((Object)veff.getEffectType()) + "\t" + veff);
                }
                if (this.verbose) {
                    System.out.println("EFF\t" + (Object)((Object)veff.getEffectType()) + "\t" + veff);
                }
                if (veff.getEffectType() != EffectType.PROTEIN_PROTEIN_INTERACTION_LOCUS) continue;
                if (this.verbose) {
                    System.out.println("FOUND\t" + (Object)((Object)veff.getEffectType()) + "\t" + veff);
                }
                if (expectedIds.containsKey(id = veff.getFeatureId())) {
                    ++countPi;
                    expectedIds.put(id, true);
                    continue;
                }
                if (!this.verbose) continue;
                System.err.println("Found additional ID '" + id + "'");
            }
            Assert.assertTrue("No protein interaction effect found", countPi > 0);
            for (String id : expectedIds.keySet()) {
                Assert.assertTrue("Interaction not found: " + id, (Boolean)expectedIds.get(id));
            }
        }
    }

    @Test
    public void test_03_protein_protein_interactions_hgvs() {
        Gpr.debug("Test");
        String[] args = new String[]{"-canon"};
        List<VcfEntry> vcfEntries = this.snpEffect("testHg19Chr22", "tests/test_interaction_03.vcf", args, null);
        boolean foundPi = false;
        boolean foundFs = false;
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            int countPi = 0;
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (this.verbose) {
                    System.out.println("\tEFF\t" + (Object)((Object)veff.getEffectType()) + "\t" + veff);
                }
                if (veff.getEffectType() == EffectType.PROTEIN_STRUCTURAL_INTERACTION_LOCUS) {
                    ++countPi;
                    Assert.assertTrue("Expected HGVS.c possition does not match", veff.getHgvsDna().startsWith("c.679"));
                    Assert.assertTrue("Expected HGVS.p possition does not match", veff.getFeatureId().startsWith("1H4R:A_227") || veff.getFeatureId().startsWith("1H4R:B_227"));
                    foundPi = true;
                    continue;
                }
                if (veff.getEffectType() != EffectType.FRAME_SHIFT) continue;
                Assert.assertTrue("Expected HGVS.c possition does not match", veff.getHgvsDna().startsWith("c.683"));
                Assert.assertTrue("Expected HGVS.p possition does not match", veff.getHgvsProt().startsWith("p.Lys228"));
                foundFs = true;
            }
            if (ve.isSingleSnp()) {
                Assert.assertTrue("No interactions found", countPi > 0);
                continue;
            }
            Assert.assertFalse("There should be no interactions", countPi > 0);
        }
        Assert.assertTrue("Interaction term not found", foundPi);
        Assert.assertTrue("Frameshift term not found", foundFs);
    }
}

