/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.motif;

import java.util.HashMap;
import java.util.Iterator;
import org.snpeff.motif.Pwm;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class Jaspar
implements Iterable<Pwm> {
    boolean verbose = false;
    HashMap<String, Pwm> pwms;

    public Pwm getPwm(String pwmId) {
        return this.pwms.get(pwmId);
    }

    @Override
    public Iterator<Pwm> iterator() {
        return this.pwms.values().iterator();
    }

    public void load(String jasparMatrixFile) {
        this.pwms = new HashMap();
        if (this.verbose) {
            Timer.showStdErr("Loading jaspar matrix from file " + jasparMatrixFile);
        }
        String[] lines2 = Gpr.readFile(jasparMatrixFile, true).split("\n");
        int i = 0;
        while (i < lines2.length) {
            String name = lines2[i++];
            String id = "";
            if (!name.startsWith(">")) {
                throw new RuntimeException("Error: Name line does not start with '>' : " + name);
            }
            String[] nameSplit = name.substring(1).split("\\s");
            id = nameSplit[0];
            name = nameSplit[1];
            int[] weightsA = this.parseWeights(lines2[i++], "A");
            int[] weightsC = this.parseWeights(lines2[i++], "C");
            int[] weightsG = this.parseWeights(lines2[i++], "G");
            int[] weightsT = this.parseWeights(lines2[i++], "T");
            if (weightsA.length != weightsC.length) {
                throw new RuntimeException("Weight lengths differ: " + weightsA.length + ", " + weightsC.length + ", " + weightsG.length + ", " + weightsT.length);
            }
            Pwm pwm = new Pwm(weightsA.length);
            pwm.setName(name);
            pwm.setId(id);
            pwm.setCounts('A', weightsA);
            pwm.setCounts('C', weightsC);
            pwm.setCounts('G', weightsG);
            pwm.setCounts('T', weightsT);
            pwm.calcLogOddsWeight();
            this.pwms.put(id, pwm);
        }
    }

    int[] parseWeights(String line, String lineType) {
        if (line.startsWith(lineType)) {
            line = line.substring(lineType.length());
        }
        line = line.replace('[', ' ').replace(']', ' ').trim();
        String[] weightStr = line.split("\\s+");
        int[] weight = new int[weightStr.length];
        for (int i = 0; i < weight.length; ++i) {
            weight[i] = Gpr.parseIntSafe(weightStr[i]);
        }
        return weight;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

