/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.util.HashMap;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.vcf.VcfInfoType;

public class GuessTableTypes {
    public static boolean debug = true;
    public static int MIN_LINES = 100000;
    String fileName;
    String headerPrefix = "#";
    String columnSeparator = "\t";
    String subfieldSeparator = ";";
    String[] fieldNames = null;
    VcfInfoType[] types = null;
    boolean[] multipleValues = null;
    HashMap<String, Integer> names2index;

    public GuessTableTypes(String fileName) {
        this.fileName = fileName;
    }

    public boolean foundAllTypes() {
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != null) continue;
            return false;
        }
        return true;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean[] getMultipleValues() {
        return this.multipleValues;
    }

    public HashMap<String, Integer> getNames2index() {
        return this.names2index;
    }

    public VcfInfoType getType(String fieldName) {
        Integer idx = this.names2index.get(fieldName);
        if (idx == null) {
            return null;
        }
        return this.types[idx];
    }

    public VcfInfoType[] getTypes() {
        return this.types;
    }

    public VcfInfoType guessType(String value2) {
        if (value2 == null || value2.isEmpty() || value2.equals(".")) {
            return null;
        }
        if (this.isMultiple(value2)) {
            String[] values2 = value2.split(this.subfieldSeparator);
            VcfInfoType type = null;
            for (String val : values2) {
                VcfInfoType valType = this.guessType(val);
                if (type == null) {
                    type = valType;
                    continue;
                }
                if (valType == null || type == valType) continue;
                return null;
            }
            return type;
        }
        try {
            Long.parseLong(value2);
            return VcfInfoType.Integer;
        }
        catch (Exception exception) {
            try {
                Double.parseDouble(value2);
                return VcfInfoType.Float;
            }
            catch (Exception exception2) {
                if (value2.length() == 1) {
                    return VcfInfoType.Character;
                }
                if (value2.equalsIgnoreCase("true") || value2.equalsIgnoreCase("false") || value2.equalsIgnoreCase("yes") || value2.equalsIgnoreCase("no")) {
                    return VcfInfoType.Flag;
                }
                return VcfInfoType.String;
            }
        }
    }

    public boolean guessTypes() {
        boolean header = true;
        if (this.headerPrefix == null) {
            this.headerPrefix = "";
        }
        LineFileIterator lfi = new LineFileIterator(this.fileName);
        for (String line : lfi) {
            if (header) {
                header = false;
                if (this.headerPrefix.isEmpty() || line.startsWith(this.headerPrefix)) {
                    line = line.substring(this.headerPrefix.length());
                    this.fieldNames = line.split(this.columnSeparator);
                    this.types = new VcfInfoType[this.fieldNames.length];
                    this.multipleValues = new boolean[this.fieldNames.length];
                    this.names2index = new HashMap();
                    for (int i = 0; i < this.fieldNames.length; ++i) {
                        this.names2index.put(this.fieldNames[i], i);
                    }
                    continue;
                }
                return false;
            }
            if (this.multipleValues == null) {
                throw new RuntimeException("Cannot parse file '" + this.fileName + "'. Missing header?");
            }
            boolean done = true;
            String[] values2 = line.split(this.columnSeparator);
            for (int i = 0; i < this.fieldNames.length; ++i) {
                VcfInfoType type = this.guessType(values2[i]);
                if (this.fieldNames[i].equals("1000Gp1_AMR_AF") && values2[i] != null) {
                    System.err.println("line: " + lfi.getLineNum() + "\tfield[" + i + "]: '" + this.fieldNames[i] + "'\tfield_type: " + (Object)((Object)this.types[i]) + "'\tvalue_type: " + (Object)((Object)type) + "\tdata: '" + values2[i] + "'");
                }
                if (this.types[i] == null) {
                    this.types[i] = type;
                } else if (this.types[i] == VcfInfoType.Integer && type == VcfInfoType.Float) {
                    this.types[i] = type;
                } else if (type == VcfInfoType.String) {
                    this.types[i] = type;
                }
                int n = i;
                this.multipleValues[n] = this.multipleValues[n] | this.isMultiple(values2[i]);
                done &= this.types[i] != null;
            }
            if (!done || lfi.getLineNum() <= MIN_LINES) continue;
            lfi.close();
            return true;
        }
        lfi.close();
        return false;
    }

    boolean isMultiple(String value2) {
        return value2.indexOf(this.subfieldSeparator) >= 0;
    }

    public Boolean isMultipleValues(String fieldName) {
        Integer idx = this.names2index.get(fieldName);
        if (idx == null) {
            return null;
        }
        return this.multipleValues[idx];
    }

    public boolean parsedHeader() {
        return this.fieldNames != null;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public void setSubfieldSeparator(String subfieldSeparator) {
        this.subfieldSeparator = subfieldSeparator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            sb.append(this.fieldNames[i] + "\t" + (Object)((Object)this.types[i]) + (this.multipleValues[i] ? "\tmultiple" : "") + "\n");
        }
        return sb.toString();
    }
}

