/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.quaternary.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.MMCIFFileReader;
import org.biojava.bio.structure.io.mmcif.SimpleMMcifConsumer;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructAssembly;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructAssemblyGen;
import org.biojava.bio.structure.io.mmcif.model.PdbxStructOperList;
import org.biojava.bio.structure.quaternary.io.RawBioUnitDataProvider;

public class MmCifPDBBiolAssemblyProvider
implements RawBioUnitDataProvider {
    String pdbId;
    List<PdbxStructAssembly> pdbxStructAssemblies;
    List<PdbxStructAssemblyGen> pdbxStructAssemblyGens;
    List<PdbxStructOperList> pdbxStructOperList;
    Structure asymUnit;
    AtomCache cache;

    @Override
    public void setPdbId(String pdbId) {
        if (this.cache == null) {
            this.cache = new AtomCache();
        }
        if (this.pdbId != null && this.pdbId.equals(pdbId)) {
            return;
        }
        this.pdbId = pdbId;
        this.reset();
        MMCIFFileReader reader = new MMCIFFileReader();
        FileParsingParameters params = this.cache.getFileParsingParams();
        params.setAlignSeqRes(true);
        params.setParseBioAssembly(true);
        reader.setFileParsingParameters(params);
        try {
            this.asymUnit = reader.getStructureById(pdbId);
            if (this.asymUnit.nrModels() > 1) {
                this.asymUnit = StructureTools.removeModels(this.asymUnit);
            }
            SimpleMMcifConsumer consumer = reader.getMMcifConsumer();
            this.pdbxStructOperList = consumer.getStructOpers();
            this.pdbxStructAssemblies = consumer.getStructAssemblies();
            this.pdbxStructAssemblyGens = consumer.getStructAssemblyGens();
            consumer.documentStart();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reset() {
        this.pdbxStructOperList = new ArrayList<PdbxStructOperList>();
        this.pdbxStructAssemblies = new ArrayList<PdbxStructAssembly>();
        this.pdbxStructAssemblyGens = new ArrayList<PdbxStructAssemblyGen>();
        this.asymUnit = null;
    }

    public String getPdbId() {
        return this.pdbId;
    }

    @Override
    public List<PdbxStructAssembly> getPdbxStructAssemblies() {
        return this.pdbxStructAssemblies;
    }

    @Override
    public List<PdbxStructAssemblyGen> getPdbxStructAssemblyGens() {
        return this.pdbxStructAssemblyGens;
    }

    @Override
    public List<PdbxStructOperList> getPdbxStructOperList() {
        return this.pdbxStructOperList;
    }

    @Override
    public int getNrBiolAssemblies() {
        return this.pdbxStructAssemblies.size();
    }

    @Override
    public boolean hasBiolAssembly() {
        int nrAssemblies = this.getNrBiolAssemblies();
        return nrAssemblies > 0;
    }

    @Override
    public PdbxStructAssembly getPdbxStructAssembly(int biolAssemblyNr) {
        if (biolAssemblyNr < this.getNrBiolAssemblies()) {
            return this.pdbxStructAssemblies.get(biolAssemblyNr);
        }
        return null;
    }

    @Override
    public List<PdbxStructAssemblyGen> getPdbxStructAssemblyGen(int biolAssemblyNr) {
        if (biolAssemblyNr > this.getNrBiolAssemblies()) {
            return null;
        }
        ArrayList<PdbxStructAssemblyGen> psags = new ArrayList<PdbxStructAssemblyGen>();
        for (PdbxStructAssemblyGen psag : this.pdbxStructAssemblyGens) {
            if (!psag.getAssembly_id().equals(biolAssemblyNr + 1 + "")) continue;
            psags.add(psag);
        }
        return psags;
    }

    public Structure getAsymUnit() {
        return this.asymUnit;
    }

    public void setAsymUnit(Structure s) {
        this.asymUnit = s;
    }

    public AtomCache getAtomCache() {
        return this.cache;
    }

    public void setAtomCache(AtomCache cache) {
        this.cache = cache;
    }
}

