/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava.bio.structure.AminoAcid;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.NucleotideImpl;
import org.biojava.bio.structure.ResidueNumber;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.io.mmcif.chem.PolymerType;
import org.biojava.bio.structure.io.mmcif.chem.ResidueType;
import org.biojava.bio.structure.io.mmcif.model.ChemComp;
import org.biojava3.alignment.Alignments;
import org.biojava3.alignment.SimpleGapPenalty;
import org.biojava3.alignment.SubstitutionMatrixHelper;
import org.biojava3.alignment.template.GapPenalty;
import org.biojava3.alignment.template.PairwiseSequenceAligner;
import org.biojava3.alignment.template.SequencePair;
import org.biojava3.alignment.template.SubstitutionMatrix;
import org.biojava3.core.exceptions.CompoundNotFoundError;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.RNASequence;
import org.biojava3.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava3.core.sequence.compound.AmbiguityRNACompoundSet;
import org.biojava3.core.sequence.compound.AminoAcidCompound;
import org.biojava3.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava3.core.sequence.compound.DNACompoundSet;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;

public class SeqRes2AtomAligner {
    boolean DEBUG = false;
    static final List<String> excludeTypes = new ArrayList<String>();
    String alignmentString = "";

    public String getAlignmentString() {
        return this.alignmentString;
    }

    public boolean isDEBUG() {
        return this.DEBUG;
    }

    public void setDEBUG(boolean debug) {
        this.DEBUG = debug;
    }

    public Chain getMatchingAtomRes(Chain seqRes, List<Chain> atomList) throws StructureException {
        for (Chain atomChain : atomList) {
            if (!atomChain.getChainID().equals(seqRes.getChainID())) continue;
            return atomChain;
        }
        throw new StructureException("could not match seqres chainID >" + seqRes.getChainID() + "< to ATOM chains!");
    }

    public void align(Structure s, List<Chain> seqResList) {
        List<Chain> atomList = s.getModel(0);
        for (Chain seqRes : seqResList) {
            try {
                Chain atomRes = this.getMatchingAtomRes(seqRes, atomList);
                this.mapSeqresRecords(atomRes, seqRes);
            }
            catch (StructureException e) {
                e.printStackTrace();
            }
        }
    }

    public void mapSeqresRecords(Chain atomRes, Chain seqRes) throws StructureException {
        boolean noMatchFound;
        boolean simpleMatchSuccessful;
        List<Group> seqResGroups = seqRes.getAtomGroups();
        List<Group> atmResGroups = atomRes.getAtomGroups();
        if (this.DEBUG) {
            System.err.println("COMPARING " + atomRes.getChainID() + " (" + atmResGroups.size() + ") " + seqRes.getChainID() + " (" + seqResGroups.size() + ") ");
        }
        if (simpleMatchSuccessful = this.trySimpleMatch(seqResGroups, atmResGroups)) {
            atomRes.setSeqResGroups(seqResGroups);
            return;
        }
        if (seqRes.getAtomGroups("amino").size() < 1) {
            if (seqRes.getAtomGroups("nucleotide").size() > 1) {
                if (this.DEBUG) {
                    System.out.println("chain " + seqRes.getChainID() + " is a nucleotide chain, aligning nucs...");
                }
                this.align2NucleotideChains(seqRes, atomRes);
                return;
            }
            if (this.DEBUG) {
                System.out.println("chain " + seqRes.getChainID() + " does not contain amino acids, ignoring...");
            }
            return;
        }
        if (atomRes.getAtomGroups("amino").size() < 1) {
            if (this.DEBUG) {
                System.out.println("chain " + atomRes.getChainID() + " does not contain amino acids, ignoring...");
            }
            return;
        }
        if (this.DEBUG) {
            System.out.println("Alignment for chain " + atomRes.getChainID());
        }
        if (!(noMatchFound = this.align(seqResGroups, atomRes.getAtomGroups()))) {
            atomRes.setSeqResGroups(seqResGroups);
        }
    }

    private void align2NucleotideChains(Chain seqRes, Chain atomRes) throws StructureException {
        List<Group> seqResGroups;
        boolean noMatchFound;
        if (atomRes.getAtomGroups("nucleotide").size() < 1) {
            if (this.DEBUG) {
                System.out.println("chain " + atomRes.getChainID() + " does not contain nucleotides, ignoring...");
            }
            return;
        }
        if (this.DEBUG) {
            System.out.println("Alignment for chain " + atomRes.getChainID());
        }
        if (!(noMatchFound = this.alignNucleotideGroups(seqResGroups = seqRes.getAtomGroups(), atomRes.getAtomGroups()))) {
            atomRes.setSeqResGroups(seqResGroups);
        }
    }

    public boolean trySimpleMatch(List<Group> seqResGroups, List<Group> atmResGroups) {
        boolean startAt1 = true;
        for (int atomResPos = 0; atomResPos < atmResGroups.size(); ++atomResPos) {
            Group seqResGroup;
            Group atomResGroup = atmResGroups.get(atomResPos);
            String threeLetterCode = atomResGroup.getPDBName();
            if (excludeTypes.contains(threeLetterCode)) continue;
            ResidueNumber atomResNum = atomResGroup.getResidueNumber();
            int seqResPos = atomResNum.getSeqNum();
            if (seqResPos < 0) {
                if (this.DEBUG) {
                    System.err.println("ATOM residue number < 0");
                }
                return false;
            }
            if (seqResPos == 0) {
                seqResGroup = seqResGroups.get(0);
                if (seqResGroup.getPDBName().equals(atomResGroup.getPDBName())) {
                    startAt1 = false;
                } else {
                    if (this.DEBUG) {
                        System.err.println("SEQRES position 1  (" + seqResGroup.getPDBName() + ") does not match ATOM PDB res num 0 (" + atomResGroup.getPDBName() + ")");
                    }
                    return false;
                }
            }
            if (startAt1) {
                --seqResPos;
            }
            if (startAt1 && seqResPos >= seqResGroups.size()) {
                if (atomResGroup instanceof AminoAcid) {
                    if (this.DEBUG) {
                        System.err.println(" ATOM residue nr: " + seqResPos + " > seqres! " + seqResGroups.size() + " " + atomResGroup);
                    }
                    return false;
                }
                if (!(atomResGroup instanceof NucleotideImpl)) continue;
                if (this.DEBUG) {
                    System.err.println(" NUCLEOTIDE residue nr: " + seqResPos + " > seqres! " + seqResGroups.size() + " " + atomResGroup);
                }
                return false;
            }
            if (seqResPos >= seqResGroups.size()) {
                if (this.DEBUG) {
                    System.err.println("seqres groups don't match atom indeces " + seqResPos);
                }
                if (!(atomResGroup instanceof AminoAcid)) continue;
                return false;
            }
            seqResGroup = seqResGroups.get(seqResPos);
            if (!seqResGroup.getPDBName().trim().equals(atomResGroup.getPDBName().trim())) {
                if (this.DEBUG) {
                    System.err.println("Mismatch of SEQRES pos " + seqResPos + " and ATOM record: " + atomResGroup + " | " + seqResGroup);
                }
                return false;
            }
            if (this.DEBUG) {
                System.err.println("merging " + seqResPos + " " + atomResGroup);
            }
            seqResGroups.set(seqResPos, atomResGroup);
        }
        return true;
    }

    public static String getFullAtomSequence(List<Group> groups, Map<Integer, Integer> positionIndex) {
        StringBuffer sequence2 = new StringBuffer();
        int seqIndex = 0;
        for (int i = 0; i < groups.size(); ++i) {
            Object a;
            Group g = groups.get(i);
            if (g instanceof AminoAcid) {
                a = (AminoAcid)g;
                char oneLetter = a.getAminoType().charValue();
                if (oneLetter == '?') {
                    oneLetter = 'X';
                }
                positionIndex.put(seqIndex, i);
                sequence2.append(oneLetter);
                ++seqIndex;
                continue;
            }
            if (excludeTypes.contains(g.getPDBName())) continue;
            if (g.size() == 1) {
                try {
                    a = g.getAtom(0);
                    if (!a.getElement().isMetal()) continue;
                }
                catch (StructureException e) {
                    e.printStackTrace();
                }
                continue;
            }
            ChemComp cc = g.getChemComp();
            if (cc == null || !ResidueType.lPeptideLinking.equals(cc.getResidueType()) && !PolymerType.PROTEIN_ONLY.contains(cc.getPolymerType()) && !PolymerType.POLYNUCLEOTIDE_ONLY.contains(cc.getPolymerType())) continue;
            String c = cc.getOne_letter_code();
            if (c.equals("?")) {
                c = "X";
            }
            positionIndex.put(seqIndex, i);
            sequence2.append(c);
            ++seqIndex;
        }
        return sequence2.toString();
    }

    public boolean alignNucleotideGroups(List<Group> seqRes, List<Group> atomRes) throws StructureException {
        AbstractSequence s2;
        AbstractSequence s1;
        HashMap<Integer, Integer> seqresIndexPosition = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> atomIndexPosition = new HashMap<Integer, Integer>();
        String seq1 = SeqRes2AtomAligner.getFullAtomSequence(seqRes, seqresIndexPosition);
        String seq2 = SeqRes2AtomAligner.getFullAtomSequence(atomRes, atomIndexPosition);
        if (this.DEBUG) {
            System.out.println("align seq1 (" + seq1.length() + ") " + seq1);
            System.out.println("align seq2 (" + seq2.length() + ") " + seq2);
        }
        try {
            s1 = new DNASequence(seq1, (CompoundSet<NucleotideCompound>)AmbiguityDNACompoundSet.getDNACompoundSet());
        }
        catch (CompoundNotFoundError e) {
            try {
                s1 = new RNASequence(seq1, (CompoundSet<NucleotideCompound>)AmbiguityRNACompoundSet.getRNACompoundSet());
            }
            catch (CompoundNotFoundError ex) {
                System.err.println("Could not determine compound set for sequence 1 " + seq1);
                return false;
            }
        }
        try {
            s2 = new DNASequence(seq2, (CompoundSet<NucleotideCompound>)AmbiguityDNACompoundSet.getDNACompoundSet());
        }
        catch (CompoundNotFoundError e) {
            try {
                s2 = new RNASequence(seq2, (CompoundSet<NucleotideCompound>)AmbiguityRNACompoundSet.getRNACompoundSet());
            }
            catch (CompoundNotFoundError ex) {
                System.err.println("Could not determine compound set for sequence 2 " + seq2);
                return false;
            }
        }
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getNuc4_2();
        SimpleGapPenalty penalty = new SimpleGapPenalty();
        short gop = 8;
        short extend = 1;
        penalty.setOpenPenalty(gop);
        penalty.setExtensionPenalty(extend);
        try {
            PairwiseSequenceAligner smithWaterman = Alignments.getPairwiseAligner((Sequence)s1, (Sequence)s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
            SequencePair pair2 = smithWaterman.getPair();
            if (pair2 == null) {
                throw new StructureException("could not align objects!");
            }
            if (this.DEBUG) {
                System.out.println(pair2.toString(60));
            }
            boolean noMatchFound = this.mapDNAChains(seqRes, atomRes, (SequencePair<DNASequence, NucleotideCompound>)pair2, seqresIndexPosition, atomIndexPosition);
            return noMatchFound;
        }
        catch (Exception e) {
            System.err.println("Problem while aligning ATOM and SEQRES records for " + atomRes.get(0).getChain().getParent().getPDBCode() + " chain: " + atomRes.get(0).getChain().getChainID());
            return true;
        }
    }

    public boolean align(List<Group> seqRes, List<Group> atomRes) throws StructureException {
        HashMap<Integer, Integer> seqresIndexPosition = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> atomIndexPosition = new HashMap<Integer, Integer>();
        String seq1 = SeqRes2AtomAligner.getFullAtomSequence(seqRes, seqresIndexPosition);
        String seq2 = SeqRes2AtomAligner.getFullAtomSequence(atomRes, atomIndexPosition);
        if (this.DEBUG) {
            System.out.println("align seq1 (" + seq1.length() + ") " + seq1);
            System.out.println("align seq2 (" + seq2.length() + ") " + seq2);
        }
        ProteinSequence s1 = new ProteinSequence(seq1);
        ProteinSequence s2 = new ProteinSequence(seq2);
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getBlosum65();
        SimpleGapPenalty penalty = new SimpleGapPenalty();
        short gop = 8;
        short extend = 1;
        penalty.setOpenPenalty(gop);
        penalty.setExtensionPenalty(extend);
        try {
            PairwiseSequenceAligner smithWaterman = Alignments.getPairwiseAligner((Sequence)s1, (Sequence)s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.LOCAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
            SequencePair pair2 = smithWaterman.getPair();
            if (pair2 == null) {
                throw new StructureException("could not align objects!");
            }
            if (this.DEBUG) {
                System.out.println(pair2.toString(60));
            }
            boolean noMatchFound = this.mapChains(seqRes, atomRes, (SequencePair<ProteinSequence, AminoAcidCompound>)pair2, seqresIndexPosition, atomIndexPosition);
            return noMatchFound;
        }
        catch (Exception e) {
            System.err.println("Problem while aligning ATOM and SEQRES records for " + atomRes.get(0).getChain().getParent().getPDBCode() + " chain: " + atomRes.get(0).getChain().getChainID());
            return true;
        }
    }

    private boolean mapChains(List<Group> seqResGroups, List<Group> atomRes, SequencePair<ProteinSequence, AminoAcidCompound> pair2, Map<Integer, Integer> seqresIndexPosition, Map<Integer, Integer> atomIndexPosition) throws StructureException {
        int aligLength = pair2.getLength();
        boolean noMatchFound = true;
        AminoAcidCompound gapSymbol = AminoAcidCompoundSet.getAminoAcidCompoundSet().getCompoundForString("-");
        for (int i = 1; i <= aligLength; ++i) {
            Compound s = pair2.getCompoundAt(1, i);
            Compound a = pair2.getCompoundAt(2, i);
            int posSeq = pair2.getIndexInQueryAt(i) - 1;
            int posAtom = pair2.getIndexInTargetAt(i) - 1;
            if (s.equals(gapSymbol) || a.equals(gapSymbol) || !s.equals(a)) continue;
            Group s1 = seqResGroups.get(seqresIndexPosition.get(posSeq));
            Group a1 = atomRes.get(atomIndexPosition.get(posAtom));
            if (s1 == null || a1 == null) {
                System.err.println("can't map " + i + ":" + s + " " + posSeq + " " + s1 + " atom: " + posAtom + " " + a1);
                continue;
            }
            String pdbNameS = s1.getPDBName();
            String pdbNameA = a1.getPDBName();
            if (pdbNameS == null || pdbNameA == null) {
                System.err.println("null value found at " + posSeq + " when trying to align " + s1 + " and " + a1 + " " + posAtom);
                throw new StructureException("null value found at group.getPDBName()");
            }
            if (!pdbNameA.equals(pdbNameS) && !pdbNameA.trim().equals(pdbNameS.trim())) {
                System.err.println(s1 + " " + posSeq + " does not align with " + a1 + " " + posAtom + " should be: " + s + " : " + a);
                if (s1.getType().equals("hetatm") && a1.getType().equals("hetatm")) {
                    System.err.println("they seem to be hetatoms, so ignoring mismatch.");
                } else {
                    System.err.println("could not match residues " + s1 + " " + a1);
                }
            }
            seqResGroups.set(seqresIndexPosition.get(posSeq), a1);
            noMatchFound = false;
        }
        if (noMatchFound && this.DEBUG) {
            System.out.println("no alignment found!");
        }
        return noMatchFound;
    }

    private boolean mapDNAChains(List<Group> seqResGroups, List<Group> atomRes, SequencePair<DNASequence, NucleotideCompound> pair2, Map<Integer, Integer> seqresIndexPosition, Map<Integer, Integer> atomIndexPosition) throws StructureException {
        int aligLength = pair2.getLength();
        boolean noMatchFound = true;
        Object gapSymbol = DNACompoundSet.getDNACompoundSet().getCompoundForString("-");
        for (int i = 1; i <= aligLength; ++i) {
            Compound s = pair2.getCompoundAt(1, i);
            Compound a = pair2.getCompoundAt(2, i);
            int posSeq = pair2.getIndexInQueryAt(i) - 1;
            int posAtom = pair2.getIndexInTargetAt(i) - 1;
            if (s.equals(gapSymbol) || a.equals(gapSymbol) || !s.equals(a)) continue;
            Group s1 = seqResGroups.get(seqresIndexPosition.get(posSeq));
            Group a1 = atomRes.get(atomIndexPosition.get(posAtom));
            if (s1 == null || a1 == null) {
                System.err.println("can't map " + i + ":" + s + " " + posSeq + " " + s1 + " atom: " + posAtom + " " + a1);
                continue;
            }
            String pdbNameS = s1.getPDBName();
            String pdbNameA = a1.getPDBName();
            if (pdbNameS == null || pdbNameA == null) {
                System.err.println("null value found at " + posSeq + " when trying to align " + s1 + " and " + a1 + " " + posAtom);
                throw new StructureException("null value found at group.getPDBName()");
            }
            if (!pdbNameA.equals(pdbNameS) && !pdbNameA.trim().equals(pdbNameS.trim())) {
                System.err.println(s1 + " " + posSeq + " does not align with " + a1 + " " + posAtom + " should be: " + s + " : " + a);
                if (s1.getType().equals("hetatm") && a1.getType().equals("hetatm")) {
                    System.err.println("they seem to be hetatoms, so ignoring mismatch.");
                } else {
                    System.err.println("could not match residues " + s1 + " " + a1);
                }
            }
            seqResGroups.set(seqresIndexPosition.get(posSeq), a1);
            noMatchFound = false;
        }
        if (noMatchFound && this.DEBUG) {
            System.out.println("no alignment found!");
        }
        return noMatchFound;
    }

    static {
        excludeTypes.add("HOH");
        excludeTypes.add("DOD");
    }
}

