/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DoubleModConstants;
import org.apfloat.internal.DoubleModMath;
import org.apfloat.internal.DoubleScramble;
import org.apfloat.internal.TransformLengthExceededException;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStrategy;
import org.apfloat.spi.Util;

public class DoubleTableFNTStrategy
extends DoubleModMath
implements NTTStrategy {
    public void transform(DataStorage dataStorage, int modulus) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        if (length > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + length + " > " + 0x180000000000L);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        this.setModulus(DoubleModConstants.MODULUS[modulus]);
        double w = this.getForwardNthRoot(DoubleModConstants.PRIMITIVE_ROOT[modulus], length);
        double[] wTable = this.createWTable(w, (int)length);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        this.tableFNT(arrayAccess, wTable, null);
        arrayAccess.close();
    }

    public void inverseTransform(DataStorage dataStorage, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        long length = dataStorage.getSize();
        if (Math.max(length, totalTransformLength) > 0x180000000000L) {
            throw new TransformLengthExceededException("Maximum transform length exceeded: " + Math.max(length, totalTransformLength) + " > " + 0x180000000000L);
        }
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        this.setModulus(DoubleModConstants.MODULUS[modulus]);
        double w = this.getInverseNthRoot(DoubleModConstants.PRIMITIVE_ROOT[modulus], length);
        double[] wTable = this.createWTable(w, (int)length);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        this.inverseTableFNT(arrayAccess, wTable, null);
        this.divideElements(arrayAccess, totalTransformLength);
        arrayAccess.close();
    }

    public long getTransformLength(long size2) {
        return Util.round2up(size2);
    }

    protected void tableFNT(ArrayAccess arrayAccess, double[] wTable, int[] permutationTable) throws ApfloatRuntimeException {
        double[] data2 = arrayAccess.getDoubleData();
        int offset = arrayAccess.getOffset();
        int nn = arrayAccess.getLength();
        assert (nn == (nn & -nn));
        if (nn < 2) {
            return;
        }
        int r = 1;
        for (int mmax = nn >> 1; mmax > 0; mmax >>= 1) {
            int istep = mmax << 1;
            for (int i = offset; i < offset + nn; i += istep) {
                int j = i + mmax;
                double a = data2[i];
                double b = data2[j];
                data2[i] = this.modAdd(a, b);
                data2[j] = this.modSubtract(a, b);
            }
            int t2 = r;
            for (int m = 1; m < mmax; ++m) {
                for (int i = offset + m; i < offset + nn; i += istep) {
                    int j = i + mmax;
                    double a = data2[i];
                    double b = data2[j];
                    data2[i] = this.modAdd(a, b);
                    data2[j] = this.modMultiply(wTable[t2], this.modSubtract(a, b));
                }
                t2 += r;
            }
            r <<= 1;
        }
        if (permutationTable != null) {
            DoubleScramble.scramble(data2, offset, permutationTable);
        }
    }

    protected void inverseTableFNT(ArrayAccess arrayAccess, double[] wTable, int[] permutationTable) throws ApfloatRuntimeException {
        double[] data2 = arrayAccess.getDoubleData();
        int offset = arrayAccess.getOffset();
        int nn = arrayAccess.getLength();
        assert (nn == (nn & -nn));
        if (nn < 2) {
            return;
        }
        if (permutationTable != null) {
            DoubleScramble.scramble(data2, offset, permutationTable);
        }
        int r = nn;
        int mmax = 1;
        while (nn > mmax) {
            int istep = mmax << 1;
            r >>= 1;
            for (int i = offset; i < offset + nn; i += istep) {
                int j = i + mmax;
                double wTemp = data2[j];
                data2[j] = this.modSubtract(data2[i], wTemp);
                data2[i] = this.modAdd(data2[i], wTemp);
            }
            int t2 = r;
            for (int m = 1; m < mmax; ++m) {
                for (int i = offset + m; i < offset + nn; i += istep) {
                    int j = i + mmax;
                    double wTemp = this.modMultiply(wTable[t2], data2[j]);
                    data2[j] = this.modSubtract(data2[i], wTemp);
                    data2[i] = this.modAdd(data2[i], wTemp);
                }
                t2 += r;
            }
            mmax = istep;
        }
    }

    private void divideElements(ArrayAccess arrayAccess, double divisor) throws ApfloatRuntimeException {
        double inverseFactor = this.modDivide(1.0, divisor);
        double[] data2 = arrayAccess.getDoubleData();
        int length = arrayAccess.getLength();
        int offset = arrayAccess.getOffset();
        for (int i = 0; i < length; ++i) {
            data2[i + offset] = this.modMultiply(data2[i + offset], inverseFactor);
        }
    }
}

