/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.FixedPrecisionApcomplexHelper;
import org.apfloat.spi.Util;

public class FixedPrecisionApfloatHelper
extends FixedPrecisionApcomplexHelper {
    public FixedPrecisionApfloatHelper(long precision) throws IllegalArgumentException {
        super(precision);
    }

    public Apfloat valueOf(Apfloat x2) {
        return super.valueOf(x2);
    }

    public Apfloat negate(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(x2).negate();
    }

    public Apfloat add(Apfloat x2, Apfloat y) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(x2).add(this.valueOf(y)));
    }

    public Apfloat subtract(Apfloat x2, Apfloat y) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(x2).subtract(this.setPrecision(y)));
    }

    public Apfloat multiply(Apfloat x2, Apfloat y) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(x2).multiply(this.setPrecision(y)));
    }

    public Apfloat divide(Apfloat x2, Apfloat y) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(x2).divide(this.setPrecision(y)));
    }

    public Apfloat pow(Apfloat x2, Apfloat y) throws ArithmeticException, ApfloatRuntimeException {
        Apfloat result2 = ApfloatHelper.checkPow(x2, y, this.precision());
        if (result2 != null) {
            return this.valueOf(result2);
        }
        return this.exp(this.multiply(this.log(x2), y));
    }

    public Apfloat pow(Apfloat x2, long n) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.pow(this.setPrecision(x2), n));
    }

    public Apfloat abs(Apfloat x2) throws ApfloatRuntimeException {
        return ApfloatMath.abs(this.valueOf(x2));
    }

    public Apfloat acos(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        if (x2.signum() == 0) {
            return this.divide(this.pi(x2.radix()), new Apfloat(2L, this.precision(), x2.radix()));
        }
        return this.valueOf(ApfloatMath.acos(this.setPrecision(x2)));
    }

    public Apfloat acosh(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.acosh(this.setPrecision(x2)));
    }

    public Apfloat asin(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.asin(this.setPrecision(x2)));
    }

    public Apfloat asinh(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.asinh(this.setPrecision(x2)));
    }

    public Apfloat atan(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.atan(this.setPrecision(x2)));
    }

    public Apfloat atanh(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.atanh(this.setPrecision(x2)));
    }

    public Apfloat cbrt(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.cbrt(this.setPrecision(x2)));
    }

    public Apfloat cos(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.cos(this.setTrigonometricPrecision(x2)));
    }

    public Apfloat cosh(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.cosh(this.setExponentialPrecision(x2)));
    }

    public Apfloat exp(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.exp(this.setExponentialPrecision(x2)));
    }

    public Apfloat log(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.log(this.setPrecision(x2)));
    }

    public Apfloat log(Apfloat x2, Apfloat b) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.log(this.setPrecision(x2), this.setPrecision(b)));
    }

    public Apfloat sin(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.sin(this.setTrigonometricPrecision(x2)));
    }

    public Apfloat sinh(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.sinh(this.setExponentialPrecision(x2)));
    }

    public Apfloat sqrt(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.sqrt(this.setPrecision(x2)));
    }

    public Apfloat tan(Apfloat x2) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.tan(this.setTrigonometricPrecision(x2)));
    }

    public Apfloat tanh(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.tanh(this.setExponentialPrecision(x2)));
    }

    public Apfloat agm(Apfloat a, Apfloat b) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.agm(this.setPrecision(a), this.setPrecision(b)));
    }

    public Apfloat inverseRoot(Apfloat x2, long n) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.inverseRoot(this.setPrecision(x2), n));
    }

    public Apfloat root(Apfloat x2, long n) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.root(this.setPrecision(x2), n));
    }

    public Apfloat scale(Apfloat x2, long scale) throws ApfloatRuntimeException {
        return ApfloatMath.scale(this.valueOf(x2), scale);
    }

    public Apfloat mod(Apfloat x2, Apfloat y) throws ApfloatRuntimeException {
        return this.fmod(x2, y);
    }

    public Apfloat ceil(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.ceil(this.setPrecision(x2)));
    }

    public Apfloat floor(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.floor(this.setPrecision(x2)));
    }

    public Apfloat truncate(Apfloat x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.truncate(this.setPrecision(x2)));
    }

    public Apfloat atan2(Apfloat x2, Apfloat y) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.atan2(this.setPrecision(x2), this.setPrecision(y)));
    }

    public Apfloat copySign(Apfloat x2, Apfloat y) throws ApfloatRuntimeException {
        return ApfloatMath.copySign(this.valueOf(x2), y);
    }

    public Apfloat fmod(Apfloat x2, Apfloat y) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.fmod(x2, this.setPrecision(y)));
    }

    public Apfloat[] modf(Apfloat x2) throws ApfloatRuntimeException {
        if (x2.scale() > 0L) {
            long precision = Util.ifFinite(this.precision(), this.precision() + x2.scale());
            x2 = x2.precision(precision);
        } else {
            x2 = this.setPrecision(x2);
        }
        Apfloat[] modfs = ApfloatMath.modf(x2);
        modfs[0] = this.valueOf(modfs[0]);
        modfs[1] = this.valueOf(modfs[1]);
        return modfs;
    }

    public Apfloat factorial(long n) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.factorial(n, this.precision()));
    }

    public Apfloat factorial(long n, int radix) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.factorial(n, this.precision(), radix));
    }

    public Apfloat pi() throws ApfloatRuntimeException {
        return super.pi();
    }

    public Apfloat pi(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return super.pi(radix);
    }

    public Apfloat logRadix(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return ApfloatMath.logRadix(this.precision(), radix);
    }

    public Apfloat multiplyAdd(Apfloat a, Apfloat b, Apfloat c, Apfloat d) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.multiplyAdd(this.setPrecision(a), this.setPrecision(b), this.setPrecision(c), this.setPrecision(d)));
    }

    public Apfloat multiplySubtract(Apfloat a, Apfloat b, Apfloat c, Apfloat d) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.multiplySubtract(this.setPrecision(a), this.setPrecision(b), this.setPrecision(c), this.setPrecision(d)));
    }

    public Apfloat product(Apfloat ... x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.product(this.setPrecision(x2)));
    }

    public Apfloat sum(Apfloat ... x2) throws ApfloatRuntimeException {
        return this.valueOf(ApfloatMath.sum(this.setPrecision(x2)));
    }

    private Apfloat setPrecision(Apfloat x2) throws ApfloatRuntimeException {
        return x2.precision(this.precision());
    }

    private Apfloat[] setPrecision(Apfloat[] x2) throws ApfloatRuntimeException {
        Apfloat[] tmp = new Apfloat[x2.length];
        for (int i = 0; i < x2.length; ++i) {
            tmp[i] = this.setPrecision(x2[i]);
        }
        return tmp;
    }
}

