/*
 * Decompiled with CFR 0.152.
 */
package com.infocom.print;

import com.infocom.print.FormLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;

class RowLayout {
    private Vector m_components = null;
    private RowLayout m_previousRow = null;
    private RowLayout m_followingRow = null;
    FormLayout m_containingLayout = null;
    protected int m_minLocation = 0;
    protected int m_prefLocation = 0;
    protected int m_currLocation = 0;
    private int m_minSize = 0;
    private int m_prefSize = 0;
    private int m_currSize = 0;
    private int m_justification = 1;
    private int m_index = 0;
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_BOTTOM = 2;
    private static final int DEBUG_LEVEL = 0;

    public RowLayout(int n, FormLayout formLayout) {
        RowLayout.debug("RowLayout.RowLayout(int, FormLayout): row " + n, 3);
        this.m_index = n;
        this.m_components = new Vector();
        this.m_containingLayout = formLayout;
    }

    public int getIndex() {
        RowLayout.debug("RowLayout.getIndex(): " + this.m_index, 10);
        return this.m_index;
    }

    private void debugLabel(Component component) {
        try {
            RowLayout.debug("RowLayout.addComponent(Component): Label is " + ((JLabel)component).getText(), 3);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void add(Component component) {
        RowLayout.debug("RowLayout.add(Component): row " + this.m_index, 3);
        this.debugLabel(component);
        this.m_components.add(new ComponentLayout(component));
    }

    public void addFloater(Component component, int n) {
        RowLayout.debug("RowLayout.addFloater(Component, int): anchorRow " + n + ", row " + this.m_index, 3);
        this.debugLabel(component);
        if (n == this.m_index) {
            try {
                ((JComponent)component).setAlignmentY(0.0f);
                this.add(component);
                return;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        ComponentLayout componentLayout = new ComponentLayout(component);
        this.m_components.add(componentLayout);
        this.getRow(n).setAnchor(componentLayout);
    }

    private void setAnchor(ComponentLayout componentLayout) {
        RowLayout.debug("RowLayout.setAnchor(ComponentLayout): row " + this.m_index, 3);
        componentLayout.setAnchor(this);
        this.m_components.add(componentLayout);
    }

    public RowLayout getRow(int n) {
        RowLayout rowLayout;
        RowLayout.debug("RowLayout.getRow(int): row " + n + ", this row " + this.m_index, 3);
        if (n == this.m_index) {
            return this;
        }
        if (n < this.m_index) {
            if (this.m_previousRow == null) {
                RowLayout rowLayout2 = new RowLayout(n, this.m_containingLayout);
                rowLayout2.m_previousRow = null;
                rowLayout2.m_followingRow = this;
                this.m_previousRow = rowLayout2;
                return rowLayout2;
            }
            return this.m_previousRow.getRow(n);
        }
        this.m_followingRow.m_previousRow = rowLayout = new RowLayout(n, this.m_containingLayout);
        rowLayout.m_followingRow = this.m_followingRow;
        this.m_followingRow = rowLayout;
        rowLayout.m_previousRow = this;
        return rowLayout;
    }

    public void removeLayoutComponent(Component component) {
        RowLayout.debug("RowLayout.removeComponent(Component): row " + this.m_index, 3);
        Enumeration enumeration = this.m_components.elements();
        while (enumeration.hasMoreElements()) {
            ComponentLayout componentLayout = (ComponentLayout)enumeration.nextElement();
            if (!componentLayout.hasComponent(component)) continue;
            this.m_components.remove(componentLayout);
        }
        this.removeIfEmpty();
    }

    protected void removeIfEmpty() {
        RowLayout.debug("RowLayout.removeIfEmpty(): row " + this.m_index, 3);
        if (this.m_components.size() == 0) {
            if (this.m_previousRow == null) {
                this.m_followingRow.m_previousRow = null;
            } else {
                this.m_followingRow.m_previousRow = this.m_previousRow;
                this.m_previousRow.m_followingRow = this.m_followingRow;
            }
        }
    }

    protected void findPreferredLocation() {
        RowLayout.debug("RowLayout.findPreferredLocation(): row " + this.m_index, 6);
        if (this.m_previousRow != null) {
            this.m_previousRow.findPreferredLocation();
            int n = this.m_previousRow.getPrefLowerBoundary();
            if (this.m_followingRow != null) {
                n += this.m_containingLayout.getInternalVGap();
            }
            this.setPreferredLocation(n);
        } else {
            this.m_prefLocation = this.m_containingLayout.getTopInset();
        }
        RowLayout.debug("RowLayout.findPreferredLocation(): m_prefLocation set to " + this.m_prefLocation + ", row " + this.m_index, 6);
        Enumeration enumeration = this.m_components.elements();
        this.m_prefSize = 0;
        while (enumeration.hasMoreElements()) {
            ComponentLayout componentLayout = (ComponentLayout)enumeration.nextElement();
            if (componentLayout.getPreferredSize(this) <= this.m_prefSize) continue;
            this.m_prefSize = componentLayout.getPreferredSize(this);
        }
        RowLayout.debug("RowLayout.findPreferredLocation(): m_prefSize set to " + this.m_prefSize + ", row " + this.m_index, 6);
    }

    protected void findMinimumLocation() {
        RowLayout.debug("RowLayout.findMinimumLocation(): row " + this.m_index, 6);
        if (this.m_previousRow != null) {
            this.m_previousRow.findMinimumLocation();
            int n = this.m_previousRow.getMinLowerBoundary();
            if (this.m_followingRow != null) {
                n += this.m_containingLayout.getInternalVGap();
            }
            this.setMinimumLocation(n);
        } else {
            this.m_minLocation = this.m_containingLayout.getTopInset();
        }
        RowLayout.debug("RowLayout.findMinimumLocation(): m_minLocation set to " + this.m_minLocation + ", row " + this.m_index, 6);
        Enumeration enumeration = this.m_components.elements();
        this.m_minSize = 0;
        while (enumeration.hasMoreElements()) {
            ComponentLayout componentLayout = (ComponentLayout)enumeration.nextElement();
            if (componentLayout.getMinimumSize(this) <= this.m_minSize) continue;
            this.m_minSize = componentLayout.getMinimumSize(this);
        }
    }

    protected void setPreferredLocation(int n) {
        RowLayout.debug("RowLayout.setPreferredLocation(int): row " + this.m_index + ", location " + n, 6);
        this.m_prefLocation = n;
    }

    protected void setMinimumLocation(int n) {
        RowLayout.debug("RowLayout.setMinimumLocation(int): row " + this.m_index + ", location " + n, 6);
        this.m_minLocation = n;
    }

    protected void setLocation(double d) {
        RowLayout.debug("RowLayout.setLocation(double): pct " + d + ", row " + this.m_index, 8);
        if (this.m_previousRow != null) {
            this.m_previousRow.setLocation(d);
        }
        RowLayout.debug("RowLayout.setLocation(double): m_minLocation is " + this.m_minLocation + ", m_prefLocation is " + this.m_prefLocation, 8);
        this.m_currLocation = (int)((double)this.m_minLocation + (double)(this.m_prefLocation - this.m_minLocation) * d);
        RowLayout.debug("RowLayout.setLocation(double): m_currLocation set to " + this.m_currLocation, 8);
    }

    protected int getPrefLowerBoundary() {
        RowLayout.debug("RowLayout.getPrefLowerBoundary(): row " + this.m_index, 6);
        return this.m_prefLocation + this.m_prefSize;
    }

    protected int getMinLowerBoundary() {
        RowLayout.debug("RowLayout.getMinLowerBoundary(): row " + this.m_index, 6);
        if (this.m_minSize == 0) {
            return this.m_minLocation;
        }
        return this.m_minLocation + this.m_minSize;
    }

    protected int getUpperBoundary() {
        RowLayout.debug("RowLayout.getUpperBoundary(): row " + this.m_index, 8);
        return this.m_currLocation;
    }

    public void doLayout() {
        RowLayout.debug("RowLayout.doLayout(): row " + this.m_index, 8);
        if (this.m_previousRow != null) {
            this.m_previousRow.doLayout();
        }
        if (this.m_followingRow != null) {
            int n = this.m_followingRow.getUpperBoundary() - this.m_containingLayout.getInternalVGap() - this.m_currLocation;
            RowLayout.debug("RowLayout.doLayout(): row " + this.m_index + ", following upper bound - gap " + (this.m_followingRow.getUpperBoundary() - this.m_containingLayout.getInternalVGap()), 8);
            RowLayout.debug("RowLayout.doLayout(): row " + this.m_index + ", m_currLocation " + this.m_currLocation, 8);
            RowLayout.debug("RowLayout.doLayout(): row " + this.m_index + ", room " + n, 8);
            Enumeration enumeration = this.m_components.elements();
            while (enumeration.hasMoreElements()) {
                ((ComponentLayout)enumeration.nextElement()).doLayout(n, this);
            }
        }
    }

    public static void debug(String string, int n) {
        if (n <= 0) {
            for (int i = 0; i < n; ++i) {
                string = "-" + string;
            }
            System.out.println(string);
        }
    }

    class ComponentLayout {
        private Component m_component = null;
        private RowLayout m_anchor = null;

        public ComponentLayout(Component component) {
            RowLayout.debug("ComponentLayout.ComponentLayout(Component)", 3);
            this.m_component = component;
        }

        public void setAnchor(RowLayout rowLayout) {
            RowLayout.debug("ComponentLayout.setAnchor(RowLayout): index " + RowLayout.this.getIndex(), 3);
            this.m_anchor = rowLayout;
        }

        public boolean hasComponent(Component component) {
            return this.m_component == component;
        }

        public void doLayout(int n, RowLayout rowLayout) {
            RowLayout.debug("ComponentLayout.doLayout(int, RowLayout): room " + n + ", thisRow index " + rowLayout.getIndex() + ", this index " + RowLayout.this.getIndex(), 8);
            if (this.m_anchor != null) {
                RowLayout.debug("ComponentLayout.doLayout(int, RowLayout): m_anchor " + this.m_anchor.getIndex(), 8);
            }
            if (this.m_anchor == null || this.m_anchor.getIndex() == rowLayout.getIndex()) {
                int n2 = rowLayout.m_currLocation;
                if (this.m_component.getPreferredSize().height <= n) {
                    n2 = (int)((float)n2 + (float)(n - this.m_component.getPreferredSize().height) * this.m_component.getAlignmentY());
                }
                RowLayout.debug("ComponentLayout.doLayout(int, RowLayout): setting location to " + n2, 8);
                this.m_component.setLocation(this.m_component.getLocation().x, n2);
            }
            if (this.m_anchor == null || this.m_anchor.getIndex() != rowLayout.getIndex()) {
                if (this.m_anchor != null && this.m_anchor.getIndex() != rowLayout.getIndex()) {
                    RowLayout.debug("ComponentLayout.doLayout(int, RowLayout): m_currLocation " + rowLayout.m_currLocation + ", anchor top " + this.m_anchor.getUpperBoundary() + "; adding " + (rowLayout.m_currLocation - this.m_anchor.getUpperBoundary()) + " to room", 8);
                    RowLayout.debug("ComponentLayout.doLayout(int, RowLayout): room is now " + (n += rowLayout.m_currLocation - this.m_anchor.getUpperBoundary()), 8);
                }
                if (this.m_component.getPreferredSize().height <= n) {
                    RowLayout.debug("ComponentLayout.doLayout(int, RowLayout): setting size to " + this.m_component.getPreferredSize().height, 8);
                    this.m_component.setSize(this.m_component.getSize().width, this.m_component.getPreferredSize().height);
                } else if (this.m_component.getMinimumSize().height < n) {
                    RowLayout.debug("ComponentLayout.doLayout(int, RowLayout): setting size to " + n, 8);
                    this.m_component.setSize(this.m_component.getSize().width, n);
                } else {
                    RowLayout.debug("ComponentLayout.doLayout(int, RowLayout): setting size to " + this.m_component.getMinimumSize().height, 8);
                    this.m_component.setSize(this.m_component.getSize().width, this.m_component.getMinimumSize().height);
                }
            }
        }

        public int getMinimumSize(RowLayout rowLayout) {
            RowLayout.debug("ComponentLayout.getMinimumSize(RowLayout): row " + RowLayout.this.getIndex() + ", thisRow " + rowLayout.getIndex(), 6);
            if (this.m_anchor != null && this.m_anchor.getIndex() == rowLayout.getIndex()) {
                return 0;
            }
            if (this.m_anchor != null && this.m_anchor.getIndex() != rowLayout.getIndex()) {
                RowLayout.debug("ComponentLayout.getMinimumSize(): found buoy: component height " + this.m_component.getMinimumSize().height + ", anchor location " + this.m_anchor.m_minLocation + ", thisRow location " + rowLayout.m_minLocation, 8);
                int n = this.m_component.getMinimumSize().height - (rowLayout.m_minLocation - this.m_anchor.m_minLocation);
                if (n <= 0) {
                    return 0;
                }
                return n;
            }
            return this.m_component.getMinimumSize().height;
        }

        public int getPreferredSize(RowLayout rowLayout) {
            RowLayout.debug("ComponentLayout.getPreferredSize(RowLayout): row " + RowLayout.this.getIndex() + ", thisRow " + rowLayout.getIndex(), 6);
            if (this.m_anchor != null && this.m_anchor.getIndex() == rowLayout.getIndex()) {
                return 0;
            }
            if (this.m_anchor != null && this.m_anchor.getIndex() != rowLayout.getIndex()) {
                int n = this.m_component.getPreferredSize().height - (rowLayout.m_prefLocation - this.m_anchor.m_prefLocation);
                if (n <= 0) {
                    return 0;
                }
                return n;
            }
            return this.m_component.getPreferredSize().height;
        }
    }
}

