/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.BitSetConversionUtils;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5BooleanReader;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5BooleanWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.util.BitSet;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

public class HDF5BooleanWriter
extends HDF5BooleanReader
implements IHDF5BooleanWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5BooleanWriter(HDF5BaseWriter baseWriter) {
        super(baseWriter);
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void setAttr(String objectPath, String name, boolean value) {
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, this.baseWriter.booleanDataTypeId, this.baseWriter.booleanDataTypeId, new byte[]{(byte)(value ? 1 : 0)});
    }

    @Override
    public void write(String objectPath, boolean value) {
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, this.baseWriter.booleanDataTypeId, this.baseWriter.booleanDataTypeId, HDFNativeData.byteToByte((byte)(value ? 1 : 0)));
    }

    @Override
    public void writeBitField(String objectPath, BitSet data) {
        this.writeBitField(objectPath, data, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void writeBitField(final String objectPath, final BitSet data, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int msb = data.length();
                int realLength = msb / 64 + (msb % 64 != 0 ? 1 : 0);
                int dataSetId = HDF5BooleanWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_B64LE, new long[]{realLength}, 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_B64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, BitSetConversionUtils.toStorageForm(data));
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createBitField(String objectPath, int size) {
        this.createBitField(objectPath, size, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createBitField(String objectPath, long size, int blockSize) {
        this.createBitField(objectPath, size, blockSize, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void createBitField(final String objectPath, final int size, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5BooleanWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_B64LE, features, new long[1], new long[]{size}, 8, registry);
                } else {
                    HDF5BooleanWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_B64LE, features, new long[]{size}, null, 8, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createBitField(final String objectPath, final long size, final int blockSize, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5BooleanWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_B64LE, features, new long[]{size}, new long[]{blockSize}, 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void writeBitFieldBlock(String objectPath, BitSet data, int dataSize, long blockNumber) {
        this.writeBitFieldBlockWithOffset(objectPath, data, dataSize, (long)dataSize * blockNumber);
    }

    @Override
    public void writeBitFieldBlockWithOffset(final String objectPath, final BitSet data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.fileId, objectPath, ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_B64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, BitSetConversionUtils.toStorageForm(data, dataSize));
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeBitFieldArray(String objectPath, BitSet[] data) {
        this.writeBitFieldArray(objectPath, data, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeBitFieldArray(final String objectPath, final BitSet[] data, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int msb = BitSetConversionUtils.getMaxLength(data);
                int numberOfWords = msb / 64 + (msb % 64 != 0 ? 1 : 0);
                if (features.isScaling() && msb < 64) {
                    features.checkScalingOK(((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.fileFormat);
                    HDF5IntStorageFeatures actualFeatures = HDF5IntStorageFeatures.build(features).scalingFactor((byte)msb).features();
                    int dataSetId = HDF5BooleanWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_U64LE, new long[]{numberOfWords, data.length}, 8, actualFeatures, registry);
                    H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, BitSetConversionUtils.toStorageForm(data, numberOfWords));
                    HDF5BooleanWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.BITFIELD, registry);
                } else {
                    HDF5IntStorageFeatures actualFeatures = HDF5IntStorageFeatures.build(features).noScaling().features();
                    int dataSetId = HDF5BooleanWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_B64LE, new long[]{numberOfWords, data.length}, 8, actualFeatures, registry);
                    H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_B64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, BitSetConversionUtils.toStorageForm(data, numberOfWords));
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createBitFieldArray(final String objectPath, final int bitFieldSize, final long arraySize, final long arrayBlockSize, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int numberOfWords = bitFieldSize / 64 + (bitFieldSize % 64 != 0 ? 1 : 0);
                if (features.requiresChunking() || arraySize > 0L) {
                    this.create(objectPath, new long[]{numberOfWords, arraySize}, new long[]{numberOfWords, arrayBlockSize}, features, registry);
                } else {
                    this.create(objectPath, new long[]{numberOfWords, arrayBlockSize}, null, features, registry);
                }
                return null;
            }

            void create(String objectPath2, long[] dimensions, long[] blockDimensionsOrNull, HDF5IntStorageFeatures features2, ICleanUpRegistry registry) {
                if (features2.isScaling() && bitFieldSize < 64) {
                    features2.checkScalingOK(((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.fileFormat);
                    HDF5IntStorageFeatures actualFeatures = HDF5IntStorageFeatures.build(features2).scalingFactor((byte)bitFieldSize).features();
                    int dataSetId = HDF5BooleanWriter.this.baseWriter.createDataSet(objectPath2, HDF5Constants.H5T_STD_U64LE, actualFeatures, dimensions, blockDimensionsOrNull, 8, registry);
                    HDF5BooleanWriter.this.baseWriter.setTypeVariant(dataSetId, HDF5DataTypeVariant.BITFIELD, registry);
                } else {
                    HDF5IntStorageFeatures actualFeatures = HDF5IntStorageFeatures.build(features2).noScaling().features();
                    HDF5BooleanWriter.this.baseWriter.createDataSet(objectPath2, HDF5Constants.H5T_STD_B64LE, actualFeatures, dimensions, blockDimensionsOrNull, 8, registry);
                }
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createBitFieldArray(String objectPath, int bitFieldSize, long arrayBlockSize, HDF5IntStorageFeatures features) {
        this.createBitFieldArray(objectPath, bitFieldSize, 0L, arrayBlockSize, features);
    }

    @Override
    public void createBitFieldArray(String objectPath, int bitFieldSize, long arraySize, long arrayBlockSize) {
        this.createBitFieldArray(objectPath, bitFieldSize, arraySize, arrayBlockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createBitFieldArray(String objectPath, int bitFieldSize, long arrayBlockSize) {
        this.createBitFieldArray(objectPath, bitFieldSize, 0L, arrayBlockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void writeBitFieldArrayBlockWithOffset(final String objectPath, final BitSet[] data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.fileId, objectPath, ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.fileFormat, new long[]{-1L, offset + (long)dataSize}, -1, registry);
                long[] dimensions = ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.getDataDimensions(dataSetId, registry);
                if (dimensions.length != 2) {
                    throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + dimensions.length);
                }
                int numberOfWords = HDF5BooleanWriter.dimToInt(dimensions[0]);
                long[] blockDimensions = new long[]{numberOfWords, dataSize};
                long[] lArray = new long[2];
                lArray[1] = offset;
                long[] slabStartOrNull = lArray;
                int dataSpaceId = ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                if (HDF5BooleanWriter.this.baseWriter.isScaledBitField(dataSetId, registry)) {
                    H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_UINT64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, BitSetConversionUtils.toStorageForm(data, numberOfWords));
                } else {
                    H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_B64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, BitSetConversionUtils.toStorageForm(data, numberOfWords));
                }
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeBitFieldArrayBlockWithOffset(String objectPath, BitSet[] data, long offset) {
        this.writeBitFieldArrayBlockWithOffset(objectPath, data, data.length, offset);
    }

    @Override
    public void writeBitFieldArrayBlock(String objectPath, BitSet[] data, int dataSize, long blockNumber) {
        this.writeBitFieldArrayBlockWithOffset(objectPath, data, dataSize, (long)dataSize * blockNumber);
    }

    @Override
    public void writeBitFieldArrayBlock(String objectPath, BitSet[] data, long blockNumber) {
        this.writeBitFieldArrayBlock(objectPath, data, data.length, blockNumber);
    }
}

