/*
 * Decompiled with CFR 0.152.
 */
package edsim51di.color;

import edsim51di.Gui;
import edsim51di.color.ColorButton;
import edsim51di.color.Preview;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ColorPicker
extends JPanel
implements ActionListener {
    private JColorChooser colorChooser = new JColorChooser();
    private JDialog dialog;
    private ColorButton pickerButton;
    private Gui gui;

    public ColorPicker(Gui gui, int pickerButtonSize) {
        this.gui = gui;
        this.colorChooser.setColor(gui.getColor());
        this.colorChooser.setPreviewPanel(new Preview(this.colorChooser));
        this.dialog = JColorChooser.createDialog(this, "Pick a colour for the target board ...", false, this.colorChooser, this, null);
        this.pickerButton = new ColorButton(pickerButtonSize);
        this.pickerButton.addActionListener(this);
        this.add(this.pickerButton);
    }

    public ColorButton getButton() {
        return this.pickerButton;
    }

    public void setColor(Color c) {
        this.colorChooser.setColor(c);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.pickerButton) {
            this.dialog.setVisible(true);
            return;
        }
        this.gui.setColor(this.colorChooser.getColor());
    }
}

