/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Gui;
import edsim51di.UartAlwaysOnTopCheckboxPanel;
import edsim51di.UartGraphics;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

class UartFloatingFrame
extends JFrame {
    private Gui gui;
    private JScrollPane sp;
    private JScrollPane rxScrollPane;
    private JScrollPane txScrollPane;
    private JButton unlockButton;
    private boolean small;
    private UartGraphics uartGraphics;
    private Dimension floatingUartDimensionSmall = new Dimension(900, 600);
    private Dimension floatingUartDimensionLarge = new Dimension(1000, 600);
    private Dimension floatingUartDataFieldDimension = new Dimension(750, 250);
    private UartAlwaysOnTopCheckboxPanel alwaysOnTopCheckboxPanel;

    UartFloatingFrame(Gui gui, UartGraphics uartGraphics, JScrollPane rxScrollPane, JScrollPane txScrollPane, JButton unlockButton) {
        this.setAlwaysOnTop(true);
        this.gui = gui;
        this.uartGraphics = uartGraphics;
        this.rxScrollPane = rxScrollPane;
        this.txScrollPane = txScrollPane;
        this.unlockButton = unlockButton;
        this.setTitle("EdSim51DI - External UART - close this window to lock UART in main window");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UartFloatingFrame.this.close(true);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                UartFloatingFrame.this.updateUartGraphics();
            }
        });
    }

    void updateUartGraphics() {
        this.uartGraphics.invalidate();
        this.uartGraphics.updateUI();
        this.invalidate();
    }

    JCheckBox getAlwaysOnTopCheckBox() {
        return this.alwaysOnTopCheckboxPanel.getCheckbox();
    }

    void open(boolean small) {
        this.alwaysOnTopCheckboxPanel = new UartAlwaysOnTopCheckboxPanel(small, this, this.getForeground());
        this.small = small;
        this.unlockButton.setEnabled(false);
        Gui.setSize(this.rxScrollPane, this.floatingUartDataFieldDimension);
        Gui.setSize(this.txScrollPane, this.floatingUartDataFieldDimension);
        if (small) {
            Gui.setSize(this.uartGraphics, this.floatingUartDimensionSmall);
        } else {
            Gui.setSize(this.uartGraphics, this.floatingUartDimensionLarge);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.sp = new JScrollPane(this.uartGraphics);
        this.getContentPane().add(this.sp);
        this.gui.unlockUartGraphics();
        this.uartGraphics.addUartAlwaysOnTopCheckbox(this.alwaysOnTopCheckboxPanel);
        this.pack();
        this.setVisible(true);
    }

    void close(boolean resize) {
        this.setVisible(false);
        this.remove(this.sp);
        this.unlockButton.setEnabled(true);
        if (resize) {
            this.uartGraphics.setSize(this.small);
        }
        this.uartGraphics.removeUartAlwaysOnTopCheckbox(this.alwaysOnTopCheckboxPanel);
        this.gui.lockUartGraphics();
    }
}

