/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.Mapping;
import edsim51di.MultiplexedDisplayGraphics;
import edsim51di.Peripheral;
import edsim51di.logicdiagram.LogicDiagramInterface;

class MultiplexedDisplay
extends Peripheral {
    private double[] data = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7};
    private double CS = 0.7;
    private double INPUT0 = 3.3;
    private double INPUT1 = 3.4;
    private int csPort;
    private int csPin;
    private int input0Port;
    private int input0Pin;
    private int input1Port;
    private int input1Pin;
    private boolean cs = false;
    private boolean input0 = true;
    private boolean input1 = true;
    private MultiplexedDisplayGraphics displayGraphics = new MultiplexedDisplayGraphics();
    private Board board;

    MultiplexedDisplay(Board board) {
        super("Multiplexed^7-segment^Display", false);
        this.board = board;
        double[] d = board.getPortMapSetting("multidisplay_dbs");
        if (d != null) {
            this.data = d;
        }
        if ((d = board.getPortMapSetting("multidisplay_cs")) != null) {
            this.CS = d[0];
        }
        if ((d = board.getPortMapSetting("multidisplay_input0")) != null) {
            this.INPUT0 = d[0];
        }
        if ((d = board.getPortMapSetting("multidisplay_input1")) != null) {
            this.INPUT1 = d[0];
        }
        String[] descriptions = new String[]{"Seg. a", "Seg. b", "Seg. c", "Seg. d", "Seg. e", "Seg. f", "Seg. g", "Seg. dp"};
        this.initDataLineMappings(this.data, descriptions);
        this.csPort = this.getPortNumber(this.CS);
        this.csPin = this.getPinNumber(this.CS);
        this.input0Port = this.getPortNumber(this.INPUT0);
        this.input0Pin = this.getPinNumber(this.INPUT0);
        this.input1Port = this.getPortNumber(this.INPUT1);
        this.input1Pin = this.getPinNumber(this.INPUT1);
    }

    @Override
    public LogicDiagramInterface[] getLogicDiagramInterfaces() {
        LogicDiagramInterface[] interfaces = new LogicDiagramInterface[11];
        int start = 282;
        for (int i = 0; i < 8; ++i) {
            interfaces[i] = new LogicDiagramInterface();
            interfaces[i].peripheralPin = start;
            interfaces[i].portNumber = this.dataLineMappings[i].portNumber;
            interfaces[i].pinNumber = this.dataLineMappings[i].pinNumber;
            start -= 10;
        }
        interfaces[8] = new LogicDiagramInterface();
        interfaces[8].peripheralPin = 67;
        interfaces[8].portNumber = this.input0Port;
        interfaces[8].pinNumber = this.input0Pin;
        interfaces[9] = new LogicDiagramInterface();
        interfaces[9].peripheralPin = 53;
        interfaces[9].portNumber = this.input1Port;
        interfaces[9].pinNumber = this.input1Pin;
        interfaces[10] = new LogicDiagramInterface();
        interfaces[10].peripheralPin = 47;
        interfaces[10].portNumber = this.csPort;
        interfaces[10].pinNumber = this.csPin;
        return interfaces;
    }

    Mapping getCSMapping() {
        return new Mapping(this.csPort, this.csPin, "Display-select Decoder CS");
    }

    Mapping getINPUT0Mapping() {
        return new Mapping(this.input0Port, this.input0Pin, "Display-select Input 0");
    }

    Mapping getINPUT1Mapping() {
        return new Mapping(this.input1Port, this.input1Pin, "Display-select Input 1");
    }

    MultiplexedDisplayGraphics getGraphics() {
        return this.displayGraphics;
    }

    void cycle() {
        this.displayGraphics.turnAllOff();
        boolean bl = this.cs = this.board.readPortPin(this.csPort, this.csPin) == 1;
        if (!this.cs) {
            return;
        }
        int dataLines = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.board.readPortPin(this.dataLineMappings[i].portNumber, this.dataLineMappings[i].pinNumber) != 1) continue;
            dataLines += 1 << i;
        }
        this.displayGraphics.write(dataLines);
        this.input0 = this.board.readPortPin(this.input0Port, this.input0Pin) == 1;
        this.input1 = this.board.readPortPin(this.input1Port, this.input1Pin) == 1;
        int displayNumber = 0;
        if (this.input1) {
            displayNumber = 2;
        }
        if (this.input0) {
            ++displayNumber;
        }
        this.displayGraphics.turnOn(displayNumber);
    }

    void refreshGraphics() {
        this.displayGraphics.updateGraphics();
    }
}

