/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.LEDBankGraphics;
import edsim51di.Peripheral;
import edsim51di.logicdiagram.LogicDiagramInterface;
import java.awt.Color;

class LEDBank
extends Peripheral {
    private double[] ledPins = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7};
    private Color[] colors = new Color[]{Color.RED, Color.ORANGE, Color.GREEN, Color.RED, Color.ORANGE, Color.GREEN, Color.RED, Color.ORANGE};
    private LEDBankGraphics graphics = new LEDBankGraphics(this.colors);
    private Board board;

    LEDBank(Board board) {
        super("LED Bank", true);
        this.board = board;
        double[] d = board.getPortMapSetting("leds_dbs");
        if (d != null) {
            this.ledPins = d;
        }
        this.initDataLineMappings(this.ledPins, "LED ");
    }

    @Override
    public LogicDiagramInterface[] getLogicDiagramInterfaces() {
        LogicDiagramInterface[] interfaces = new LogicDiagramInterface[8];
        int start = 512;
        for (int i = 0; i < 8; ++i) {
            interfaces[i] = new LogicDiagramInterface();
            interfaces[i].peripheralPin = start;
            interfaces[i].portNumber = this.dataLineMappings[i].portNumber;
            interfaces[i].pinNumber = this.dataLineMappings[i].pinNumber;
            start -= 44;
        }
        return interfaces;
    }

    LEDBankGraphics getGraphics() {
        return this.graphics;
    }

    void cycle() {
        for (int i = 0; i < 8; ++i) {
            this.graphics.turnOn(i, this.board.readPortPin(this.dataLineMappings[i].portNumber, this.dataLineMappings[i].pinNumber) == 0);
        }
    }

    void refreshGraphics() {
        this.graphics.updateGraphics();
    }
}

