/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.Board;
import edsim51di.KeypadGraphics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class Key
extends JButton {
    private final double BOUNCE_LENGTH = 30000.0;
    private boolean small = true;
    private int keyNumber;
    private int rowPort;
    private int rowPin;
    private int columnPort;
    private int columnPin;
    private Board board;
    private KeypadGraphics keypad;
    private boolean keyOpen = true;
    private double keyBounceTime = 0.0;
    private boolean justStoppedBouncing = false;
    private Color keyColor;
    private Color normalColor;
    private Color bounceColor = Color.RED;
    private Random random = new Random();

    Key(int keyNumber, String label, int rowPort, int rowPin, int columnPort, int columnPin, Board board, KeypadGraphics keypad) {
        super(label);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setFontSize();
        this.setDimension();
        this.keyNumber = keyNumber;
        this.rowPort = rowPort;
        this.rowPin = rowPin;
        this.columnPort = columnPort;
        this.columnPin = columnPin;
        this.board = board;
        this.keypad = keypad;
        this.setToolTipText("key " + keyNumber + " | right-click to change label");
        this.keyColor = this.normalColor = this.getBackground();
    }

    int getRowPort() {
        return this.rowPort;
    }

    int getRowPin() {
        return this.rowPin;
    }

    int getColumnPort() {
        return this.columnPort;
    }

    int getColumnPin() {
        return this.columnPin;
    }

    boolean isKeyOpen() {
        return this.keyOpen;
    }

    boolean isKeyClosed() {
        return !this.keyOpen;
    }

    void closeKey() {
        this.keyOpen = false;
        this.keypad.updatePortPins();
        this.setBackground(this.keyColor.darker());
    }

    void openKey(boolean resetting) {
        this.keyOpen = true;
        if (!resetting) {
            this.keypad.updatePortPins();
        }
        this.setBackground(this.keyColor);
    }

    void synchroniseKeyGraphics() {
        if (this.keyOpen) {
            this.setBackground(this.keyColor);
        } else {
            this.setBackground(this.keyColor.darker());
        }
    }

    void bounceKey(double lastInstructionElapsedTimeInNanos) {
        double time = lastInstructionElapsedTimeInNanos / 1000.0;
        this.decreaseBounceTime(time);
        if (this.isKeyBouncing()) {
            if (this.random.nextBoolean()) {
                this.keyOpen = !this.keyOpen;
            }
        } else if (this.hasKeyJustStoppedBouncing()) {
            this.closeKey();
        }
    }

    private void decreaseBounceTime(double time) {
        if (this.isKeyBouncing()) {
            this.keyBounceTime -= time;
            if (this.keyBounceTime <= 0.0) {
                this.keyBounceTime = 0.0;
                this.keyColor = this.normalColor;
                this.justStoppedBouncing = true;
            }
        }
    }

    private boolean hasKeyJustStoppedBouncing() {
        boolean b = this.justStoppedBouncing;
        if (b) {
            this.justStoppedBouncing = false;
        }
        return b;
    }

    private void startKeyBounce() {
        this.keyBounceTime = 30000.0;
        this.keyColor = this.bounceColor;
        this.setBackground(this.keyColor);
    }

    void stopKeyBounce() {
        this.keyBounceTime = 0.0;
        this.keyColor = this.normalColor;
    }

    private boolean isKeyBouncing() {
        if (this.keyBounceTime > 0.0) {
            return true;
        }
        this.keyBounceTime = 0.0;
        return false;
    }

    private void renameKey() {
        String newLabel = JOptionPane.showInputDialog(this, "Key labels can be any length\n(keypad will automatically rezise).\n\nCurrent Label: " + this.getText(), "Change Key Label", 3);
        if (newLabel == null) {
            return;
        }
        if (!(newLabel = newLabel.trim()).equals("")) {
            this.setText(newLabel);
            this.keypad.setKeyDimensions();
            this.board.setHardwareSetting("key" + this.keyNumber + ":label", newLabel);
        }
    }

    private void openAllKeysExceptThisOne() {
        for (int i = 0; i < this.keypad.keys.length; ++i) {
            if (i == this.keyNumber || !this.keypad.keys[i].isKeyClosed()) continue;
            this.keypad.keys[i].openKey(false);
        }
    }

    @Override
    public void setText(String s) {
        super.setText(s);
        this.setDimension();
    }

    void setSmall(boolean small) {
        this.small = small;
        this.setFontSize();
    }

    boolean isSmall() {
        return this.small;
    }

    void setDimension(int textLength) {
        Dimension d = new Dimension(10 + 12 * textLength, 25);
        d = this.scale(d);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
    }

    void setDimension() {
        this.setDimension(this.getText().length());
    }

    private Dimension scale(Dimension d) {
        if (this.small) {
            return d;
        }
        int w = d.width;
        int h = d.height;
        w = w * 3 / 2;
        h = h * 3 / 2;
        return new Dimension(w, h);
    }

    private void setFontSize() {
        int size = 12;
        if (!this.small) {
            size = size * 3 / 2;
        }
        Font font = this.getFont();
        font = new Font(font.getName(), font.getStyle(), size);
        this.setFont(font);
    }

    void mousePressed(MouseEvent event) {
        boolean rightClick;
        boolean bl = rightClick = (event.getModifiers() & 4) == 4;
        if (rightClick) {
            this.renameKey();
        } else if (this.keypad.getKeypadType() == 1 && this.keyOpen) {
            this.doClick();
            this.closeKey();
        } else if (this.keyOpen) {
            if (this.keypad.getKeypadType() == 0 && this.keypad.isKeyBounceEnabled()) {
                this.startKeyBounce();
            }
            this.closeKey();
            if (this.keypad.getKeypadType() == 2) {
                this.openAllKeysExceptThisOne();
            }
        } else {
            this.stopKeyBounce();
            this.openKey(false);
        }
    }

    void mouseReleased() {
        if (this.keypad.getKeypadType() == 1 && !this.keyOpen) {
            this.openKey(false);
        }
    }
}

