/*
 * Decompiled with CFR 0.152.
 */
package edsim51di;

import edsim51di.ADC;
import edsim51di.Board;
import edsim51di.Comparator;
import edsim51di.DAC;
import edsim51di.KeypadGraphics;
import edsim51di.LCDModule;
import edsim51di.LEDBank;
import edsim51di.Motor;
import edsim51di.MultiplexedDisplay;
import edsim51di.Peripheral;
import edsim51di.PeripheralMainPanel;
import edsim51di.SwitchBank;
import edsim51di.Uart;
import edsim51di.color.ColorPicker;
import edsim51di.logicdiagram.LogicDiagram;
import edsim51sh.EdSim51Button;
import edsim51sh.InfoButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class Gui
extends JPanel
implements ActionListener {
    public static final Color BOARD_COLOR = new Color(117, 194, 43);
    static final Color UNEDITABLE_FIELD_GREY = new Color(220, 220, 220);
    private InfoButton diInfoButton = new InfoButton(this, "Dynamic Interface:\nSwitch the peripherals to whatver ports you like.\nRestart required.\n\nTo restore default settings (including hardware and simulator settings), delete the following files:\n\n    edsim51diSettings.ser\n    edsim51diHardwareSettings.ser\n\nOn Windows or Mac, the files will most likely be in the same folder as edsim51di.jar.\nOn Linux, the files will most likely be in the user's home folder.\n\n\nLogic Diagram:\nDiagram depicts the current hardware interface.", "EdSim51DI - Dynamic Interface/Logic Diagram Information", "information");
    private boolean firstTime = true;
    private JPanel mainPanel;
    private JButton DIButton;
    private KeypadGraphics keypad;
    private LCDModule lcdModule;
    private MultiplexedDisplay LEDDisplay;
    private ADC adc;
    private DAC dac;
    private Comparator comparator;
    private Motor motor;
    private LEDBank ledBank;
    private SwitchBank switchBank;
    private Uart uart;
    private GridBagConstraints uartGbc;
    private JPanel dummyUartPanel = new JPanel();
    private EdSim51Button logicDiagramButton = new EdSim51Button("LD");
    private LogicDiagram logicDiagram;
    private Peripheral[] peripherals = new Peripheral[10];
    private ColorPicker colorPicker;
    private JPanel DIAndBanksAndKeypadPanel;
    private JPanel motorPanel;
    private PeripheralMainPanel DIButtonPanel;
    private Board board;

    Gui(boolean small, Board board) {
        this.board = board;
        this.keypad = new KeypadGraphics(board);
        this.lcdModule = new LCDModule(board);
        this.LEDDisplay = new MultiplexedDisplay(board);
        this.dac = new DAC(board);
        this.comparator = new Comparator(board, this.dac, this.keypad);
        this.adc = new ADC(board, this.comparator.getGraphics(), this.keypad);
        this.motor = new Motor(board, this.keypad);
        this.ledBank = new LEDBank(board);
        this.switchBank = new SwitchBank(board, this.keypad);
        this.uart = new Uart(board, this, this.keypad);
        this.colorPicker = new ColorPicker(this, 40);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBackground(BOARD_COLOR);
        this.DIButton = board.getDynamicInterfaceLaunchButton();
        this.DIButton.setMargin(new Insets(1, 1, 1, 1));
        this.DIButton.setText("DI");
        this.DIButton.setToolTipText("dynamic interface");
        this.DIButtonPanel = new PeripheralMainPanel();
        this.DIButtonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(4, 4, 4, 10);
        this.DIButtonPanel.add((Component)this.DIButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 10);
        this.DIButtonPanel.add((Component)this.diInfoButton, gbc);
        this.logicDiagramButton.setToolTipText("logic diagram");
        this.logicDiagramButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 4);
        this.DIButtonPanel.add((Component)this.logicDiagramButton, gbc);
        this.DIAndBanksAndKeypadPanel = new JPanel();
        this.DIAndBanksAndKeypadPanel.setBackground(BOARD_COLOR);
        this.DIAndBanksAndKeypadPanel.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 100);
        gbc.anchor = 18;
        this.DIAndBanksAndKeypadPanel.add((Component)this.DIButtonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 0, 0);
        this.DIAndBanksAndKeypadPanel.add((Component)this.ledBank.getGraphics(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.DIAndBanksAndKeypadPanel.add((Component)this.switchBank.getGraphics(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 3;
        this.DIAndBanksAndKeypadPanel.add((Component)this.keypad, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 12;
        gbc.insets = new Insets(0, 0, 0, 5);
        this.mainPanel.add((Component)this.DIAndBanksAndKeypadPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.anchor = 15;
        this.mainPanel.add((Component)this.dac.getGraphics(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.mainPanel.add((Component)this.lcdModule.getGraphics(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 0, 0, 0);
        this.mainPanel.add((Component)this.LEDDisplay.getGraphics(), gbc);
        this.uartGbc = new GridBagConstraints();
        this.uartGbc.gridx = 2;
        this.uartGbc.gridy = 0;
        this.mainPanel.add((Component)this.uart.getGraphics(), this.uartGbc);
        this.dummyUartPanel.setBackground(BOARD_COLOR.brighter());
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.mainPanel.add((Component)this.adc.getGraphics(), gbc);
        this.motorPanel = new JPanel();
        this.motorPanel.setLayout(new GridBagLayout());
        this.motorPanel.setBackground(BOARD_COLOR);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 10, 10, 10);
        gbc.anchor = 12;
        this.motorPanel.add((Component)this.colorPicker.getButton(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.motorPanel.add((Component)this.motor.getGraphics(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.mainPanel.add((Component)this.motorPanel, gbc);
        this.add(this.mainPanel);
        this.peripherals[0] = this.switchBank;
        this.peripherals[1] = this.ledBank;
        this.peripherals[2] = this.dac;
        this.peripherals[3] = this.keypad.getKeypadForLogicDiagram();
        this.peripherals[4] = this.lcdModule;
        this.peripherals[5] = this.uart;
        this.peripherals[6] = this.LEDDisplay;
        this.peripherals[7] = this.adc;
        this.peripherals[8] = this.comparator;
        this.peripherals[9] = this.motor;
        try {
            int color = Integer.parseInt(board.getHardwareSetting("colour"));
            this.setColor(new Color(color));
        }
        catch (NumberFormatException ex) {
            this.setColor(BOARD_COLOR);
        }
    }

    public Color getColor() {
        return this.getBackground();
    }

    public void setColor(Color color) {
        if (this.getBackground().getRGB() == color.getRGB()) {
            return;
        }
        this.setBackground(color);
        this.mainPanel.setBackground(color);
        this.colorPicker.setBackground(color);
        this.DIAndBanksAndKeypadPanel.setBackground(color);
        this.dummyUartPanel.setBackground(color.brighter());
        this.motorPanel.setBackground(color);
        this.keypad.setBackground(color.darker());
        this.uart.getGraphics().setBackground(color.darker());
        this.lcdModule.getGraphics().setBackground(color.darker());
        this.DIButtonPanel.setBackground(color.darker().darker().darker());
        this.dac.getGraphics().setScopeColor(color.darker());
        this.colorPicker.setColor(color);
        this.board.setHardwareSetting("colour", "" + color.getRGB());
    }

    public static void setSize(Component c, Dimension d) {
        c.setMaximumSize(d);
        c.setMinimumSize(d);
        c.setPreferredSize(d);
    }

    public static void setFont(Component c, int style, int size) {
        Font font = c.getFont();
        c.setFont(new Font(font.getName(), style, size));
    }

    public static void setSize(Component c, Dimension d, int fontStyle, int fontSize) {
        Gui.setFont(c, fontStyle, fontSize);
        Gui.setSize(c, d);
    }

    public static void setSize(JButton b, int fontStyle, int fontSize, String textA, String textB) {
        Gui.setFont(b, fontStyle, fontSize);
        String s = b.getText();
        JButton temp = textA.length() > textB.length() ? new JButton(textA) : new JButton(textB);
        Gui.setFont(temp, fontStyle, fontSize);
        Dimension d = temp.getPreferredSize();
        b.setMaximumSize(d);
        b.setMinimumSize(d);
        b.setPreferredSize(d);
        b.setText(s);
    }

    void reset() {
        this.keypad.reset();
        this.lcdModule.reset();
        this.adc.foredReset();
        this.motor.reset();
        this.switchBank.getGraphics().reset();
        this.uart.getGraphics().reset();
    }

    void refresh() {
        this.keypad.refreshGraphics();
        this.lcdModule.refreshGraphics();
        this.LEDDisplay.refreshGraphics();
        if (this.adc.isEnabled()) {
            this.adc.refreshGraphics();
        }
        this.dac.refreshGraphics();
        this.motor.refreshGraphics();
        this.ledBank.refreshGraphics();
        this.uart.updateGraphics();
    }

    void updatePortPins(int instructionElapsedTime) {
        this.lcdModule.update();
        this.LEDDisplay.cycle();
        this.adc.cycle(instructionElapsedTime);
        this.dac.cycle();
        this.comparator.cycle(this.dac.getOutputVoltage());
        this.motor.cycle(instructionElapsedTime);
        this.ledBank.cycle();
        this.uart.updatePortPins();
        this.keypad.update();
    }

    void setSize(boolean small) {
        if (small) {
            Gui.setFont(this.DIButton, 1, 12);
            Gui.setFont(this.logicDiagramButton, 1, 12);
        } else {
            Gui.setFont(this.DIButton, 1, 18);
            Gui.setFont(this.logicDiagramButton, 1, 18);
        }
        this.keypad.setSize(small);
        this.lcdModule.getGraphics().setSize(small);
        this.LEDDisplay.getGraphics().setSize(small);
        this.adc.getGraphics().setSize(small);
        this.dac.getGraphics().setSize(small);
        this.comparator.getGraphics().setSize(small);
        this.motor.getGraphics().setSize(small);
        this.ledBank.getGraphics().setSize(small);
        this.switchBank.getGraphics().setSize(small);
        this.uart.getGraphics().setSize(small);
        if (this.firstTime) {
            this.uart.setBitRateInMachineCycles();
            this.firstTime = false;
        }
        Gui.setSize(this.dummyUartPanel, this.uart.getGraphics().getPreferredSize());
        this.diInfoButton.setSize(small);
    }

    void unlockUartGraphics() {
        this.mainPanel.remove(this.uart.getGraphics());
        this.mainPanel.add((Component)this.dummyUartPanel, this.uartGbc);
        this.uart.getGraphics().updateUI();
        this.mainPanel.updateUI();
    }

    void lockUartGraphics() {
        this.mainPanel.remove(this.dummyUartPanel);
        this.mainPanel.add((Component)this.uart.getGraphics(), this.uartGbc);
        this.uart.getGraphics().updateUI();
        this.mainPanel.updateUI();
    }

    KeypadGraphics getKeypad() {
        return this.keypad;
    }

    LCDModule getLcdModule() {
        return this.lcdModule;
    }

    MultiplexedDisplay getMultiplexedDisplay() {
        return this.LEDDisplay;
    }

    ADC getADC() {
        return this.adc;
    }

    DAC getDAC() {
        return this.dac;
    }

    Comparator getComparator() {
        return this.comparator;
    }

    Motor getMotor() {
        return this.motor;
    }

    LEDBank getLEDBank() {
        return this.ledBank;
    }

    SwitchBank getSwitchBank() {
        return this.switchBank;
    }

    Uart getUart() {
        return this.uart;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.logicDiagramButton) {
            if (this.logicDiagram == null) {
                this.logicDiagram = new LogicDiagram(this.peripherals);
            } else {
                this.logicDiagram.show();
            }
        }
    }
}

