/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.movx;

import edsim51sh.Memory;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.movx.MovxAatDptr;
import edsim51sh.instructions.movx.MovxAatReg;
import edsim51sh.instructions.movx.MovxAtDptrA;
import edsim51sh.instructions.movx.MovxAtRegA;

public class Movx
extends Instruction {
    public Movx() {
        this.mneumonic = "MOVX";
    }

    @Override
    public Instruction getInstruction(String mneumonic) {
        if (mneumonic.equals("MOVX A,@R0") || mneumonic.equals("MOVX A,@R1")) {
            int regNumber = mneumonic.charAt(9) - 48;
            return new MovxAatReg(regNumber);
        }
        if (mneumonic.equals("MOVX @R0,A") || mneumonic.equals("MOVX @R1,A")) {
            int regNumber = mneumonic.charAt(7) - 48;
            return new MovxAtRegA(regNumber);
        }
        if (mneumonic.equals("MOVX A,@DPTR")) {
            return new MovxAatDptr();
        }
        if (mneumonic.equals("MOVX @DPTR,A")) {
            return new MovxAtDptrA();
        }
        return null;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        return 0;
    }

    @Override
    public int getOpcode() {
        return -1;
    }
}

