/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.mov;

import edsim51sh.Memory;
import edsim51sh.Text;
import edsim51sh.instructions.mov.Mov;

public class MovAddressReg
extends Mov {
    private int registerNumber;

    public MovAddressReg(int registerNumber) {
        this.registerNumber = registerNumber;
        this.mneumonic = "MOV direct,Rn";
        this.size = 2;
        this.cycles = 2;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        ram.writeByte(this.operand0, ram.readRegister(this.registerNumber));
        return this.incrementPc(pc);
    }

    @Override
    public void extractOperand0String(String line) throws Exception {
        line = line.replaceFirst("MOV", "").trim();
        line = line.replaceFirst(",R" + this.registerNumber, "").trim();
        this.setOperand0String(line);
    }

    @Override
    public String toString() {
        return "MOV " + Text.inHex(this.operand0, false) + "H,R" + this.registerNumber;
    }

    @Override
    public int getOpcode() {
        return 136 + this.registerNumber;
    }
}

