/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.instructions.branches;

import edsim51sh.Memory;
import edsim51sh.instructions.Instruction;
import edsim51sh.instructions.branches.Acall;
import edsim51sh.instructions.branches.Ajmp;
import edsim51sh.instructions.branches.Call;
import edsim51sh.instructions.branches.CjneAaddress;
import edsim51sh.instructions.branches.CjneAdata;
import edsim51sh.instructions.branches.CjneAtRegData;
import edsim51sh.instructions.branches.CjneRegData;
import edsim51sh.instructions.branches.DjnzData;
import edsim51sh.instructions.branches.DjnzReg;
import edsim51sh.instructions.branches.Jb;
import edsim51sh.instructions.branches.Jbc;
import edsim51sh.instructions.branches.Jc;
import edsim51sh.instructions.branches.Jmp;
import edsim51sh.instructions.branches.JmpDptr;
import edsim51sh.instructions.branches.Jnb;
import edsim51sh.instructions.branches.Jnc;
import edsim51sh.instructions.branches.Jnz;
import edsim51sh.instructions.branches.Jz;
import edsim51sh.instructions.branches.Lcall;
import edsim51sh.instructions.branches.Ljmp;
import edsim51sh.instructions.branches.Ret;
import edsim51sh.instructions.branches.Reti;
import edsim51sh.instructions.branches.Sjmp;

public class Branch
extends Instruction {
    public Branch() {
        this.mneumonic = "BRANCH";
    }

    private String removeWhitespace(String mneumonic) {
        return mneumonic.replaceAll(" ", "");
    }

    @Override
    public Instruction getInstruction(String mneumonic) {
        int registerNumber;
        if (mneumonic.startsWith("JMP ") && this.removeWhitespace(mneumonic).endsWith("@A+DPTR")) {
            return new JmpDptr();
        }
        if (mneumonic.startsWith("JMP ")) {
            return new Jmp();
        }
        if (mneumonic.startsWith("SJMP ")) {
            return new Sjmp();
        }
        if (mneumonic.startsWith("AJMP ")) {
            return new Ajmp();
        }
        if (mneumonic.startsWith("LJMP ")) {
            return new Ljmp();
        }
        if (mneumonic.startsWith("CALL ")) {
            return new Call();
        }
        if (mneumonic.startsWith("ACALL ")) {
            return new Acall();
        }
        if (mneumonic.startsWith("LCALL ")) {
            return new Lcall();
        }
        if (mneumonic.equals("RET")) {
            return new Ret();
        }
        if (mneumonic.equals("RETI")) {
            return new Reti();
        }
        if (mneumonic.startsWith("JZ ")) {
            return new Jz();
        }
        if (mneumonic.startsWith("JNZ ")) {
            return new Jnz();
        }
        if (mneumonic.startsWith("CJNE A,#")) {
            return new CjneAdata();
        }
        if (mneumonic.startsWith("CJNE A,")) {
            return new CjneAaddress();
        }
        if (mneumonic.length() >= 10) {
            registerNumber = mneumonic.charAt(7) - 48;
            if (mneumonic.startsWith("CJNE @R") && mneumonic.charAt(9) == '#' && (mneumonic.charAt(7) == '0' || mneumonic.charAt(7) == '1')) {
                return new CjneAtRegData(registerNumber);
            }
        }
        if (mneumonic.length() >= 9) {
            registerNumber = mneumonic.charAt(6) - 48;
            if (mneumonic.startsWith("CJNE R") && mneumonic.charAt(8) == '#' && mneumonic.charAt(6) >= '0' && mneumonic.charAt(6) <= '7') {
                return new CjneRegData(registerNumber);
            }
        }
        if (mneumonic.length() >= 7) {
            registerNumber = mneumonic.charAt(6) - 48;
            if (mneumonic.startsWith("DJNZ R") && mneumonic.charAt(6) >= '0' && mneumonic.charAt(6) <= '7') {
                return new DjnzReg(registerNumber);
            }
        }
        if (mneumonic.startsWith("DJNZ ")) {
            return new DjnzData();
        }
        if (mneumonic.startsWith("JC")) {
            return new Jc();
        }
        if (mneumonic.startsWith("JNC")) {
            return new Jnc();
        }
        if (mneumonic.startsWith("JBC")) {
            return new Jbc();
        }
        if (mneumonic.startsWith("JB")) {
            return new Jb();
        }
        if (mneumonic.startsWith("JNB")) {
            return new Jnb();
        }
        return null;
    }

    @Override
    public int execute(Memory ram, int pc) throws Exception {
        return 0;
    }

    @Override
    public int getOpcode() {
        return -1;
    }
}

