/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh.dynamicinterface;

import edsim51sh.DITargetBoard;
import edsim51sh.dynamicinterface.Menu;
import edsim51sh.ports.Pin;
import edsim51sh.ports.PortPinDescriptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DynamicInterface
extends JPanel
implements ActionListener {
    private JFrame frame = new JFrame();
    private JButton saveButton = new JButton("Save");
    private JButton cancelButton = new JButton("Cancel");
    private Vector menus = new Vector();
    private DITargetBoard targetBoard;

    public DynamicInterface(DITargetBoard targetBoard, PortPinDescriptions pinDescriptions, String targetBoardTitle) {
        String[] descriptions;
        String restartText = "Restart required for settings to take effect.";
        this.targetBoard = targetBoard;
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        Pin[] pins = pinDescriptions.getPins();
        int numberConnected = 0;
        for (int i = 0; i < pins.length; ++i) {
            if (!pins[i].isConnectedToHardware()) continue;
            descriptions = pins[i].getDescriptions();
            for (int j = 0; j < descriptions.length; ++j) {
                ++numberConnected;
            }
        }
        JPanel[] panels = new JPanel[3];
        panels[0] = new JPanel();
        panels[0].setLayout(new GridBagLayout());
        panels[0].setBackground(Color.WHITE);
        panels[1] = new JPanel();
        panels[1].setLayout(new GridBagLayout());
        panels[1].setBackground(new Color(240, 240, 240));
        panels[2] = new JPanel();
        panels[2].setLayout(new GridBagLayout());
        panels[2].setBackground(Color.WHITE);
        int rows = numberConnected / 3;
        if (rows * 3 < numberConnected) {
            ++rows;
        }
        int row = 0;
        int column = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 50, 0, 50);
        for (int i = 0; i < pins.length; ++i) {
            if (!pins[i].isConnectedToHardware()) continue;
            descriptions = pins[i].getDescriptions();
            for (int j = 0; j < descriptions.length; ++j) {
                Menu menu = new Menu(pins[i].getPortNumber(), pins[i].getPinNumber(), descriptions[j], panels[column].getBackground());
                this.menus.add(menu);
                gbc.gridy = row++;
                panels[column].add((Component)menu, gbc);
                if (row < rows) continue;
                row = 0;
                ++column;
            }
        }
        JLabel restartLabelTop = new JLabel(restartText);
        restartLabelTop.setForeground(Color.RED);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 0, 15, 0);
        this.add((Component)restartLabelTop, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 11;
        this.add((Component)panels[0], gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 11;
        this.add((Component)panels[1], gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 11;
        this.add((Component)panels[2], gbc);
        JPanel controlPanel = new JPanel();
        this.saveButton.addActionListener(this);
        controlPanel.add(this.saveButton);
        this.cancelButton.addActionListener(this);
        controlPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = rows + 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(15, 15, 15, 15);
        gbc.anchor = 10;
        this.add((Component)controlPanel, gbc);
        JLabel restartLabelBottom = new JLabel(restartText);
        restartLabelBottom.setForeground(Color.RED);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = rows + 2;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(5, 0, 15, 0);
        this.add((Component)restartLabelBottom, gbc);
        JScrollPane scrollPane = new JScrollPane(this);
        scrollPane.setPreferredSize(new Dimension(1000, 600));
        this.frame.getContentPane().add(scrollPane);
        this.frame.setTitle("EdSim51DI - Dynamic Interface");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public boolean isOpen() {
        return this.frame.isVisible();
    }

    public Menu getMenu(String label) {
        for (int i = 0; i < this.menus.size(); ++i) {
            Menu menu = (Menu)this.menus.elementAt(i);
            if (!menu.getLabel().trim().equals(label)) continue;
            return menu;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.saveButton) {
            this.targetBoard.remapHardware(this);
        }
        this.frame.setVisible(false);
    }
}

