/*
 * Decompiled with CFR 0.152.
 */
package edsim51sh;

import edsim51sh.Memory;

public class Serial {
    private static final int[] mode2cycleMultiples0 = new int[]{5, 5, 6, 5, 5, 6};
    private static final int[] mode2cycleMultiples1 = new int[]{2, 3, 2, 3, 2, 3};
    private Memory dataMemory;
    private int txTimer1overflow = 0;
    private int txMode2multipleIndex = 0;
    private int txMode2count = 0;
    private boolean dataToSend = false;
    private int txIndex = 0;
    private int txBitAddress;
    private int rxTimer1overflow = 0;
    private int rxMode2multipleIndex = 0;
    private int rxMode2count = 0;
    private boolean dataBeingReceived = false;
    private int rxIndex = 0;
    private boolean previousRxd = true;
    private boolean[] rxShiftRegister = new boolean[8];
    private int sbufReadOnly = 0;
    private int realStartBitCount = 0;

    public Serial(Memory dataMemory) {
        this.dataMemory = dataMemory;
    }

    public void resetRx() {
        this.rxTimer1overflow = 0;
        this.rxMode2multipleIndex = 0;
        this.rxMode2count = 0;
        this.dataBeingReceived = false;
        this.rxIndex = 0;
        this.realStartBitCount = 0;
    }

    public void resetTx() {
        this.txTimer1overflow = 0;
        this.txMode2multipleIndex = 0;
        this.txMode2count = 0;
        this.dataToSend = false;
        this.txIndex = 0;
    }

    public void reset() {
        this.resetRx();
        this.resetTx();
    }

    public int getSbufReadOnly() {
        return this.sbufReadOnly;
    }

    public void setDataToSend() {
        this.dataToSend = true;
        this.txIndex = 0;
    }

    public void pulseClock() {
        ++this.rxTimer1overflow;
        ++this.txTimer1overflow;
    }

    private boolean isStartBit() {
        try {
            boolean bit = this.dataMemory.port3.isPortPinHigh(0);
            return !bit && this.previousRxd;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isReceiverEnabled() {
        try {
            return this.dataMemory.getBit(156) == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isRiClear() {
        try {
            return this.dataMemory.getBit(152) == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void moveToSbufReadOnly() {
        this.sbufReadOnly = 0;
        int mask = 0;
        for (int i = 0; i < 8; ++i) {
            mask = this.rxShiftRegister[i] ? 1 : 0;
            this.sbufReadOnly |= mask << i;
        }
    }

    public void poll() {
        int[] multiples;
        if (this.isReceiverEnabled()) {
            if (this.getMode() == 0) {
                if (this.isRiClear()) {
                    this.receiveDataBit(this.rxIndex);
                    ++this.rxIndex;
                    if (this.rxIndex == 8) {
                        this.moveToSbufReadOnly();
                        try {
                            this.dataMemory.setBit(152);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.rxIndex = 0;
                    }
                }
            } else {
                if (!this.dataBeingReceived) {
                    if (this.getMode() == 2) {
                        multiples = this.getMachineCycleMultiple();
                        ++this.rxMode2count;
                        if (this.rxMode2count >= multiples[this.rxMode2multipleIndex] / 2) {
                            this.rxMode2count = 0;
                            if (this.isStartBit()) {
                                ++this.realStartBitCount;
                            }
                        }
                    } else if (this.rxTimer1overflow >= 16 / (this.getSmod() + 1)) {
                        this.rxTimer1overflow = 0;
                        if (this.isStartBit()) {
                            ++this.realStartBitCount;
                        }
                    }
                    if (this.realStartBitCount == 2) {
                        this.realStartBitCount = 0;
                        this.dataBeingReceived = true;
                    }
                }
                if (this.dataBeingReceived) {
                    if (this.getMode() == 2) {
                        multiples = this.getMachineCycleMultiple();
                        ++this.rxMode2count;
                        if (this.rxMode2count >= multiples[this.rxMode2multipleIndex]) {
                            this.rxMode2count = 0;
                            ++this.rxMode2multipleIndex;
                            if (this.rxMode2multipleIndex == 6) {
                                this.rxMode2multipleIndex = 0;
                            }
                            this.receiveBit();
                        }
                    } else if (this.rxTimer1overflow >= 32 / (this.getSmod() + 1)) {
                        this.rxTimer1overflow = 0;
                        this.receiveBit();
                    }
                }
            }
        }
        if (this.dataToSend) {
            if (this.getMode() == 0) {
                this.txBitAddress = 176;
                this.transmitDataBit(this.txIndex);
                ++this.txIndex;
                if (this.txIndex == 8) {
                    this.txIndex = 0;
                    try {
                        this.dataMemory.setBit(153);
                    }
                    catch (Exception multiples2) {
                        // empty catch block
                    }
                    this.dataToSend = false;
                }
            } else {
                this.txBitAddress = 177;
                if (this.getMode() == 2) {
                    multiples = this.getMachineCycleMultiple();
                    ++this.txMode2count;
                    if (this.txMode2count >= multiples[this.txMode2multipleIndex]) {
                        this.txMode2count = 0;
                        ++this.txMode2multipleIndex;
                        if (this.txMode2multipleIndex == 6) {
                            this.txMode2multipleIndex = 0;
                        }
                        this.transmitBit();
                    }
                } else if (this.txTimer1overflow >= 32 / (this.getSmod() + 1)) {
                    this.txTimer1overflow = 0;
                    this.transmitBit();
                }
            }
        }
    }

    private int[] getMachineCycleMultiple() {
        if (this.getSmod() == 0) {
            return mode2cycleMultiples0;
        }
        return mode2cycleMultiples1;
    }

    private int getSmod() {
        int smod = 0;
        try {
            smod = this.dataMemory.readByte(135);
            smod >>= 7;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return smod;
    }

    private int wordSize() {
        if (this.getMode() >= 2) {
            return 9;
        }
        return 8;
    }

    public int getMode() {
        try {
            int mode = this.dataMemory.readByte(152);
            mode = mode >> 6 & 3;
            return mode;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void transmitBit() {
        try {
            if (this.txIndex == 0) {
                this.dataMemory.clearBit(177);
                ++this.txIndex;
            } else if (this.txIndex == this.wordSize() + 1) {
                this.dataMemory.setBit(177);
                this.dataMemory.setBit(153);
                this.dataToSend = false;
            } else {
                if (this.txIndex == 8 && (this.getMode() == 2 || this.getMode() == 3)) {
                    boolean bit8;
                    boolean bl = bit8 = this.dataMemory.getBit(155) == 1;
                    if (bit8) {
                        this.dataMemory.setBit(177);
                    } else {
                        this.dataMemory.clearBit(177);
                    }
                } else {
                    this.transmitDataBit(this.txIndex - 1);
                }
                ++this.txIndex;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void transmitDataBit(int bitNumber) {
        try {
            int bit = this.dataMemory.readSbufWriteOnly();
            bit = bit >> bitNumber & 1;
            if (bit == 1) {
                this.dataMemory.setBit(this.txBitAddress);
            } else {
                this.dataMemory.clearBit(this.txBitAddress);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void receiveBit() {
        try {
            if (this.rxIndex == 8 && this.dataMemory.getBit(152) == 0 && (this.dataMemory.getBit(157) == 0 || this.dataMemory.port3.isPortPinHigh(0))) {
                boolean bit = this.dataMemory.port3.isPortPinHigh(0);
                if (bit) {
                    this.dataMemory.setBit(154);
                } else {
                    this.dataMemory.clearBit(154);
                }
                this.moveToSbufReadOnly();
                this.dataMemory.setBit(152);
                this.dataBeingReceived = false;
                this.rxIndex = 0;
                this.previousRxd = bit;
            } else {
                this.receiveDataBit(this.rxIndex);
                ++this.rxIndex;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void receiveDataBit(int bitNumber) {
        try {
            this.rxShiftRegister[bitNumber] = this.dataMemory.port3.isPortPinHigh(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

