/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.ListIterator;

final class DoubleByDigit
implements Cloneable,
DoubleByDigitGetters {
    private ArrayList<Integer> intField = new ArrayList();
    private ArrayList<Integer> fracField = new ArrayList();
    private ArrayList<Integer> expField = new ArrayList();
    private int sign = 1;
    private int expSign = 1;
    private boolean overflow = false;

    DoubleByDigit() {
    }

    public DoubleByDigit clone() {
        DoubleByDigit doubleByDigit = new DoubleByDigit();
        doubleByDigit.intField = new ArrayList<Integer>(this.intField);
        doubleByDigit.fracField = new ArrayList<Integer>(this.fracField);
        doubleByDigit.expField = new ArrayList<Integer>(this.expField);
        doubleByDigit.sign = this.sign;
        doubleByDigit.expSign = this.expSign;
        doubleByDigit.overflow = this.overflow;
        return doubleByDigit;
    }

    void clear() {
        this.intField.clear();
        this.fracField.clear();
        this.expField.clear();
        this.sign = 1;
        this.expSign = 1;
        this.overflow = false;
    }

    void addIntDigit(int n) {
        this.intField.add(n);
    }

    void addFracDigit(int n) {
        this.fracField.add(n);
    }

    void addExpDigit(int n, int n2) {
        if (n2 < 1) {
            throw new RuntimeException("Exp field length equals " + n2 + " while it must be positive");
        }
        if (this.expField.size() >= n2) {
            do {
                this.expField.remove(0);
            } while (this.expField.size() >= n2);
        } else {
            while (this.expField.size() < n2 - 1) {
                this.expField.add(0, 0);
            }
        }
        this.expField.add(n);
    }

    void setSign(int n) {
        this.sign = n >= 0 ? 1 : -1;
    }

    void setExpSign(int n) {
        this.expSign = n >= 0 ? 1 : -1;
    }

    void inverseSign() {
        this.sign = -this.sign;
    }

    void inverseExpSign() {
        this.expSign = -this.expSign;
    }

    void setOverflow(boolean bl) {
        this.overflow = bl;
    }

    @Override
    public boolean isOverflow() {
        return this.overflow;
    }

    @Override
    public int getNIntDigits() {
        return this.intField.size();
    }

    @Override
    public int getIntDigit(int n) {
        return this.intField.get(n);
    }

    @Override
    public int getNFracDigits() {
        return this.fracField.size();
    }

    @Override
    public int getFracDigit(int n) {
        return this.fracField.get(n);
    }

    @Override
    public int getNExpDigits() {
        return this.expField.size();
    }

    @Override
    public int getExpDigit(int n) {
        return this.expField.get(n);
    }

    @Override
    public int getSign() {
        return this.sign;
    }

    @Override
    public int getExpSign() {
        return this.expSign;
    }

    @Override
    public double toDouble(int n) {
        if (this.overflow) {
            return Double.NaN;
        }
        double d = n;
        double d2 = 0.0;
        ListIterator<Integer> listIterator = this.intField.listIterator();
        while (listIterator.hasNext()) {
            d2 = d2 * d + (double)listIterator.next().intValue();
        }
        double d3 = 1.0;
        ListIterator<Integer> listIterator2 = this.fracField.listIterator();
        while (listIterator2.hasNext()) {
            d2 += (double)listIterator2.next().intValue() * (d3 /= d);
        }
        if (this.sign < 0) {
            d2 = -d2;
        }
        int n2 = 0;
        ListIterator<Integer> listIterator3 = this.expField.listIterator();
        while (listIterator3.hasNext()) {
            n2 = n2 * n + listIterator3.next();
        }
        if (this.expSign < 0) {
            n2 = -n2;
        }
        return d2 *= Math.pow(d, n2);
    }

    @Override
    public String toString() {
        if (this.overflow) {
            return "error";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sign < 0) {
            stringBuffer.append('-');
        }
        if (this.intField.size() == 0) {
            stringBuffer.append('0');
        }
        ListIterator<Integer> listIterator = this.intField.listIterator();
        while (listIterator.hasNext()) {
            stringBuffer.append(listIterator.next());
        }
        if (this.fracField.size() > 0) {
            stringBuffer.append('.');
            listIterator = this.fracField.listIterator();
            while (listIterator.hasNext()) {
                stringBuffer.append(listIterator.next());
            }
        }
        if (this.expField.size() > 0) {
            stringBuffer.append('e');
            if (this.expSign < 0) {
                stringBuffer.append('-');
            }
            listIterator = this.expField.listIterator();
            while (listIterator.hasNext()) {
                stringBuffer.append(listIterator.next());
            }
        }
        return stringBuffer.toString();
    }

    static DoubleByDigit fromDouble(double d, int n, int n2, boolean bl, int n3, int n4, boolean bl2, int n5) {
        int n6;
        int n7;
        double d2 = n5;
        DoubleByDigit doubleByDigit = new DoubleByDigit();
        if (n3 <= 0 || (double)n3 >= Math.pow(d2, n2)) {
            throw new RuntimeException("expDivisor = " + n3 + " but it must in interval [1, " + (Math.pow(d2, n2) - 1.0) + "]");
        }
        if (n <= 0 || n < n4) {
            throw new RuntimeException("nDigitsToRoundTo = " + n4 + " but it must be greater than 0 and not greater than mantissa length " + n);
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            doubleByDigit.overflow = true;
            return doubleByDigit;
        }
        double d3 = Math.abs(d);
        if (d3 >= Math.pow(d2, Math.pow(d2, n2))) {
            doubleByDigit.overflow = true;
            return doubleByDigit;
        }
        if (d3 < Math.pow(d2, -(Math.pow(d2, n2) - 1.0))) {
            doubleByDigit.intField.add(0);
            return doubleByDigit;
        }
        doubleByDigit.sign = d >= 0.0 ? 1 : -1;
        int n8 = (int)Math.floor(Math.log(d3) / Math.log(d2));
        long l = Math.round(d3 / Math.pow(d2, n8 + 1) * Math.pow(d2, n4));
        if ((double)l >= Math.pow(d2, n4)) {
            l = Math.round((double)l / d2);
            ++n8;
        }
        if (n8 == -1 && !bl && (double)Math.round((double)l / d2) >= Math.pow(d2, n4 - 1)) {
            doubleByDigit.intField.add(1);
            return doubleByDigit;
        }
        l = (long)((double)l * Math.pow(d2, n - n4));
        int[] nArray = new int[n];
        for (n7 = n - 1; n7 >= 0; --n7) {
            nArray[n7] = n6 = (int)(l % (long)n5);
            l = (l - (long)n6) / (long)n5;
        }
        if (0 <= n8 && n8 < n && !bl) {
            n7 = n8 + 1;
            for (n6 = 0; n6 < n7; ++n6) {
                doubleByDigit.intField.add(nArray[n6]);
            }
            n6 = n - n7;
            for (int i = 0; i < n6; ++i) {
                doubleByDigit.fracField.add(nArray[n7 + i]);
            }
        } else if (-n < n8 && n8 < 0 && !bl) {
            int n9;
            long l2;
            doubleByDigit.intField.add(0);
            n7 = -n8 - 1;
            for (n6 = 0; n6 < n7; ++n6) {
                doubleByDigit.fracField.add(0);
            }
            n6 = n - 1 - n7;
            if (n6 > n4) {
                n6 = n4;
            }
            if ((double)(l2 = Math.round(d3 / Math.pow(d2, n8 + 1) * Math.pow(d2, n6))) >= Math.pow(d2, n6)) {
                if (n6 < n4) {
                    ++n6;
                    --n7;
                } else {
                    l2 = Math.round((double)l2 / d2);
                }
            }
            for (n9 = n6 - 1; n9 >= 0; --n9) {
                int n10;
                nArray[n9] = n10 = (int)(l2 % (long)n5);
                l2 = Math.round((l2 - (long)n10) / (long)n5);
            }
            for (n9 = 0; n9 < n6; ++n9) {
                doubleByDigit.fracField.add(nArray[n9]);
            }
        } else {
            int n11;
            if (n3 == 1) {
                doubleByDigit.intField.add(nArray[0]);
                for (n7 = 0; n7 < n - 1; ++n7) {
                    doubleByDigit.fracField.add(nArray[n7 + 1]);
                }
            } else {
                n7 = Math.abs(n8) % n3;
                if (n8 < 0 && n7 != 0) {
                    n7 = n3 - n7;
                }
                for (n6 = 0; n6 < 1 + n7; ++n6) {
                    doubleByDigit.intField.add(nArray[n6]);
                }
                n6 = n - 1 - n7;
                for (n11 = 0; n11 < n6; ++n11) {
                    doubleByDigit.fracField.add(nArray[n11 + 1 + n7]);
                }
                n8 -= n7;
            }
            if ((n7 = Math.abs(n8)) != 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                while (n7 > 0) {
                    arrayList.add(n7 % n5);
                    n7 = (int)Math.floor(n7 / n5);
                }
                for (n11 = 0; n11 < n2 - arrayList.size(); ++n11) {
                    doubleByDigit.expField.add(0);
                }
                ListIterator listIterator = arrayList.listIterator(arrayList.size());
                while (listIterator.hasPrevious()) {
                    doubleByDigit.expField.add((Integer)listIterator.previous());
                }
                doubleByDigit.expSign = n8 > 0 ? 1 : -1;
            }
        }
        while (!(doubleByDigit.fracField.size() <= 0 || doubleByDigit.fracField.get(doubleByDigit.fracField.size() - 1) != 0 || bl2 && doubleByDigit.intField.size() + doubleByDigit.fracField.size() <= n4)) {
            doubleByDigit.fracField.remove(doubleByDigit.fracField.size() - 1);
        }
        return doubleByDigit;
    }
}

