/*
 * Decompiled with CFR 0.152.
 */
package org.forester.sequence;

import org.forester.sequence.MolecularSequence;
import org.forester.util.ForesterUtil;

public class BasicSequence
implements MolecularSequence {
    private final char[] _mol_sequence;
    private String _identifier;
    private final MolecularSequence.TYPE _type;

    public BasicSequence(String string, String string2, MolecularSequence.TYPE tYPE) {
        BasicSequence.check(string, string2);
        this._mol_sequence = string2.toCharArray();
        this._identifier = string;
        this._type = tYPE;
    }

    private static final void check(String string, String string2) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("identifier of sequence cannot be empty");
        }
        if (ForesterUtil.isEmpty(string2)) {
            throw new IllegalArgumentException("molecular sequence cannot be empty");
        }
    }

    public BasicSequence(String string, char[] cArray, MolecularSequence.TYPE tYPE) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("identifier of sequence cannot be empty");
        }
        if (cArray == null || cArray.length < 1) {
            throw new IllegalArgumentException("molecular sequence cannot be empty");
        }
        this._mol_sequence = cArray;
        this._identifier = string;
        this._type = tYPE;
    }

    public void setIdentifier(String string) {
        this._identifier = string;
    }

    @Override
    public String getIdentifier() {
        return this._identifier;
    }

    @Override
    public int getLength() {
        return this._mol_sequence.length;
    }

    @Override
    public char[] getMolecularSequence() {
        return this._mol_sequence;
    }

    @Override
    public char getResidueAt(int n) {
        return this._mol_sequence[n];
    }

    @Override
    public MolecularSequence.TYPE getType() {
        return this._type;
    }

    @Override
    public int getNumberOfGapResidues() {
        int n = 0;
        for (char c : this._mol_sequence) {
            if (c != '-') continue;
            ++n;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        MolecularSequence molecularSequence = (MolecularSequence)object;
        return this.getMolecularSequenceAsString().equals(molecularSequence.getMolecularSequenceAsString());
    }

    public int hashCode() {
        return this.getMolecularSequenceAsString().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._identifier.toString());
        stringBuffer.append(": ");
        stringBuffer.append(this.getMolecularSequenceAsString());
        return stringBuffer.toString();
    }

    public static MolecularSequence copySequence(MolecularSequence molecularSequence) {
        char[] cArray = new char[molecularSequence.getMolecularSequence().length];
        for (int i = 0; i < molecularSequence.getMolecularSequence().length; ++i) {
            cArray[i] = molecularSequence.getMolecularSequence()[i];
        }
        return new BasicSequence(new String(molecularSequence.getIdentifier()), cArray, molecularSequence.getType());
    }

    public static MolecularSequence createSequence(String string, String string2) {
        char c;
        String string3;
        BasicSequence.check(string, string2);
        MolecularSequence.TYPE tYPE = ForesterUtil.guessMolecularSequenceType(string2);
        if (tYPE == MolecularSequence.TYPE.AA) {
            string3 = "[^ARNDBCQEZGHILKMFPSTWYVXUO\\-\\*]";
            c = 'X';
        } else if (tYPE == MolecularSequence.TYPE.DNA) {
            string3 = "[^ACGTRYMKWSN\\-\\*]";
            c = 'N';
        } else if (tYPE == MolecularSequence.TYPE.RNA) {
            string3 = "[^ACGURYMKWSN\\-\\*]";
            c = 'N';
        } else {
            throw new IllegalArgumentException("could not determine sequence type for: " + string2);
        }
        return new BasicSequence(string, string2.toUpperCase().replaceAll("\\.", GAP_STR).replaceAll(string3, Character.toString(c)), tYPE);
    }

    public static MolecularSequence createGeneralSequence(String string, String string2) {
        BasicSequence.check(string, string2);
        return new BasicSequence(string, string2.toUpperCase().replaceAll("\\.", GAP_STR), MolecularSequence.TYPE.GENERAL);
    }

    public static MolecularSequence createAaSequence(String string, String string2) {
        BasicSequence.check(string, string2);
        return new BasicSequence(string, string2.toUpperCase().replaceAll("\\.", GAP_STR).replaceAll("[^ARNDBCQEZGHILKMFPSTWYVXUO\\-\\*]", Character.toString('X')), MolecularSequence.TYPE.AA);
    }

    public static MolecularSequence createDnaSequence(String string, String string2) {
        BasicSequence.check(string, string2);
        return new BasicSequence(string, string2.toUpperCase().replaceAll("\\.", GAP_STR).replaceAll("[^ACGTRYMKWSN\\-\\*]", Character.toString('N')), MolecularSequence.TYPE.DNA);
    }

    public static MolecularSequence createRnaSequence(String string, String string2) {
        BasicSequence.check(string, string2);
        return new BasicSequence(string, string2.toUpperCase().replaceAll("\\.", GAP_STR).replaceAll("[^ACGURYMKWSN\\-\\*]", Character.toString('N')), MolecularSequence.TYPE.RNA);
    }

    @Override
    public String getMolecularSequenceAsString() {
        return new String(this.getMolecularSequence());
    }

    @Override
    public boolean isGapAt(int n) {
        return this.getResidueAt(n) == '-';
    }
}

