/*
 * Decompiled with CFR 0.152.
 */
package org.forester.rio;

import java.io.File;
import org.forester.datastructures.IntMatrix;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.rio.RIO;
import org.forester.sdi.SDIutil;
import org.forester.util.ForesterUtil;

public final class TestRIO {
    private static final String PATH_TO_TEST_DATA = System.getProperty("user.dir") + ForesterUtil.getFileSeparator() + "test_data" + ForesterUtil.getFileSeparator();

    public static void main(String[] stringArray) {
        if (!TestRIO.testRIO_GSDIR()) {
            System.out.println("testRIO GSDIR failed");
        }
        if (!TestRIO.testRIO_GSDIR_Iterating()) {
            System.out.println("testRIO GSDIR iterating failed");
        } else {
            System.out.println("OK");
        }
    }

    public static boolean test() {
        if (!TestRIO.testRIO_GSDIR()) {
            return false;
        }
        return TestRIO.testRIO_GSDIR_Iterating();
    }

    private static boolean testRIO_GSDIR() {
        try {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            NHXParser nHXParser = new NHXParser();
            nHXParser.setReplaceUnderscores(false);
            nHXParser.setIgnoreQuotes(true);
            nHXParser.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
            Phylogeny[] phylogenyArray = phylogenyFactory.create("(MOUSE,RAT);(MOUSE,RAT);(MOUSE,RAT);(RAT,MOUSE);", nHXParser);
            Phylogeny phylogeny = phylogenyFactory.create("(MOUSE,RAT);", new NHXParser())[0];
            phylogeny.setRooted(true);
            PhylogenyMethods.transferNodeNameToField(phylogeny, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
            RIO rIO = RIO.executeAnalysis(phylogenyArray, phylogeny, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rIO.getAnalyzedGeneTrees().length != 4) {
                return false;
            }
            if (rIO.getExtNodesOfAnalyzedGeneTrees() != 2) {
                return false;
            }
            if (rIO.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.CODE) {
                return false;
            }
            if (rIO.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            IntMatrix intMatrix = RIO.calculateOrthologTable(rIO.getAnalyzedGeneTrees(), true);
            if (!intMatrix.getRowAsString(0, ',').equals("MOUSE,4,4")) {
                System.out.println(intMatrix.toString());
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("RAT,4,4")) {
                System.out.println(intMatrix.toString());
                return false;
            }
            Phylogeny[] phylogenyArray2 = phylogenyFactory.create("(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE]);(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE])", nHXParser);
            Phylogeny phylogeny2 = phylogenyFactory.create("[&&NHX:S=MOUSE];", new NHXParser())[0];
            phylogeny2.setRooted(true);
            rIO = RIO.executeAnalysis(phylogenyArray2, phylogeny2, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rIO.getAnalyzedGeneTrees().length != 2) {
                return false;
            }
            if (rIO.getExtNodesOfAnalyzedGeneTrees() != 2) {
                return false;
            }
            if (rIO.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME) {
                return false;
            }
            if (rIO.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            intMatrix = RIO.calculateOrthologTable(rIO.getAnalyzedGeneTrees(), true);
            if (!intMatrix.getRowAsString(0, ',').equals("MOUSE1,2,0")) {
                System.out.println(intMatrix.toString());
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("MOUSE2,0,2")) {
                System.out.println(intMatrix.toString());
                return false;
            }
            Phylogeny[] phylogenyArray3 = phylogenyFactory.create("(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE]);(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE]);(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE])", nHXParser);
            Phylogeny phylogeny3 = phylogenyFactory.create("([&&NHX:S=MOUSE]);", new NHXParser())[0];
            phylogeny3.setRooted(true);
            rIO = RIO.executeAnalysis(phylogenyArray3, phylogeny3, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rIO.getAnalyzedGeneTrees().length != 3) {
                return false;
            }
            if (rIO.getExtNodesOfAnalyzedGeneTrees() != 2) {
                return false;
            }
            if (rIO.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME) {
                return false;
            }
            if (rIO.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            intMatrix = RIO.calculateOrthologTable(rIO.getAnalyzedGeneTrees(), true);
            if (!intMatrix.getRowAsString(0, ',').equals("MOUSE1,3,0")) {
                System.out.println(intMatrix.toString());
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("MOUSE2,0,3")) {
                System.out.println(intMatrix.toString());
                return false;
            }
            Phylogeny[] phylogenyArray4 = phylogenyFactory.create("(MOUSE1[&&NHX:S=MOUSE],MOUSE2[&&NHX:S=MOUSE])", nHXParser);
            Phylogeny phylogeny4 = phylogenyFactory.create("[&&NHX:S=MOUSE];", new NHXParser())[0];
            phylogeny4.setRooted(true);
            rIO = RIO.executeAnalysis(phylogenyArray4, phylogeny4, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rIO.getAnalyzedGeneTrees().length != 1) {
                return false;
            }
            if (rIO.getExtNodesOfAnalyzedGeneTrees() != 2) {
                return false;
            }
            if (rIO.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME) {
                return false;
            }
            if (rIO.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            intMatrix = RIO.calculateOrthologTable(rIO.getAnalyzedGeneTrees(), true);
            if (!intMatrix.getRowAsString(0, ',').equals("MOUSE1,1,0")) {
                System.out.println(intMatrix.toString());
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("MOUSE2,0,1")) {
                System.out.println(intMatrix.toString());
                return false;
            }
            Phylogeny[] phylogenyArray5 = phylogenyFactory.create("(MOUSE1[&&NHX:S=MOUSE],RAT1[&&NHX:S=RAT])", nHXParser);
            Phylogeny phylogeny5 = phylogenyFactory.create("([&&NHX:S=MOUSE],[&&NHX:S=RAT]);", new NHXParser())[0];
            phylogeny5.setRooted(true);
            rIO = RIO.executeAnalysis(phylogenyArray5, phylogeny5, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rIO.getAnalyzedGeneTrees().length != 1) {
                return false;
            }
            if (rIO.getExtNodesOfAnalyzedGeneTrees() != 2) {
                return false;
            }
            if (rIO.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME) {
                return false;
            }
            if (rIO.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            intMatrix = RIO.calculateOrthologTable(rIO.getAnalyzedGeneTrees(), true);
            if (!intMatrix.getRowAsString(0, ',').equals("MOUSE1,1,1")) {
                System.out.println(intMatrix.toString());
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("RAT1,1,1")) {
                System.out.println(intMatrix.toString());
                return false;
            }
            Phylogeny[] phylogenyArray6 = phylogenyFactory.create("(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);((((MOUSE,RAT),HUMAN),(ARATH,YEAST)),CAEEL);((MOUSE,RAT),(((ARATH,YEAST),CAEEL),HUMAN));(((((MOUSE,HUMAN),RAT),CAEEL),YEAST),ARATH);((((HUMAN,MOUSE),RAT),(ARATH,YEAST)),CAEEL);", nHXParser);
            Phylogeny phylogeny6 = phylogenyFactory.create("(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);", new NHXParser())[0];
            phylogeny6.setRooted(true);
            PhylogenyMethods.transferNodeNameToField(phylogeny6, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
            rIO = RIO.executeAnalysis(phylogenyArray6, phylogeny6, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rIO.getAnalyzedGeneTrees().length != 5) {
                return false;
            }
            if (rIO.getExtNodesOfAnalyzedGeneTrees() != 6) {
                return false;
            }
            if (rIO.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.CODE) {
                return false;
            }
            if (rIO.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            intMatrix = RIO.calculateOrthologTable(rIO.getAnalyzedGeneTrees(), true);
            if (!intMatrix.getRowAsString(0, ',').equals("ARATH,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("CAEEL,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(2, ',').equals("HUMAN,5,5,5,5,3,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(3, ',').equals("MOUSE,5,5,5,5,3,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(4, ',').equals("RAT,5,5,3,3,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(5, ',').equals("YEAST,5,5,5,5,5,5")) {
                return false;
            }
            Phylogeny[] phylogenyArray7 = phylogenyFactory.create("(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);((((MOUSE,RAT),HUMAN),(ARATH,YEAST)),CAEEL);((MOUSE,RAT),(((ARATH,YEAST),CAEEL),HUMAN));(((((MOUSE,HUMAN),RAT),CAEEL),YEAST),ARATH);((((HUMAN,MOUSE),RAT),(ARATH,YEAST)),CAEEL);", nHXParser);
            Phylogeny phylogeny7 = phylogenyFactory.create("((((MOUSE,RAT,HUMAN),CAEEL),YEAST),ARATH);", new NHXParser())[0];
            phylogeny7.setRooted(true);
            PhylogenyMethods.transferNodeNameToField(phylogeny7, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
            rIO = RIO.executeAnalysis(phylogenyArray7, phylogeny7);
            intMatrix = RIO.calculateOrthologTable(rIO.getAnalyzedGeneTrees(), true);
            if (!intMatrix.getRowAsString(0, ',').equals("ARATH,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("CAEEL,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(2, ',').equals("HUMAN,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(3, ',').equals("MOUSE,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(4, ',').equals("RAT,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(5, ',').equals("YEAST,5,5,5,5,5,5")) {
                return false;
            }
            RIO rIO2 = RIO.executeAnalysis(new File(PATH_TO_TEST_DATA + "rio_mb_taxcode.run1.t"), new File(PATH_TO_TEST_DATA + "rio_tol_1.xml"), SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", -1, -1, true, false, true);
            if (rIO2.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.CODE) {
                return false;
            }
            if (rIO2.getAnalyzedGeneTrees().length != 201) {
                return false;
            }
            if (rIO2.getExtNodesOfAnalyzedGeneTrees() != 6) {
                System.out.println(rIO2.getExtNodesOfAnalyzedGeneTrees());
                return false;
            }
            if (rIO2.getIntNodesOfAnalyzedGeneTrees() != 5) {
                return false;
            }
            if (rIO2.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            if (ForesterUtil.roundToInt(rIO2.getDuplicationsStatistics().median()) != 1) {
                return false;
            }
            intMatrix = RIO.calculateOrthologTable(rIO2.getAnalyzedGeneTrees(), true);
            if (!intMatrix.getRowAsString(0, ',').equals("A7SHU1_NEMVE,201,201,200,200,200,200")) {
                System.out.println(intMatrix.getRowAsString(0, ','));
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("BCDO2_HUMAN,201,201,200,200,200,43")) {
                System.out.println(intMatrix.getRowAsString(1, ','));
                return false;
            }
            if (!intMatrix.getRowAsString(2, ',').equals("BCDO2_MOUSE,200,200,201,201,201,43")) {
                System.out.println(intMatrix.getRowAsString(2, ','));
                return false;
            }
            if (!intMatrix.getRowAsString(3, ',').equals("H2ZH97_CIOSA,200,200,201,201,201,201")) {
                System.out.println(intMatrix.getRowAsString(3, ','));
                return false;
            }
            if (!intMatrix.getRowAsString(4, ',').equals("Q1RLW1_DANRE,200,200,201,201,201,43")) {
                System.out.println(intMatrix.getRowAsString(4, ','));
                return false;
            }
            if (!intMatrix.getRowAsString(5, ',').equals("Q6DIN7_XENTR,200,43,43,201,43,201")) {
                System.out.println(intMatrix.getRowAsString(5, ','));
                return false;
            }
            rIO2 = RIO.executeAnalysis(new File(PATH_TO_TEST_DATA + "rio_mb_taxid.run1.t"), new File(PATH_TO_TEST_DATA + "rio_tol_1.xml"), SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", -1, -1, true, false, true);
            if (rIO2.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.ID) {
                return false;
            }
            if (rIO2.getAnalyzedGeneTrees().length != 201) {
                return false;
            }
            if (rIO2.getExtNodesOfAnalyzedGeneTrees() != 6) {
                return false;
            }
            if (rIO2.getIntNodesOfAnalyzedGeneTrees() != 5) {
                return false;
            }
            if (rIO2.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            if (ForesterUtil.roundToInt(rIO2.getDuplicationsStatistics().median()) != 1) {
                return false;
            }
            intMatrix = RIO.calculateOrthologTable(rIO2.getAnalyzedGeneTrees(), true);
            if (!intMatrix.getRowAsString(0, ',').equals("A7SHU1_45351,201,200,201,200,200,200")) {
                System.out.println(intMatrix.getRowAsString(0, ','));
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("BCDO2_10090,200,201,200,201,201,43")) {
                System.out.println(intMatrix.getRowAsString(1, ','));
                return false;
            }
            if (!intMatrix.getRowAsString(2, ',').equals("BCDO2_9606,201,200,201,200,200,43")) {
                System.out.println(intMatrix.getRowAsString(2, ','));
                return false;
            }
            if (!intMatrix.getRowAsString(3, ',').equals("H2ZH97_51511,200,201,200,201,201,201")) {
                System.out.println(intMatrix.getRowAsString(3, ','));
                return false;
            }
            if (!intMatrix.getRowAsString(4, ',').equals("Q1RLW1_7955,200,201,200,201,201,43")) {
                System.out.println(intMatrix.getRowAsString(4, ','));
                return false;
            }
            if (!intMatrix.getRowAsString(5, ',').equals("Q6DIN7_8364,200,43,43,201,43,201")) {
                System.out.println(intMatrix.getRowAsString(5, ','));
                return false;
            }
            rIO2 = RIO.executeAnalysis(new File(PATH_TO_TEST_DATA + "rio_mb_taxsn.run1.t"), new File(PATH_TO_TEST_DATA + "rio_tol_1.xml"), SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", -1, -1, true, false, true);
            if (rIO2.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.SCIENTIFIC_NAME) {
                return false;
            }
            if (rIO2.getAnalyzedGeneTrees().length != 201) {
                return false;
            }
            if (rIO2.getExtNodesOfAnalyzedGeneTrees() != 6) {
                System.out.println(rIO2.getExtNodesOfAnalyzedGeneTrees());
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private static boolean testRIO_GSDIR_Iterating() {
        try {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            NHXParser nHXParser = new NHXParser();
            nHXParser.setReplaceUnderscores(false);
            nHXParser.setIgnoreQuotes(true);
            nHXParser.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
            nHXParser.setSource("(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);((((MOUSE,RAT),HUMAN),(ARATH,YEAST)),CAEEL);((MOUSE,RAT),(((ARATH,YEAST),CAEEL),HUMAN));(((((MOUSE,HUMAN),RAT),CAEEL),YEAST),ARATH);((((HUMAN,MOUSE),RAT),(ARATH,YEAST)),CAEEL);");
            Phylogeny phylogeny = phylogenyFactory.create("(((((MOUSE,RAT),HUMAN),CAEEL),YEAST),ARATH);", new NHXParser())[0];
            phylogeny.setRooted(true);
            PhylogenyMethods.transferNodeNameToField(phylogeny, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
            RIO rIO = RIO.executeAnalysis(nHXParser, phylogeny, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            if (rIO.getExtNodesOfAnalyzedGeneTrees() != 6) {
                return false;
            }
            if (rIO.getGSDIRtaxCompBase() != SDIutil.TaxonomyComparisonBase.CODE) {
                return false;
            }
            if (rIO.getRemovedGeneTreeNodes().size() != 0) {
                return false;
            }
            IntMatrix intMatrix = rIO.getOrthologTable();
            if (!intMatrix.getRowAsString(0, ',').equals("ARATH,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("CAEEL,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(2, ',').equals("HUMAN,5,5,5,5,3,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(3, ',').equals("MOUSE,5,5,5,5,3,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(4, ',').equals("RAT,5,5,3,3,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(5, ',').equals("YEAST,5,5,5,5,5,5")) {
                return false;
            }
            Phylogeny phylogeny2 = phylogenyFactory.create("((((MOUSE,RAT,HUMAN),CAEEL),YEAST),ARATH);", new NHXParser())[0];
            phylogeny2.setRooted(true);
            PhylogenyMethods.transferNodeNameToField(phylogeny2, PhylogenyMethods.PhylogenyNodeField.TAXONOMY_CODE, true);
            rIO = RIO.executeAnalysis(nHXParser, phylogeny2, SDIutil.ALGORITHM.GSDIR, RIO.REROOTING.BY_ALGORITHM, "", true, false, true);
            intMatrix = rIO.getOrthologTable();
            if (!intMatrix.getRowAsString(0, ',').equals("ARATH,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(1, ',').equals("CAEEL,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(2, ',').equals("HUMAN,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(3, ',').equals("MOUSE,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(4, ',').equals("RAT,5,5,5,5,5,5")) {
                return false;
            }
            if (!intMatrix.getRowAsString(5, ',').equals("YEAST,5,5,5,5,5,5")) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return false;
        }
        return true;
    }
}

