/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.MultipleUris;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.PropertiesList;
import org.forester.phylogeny.data.Uri;
import org.forester.util.ForesterUtil;

public class Annotation
implements PhylogenyData,
MultipleUris,
Comparable<Annotation> {
    private Confidence _confidence;
    private String _desc;
    private String _evidence;
    private PropertiesList _properties;
    private final String _ref_source;
    private final String _ref_value;
    private String _source;
    private String _type;
    private List<Uri> _uris;

    public Annotation() {
        this._ref_value = "";
        this._ref_source = "";
        this.init();
    }

    public Annotation(String string) {
        if (ForesterUtil.isEmpty(string)) {
            throw new IllegalArgumentException("annotation reference is empty or null");
        }
        String[] stringArray = string.split(":");
        if (stringArray.length != 2 || ForesterUtil.isEmpty(stringArray[0]) || ForesterUtil.isEmpty(stringArray[1])) {
            throw new IllegalArgumentException("illegal format for annotation reference: [" + string + "]");
        }
        this._ref_source = stringArray[0];
        this._ref_value = stringArray[1];
        this.init();
    }

    public Annotation(String string, String string2) {
        if (ForesterUtil.isEmpty(string) || ForesterUtil.isEmpty(string2)) {
            throw new IllegalArgumentException("illegal format for annotation reference");
        }
        this._ref_source = string;
        this._ref_value = string2;
        this.init();
    }

    @Override
    public void addUri(Uri uri) {
        if (this.getUris() == null) {
            this.setUris(new ArrayList<Uri>());
        }
        this.getUris().add(uri);
    }

    @Override
    public StringBuffer asSimpleText() {
        return new StringBuffer(!ForesterUtil.isEmpty(this.getRef()) ? this.getRef() : this.getDesc());
    }

    @Override
    public StringBuffer asText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getDesc()) && !ForesterUtil.isEmpty(this.getRef())) {
            stringBuffer.append(this.getDesc());
            stringBuffer.append(" (");
            stringBuffer.append(this.getRef());
            stringBuffer.append(")");
        } else if (!ForesterUtil.isEmpty(this.getDesc())) {
            stringBuffer.append(this.getDesc());
        } else if (!ForesterUtil.isEmpty(this.getRef())) {
            stringBuffer.append(this.getRef());
        }
        return stringBuffer;
    }

    @Override
    public int compareTo(Annotation annotation) {
        if (this.equals(annotation)) {
            return 0;
        }
        if (this.getRef().equals(annotation.getRef())) {
            return this.getDesc().compareTo(annotation.getDesc());
        }
        return this.getRef().compareTo(annotation.getRef());
    }

    @Override
    public PhylogenyData copy() {
        Annotation annotation = new Annotation(this.getRefSource(), this.getRefValue());
        if (this.getConfidence() != null) {
            annotation.setConfidence((Confidence)this.getConfidence().copy());
        } else {
            annotation.setConfidence(null);
        }
        annotation.setType(this.getType());
        annotation.setDesc(this.getDesc());
        annotation.setEvidence(this.getEvidence());
        annotation.setSource(new String(this.getSource()));
        if (this.getProperties() != null) {
            annotation.setProperties((PropertiesList)this.getProperties().copy());
        } else {
            annotation.setProperties(null);
        }
        if (this.getUris() != null) {
            annotation.setUris(new ArrayList<Uri>());
            for (Uri uri : this.getUris()) {
                if (uri == null) continue;
                annotation.getUris().add(uri);
            }
        }
        return annotation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + object + " [" + object.getClass() + "]");
        }
        return this.isEqual((Annotation)object);
    }

    public Confidence getConfidence() {
        return this._confidence;
    }

    public String getDesc() {
        return this._desc;
    }

    public String getEvidence() {
        return this._evidence;
    }

    public PropertiesList getProperties() {
        return this._properties;
    }

    public String getRef() {
        if (ForesterUtil.isEmpty(this._ref_source)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._ref_source);
        stringBuilder.append(':');
        stringBuilder.append(this._ref_value);
        return stringBuilder.toString();
    }

    public final String getRefSource() {
        return this._ref_source;
    }

    public final String getRefValue() {
        return this._ref_value;
    }

    public String getSource() {
        return this._source;
    }

    public String getType() {
        return this._type;
    }

    @Override
    public Uri getUri(int n) {
        return this.getUris().get(n);
    }

    @Override
    public List<Uri> getUris() {
        return this._uris;
    }

    @Override
    public boolean isEqual(PhylogenyData phylogenyData) {
        Annotation annotation = (Annotation)phylogenyData;
        return this.getDesc().equalsIgnoreCase(annotation.getDesc()) && this.getType().equals(annotation.getType()) && this.getSource().equals(annotation.getSource()) && this.getRef().equals(annotation.getRef());
    }

    public void setConfidence(Confidence confidence) {
        this._confidence = confidence;
    }

    public void setDesc(String string) {
        this._desc = string;
    }

    public void setEvidence(String string) {
        this._evidence = string;
    }

    public void setProperties(PropertiesList propertiesList) {
        this._properties = propertiesList;
    }

    public void setSource(String string) {
        this._source = string;
    }

    public void setType(String string) {
        this._type = string;
    }

    @Override
    public void setUris(List<Uri> list) {
        this._uris = list;
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int n, String string) throws IOException {
        if (this.getConfidence() != null || this.getProperties() != null || this.getUris() != null && !this.getUris().isEmpty() || !ForesterUtil.isEmpty(this.getDesc())) {
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string);
            PhylogenyDataUtil.appendOpen(writer, "annotation", "ref", this.getRef(), "evidence", this.getEvidence(), "type", this.getType(), "source", this.getSource());
            if (!ForesterUtil.isEmpty(this.getDesc())) {
                PhylogenyDataUtil.appendElement(writer, "desc", this.getDesc(), string);
            }
            if (this.getConfidence() != null) {
                this.getConfidence().toPhyloXML(writer, n, string + "  ");
            }
            if (this.getProperties() != null) {
                this.getProperties().toPhyloXML(writer, n, string);
            }
            if (this.getUris() != null) {
                for (Uri uri : this.getUris()) {
                    if (uri == null) continue;
                    uri.toPhyloXML(writer, n, string);
                }
            }
            writer.write(ForesterUtil.LINE_SEPARATOR);
            writer.write(string);
            PhylogenyDataUtil.appendClose(writer, "annotation");
        } else {
            PhylogenyDataUtil.appendElement(writer, "annotation", "ref", this.getRef(), "evidence", this.getEvidence(), "type", this.getType(), "source", this.getSource(), string);
        }
    }

    public String toString() {
        return this.asText().toString();
    }

    private void init() {
        this._desc = "";
        this._type = "";
        this._source = "";
        this._evidence = "";
        this._confidence = null;
        this._properties = null;
        this.setUris(null);
    }
}

