/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.forester.io.parsers.FastaParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.msa.Msa;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.BranchWidth;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;
import org.forester.util.TaxonomyUtil;

public class PhylogenyMethods {
    private static boolean _order_changed;

    private PhylogenyMethods() {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public static boolean extractFastaInformation(Phylogeny phylogeny) {
        boolean bl = false;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            Matcher matcher;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (ForesterUtil.isEmpty(phylogenyNode.getName()) || !(matcher = FastaParser.FASTA_DESC_LINE.matcher(phylogenyNode.getName())).lookingAt()) continue;
            bl = true;
            String string = matcher.group(1);
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            String string4 = matcher.group(4);
            if (!ForesterUtil.isEmpty(string) && !ForesterUtil.isEmpty(string2)) {
                ForesterUtil.ensurePresenceOfSequence(phylogenyNode);
                phylogenyNode.getNodeData().getSequence(0).setAccession(new Accession(string2, string));
            }
            if (!ForesterUtil.isEmpty(string3)) {
                ForesterUtil.ensurePresenceOfSequence(phylogenyNode);
                phylogenyNode.getNodeData().getSequence(0).setName(string3);
            }
            if (ForesterUtil.isEmpty(string4)) continue;
            ForesterUtil.ensurePresenceOfTaxonomy(phylogenyNode);
            phylogenyNode.getNodeData().getTaxonomy(0).setScientificName(string4);
        }
        return bl;
    }

    public static DescriptiveStatistics calculateBranchLengthStatistics(Phylogeny phylogeny) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isRoot() || !(phylogenyNode.getDistanceToParent() >= 0.0)) continue;
            basicDescriptiveStatistics.addValue(phylogenyNode.getDistanceToParent());
        }
        return basicDescriptiveStatistics;
    }

    public static List<DescriptiveStatistics> calculateConfidenceStatistics(Phylogeny phylogeny) {
        ArrayList<DescriptiveStatistics> arrayList = new ArrayList<DescriptiveStatistics>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.isRoot() || !phylogenyNode.getBranchData().isHasConfidences()) continue;
            for (int i = 0; i < phylogenyNode.getBranchData().getConfidences().size(); ++i) {
                Confidence confidence = phylogenyNode.getBranchData().getConfidences().get(i);
                if (i > arrayList.size() - 1 || arrayList.get(i) == null) {
                    arrayList.add(i, new BasicDescriptiveStatistics());
                }
                if (!ForesterUtil.isEmpty(confidence.getType())) {
                    if (!ForesterUtil.isEmpty(((DescriptiveStatistics)arrayList.get(i)).getDescription()) && !((DescriptiveStatistics)arrayList.get(i)).getDescription().equalsIgnoreCase(confidence.getType())) {
                        throw new IllegalArgumentException("support values in node [" + phylogenyNode.toString() + "] appear inconsistently ordered");
                    }
                    ((DescriptiveStatistics)arrayList.get(i)).setDescription(confidence.getType());
                }
                ((DescriptiveStatistics)arrayList.get(i)).addValue(confidence != null && confidence.getValue() >= 0.0 ? confidence.getValue() : 0.0);
            }
        }
        return arrayList;
    }

    public static int calculateLevel(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isExternal()) {
            return 0;
        }
        int n = 0;
        for (PhylogenyNode phylogenyNode2 : phylogenyNode.getAllExternalDescendants()) {
            int n2 = 0;
            while (phylogenyNode2 != phylogenyNode) {
                phylogenyNode2 = phylogenyNode2.getParent();
                ++n2;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static double calculateDistance(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        PhylogenyNode phylogenyNode3 = PhylogenyMethods.calculateLCA(phylogenyNode, phylogenyNode2);
        PhylogenyNode phylogenyNode4 = phylogenyNode;
        PhylogenyNode phylogenyNode5 = phylogenyNode2;
        return PhylogenyMethods.getDistance(phylogenyNode4, phylogenyNode3) + PhylogenyMethods.getDistance(phylogenyNode5, phylogenyNode3);
    }

    public static final PhylogenyNode calculateLCA(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        if (phylogenyNode == null) {
            throw new IllegalArgumentException("first argument (node) is null");
        }
        if (phylogenyNode2 == null) {
            throw new IllegalArgumentException("second argument (node) is null");
        }
        if (phylogenyNode == phylogenyNode2) {
            return phylogenyNode;
        }
        if (phylogenyNode.getParent() == phylogenyNode2.getParent()) {
            return phylogenyNode.getParent();
        }
        int n = phylogenyNode.calculateDepth();
        int n2 = phylogenyNode2.calculateDepth();
        while (n > -1 && n2 > -1) {
            if (n > n2) {
                phylogenyNode = phylogenyNode.getParent();
                --n;
                continue;
            }
            if (n2 > n) {
                phylogenyNode2 = phylogenyNode2.getParent();
                --n2;
                continue;
            }
            if (phylogenyNode == phylogenyNode2) {
                return phylogenyNode;
            }
            phylogenyNode = phylogenyNode.getParent();
            phylogenyNode2 = phylogenyNode2.getParent();
            --n;
            --n2;
        }
        throw new IllegalArgumentException("illegal attempt to calculate LCA of two nodes which do not share a common root");
    }

    public static final PhylogenyNode calculateLCAonTreeWithIdsInPreOrder(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        if (phylogenyNode == null) {
            throw new IllegalArgumentException("first argument (node) is null");
        }
        if (phylogenyNode2 == null) {
            throw new IllegalArgumentException("second argument (node) is null");
        }
        while (phylogenyNode != phylogenyNode2) {
            if (phylogenyNode.getId() > phylogenyNode2.getId()) {
                phylogenyNode = phylogenyNode.getParent();
                continue;
            }
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        return phylogenyNode;
    }

    public static int calculateMaxDepth(Phylogeny phylogeny) {
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            int n2 = phylogenyNode.calculateDepth();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static String[] obtainPresentRanksSorted(Phylogeny phylogeny) {
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = phylogeny.iteratorPreorder();
        while (stringArray.hasNext()) {
            String object;
            PhylogenyNode phylogenyNode = stringArray.next();
            if (phylogenyNode.isExternal() || phylogenyNode.isRoot() || phylogenyNode.getNodeData().getTaxonomy() == null || ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getRank()) || !TaxonomyUtil.RANK_TO_INT.containsKey(object = phylogenyNode.getNodeData().getTaxonomy().getRank())) continue;
            hashSet.add(object);
        }
        stringArray = new String[hashSet.size() + 1];
        int n = 0;
        for (String string : TaxonomyUtil.RANKS) {
            if (!hashSet.contains(string)) continue;
            stringArray[n++] = string;
        }
        stringArray[n] = "off";
        return stringArray;
    }

    public static int calculateMaxDepthConsiderCollapsed(Phylogeny phylogeny) {
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            int n2 = 0;
            while (phylogenyNode.getParent() != null) {
                if (!phylogenyNode.isCollapse()) {
                    ++n2;
                }
                phylogenyNode = phylogenyNode.getParent();
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public static double calculateMaxDistanceToRoot(Phylogeny phylogeny) {
        double d = 0.0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            double d2 = phylogenyNode.calculateDistanceToRoot();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static PhylogenyNode calculateNodeWithMaxDistanceToRoot(Phylogeny phylogeny) {
        double d = 0.0;
        PhylogenyNode phylogenyNode = phylogeny.getFirstExternalNode();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode2 = phylogenyNodeIterator.next();
            double d2 = phylogenyNode2.calculateDistanceToRoot();
            if (!(d2 > d)) continue;
            d = d2;
            phylogenyNode = phylogenyNode2;
        }
        return phylogenyNode;
    }

    public static int calculateNumberOfExternalNodesWithoutTaxonomy(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        int n = 0;
        for (PhylogenyNode phylogenyNode2 : list) {
            if (phylogenyNode2.getNodeData().isHasTaxonomy() && !phylogenyNode2.getNodeData().getTaxonomy().isEmpty()) continue;
            ++n;
        }
        return n;
    }

    public static DescriptiveStatistics calculateNumberOfDescendantsPerNodeStatistics(Phylogeny phylogeny) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal()) continue;
            basicDescriptiveStatistics.addValue(phylogenyNode.getNumberOfDescendants());
        }
        return basicDescriptiveStatistics;
    }

    public static final void collapseSubtreeStructure(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (PhylogenyNode phylogenyNode2 : list) {
            arrayList.add(PhylogenyMethods.calculateDistanceToAncestor(phylogenyNode, phylogenyNode2));
        }
        for (int i = 0; i < list.size(); ++i) {
            phylogenyNode.setChildNode(i, list.get(i));
            list.get(i).setDistanceToParent((Double)arrayList.get(i));
        }
    }

    public static int countNumberOfOneDescendantNodes(Phylogeny phylogeny) {
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.getNumberOfDescendants() != 1) continue;
            ++n;
        }
        return n;
    }

    public static int countNumberOfPolytomies(Phylogeny phylogeny) {
        int n = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.getNumberOfDescendants() <= 2) continue;
            ++n;
        }
        return n;
    }

    public static final HashMap<String, PhylogenyNode> createNameToExtNodeMap(Phylogeny phylogeny) {
        HashMap<String, PhylogenyNode> hashMap = new HashMap<String, PhylogenyNode>();
        List<PhylogenyNode> list = phylogeny.getExternalNodes();
        for (PhylogenyNode phylogenyNode : list) {
            hashMap.put(phylogenyNode.getName(), phylogenyNode);
        }
        return hashMap;
    }

    public static void deleteExternalNodesNegativeSelection(Set<Long> set, Phylogeny phylogeny) {
        for (Long l : set) {
            phylogeny.deleteSubtree(phylogeny.getNode(l), true);
        }
        phylogeny.clearHashIdToNodeMap();
        phylogeny.externalNodesHaveChanged();
    }

    public static void deleteExternalNodesNegativeSelection(String[] stringArray, Phylogeny phylogeny) throws IllegalArgumentException {
        for (String string : stringArray) {
            if (ForesterUtil.isEmpty(string)) continue;
            List<PhylogenyNode> list = null;
            list = phylogeny.getNodes(string);
            for (PhylogenyNode phylogenyNode : list) {
                if (!phylogenyNode.isExternal()) {
                    throw new IllegalArgumentException("attempt to delete non-external node \"" + string + "\"");
                }
                phylogeny.deleteSubtree(phylogenyNode, true);
            }
        }
        phylogeny.clearHashIdToNodeMap();
        phylogeny.externalNodesHaveChanged();
    }

    public static List<String> deleteExternalNodesPositiveSelection(String[] stringArray, Phylogeny phylogeny) {
        Object object;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        String[] stringArray2 = new String[phylogeny.getNumberOfExternalNodes()];
        int n = 0;
        Arrays.sort(stringArray);
        while (phylogenyNodeIterator.hasNext()) {
            object = phylogenyNodeIterator.next().getName();
            if (Arrays.binarySearch(stringArray, object) >= 0) continue;
            stringArray2[n++] = object;
        }
        PhylogenyMethods.deleteExternalNodesNegativeSelection(stringArray2, phylogeny);
        object = new ArrayList();
        for (String string : stringArray2) {
            if (ForesterUtil.isEmpty(string)) continue;
            object.add(string);
        }
        return object;
    }

    public static void deleteExternalNodesPositiveSelectionT(List<Taxonomy> list, Phylogeny phylogeny) {
        HashSet<Long> hashSet = new HashSet<Long>();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getNodeData().isHasTaxonomy()) {
                if (list.contains(phylogenyNode.getNodeData().getTaxonomy())) continue;
                hashSet.add(phylogenyNode.getId());
                continue;
            }
            throw new IllegalArgumentException("node " + phylogenyNode.getId() + " has no taxonomic data");
        }
        PhylogenyMethods.deleteExternalNodesNegativeSelection(hashSet, phylogeny);
    }

    public static final void deleteInternalNodesWithOnlyOneDescendent(Phylogeny phylogeny) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        Iterator<PhylogenyNode> iterator = phylogeny.iteratorPostorder();
        while (iterator.hasNext()) {
            PhylogenyNode phylogenyNode = iterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.getNumberOfDescendants() != 1) continue;
            arrayList.add(phylogenyNode);
        }
        for (PhylogenyNode phylogenyNode : arrayList) {
            PhylogenyMethods.removeNode(phylogenyNode, phylogeny);
        }
        phylogeny.clearHashIdToNodeMap();
        phylogeny.externalNodesHaveChanged();
    }

    public static final void deleteNonOrthologousExternalNodes(Phylogeny phylogeny, PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isInternal()) {
            throw new IllegalArgumentException("node is not external");
        }
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        Iterator<PhylogenyNode> iterator = phylogeny.iteratorExternalForward();
        while (iterator.hasNext()) {
            PhylogenyNode phylogenyNode2 = iterator.next();
            if (PhylogenyMethods.getEventAtLCA(phylogenyNode, phylogenyNode2).isSpeciation()) continue;
            arrayList.add(phylogenyNode2);
        }
        for (PhylogenyNode phylogenyNode2 : arrayList) {
            phylogeny.deleteSubtree(phylogenyNode2, true);
        }
        phylogeny.clearHashIdToNodeMap();
        phylogeny.externalNodesHaveChanged();
    }

    public static final List<List<PhylogenyNode>> divideIntoSubTrees(Phylogeny phylogeny, double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("attempt to use min distance to root of: " + d);
        }
        ArrayList<List<PhylogenyNode>> arrayList = new ArrayList<List<PhylogenyNode>>();
        PhylogenyMethods.setAllIndicatorsToZero(phylogeny);
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.getIndicator() != 0) continue;
            arrayList.add(PhylogenyMethods.divideIntoSubTreesHelper(phylogenyNode, d));
            if (!arrayList.isEmpty()) continue;
            throw new RuntimeException("this should not have happened");
        }
        return arrayList;
    }

    public static List<PhylogenyNode> getAllDescendants(PhylogenyNode phylogenyNode) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        HashSet<Long> hashSet = new HashSet<Long>();
        if (!phylogenyNode.isExternal()) {
            List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
            for (PhylogenyNode phylogenyNode2 : list) {
                arrayList.add(phylogenyNode2);
                while (phylogenyNode2 != phylogenyNode) {
                    if (hashSet.contains((phylogenyNode2 = phylogenyNode2.getParent()).getId())) continue;
                    arrayList.add(phylogenyNode2);
                    hashSet.add(phylogenyNode2.getId());
                }
            }
        }
        return arrayList;
    }

    public static List<PhylogenyNode> getAllDescendantsOfGivenLevel(PhylogenyNode phylogenyNode, int n) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        HashSet<Long> hashSet = new HashSet<Long>();
        if (!phylogenyNode.isExternal()) {
            List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
            for (PhylogenyNode phylogenyNode2 : list) {
                if (PhylogenyMethods.calculateLevel(phylogenyNode2) == n) {
                    arrayList.add(phylogenyNode2);
                }
                while (phylogenyNode2 != phylogenyNode) {
                    if (hashSet.contains((phylogenyNode2 = phylogenyNode2.getParent()).getId())) continue;
                    if (PhylogenyMethods.calculateLevel(phylogenyNode2) == n) {
                        arrayList.add(phylogenyNode2);
                    }
                    hashSet.add(phylogenyNode2.getId());
                }
            }
        }
        return arrayList;
    }

    public static Color getBranchColorValue(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.getBranchData().getBranchColor() == null) {
            return null;
        }
        return phylogenyNode.getBranchData().getBranchColor().getValue();
    }

    public static double getBranchWidthValue(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getBranchData().isHasBranchWidth()) {
            return 1.0;
        }
        return phylogenyNode.getBranchData().getBranchWidth().getValue();
    }

    public static double getConfidenceValue(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getBranchData().isHasConfidences()) {
            return -2.147483647E9;
        }
        return phylogenyNode.getBranchData().getConfidence(0).getValue();
    }

    public static double[] getConfidenceValuesAsArray(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getBranchData().isHasConfidences()) {
            return new double[0];
        }
        double[] dArray = new double[phylogenyNode.getBranchData().getConfidences().size()];
        int n = 0;
        for (Confidence confidence : phylogenyNode.getBranchData().getConfidences()) {
            dArray[n++] = confidence.getValue();
        }
        return dArray;
    }

    public static final Event getEventAtLCA(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        return PhylogenyMethods.calculateLCA(phylogenyNode, phylogenyNode2).getNodeData().getEvent();
    }

    public static Taxonomy getExternalDescendantsTaxonomy(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        Taxonomy taxonomy = null;
        for (PhylogenyNode phylogenyNode2 : list) {
            if (!phylogenyNode2.getNodeData().isHasTaxonomy() || phylogenyNode2.getNodeData().getTaxonomy().isEmpty()) {
                return null;
            }
            if (taxonomy == null) {
                taxonomy = phylogenyNode2.getNodeData().getTaxonomy();
                continue;
            }
            if (!phylogenyNode2.getNodeData().getTaxonomy().isEmpty() && taxonomy.isEqual(phylogenyNode2.getNodeData().getTaxonomy())) continue;
            return null;
        }
        return taxonomy;
    }

    public static PhylogenyNode getFurthestDescendant(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        PhylogenyNode phylogenyNode2 = null;
        double d = -1.7976931348623157E308;
        for (PhylogenyNode phylogenyNode3 : list) {
            if (!(PhylogenyMethods.getDistance(phylogenyNode3, phylogenyNode) > d)) continue;
            phylogenyNode2 = phylogenyNode3;
            d = PhylogenyMethods.getDistance(phylogenyNode3, phylogenyNode);
        }
        return phylogenyNode2;
    }

    public static double getMaximumConfidenceValue(Phylogeny phylogeny) {
        double d = -1.7976931348623157E308;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            double d2 = PhylogenyMethods.getConfidenceValue(phylogenyNodeIterator.next());
            if (d2 == -2.147483647E9 || !(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static int getMinimumDescendentsPerInternalNodes(Phylogeny phylogeny) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isInternal() || (n2 = phylogenyNode.getNumberOfDescendants()) >= n) continue;
            n = n2;
        }
        return n;
    }

    public static String getSpecies(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
            return "";
        }
        if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName())) {
            return phylogenyNode.getNodeData().getTaxonomy().getScientificName();
        }
        if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode())) {
            return phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode();
        }
        return phylogenyNode.getNodeData().getTaxonomy().getCommonName();
    }

    public static String getTaxonomyIdentifier(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasTaxonomy() || phylogenyNode.getNodeData().getTaxonomy().getIdentifier() == null) {
            return "";
        }
        return phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue();
    }

    public static final boolean isAllDecendentsAreDuplications(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isExternal()) {
            return true;
        }
        if (phylogenyNode.isDuplication()) {
            for (PhylogenyNode phylogenyNode2 : phylogenyNode.getDescendants()) {
                if (PhylogenyMethods.isAllDecendentsAreDuplications(phylogenyNode2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isHasExternalDescendant(PhylogenyNode phylogenyNode) {
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            if (!phylogenyNode.getChildNode(i).isExternal()) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean isTaxonomyHasIdentifierOfGivenProvider(Taxonomy taxonomy, String[] stringArray) {
        if (taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getProvider())) {
            String string = taxonomy.getIdentifier().getProvider();
            for (String string2 : stringArray) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void midpointRoot(Phylogeny phylogeny) {
        if (phylogeny.getNumberOfExternalNodes() < 2 || PhylogenyMethods.calculateMaxDistanceToRoot(phylogeny) <= 0.0) {
            return;
        }
        int n = 0;
        int n2 = phylogeny.getNodeCount();
        while (true) {
            double d;
            if (++n > n2) {
                throw new RuntimeException("this should not have happened: midpoint rooting does not converge");
            }
            PhylogenyNode phylogenyNode = null;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < phylogeny.getRoot().getNumberOfDescendants(); ++i) {
                PhylogenyNode phylogenyNode2 = PhylogenyMethods.getFurthestDescendant(phylogeny.getRoot().getChildNode(i));
                d = PhylogenyMethods.getDistance(phylogenyNode2, phylogeny.getRoot());
                if (!(d > 0.0)) continue;
                if (d > d2) {
                    d3 = d2;
                    d2 = d;
                    phylogenyNode = phylogenyNode2;
                    continue;
                }
                if (!(d > d3)) continue;
                d3 = d;
            }
            double d4 = d2 - d3;
            if (d4 < 1.0E-6) break;
            d = d2 - d4 / 2.0;
            while (d > phylogenyNode.getDistanceToParent() && !phylogenyNode.isRoot()) {
                d -= phylogenyNode.getDistanceToParent() > 0.0 ? phylogenyNode.getDistanceToParent() : 0.0;
                phylogenyNode = phylogenyNode.getParent();
            }
            phylogeny.reRoot(phylogenyNode, d);
        }
        phylogeny.recalculateNumberOfExternalDescendants(true);
    }

    public static void normalizeBootstrapValues(Phylogeny phylogeny, double d, double d2) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            double d3;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isInternal() || (d3 = PhylogenyMethods.getConfidenceValue(phylogenyNode)) == -2.147483647E9) continue;
            if (d3 >= d) {
                PhylogenyMethods.setBootstrapConfidence(phylogenyNode, d2);
                continue;
            }
            PhylogenyMethods.setBootstrapConfidence(phylogenyNode, d3 * d2 / d);
        }
    }

    public static List<PhylogenyNode> obtainAllNodesAsList(Phylogeny phylogeny) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        if (phylogeny.isEmpty()) {
            return arrayList;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            arrayList.add(phylogenyNodeIterator.next());
        }
        return arrayList;
    }

    public static Map<Taxonomy, Integer> obtainDistinctTaxonomyCounts(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        HashMap<Taxonomy, Integer> hashMap = new HashMap<Taxonomy, Integer>();
        for (PhylogenyNode phylogenyNode2 : list) {
            if (!phylogenyNode2.getNodeData().isHasTaxonomy() || phylogenyNode2.getNodeData().getTaxonomy().isEmpty()) {
                return null;
            }
            Taxonomy taxonomy = phylogenyNode2.getNodeData().getTaxonomy();
            if (hashMap.containsKey(taxonomy)) {
                hashMap.put(taxonomy, (Integer)hashMap.get(taxonomy) + 1);
                continue;
            }
            hashMap.put(taxonomy, 1);
        }
        return hashMap;
    }

    public static void orderAppearance(PhylogenyNode phylogenyNode, boolean bl, boolean bl2, DESCENDANT_SORT_PRIORITY dESCENDANT_SORT_PRIORITY) {
        if (phylogenyNode.isExternal()) {
            return;
        }
        if (phylogenyNode.getNumberOfDescendants() == 2 && phylogenyNode.getChildNode1().getNumberOfExternalNodes() != phylogenyNode.getChildNode2().getNumberOfExternalNodes() && phylogenyNode.getChildNode1().getNumberOfExternalNodes() < phylogenyNode.getChildNode2().getNumberOfExternalNodes() == bl) {
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode1();
            phylogenyNode.setChild1(phylogenyNode.getChildNode2());
            phylogenyNode.setChild2(phylogenyNode2);
            _order_changed = true;
        } else if (bl2) {
            boolean bl3 = true;
            for (PhylogenyNode phylogenyNode3 : phylogenyNode.getDescendants()) {
                if (phylogenyNode3.isExternal()) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                PhylogenyMethods.sortNodeDescendents(phylogenyNode, dESCENDANT_SORT_PRIORITY);
            }
        }
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            PhylogenyMethods.orderAppearance(phylogenyNode.getChildNode(i), bl, bl2, dESCENDANT_SORT_PRIORITY);
        }
    }

    public static synchronized void orderAppearanceX(PhylogenyNode phylogenyNode, boolean bl, DESCENDANT_SORT_PRIORITY dESCENDANT_SORT_PRIORITY) {
        if (phylogenyNode.isExternal()) {
            return;
        }
        _order_changed = false;
        PhylogenyMethods.orderAppearance(phylogenyNode, true, bl, dESCENDANT_SORT_PRIORITY);
        if (!_order_changed) {
            PhylogenyMethods.orderAppearance(phylogenyNode, false, bl, dESCENDANT_SORT_PRIORITY);
        }
    }

    public static void postorderBranchColorAveragingExternalNodeBased(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            int n = 0;
            if (!phylogenyNode.isInternal()) continue;
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
                Color color = PhylogenyMethods.getBranchColorValue(phylogenyNode2);
                if (color == null) continue;
                ++n;
                d += (double)color.getRed();
                d2 += (double)color.getGreen();
                d3 += (double)color.getBlue();
            }
            PhylogenyMethods.setBranchColorValue(phylogenyNode, new Color(ForesterUtil.roundToInt(d / (double)n), ForesterUtil.roundToInt(d2 / (double)n), ForesterUtil.roundToInt(d3 / (double)n)));
        }
    }

    public static final void preOrderReId(Phylogeny phylogeny) {
        if (phylogeny.isEmpty()) {
            return;
        }
        phylogeny.setIdToNodeMap(null);
        long l = PhylogenyNode.getNodeCount();
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNodeIterator.next().setId(l++);
        }
        PhylogenyNode.setNodeCount(l);
    }

    public static final Phylogeny[] readPhylogenies(PhylogenyParser phylogenyParser, File file) throws IOException {
        PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
        Phylogeny[] phylogenyArray = phylogenyFactory.create(file, phylogenyParser);
        if (phylogenyArray == null || phylogenyArray.length == 0) {
            throw new PhylogenyParserException("Unable to parse phylogeny from file: " + file);
        }
        return phylogenyArray;
    }

    public static final Phylogeny[] readPhylogenies(PhylogenyParser phylogenyParser, List<File> list) throws IOException {
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        for (File file : list) {
            PhylogenyFactory phylogenyFactory = ParserBasedPhylogenyFactory.getInstance();
            Phylogeny[] phylogenyArray = phylogenyFactory.create(file, phylogenyParser);
            if (phylogenyArray == null || phylogenyArray.length == 0) {
                throw new PhylogenyParserException("Unable to parse phylogeny from file: " + file);
            }
            arrayList.addAll(Arrays.asList(phylogenyArray));
        }
        return arrayList.toArray(new Phylogeny[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeNode(PhylogenyNode phylogenyNode, Phylogeny phylogeny) {
        if (phylogenyNode.isRoot()) {
            if (phylogenyNode.getNumberOfDescendants() != 1) throw new IllegalArgumentException("attempt to remove a root node with more than one descendants");
            PhylogenyNode phylogenyNode2 = phylogenyNode.getDescendants().get(0);
            phylogenyNode2.setDistanceToParent(PhylogenyMethods.addPhylogenyDistances(phylogenyNode.getDistanceToParent(), phylogenyNode2.getDistanceToParent()));
            phylogenyNode2.setParent(null);
            phylogeny.setRoot(phylogenyNode2);
            phylogeny.clearHashIdToNodeMap();
            return;
        } else if (phylogenyNode.isExternal()) {
            phylogeny.deleteSubtree(phylogenyNode, false);
            phylogeny.clearHashIdToNodeMap();
            phylogeny.externalNodesHaveChanged();
            return;
        } else {
            PhylogenyNode phylogenyNode3 = phylogenyNode.getParent();
            List<PhylogenyNode> list = phylogenyNode.getDescendants();
            phylogenyNode3.removeChildNode(phylogenyNode);
            for (PhylogenyNode phylogenyNode4 : list) {
                phylogenyNode3.addAsChild(phylogenyNode4);
                phylogenyNode4.setDistanceToParent(PhylogenyMethods.addPhylogenyDistances(phylogenyNode.getDistanceToParent(), phylogenyNode4.getDistanceToParent()));
            }
            phylogenyNode.setParent(null);
            phylogeny.clearHashIdToNodeMap();
            phylogeny.externalNodesHaveChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<Long> searchData(String string, Phylogeny phylogeny, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (phylogeny.isEmpty() || string == null) {
            return arrayList;
        }
        if (ForesterUtil.isEmpty(string)) {
            return arrayList;
        }
        String string2 = string;
        NDF nDF = null;
        if (string2.length() > 2 && string2.indexOf(":") == 2 && (nDF = NDF.fromString(string2)) != null) {
            string2 = string2.substring(3);
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            Iterator iterator;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            boolean bl5 = false;
            if ((nDF == null || nDF == NDF.NodeName) && PhylogenyMethods.match(phylogenyNode.getName(), string2, bl, bl2, bl3)) {
                bl5 = true;
            } else if ((nDF == null || nDF == NDF.TaxonomyCode) && phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode(), string2, bl, bl2, bl3)) {
                bl5 = true;
            } else if ((nDF == null || nDF == NDF.TaxonomyCommonName) && phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getCommonName(), string2, bl, bl2, bl3)) {
                bl5 = true;
            } else if ((nDF == null || nDF == NDF.TaxonomyScientificName) && phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getScientificName(), string2, bl, bl2, bl3)) {
                bl5 = true;
            } else if ((nDF == null || nDF == NDF.TaxonomyIdentifier) && phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode.getNodeData().getTaxonomy().getIdentifier() != null && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue(), string2, bl, bl2, bl3)) {
                bl5 = true;
            } else if ((nDF == null || nDF == NDF.TaxonomySynonym) && phylogenyNode.getNodeData().isHasTaxonomy() && !phylogenyNode.getNodeData().getTaxonomy().getSynonyms().isEmpty()) {
                iterator = phylogenyNode.getNodeData().getTaxonomy().getSynonyms();
                Iterator i = iterator.iterator();
                while (i.hasNext()) {
                    String string3 = (String)i.next();
                    if (!PhylogenyMethods.match(string3, string2, bl, bl2, bl3)) continue;
                    bl5 = true;
                    break;
                }
            }
            if (!bl5 && (nDF == null || nDF == NDF.SequenceName) && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getName(), string2, bl, bl2, bl3)) {
                bl5 = true;
            }
            if (!bl5 && (nDF == null || nDF == NDF.GeneName) && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getGeneName(), string2, bl, bl2, bl3)) {
                bl5 = true;
            }
            if (!bl5 && (nDF == null || nDF == NDF.SequenceSymbol) && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getSymbol(), string2, bl, bl2, bl3)) {
                bl5 = true;
            }
            if (!bl5 && (nDF == null || nDF == NDF.SequenceAccession) && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getAccession().getValue(), string2, bl, bl2, bl3)) {
                bl5 = true;
            }
            if (!bl5 && (nDF == null && bl4 || nDF == NDF.Domain) && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getDomainArchitecture() != null) {
                void var15_17;
                iterator = phylogenyNode.getNodeData().getSequence().getDomainArchitecture();
                boolean bl6 = false;
                while (var15_17 < ((DomainArchitecture)((Object)iterator)).getNumberOfDomains()) {
                    if (((DomainArchitecture)((Object)iterator)).getDomain((int)var15_17).getConfidence() <= d && PhylogenyMethods.match(((DomainArchitecture)((Object)iterator)).getDomain((int)var15_17).getName(), string2, bl, bl2, bl3)) {
                        bl5 = true;
                        break;
                    }
                    ++var15_17;
                }
            }
            if (!bl5 && (nDF == null || nDF == NDF.Annotation) && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAnnotations() != null) {
                for (Annotation annotation : phylogenyNode.getNodeData().getSequence().getAnnotations()) {
                    if (PhylogenyMethods.match(annotation.getDesc(), string2, bl, bl2, bl3)) {
                        bl5 = true;
                        break;
                    }
                    if (!PhylogenyMethods.match(annotation.getRef(), string2, bl, bl2, bl3)) continue;
                    bl5 = true;
                    break;
                }
            }
            if (!bl5 && (nDF == null || nDF == NDF.CrossRef) && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getCrossReferences() != null) {
                for (Accession accession : phylogenyNode.getNodeData().getSequence().getCrossReferences()) {
                    if (PhylogenyMethods.match(accession.getComment(), string2, bl, bl2, bl3)) {
                        bl5 = true;
                        break;
                    }
                    if (PhylogenyMethods.match(accession.getSource(), string2, bl, bl2, bl3)) {
                        bl5 = true;
                        break;
                    }
                    if (!PhylogenyMethods.match(accession.getValue(), string2, bl, bl2, bl3)) continue;
                    bl5 = true;
                    break;
                }
            }
            if (!(bl5 || nDF != null && nDF != NDF.BinaryCharacter || phylogenyNode.getNodeData().getBinaryCharacters() == null)) {
                iterator = phylogenyNode.getNodeData().getBinaryCharacters().getPresentCharacters().iterator();
                while (iterator.hasNext()) {
                    if (!PhylogenyMethods.match((String)iterator.next(), string2, bl, bl2, bl3)) continue;
                    bl5 = true;
                    break;
                }
                iterator = phylogenyNode.getNodeData().getBinaryCharacters().getGainedCharacters().iterator();
                while (iterator.hasNext()) {
                    if (!PhylogenyMethods.match((String)iterator.next(), string2, bl, bl2, bl3)) continue;
                    bl5 = true;
                    break;
                }
            }
            if (!bl5 && nDF == NDF.MolecularSequence && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getMolecularSequence(), string2, bl, true, bl3)) {
                bl5 = true;
            }
            if (!bl5) continue;
            arrayList.add(phylogenyNode.getId());
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Long> searchDataLogicalAnd(String[] stringArray, Phylogeny phylogeny, boolean bl, boolean bl2, boolean bl3, double d) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (phylogeny.isEmpty() || stringArray == null || stringArray.length < 1) {
            return arrayList;
        }
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            boolean bl4 = true;
            for (String string : stringArray) {
                Iterator iterator;
                if (string == null) continue;
                string = string.trim();
                NDF nDF = null;
                if (string.length() > 2 && string.indexOf(":") == 2 && (nDF = NDF.fromString(string)) != null) {
                    string = string.substring(3);
                }
                boolean bl5 = false;
                if (ForesterUtil.isEmpty(string)) continue;
                if ((nDF == null || nDF == NDF.NodeName) && PhylogenyMethods.match(phylogenyNode.getName(), string, bl, bl2, false)) {
                    bl5 = true;
                } else if ((nDF == null || nDF == NDF.TaxonomyCode) && phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode(), string, bl, bl2, false)) {
                    bl5 = true;
                } else if ((nDF == null || nDF == NDF.TaxonomyCommonName) && phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getCommonName(), string, bl, bl2, false)) {
                    bl5 = true;
                } else if ((nDF == null || nDF == NDF.TaxonomyScientificName) && phylogenyNode.getNodeData().isHasTaxonomy() && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getScientificName(), string, bl, bl2, false)) {
                    bl5 = true;
                } else if ((nDF == null || nDF == NDF.TaxonomyIdentifier) && phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode.getNodeData().getTaxonomy().getIdentifier() != null && PhylogenyMethods.match(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue(), string, bl, bl2, false)) {
                    bl5 = true;
                } else if ((nDF == null || nDF == NDF.TaxonomySynonym) && phylogenyNode.getNodeData().isHasTaxonomy() && !phylogenyNode.getNodeData().getTaxonomy().getSynonyms().isEmpty()) {
                    iterator = phylogenyNode.getNodeData().getTaxonomy().getSynonyms();
                    Iterator i = iterator.iterator();
                    while (i.hasNext()) {
                        String string2 = (String)i.next();
                        if (!PhylogenyMethods.match(string2, string, bl, bl2, false)) continue;
                        bl5 = true;
                        break;
                    }
                }
                if (!bl5 && (nDF == null || nDF == NDF.SequenceName) && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getName(), string, bl, bl2, false)) {
                    bl5 = true;
                }
                if (!bl5 && (nDF == null || nDF == NDF.GeneName) && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getGeneName(), string, bl, bl2, false)) {
                    bl5 = true;
                }
                if (!bl5 && (nDF == null || nDF == NDF.SequenceSymbol) && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getSymbol(), string, bl, bl2, false)) {
                    bl5 = true;
                }
                if (!bl5 && (nDF == null || nDF == NDF.SequenceAccession) && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAccession() != null && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getAccession().getValue(), string, bl, bl2, false)) {
                    bl5 = true;
                }
                if (!bl5 && (nDF == null && bl3 || nDF == NDF.Domain) && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getDomainArchitecture() != null) {
                    void var18_20;
                    iterator = phylogenyNode.getNodeData().getSequence().getDomainArchitecture();
                    boolean bl6 = false;
                    while (var18_20 < ((DomainArchitecture)((Object)iterator)).getNumberOfDomains()) {
                        if (((DomainArchitecture)((Object)iterator)).getDomain((int)var18_20).getConfidence() <= d && PhylogenyMethods.match(((DomainArchitecture)((Object)iterator)).getDomain((int)var18_20).getName(), string, bl, bl2, false)) {
                            bl5 = true;
                            break;
                        }
                        ++var18_20;
                    }
                }
                if (!bl5 && (nDF == null || nDF == NDF.Annotation) && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAnnotations() != null) {
                    for (Annotation annotation : phylogenyNode.getNodeData().getSequence().getAnnotations()) {
                        if (PhylogenyMethods.match(annotation.getDesc(), string, bl, bl2, false)) {
                            bl5 = true;
                            break;
                        }
                        if (!PhylogenyMethods.match(annotation.getRef(), string, bl, bl2, false)) continue;
                        bl5 = true;
                        break;
                    }
                }
                if (!bl5 && (nDF == null || nDF == NDF.CrossRef) && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getCrossReferences() != null) {
                    for (Accession accession : phylogenyNode.getNodeData().getSequence().getCrossReferences()) {
                        if (PhylogenyMethods.match(accession.getComment(), string, bl, bl2, false)) {
                            bl5 = true;
                            break;
                        }
                        if (PhylogenyMethods.match(accession.getSource(), string, bl, bl2, false)) {
                            bl5 = true;
                            break;
                        }
                        if (!PhylogenyMethods.match(accession.getValue(), string, bl, bl2, false)) continue;
                        bl5 = true;
                        break;
                    }
                }
                if (!(bl5 || nDF != null && nDF != NDF.BinaryCharacter || phylogenyNode.getNodeData().getBinaryCharacters() == null)) {
                    iterator = phylogenyNode.getNodeData().getBinaryCharacters().getPresentCharacters().iterator();
                    while (iterator.hasNext()) {
                        if (!PhylogenyMethods.match((String)iterator.next(), string, bl, bl2, false)) continue;
                        bl5 = true;
                        break;
                    }
                    iterator = phylogenyNode.getNodeData().getBinaryCharacters().getGainedCharacters().iterator();
                    while (iterator.hasNext()) {
                        if (!PhylogenyMethods.match((String)iterator.next(), string, bl, bl2, false)) continue;
                        bl5 = true;
                        break;
                    }
                }
                if (!bl5 && nDF == NDF.MolecularSequence && phylogenyNode.getNodeData().isHasSequence() && PhylogenyMethods.match(phylogenyNode.getNodeData().getSequence().getMolecularSequence(), string, bl, true, false)) {
                    bl5 = true;
                }
                if (bl5) continue;
                bl4 = false;
                break;
            }
            if (!bl4) continue;
            arrayList.add(phylogenyNode.getId());
        }
        return arrayList;
    }

    public static void setAllIndicatorsToZero(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            phylogenyNodeIterator.next().setIndicator((byte)0);
        }
    }

    public static void setBootstrapConfidence(PhylogenyNode phylogenyNode, double d) {
        PhylogenyMethods.setConfidence(phylogenyNode, d, "bootstrap");
    }

    public static void setBranchColorValue(PhylogenyNode phylogenyNode, Color color) {
        if (phylogenyNode.getBranchData().getBranchColor() == null) {
            phylogenyNode.getBranchData().setBranchColor(new BranchColor());
        }
        phylogenyNode.getBranchData().getBranchColor().setValue(color);
    }

    public static void setBranchWidthValue(PhylogenyNode phylogenyNode, double d) {
        phylogenyNode.getBranchData().setBranchWidth(new BranchWidth(d));
    }

    public static void setConfidence(PhylogenyNode phylogenyNode, double d) {
        PhylogenyMethods.setConfidence(phylogenyNode, d, "");
    }

    public static void setConfidence(PhylogenyNode phylogenyNode, double d, String string) {
        Confidence confidence = null;
        if (phylogenyNode.getBranchData().getNumberOfConfidences() > 0) {
            confidence = phylogenyNode.getBranchData().getConfidence(0);
        } else {
            confidence = new Confidence();
            phylogenyNode.getBranchData().addConfidence(confidence);
        }
        confidence.setType(string);
        confidence.setValue(d);
    }

    public static void setScientificName(PhylogenyNode phylogenyNode, String string) {
        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
        }
        phylogenyNode.getNodeData().getTaxonomy().setScientificName(string);
    }

    public static void setTaxonomyCode(PhylogenyNode phylogenyNode, String string) throws PhyloXmlDataFormatException {
        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
        }
        phylogenyNode.getNodeData().getTaxonomy().setTaxonomyCode(string);
    }

    public static final void sortNodeDescendents(PhylogenyNode phylogenyNode, DESCENDANT_SORT_PRIORITY dESCENDANT_SORT_PRIORITY) {
        Comparator<PhylogenyNode> comparator;
        switch (dESCENDANT_SORT_PRIORITY) {
            case SEQUENCE: {
                comparator = new PhylogenyNodeSortSequencePriority();
                break;
            }
            case NODE_NAME: {
                comparator = new PhylogenyNodeSortNodeNamePriority();
                break;
            }
            default: {
                comparator = new PhylogenyNodeSortTaxonomyPriority();
            }
        }
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        Collections.sort(list, comparator);
        int n = 0;
        for (PhylogenyNode phylogenyNode2 : list) {
            phylogenyNode.setChildNode(n++, phylogenyNode2);
        }
    }

    public static List<PhylogenyNode> taxonomyBasedDeletionOfExternalNodes(Phylogeny phylogeny, Phylogeny phylogeny2) {
        PhylogenyNode phylogenyNode;
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        Object object2 = phylogeny.iteratorExternalForward();
        while (object2.hasNext()) {
            object = object2.next();
            if (!((PhylogenyNode)object).getNodeData().isHasTaxonomy()) {
                throw new IllegalArgumentException("no taxonomic data in node: " + object);
            }
            if (!ForesterUtil.isEmpty(((PhylogenyNode)object).getNodeData().getTaxonomy().getScientificName())) {
                hashSet.add(((PhylogenyNode)object).getNodeData().getTaxonomy().getScientificName());
            }
            if (!ForesterUtil.isEmpty(((PhylogenyNode)object).getNodeData().getTaxonomy().getTaxonomyCode())) {
                hashSet.add(((PhylogenyNode)object).getNodeData().getTaxonomy().getTaxonomyCode());
            }
            if (((PhylogenyNode)object).getNodeData().getTaxonomy().getIdentifier() == null || ForesterUtil.isEmpty(((PhylogenyNode)object).getNodeData().getTaxonomy().getIdentifier().getValue())) continue;
            hashSet.add(((PhylogenyNode)object).getNodeData().getTaxonomy().getIdentifier().getValuePlusProvider());
        }
        object2 = new ArrayList();
        object = phylogeny2.iteratorExternalForward();
        while (object.hasNext()) {
            phylogenyNode = object.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                ((ArrayList)object2).add(phylogenyNode);
                continue;
            }
            if (hashSet.contains(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) || hashSet.contains(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) || phylogenyNode.getNodeData().getTaxonomy().getIdentifier() != null && hashSet.contains(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValuePlusProvider())) continue;
            ((ArrayList)object2).add(phylogenyNode);
        }
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            phylogenyNode = (PhylogenyNode)object.next();
            phylogeny2.deleteSubtree(phylogenyNode, true);
        }
        phylogeny2.clearHashIdToNodeMap();
        phylogeny2.externalNodesHaveChanged();
        return object2;
    }

    public static final void transferInternalNamesToConfidenceValues(Phylogeny phylogeny, String string) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || ForesterUtil.isEmpty(phylogenyNode.getName())) continue;
            double d = -1.0;
            try {
                d = Double.parseDouble(phylogenyNode.getName());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("failed to parse number from [" + phylogenyNode.getName() + "]: " + numberFormatException.getLocalizedMessage());
            }
            if (!(d >= 0.0)) continue;
            phylogenyNode.getBranchData().addConfidence(new Confidence(d, string));
            phylogenyNode.setName("");
        }
    }

    public static final boolean isInternalNamesLookLikeConfidences(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || phylogenyNode.isRoot() || ForesterUtil.isEmpty(phylogenyNode.getName())) continue;
            double d = -1.0;
            try {
                d = Double.parseDouble(phylogenyNode.getName());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (!(d < 0.0) && !(d > 100.0)) continue;
            return false;
        }
        return true;
    }

    public static final void transferInternalNodeNamesToConfidence(Phylogeny phylogeny, String string) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyMethods.transferInternalNodeNameToConfidence(string, phylogenyNodeIterator.next());
        }
    }

    private static void transferInternalNodeNameToConfidence(String string, PhylogenyNode phylogenyNode) {
        if (!(phylogenyNode.isExternal() || phylogenyNode.getBranchData().isHasConfidences() || ForesterUtil.isEmpty(phylogenyNode.getName()))) {
            double d = -1.0;
            try {
                d = Double.parseDouble(phylogenyNode.getName());
            }
            catch (Exception exception) {
                d = -1.0;
            }
            if (d >= 0.0) {
                phylogenyNode.getBranchData().addConfidence(new Confidence(d, string));
                phylogenyNode.setName("");
            }
        }
    }

    public static final void transferNodeNameToField(Phylogeny phylogeny, PhylogenyNodeField phylogenyNodeField, boolean bl) throws PhyloXmlDataFormatException {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        block11: while (phylogenyNodeIterator.hasNext()) {
            String string;
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (bl && phylogenyNode.isInternal() || ForesterUtil.isEmpty(string = phylogenyNode.getName().trim())) continue;
            switch (phylogenyNodeField) {
                case TAXONOMY_CODE: {
                    phylogenyNode.setName("");
                    PhylogenyMethods.setTaxonomyCode(phylogenyNode, string);
                    continue block11;
                }
                case TAXONOMY_SCIENTIFIC_NAME: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setScientificName(string);
                    continue block11;
                }
                case TAXONOMY_COMMON_NAME: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setCommonName(string);
                    continue block11;
                }
                case SEQUENCE_SYMBOL: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasSequence()) {
                        phylogenyNode.getNodeData().setSequence(new Sequence());
                    }
                    phylogenyNode.getNodeData().getSequence().setSymbol(string);
                    continue block11;
                }
                case SEQUENCE_NAME: {
                    phylogenyNode.setName("");
                    if (!phylogenyNode.getNodeData().isHasSequence()) {
                        phylogenyNode.getNodeData().setSequence(new Sequence());
                    }
                    phylogenyNode.getNodeData().getSequence().setName(string);
                    continue block11;
                }
                case TAXONOMY_ID_UNIPROT_1: {
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    String string2 = string;
                    int n = string.indexOf(95);
                    if (n > 0) {
                        string2 = string.substring(0, n);
                    } else {
                        phylogenyNode.setName("");
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(string2, "uniprot"));
                    continue block11;
                }
                case TAXONOMY_ID_UNIPROT_2: {
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    String string2 = string;
                    int n = string.indexOf(95);
                    if (n > 0) {
                        string2 = string.substring(n + 1, string.length());
                    } else {
                        phylogenyNode.setName("");
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(string2, "uniprot"));
                    continue block11;
                }
                case TAXONOMY_ID: {
                    if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                        phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                    }
                    phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(string));
                    continue block11;
                }
                case CLADE_NAME: {
                    phylogenyNode.setName(string);
                    continue block11;
                }
            }
            throw new IllegalArgumentException("don't know what to do with " + (Object)((Object)phylogenyNodeField));
        }
    }

    static double addPhylogenyDistances(double d, double d2) {
        if (d >= 0.0 && d2 >= 0.0) {
            return d + d2;
        }
        if (d >= 0.0) {
            return d;
        }
        if (d2 >= 0.0) {
            return d2;
        }
        return -1024.0;
    }

    static double calculateDistanceToAncestor(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        double d = 0.0;
        boolean bl = true;
        while (phylogenyNode != phylogenyNode2) {
            if (phylogenyNode2.getDistanceToParent() != -1024.0) {
                d += phylogenyNode2.getDistanceToParent();
                if (bl) {
                    bl = false;
                }
            }
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        if (bl) {
            return -1024.0;
        }
        return d;
    }

    public static double calculateAverageTreeHeight(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        double d = 0.0;
        Iterator<PhylogenyNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            for (PhylogenyNode phylogenyNode2 = iterator.next(); phylogenyNode2 != phylogenyNode; phylogenyNode2 = phylogenyNode2.getParent()) {
                if (!(phylogenyNode2.getDistanceToParent() > 0.0)) continue;
                d += phylogenyNode2.getDistanceToParent();
            }
        }
        return d / (double)list.size();
    }

    static PhylogenyNode copySubTree(PhylogenyNode phylogenyNode) {
        if (phylogenyNode == null) {
            return null;
        }
        PhylogenyNode phylogenyNode2 = phylogenyNode.copyNodeData();
        if (!phylogenyNode.isExternal()) {
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                phylogenyNode2.setChildNode(i, PhylogenyMethods.copySubTree(phylogenyNode.getChildNode(i)));
            }
        }
        return phylogenyNode2;
    }

    static PhylogenyNode copySubTreeShallow(PhylogenyNode phylogenyNode) {
        if (phylogenyNode == null) {
            return null;
        }
        PhylogenyNode phylogenyNode2 = phylogenyNode.copyNodeDataShallow();
        if (!phylogenyNode.isExternal()) {
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                phylogenyNode2.setChildNode(i, PhylogenyMethods.copySubTreeShallow(phylogenyNode.getChildNode(i)));
            }
        }
        return phylogenyNode2;
    }

    private static final List<PhylogenyNode> divideIntoSubTreesHelper(PhylogenyNode phylogenyNode, double d) {
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        PhylogenyNode phylogenyNode2 = PhylogenyMethods.moveTowardsRoot(phylogenyNode, d);
        for (PhylogenyNode phylogenyNode3 : phylogenyNode2.getAllExternalDescendants()) {
            if (phylogenyNode3.getIndicator() != 0) {
                throw new RuntimeException("this should not have happened");
            }
            phylogenyNode3.setIndicator((byte)1);
            arrayList.add(phylogenyNode3);
        }
        return arrayList;
    }

    private static double getDistance(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
        double d = 0.0;
        while (phylogenyNode != phylogenyNode2) {
            if (phylogenyNode.getDistanceToParent() > 0.0) {
                d += phylogenyNode.getDistanceToParent();
            }
            phylogenyNode = phylogenyNode.getParent();
        }
        return d;
    }

    private static boolean match(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (ForesterUtil.isEmpty(string) || ForesterUtil.isEmpty(string2)) {
            return false;
        }
        String string3 = string.trim();
        String string4 = string2.trim();
        if (!bl && !bl3) {
            string3 = string3.toLowerCase();
            string4 = string4.toLowerCase();
        }
        if (bl3) {
            Pattern pattern = null;
            try {
                pattern = bl ? Pattern.compile(string4) : Pattern.compile(string4, 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                return false;
            }
            if (pattern != null) {
                return pattern.matcher(string3).find();
            }
            return false;
        }
        if (bl2) {
            return string3.indexOf(string4) >= 0;
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile("(\\b|_)" + Pattern.quote(string4) + "(\\b|_)");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        if (pattern != null) {
            return pattern.matcher(string3).find();
        }
        return false;
    }

    private static final PhylogenyNode moveTowardsRoot(PhylogenyNode phylogenyNode, double d) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        PhylogenyNode phylogenyNode3 = phylogenyNode;
        while (d < phylogenyNode2.calculateDistanceToRoot()) {
            phylogenyNode3 = phylogenyNode2;
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        return phylogenyNode3;
    }

    public static void addMolecularSeqsToTree(Phylogeny phylogeny, Msa msa) {
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            MolecularSequence molecularSequence = msa.getSequence(i);
            PhylogenyNode phylogenyNode = phylogeny.getNode(molecularSequence.getIdentifier());
            Sequence sequence = new Sequence();
            sequence.setMolecularSequenceAligned(true);
            sequence.setMolecularSequence(molecularSequence.getMolecularSequenceAsString());
            sequence.setName(molecularSequence.getIdentifier());
            try {
                sequence.setType("protein");
            }
            catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {
                // empty catch block
            }
            phylogenyNode.getNodeData().addSequence(sequence);
        }
    }

    public static final Map<Long, Integer> calculateDepths(Phylogeny phylogeny) {
        HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
        PhylogenyMethods.calculateDepthsHelper(phylogeny.getRoot(), 0, hashMap);
        return hashMap;
    }

    private static final void calculateDepthsHelper(PhylogenyNode phylogenyNode, int n, Map<Long, Integer> map) {
        map.put(phylogenyNode.getId(), n);
        ++n;
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        for (PhylogenyNode phylogenyNode2 : list) {
            PhylogenyMethods.calculateDepthsHelper(phylogenyNode2, n, map);
        }
    }

    public static final void collapseToDepth(Phylogeny phylogeny, int n) {
        if (phylogeny.getNumberOfExternalNodes() < 3) {
            return;
        }
        PhylogenyMethods.collapseToDepthHelper(phylogeny.getRoot(), 0, n);
    }

    private static final void collapseToDepthHelper(PhylogenyNode phylogenyNode, int n, int n2) {
        if (phylogenyNode.isExternal()) {
            phylogenyNode.setCollapse(false);
            return;
        }
        if (n >= n2) {
            phylogenyNode.setCollapse(true);
            PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(phylogenyNode);
            while (preorderTreeIterator.hasNext()) {
                preorderTreeIterator.next().setCollapse(true);
            }
        } else {
            phylogenyNode.setCollapse(false);
            ++n;
            List<PhylogenyNode> list = phylogenyNode.getDescendants();
            for (PhylogenyNode phylogenyNode2 : list) {
                PhylogenyMethods.collapseToDepthHelper(phylogenyNode2, n, n2);
            }
        }
    }

    public static final void collapseToRank(Phylogeny phylogeny, int n) {
        if (phylogeny.getNumberOfExternalNodes() < 3) {
            return;
        }
        if (n < 0 || n >= TaxonomyUtil.RANKS.length) {
            throw new IllegalArgumentException("Rank " + n + " is out of range");
        }
        PhylogenyMethods.collapseToRankHelper(phylogeny.getRoot(), n);
    }

    private static final void collapseToRankHelper(PhylogenyNode phylogenyNode, int n) {
        Object object;
        if (phylogenyNode.isExternal()) {
            phylogenyNode.setCollapse(false);
            return;
        }
        if (phylogenyNode.getNodeData().getTaxonomy() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getRank())) {
            object = phylogenyNode.getNodeData().getTaxonomy().getRank();
            if (!TaxonomyUtil.RANK_TO_INT.containsKey(object)) {
                System.out.println("Don't know rank \"" + (String)object + "\", ignoring.");
            } else if (TaxonomyUtil.RANK_TO_INT.get(object) >= n) {
                phylogenyNode.setCollapse(true);
                PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(phylogenyNode);
                while (preorderTreeIterator.hasNext()) {
                    preorderTreeIterator.next().setCollapse(true);
                }
                return;
            }
        }
        phylogenyNode.setCollapse(false);
        object = phylogenyNode.getDescendants();
        Iterator<PhylogenyNode> iterator = object.iterator();
        while (iterator.hasNext()) {
            PhylogenyNode phylogenyNode2 = iterator.next();
            PhylogenyMethods.collapseToRankHelper(phylogenyNode2, n);
        }
    }

    public static final PhylogenyNode getFirstExternalNode(PhylogenyNode phylogenyNode) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        while (phylogenyNode2.isInternal()) {
            phylogenyNode2 = phylogenyNode2.getFirstChildNode();
        }
        return phylogenyNode2;
    }

    public static final PhylogenyNode getLastExternalNode(PhylogenyNode phylogenyNode) {
        PhylogenyNode phylogenyNode2 = phylogenyNode;
        while (phylogenyNode2.isInternal()) {
            phylogenyNode2 = phylogenyNode2.getLastChildNode();
        }
        return phylogenyNode2;
    }

    public static final boolean isHasCollapsedNodes(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPreorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (phylogenyNode.isExternal() || !phylogenyNode.isCollapse()) continue;
            return true;
        }
        return false;
    }

    public static final boolean isAllExternalDescedantsFromSameSpecies(PhylogenyNode phylogenyNode) {
        Set<Taxonomy> set;
        return !phylogenyNode.isExternal() && phylogenyNode.getNumberOfDescendants() > 1 && (set = PhylogenyMethods.obtainDistinctTaxonomies(phylogenyNode)) != null && set.size() == 1;
    }

    public static final Set<Taxonomy> obtainDistinctTaxonomies(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        HashSet<Taxonomy> hashSet = new HashSet<Taxonomy>();
        for (PhylogenyNode phylogenyNode2 : list) {
            if (!phylogenyNode2.getNodeData().isHasTaxonomy() || phylogenyNode2.getNodeData().getTaxonomy().isEmpty()) {
                return null;
            }
            hashSet.add(phylogenyNode2.getNodeData().getTaxonomy());
        }
        return hashSet;
    }

    public static final void removeDuplicateExternalSpeciesNodes(Phylogeny phylogeny) {
        HashSet<Taxonomy> hashSet = new HashSet<Taxonomy>();
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        Iterator<PhylogenyNode> iterator = phylogeny.iteratorExternalForward();
        while (iterator.hasNext()) {
            PhylogenyNode phylogenyNode = iterator.next();
            if (!phylogenyNode.getNodeData().isHasTaxonomy() || phylogenyNode.getNodeData().getTaxonomy().isEmpty()) continue;
            if (hashSet.contains(phylogenyNode.getNodeData().getTaxonomy())) {
                arrayList.add(phylogenyNode);
                continue;
            }
            hashSet.add(phylogenyNode.getNodeData().getTaxonomy());
        }
        for (PhylogenyNode phylogenyNode : arrayList) {
            phylogeny.deleteSubtree(phylogenyNode, true);
        }
    }

    private static final class PhylogenyNodeSortNodeNamePriority
    implements Comparator<PhylogenyNode> {
        private PhylogenyNodeSortNodeNamePriority() {
        }

        @Override
        public int compare(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
            if (!ForesterUtil.isEmpty(phylogenyNode.getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getName())) {
                return phylogenyNode.getName().toLowerCase().compareTo(phylogenyNode2.getName().toLowerCase());
            }
            if (phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode2.getNodeData().isHasTaxonomy()) {
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName())) {
                    return phylogenyNode.getNodeData().getTaxonomy().getScientificName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getScientificName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                    return phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode());
                }
            }
            if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode2.getNodeData().isHasSequence()) {
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getName())) {
                    return phylogenyNode.getNodeData().getSequence().getName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getSequence().getName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getGeneName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getGeneName())) {
                    return phylogenyNode.getNodeData().getSequence().getGeneName().compareTo(phylogenyNode2.getNodeData().getSequence().getGeneName());
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getSymbol())) {
                    return phylogenyNode.getNodeData().getSequence().getSymbol().compareTo(phylogenyNode2.getNodeData().getSequence().getSymbol());
                }
            }
            return 0;
        }
    }

    private static final class PhylogenyNodeSortSequencePriority
    implements Comparator<PhylogenyNode> {
        private PhylogenyNodeSortSequencePriority() {
        }

        @Override
        public int compare(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
            if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode2.getNodeData().isHasSequence()) {
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getName())) {
                    return phylogenyNode.getNodeData().getSequence().getName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getSequence().getName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getGeneName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getGeneName())) {
                    return phylogenyNode.getNodeData().getSequence().getGeneName().compareTo(phylogenyNode2.getNodeData().getSequence().getGeneName());
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getSymbol())) {
                    return phylogenyNode.getNodeData().getSequence().getSymbol().compareTo(phylogenyNode2.getNodeData().getSequence().getSymbol());
                }
            }
            if (phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode2.getNodeData().isHasTaxonomy()) {
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName())) {
                    return phylogenyNode.getNodeData().getTaxonomy().getScientificName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getScientificName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                    return phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode());
                }
            }
            if (!ForesterUtil.isEmpty(phylogenyNode.getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getName())) {
                return phylogenyNode.getName().toLowerCase().compareTo(phylogenyNode2.getName().toLowerCase());
            }
            return 0;
        }
    }

    private static final class PhylogenyNodeSortTaxonomyPriority
    implements Comparator<PhylogenyNode> {
        private PhylogenyNodeSortTaxonomyPriority() {
        }

        @Override
        public int compare(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2) {
            if (phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode2.getNodeData().isHasTaxonomy()) {
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName())) {
                    return phylogenyNode.getNodeData().getTaxonomy().getScientificName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getScientificName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                    return phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode().compareTo(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode());
                }
            }
            if (phylogenyNode.getNodeData().isHasSequence() && phylogenyNode2.getNodeData().isHasSequence()) {
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getName())) {
                    return phylogenyNode.getNodeData().getSequence().getName().toLowerCase().compareTo(phylogenyNode2.getNodeData().getSequence().getName().toLowerCase());
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getGeneName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getGeneName())) {
                    return phylogenyNode.getNodeData().getSequence().getGeneName().compareTo(phylogenyNode2.getNodeData().getSequence().getGeneName());
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getSymbol()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getSymbol())) {
                    return phylogenyNode.getNodeData().getSequence().getSymbol().compareTo(phylogenyNode2.getNodeData().getSequence().getSymbol());
                }
            }
            if (!ForesterUtil.isEmpty(phylogenyNode.getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getName())) {
                return phylogenyNode.getName().toLowerCase().compareTo(phylogenyNode2.getName().toLowerCase());
            }
            return 0;
        }
    }

    public static enum PhylogenyNodeField {
        CLADE_NAME,
        SEQUENCE_NAME,
        SEQUENCE_SYMBOL,
        TAXONOMY_CODE,
        TAXONOMY_COMMON_NAME,
        TAXONOMY_ID,
        TAXONOMY_ID_UNIPROT_1,
        TAXONOMY_ID_UNIPROT_2,
        TAXONOMY_SCIENTIFIC_NAME;

    }

    public static enum DESCENDANT_SORT_PRIORITY {
        NODE_NAME,
        SEQUENCE,
        TAXONOMY;

    }

    private static enum NDF {
        NodeName("NN"),
        TaxonomyCode("TC"),
        TaxonomyCommonName("TN"),
        TaxonomyScientificName("TS"),
        TaxonomyIdentifier("TI"),
        TaxonomySynonym("SY"),
        SequenceName("SN"),
        GeneName("GN"),
        SequenceSymbol("SS"),
        SequenceAccession("SA"),
        Domain("DO"),
        Annotation("AN"),
        CrossRef("XR"),
        BinaryCharacter("BC"),
        MolecularSequence("MS");

        private final String _text;

        private NDF(String string2) {
            this._text = string2;
        }

        public static NDF fromString(String string) {
            for (NDF nDF : NDF.values()) {
                if (!string.startsWith(nDF._text)) continue;
                return nDF;
            }
            return null;
        }
    }
}

