/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa_compactor;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.archaeopteryx.Archaeopteryx;
import org.forester.archaeopteryx.Configuration;
import org.forester.evoinference.distance.NeighborJoiningF;
import org.forester.evoinference.distance.PairwiseDistanceCalculator;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;
import org.forester.evoinference.tools.BootstrapResampler;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.DeleteableMsa;
import org.forester.msa.Mafft;
import org.forester.msa.Msa;
import org.forester.msa.MsaInferrer;
import org.forester.msa.MsaMethods;
import org.forester.msa.ResampleableMsa;
import org.forester.msa_compactor.GapContribution;
import org.forester.msa_compactor.MsaProperties;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.sequence.MolecularSequence;
import org.forester.tools.ConfidenceAssessor;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;

public class MsaCompactor {
    private static final NumberFormat NF_1 = new DecimalFormat("0.#");
    private static final NumberFormat NF_3 = new DecimalFormat("0.###");
    private static final NumberFormat NF_4 = new DecimalFormat("0.####");
    private boolean _calculate_shannon_entropy = false;
    private String _infile_name = null;
    private final short _longest_id_length;
    private String _maffts_opts = "--auto";
    private DeleteableMsa _msa = null;
    private boolean _normalize_for_effective_seq_length = true;
    private File _out_file_base = null;
    private Msa.MSA_FORMAT _output_format = Msa.MSA_FORMAT.FASTA;
    private String _path_to_mafft = null;
    private boolean _phylogentic_inference = false;
    private boolean _realign = false;
    private final SortedSet<String> _removed_seq_ids;
    private final ArrayList<MolecularSequence> _removed_seqs;
    private File _removed_seqs_out_base = null;
    private int _step = -1;
    private int _step_for_diagnostics = -1;

    public MsaCompactor(DeleteableMsa deleteableMsa) {
        this._msa = deleteableMsa;
        this._removed_seq_ids = new TreeSet<String>();
        this._longest_id_length = this._msa.determineMaxIdLength();
        this._removed_seqs = new ArrayList();
    }

    public final Phylogeny calcTree() {
        Phylogeny phylogeny = this.inferNJphylogeny(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.KIMURA_DISTANCE, this._msa, false, "");
        PhylogenyMethods.midpointRoot(phylogeny);
        PhylogenyMethods.orderAppearance(phylogeny.getRoot(), true, true, PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME);
        boolean bl = PhylogenyMethods.extractFastaInformation(phylogeny);
        if (!bl) {
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
            while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
                String string = phylogenyNode.getName().trim();
                if (ForesterUtil.isEmpty(string)) continue;
                try {
                    ParserUtils.extractTaxonomyDataFromNodeName(phylogenyNode, NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
                }
                catch (PhyloXmlDataFormatException phyloXmlDataFormatException) {}
            }
        }
        return phylogeny;
    }

    /*
     * WARNING - void declaration
     */
    public final List<MsaProperties> chart(int n, boolean bl, boolean bl2) throws IOException, InterruptedException {
        GapContribution[] gapContributionArray = this.calcGapContribtionsStats(bl2);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<MsaProperties> arrayList2 = new ArrayList<MsaProperties>();
        GapContribution[] object = gapContributionArray;
        int n2 = object.length;
        for (int i = 0; i < n2; ++i) {
            GapContribution gapContribution = object[i];
            arrayList.add(gapContribution.getId());
        }
        Object var7_8 = null;
        if (this._phylogentic_inference) {
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            Phylogeny phylogeny = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phylogeny);
        }
        if (!this._realign) {
            this._step = -1;
        }
        if ((n2 = ForesterUtil.roundToInt((double)this._msa.getNumberOfSequences() / 10.0)) < 2) {
            n2 = 2;
        }
        MsaProperties msaProperties = new MsaProperties(this._msa, "", this._calculate_shannon_entropy);
        arrayList2.add(msaProperties);
        this.printTableHeader();
        this.printMsaProperties(msaProperties);
        System.out.println();
        int n3 = 0;
        while (this._msa.getNumberOfSequences() > n2) {
            String string = (String)arrayList.get(n3);
            this._msa.deleteRow(string, false);
            if (bl && this.isPrintMsaStatsWriteOutfileAndRealign(n3)) {
                this.removeGapColumns();
                this.realignWithMafft();
                msaProperties = new MsaProperties(this._msa, string, this._calculate_shannon_entropy);
                arrayList2.add(msaProperties);
                this.printMsaProperties(msaProperties);
                System.out.print("(realigned)");
                System.out.println();
            } else if (this.isPrintMsaStats(n3)) {
                this.removeGapColumns();
                msaProperties = new MsaProperties(this._msa, string, this._calculate_shannon_entropy);
                arrayList2.add(msaProperties);
                this.printMsaProperties(msaProperties);
                System.out.println();
            }
            ++n3;
        }
        if (this._phylogentic_inference) {
            void var7_10;
            MsaCompactor.decorateTree((Phylogeny)var7_10, arrayList2, true);
            this.displayTree((Phylogeny)var7_10);
        }
        return arrayList2;
    }

    private static final void addSeqs2Tree(Msa msa, Phylogeny phylogeny) {
        for (int i = 0; i < msa.getNumberOfSequences(); ++i) {
            MolecularSequence molecularSequence = msa.getSequence(i);
            String string = molecularSequence.getIdentifier();
            PhylogenyNode phylogenyNode = phylogeny.getNode(string);
            if (phylogenyNode.getNodeData().isHasSequence()) {
                throw new IllegalArgumentException("this should not have happened");
            }
            phylogenyNode.getNodeData().addSequence(new Sequence());
            phylogenyNode.getNodeData().getSequence().setMolecularSequence(molecularSequence.getMolecularSequenceAsString());
            phylogenyNode.getNodeData().getSequence().setMolecularSequenceAligned(true);
            phylogenyNode.getNodeData().getSequence().setName(string);
        }
    }

    private static final void decorateTree(Phylogeny phylogeny, List<MsaProperties> list, boolean bl) {
        BasicDescriptiveStatistics basicDescriptiveStatistics = new BasicDescriptiveStatistics();
        for (int i = 0; i < list.size(); ++i) {
            MsaProperties msaProperties = list.get(i);
            String string = msaProperties.getRemovedSeq();
            if (ForesterUtil.isEmpty(string)) continue;
            basicDescriptiveStatistics.addValue(msaProperties.getLength());
        }
        double d = basicDescriptiveStatistics.arithmeticMean();
        double d2 = basicDescriptiveStatistics.getMin();
        double d3 = basicDescriptiveStatistics.getMax();
        Color color = new Color(0, 255, 0);
        Color color2 = new Color(255, 0, 0);
        Color color3 = new Color(255, 255, 0);
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        if (bl) {
            while (phylogenyNodeIterator.hasNext()) {
                NodeVisualData nodeVisualData = new NodeVisualData();
                nodeVisualData.setFillType(NodeVisualData.NodeFill.SOLID);
                nodeVisualData.setShape(NodeVisualData.NodeShape.RECTANGLE);
                nodeVisualData.setNodeColor(color);
                phylogenyNodeIterator.next().getNodeData().setNodeVisualData(nodeVisualData);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            MsaProperties msaProperties = list.get(i);
            String string = msaProperties.getRemovedSeq();
            if (ForesterUtil.isEmpty(string)) continue;
            PhylogenyNode phylogenyNode = phylogeny.getNode(string);
            phylogenyNode.setName(phylogenyNode.getName() + " [" + i + "]");
            if (!bl) {
                NodeVisualData nodeVisualData = new NodeVisualData();
                nodeVisualData.setFillType(NodeVisualData.NodeFill.SOLID);
                nodeVisualData.setShape(NodeVisualData.NodeShape.RECTANGLE);
                nodeVisualData.setNodeColor(ForesterUtil.calcColor(msaProperties.getLength(), d2, d3, color3, color2));
                phylogenyNode.getNodeData().setNodeVisualData(nodeVisualData);
                continue;
            }
            phylogenyNode.getNodeData().getNodeVisualData().setNodeColor(ForesterUtil.calcColor(msaProperties.getLength(), d2, d3, d, color, color2, color3));
        }
    }

    public final void deleteGapColumns(double d) {
        this._msa.deleteGapColumns(d);
    }

    public final void displayTree(Phylogeny phylogeny) {
        Configuration configuration = new Configuration();
        configuration.setDisplayAsPhylogram(true);
        configuration.setUseStyle(true);
        configuration.setDisplayTaxonomyCode(false);
        configuration.setDisplayTaxonomyCommonNames(false);
        configuration.setDisplayTaxonomyScientificNames(false);
        configuration.setDisplaySequenceNames(false);
        configuration.setDisplaySequenceSymbols(false);
        configuration.setDisplayGeneNames(false);
        configuration.setDisplayMultipleSequenceAlignment(true);
        configuration.setShowScale(true);
        configuration.setAddTaxonomyImagesCB(false);
        configuration.setBaseFontSize(9);
        configuration.setBaseFontFamilyName("Arial");
        Archaeopteryx.createApplication(phylogeny, configuration, this._infile_name);
    }

    public final Msa getMsa() {
        return this._msa;
    }

    public final void removeSequencesByMinimalLength(int n) throws IOException {
        this._msa = DeleteableMsa.createInstance(MsaMethods.removeSequencesByMinimalLength(this._msa, n));
        this.removeGapColumns();
        String string = this.writeOutfile();
        DescriptiveStatistics descriptiveStatistics = MsaMethods.calculateEffectiveLengthStatistics(this._msa);
        System.out.println("Output MSA                           : " + string);
        System.out.println("  MSA length                         : " + this._msa.getLength());
        System.out.println("  Number of sequences                : " + this._msa.getNumberOfSequences());
        System.out.println("  Median sequence length             : " + NF_1.format(descriptiveStatistics.median()));
        System.out.println("  Mean sequence length               : " + NF_1.format(descriptiveStatistics.arithmeticMean()));
        System.out.println("  Max sequence length                : " + (int)descriptiveStatistics.getMax());
        System.out.println("  Min sequence length                : " + (int)descriptiveStatistics.getMin());
        System.out.println("  Gap ratio                          : " + NF_4.format(MsaMethods.calcGapRatio(this._msa)));
        System.out.println("  Normalized Shannon Entropy (entn21): " + NF_4.format(MsaMethods.calcNormalizedShannonsEntropy(21, this._msa)));
        System.out.println();
    }

    /*
     * WARNING - void declaration
     */
    public final List<MsaProperties> removeViaGapAverage(double d) throws IOException, InterruptedException {
        GapContribution[] gapContributionArray = this.calcGapContribtionsStats(this._normalize_for_effective_seq_length);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<MsaProperties> arrayList2 = new ArrayList<MsaProperties>();
        for (GapContribution gapContribution : gapContributionArray) {
            arrayList.add(gapContribution.getId());
        }
        Object var6_6 = null;
        if (this._phylogentic_inference) {
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            Phylogeny phylogeny = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phylogeny);
        }
        this.printTableHeader();
        MsaProperties msaProperties = new MsaProperties(this._msa, "", this._calculate_shannon_entropy);
        arrayList2.add(msaProperties);
        this.printMsaProperties(msaProperties);
        System.out.println();
        int n = 0;
        while (MsaMethods.calcGapRatio(this._msa) > d) {
            String string = (String)arrayList.get(n);
            this._removed_seq_ids.add(string);
            MolecularSequence molecularSequence = this._msa.deleteRow(string, true);
            this._removed_seqs.add(molecularSequence);
            this.removeGapColumns();
            if (this.isPrintMsaStatsWriteOutfileAndRealign(n) || MsaMethods.calcGapRatio(this._msa) <= d) {
                msaProperties = this.printMsaStatsWriteOutfileAndRealign(this._realign, string);
                arrayList2.add(msaProperties);
                System.out.println();
            } else if (this.isPrintMsaStats(n)) {
                msaProperties = new MsaProperties(this._msa, string, this._calculate_shannon_entropy);
                arrayList2.add(msaProperties);
                this.printMsaProperties(msaProperties);
                System.out.println();
            }
            ++n;
        }
        if (this._removed_seqs_out_base != null) {
            String string = this.writeAndAlignRemovedSeqs();
            System.out.println();
            System.out.println(string);
        }
        if (this._phylogentic_inference) {
            void var6_8;
            MsaCompactor.decorateTree((Phylogeny)var6_8, arrayList2, false);
            this.displayTree((Phylogeny)var6_8);
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            Phylogeny phylogeny = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phylogeny);
            this.displayTree(phylogeny);
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public List<MsaProperties> removeViaLength(int n) throws IOException, InterruptedException {
        GapContribution[] gapContributionArray = this.calcGapContribtionsStats(this._normalize_for_effective_seq_length);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<MsaProperties> arrayList2 = new ArrayList<MsaProperties>();
        for (GapContribution gapContribution : gapContributionArray) {
            arrayList.add(gapContribution.getId());
        }
        Object var5_6 = null;
        if (this._phylogentic_inference) {
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            Phylogeny phylogeny = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phylogeny);
        }
        this.printTableHeader();
        MsaProperties msaProperties = new MsaProperties(this._msa, "", this._calculate_shannon_entropy);
        arrayList2.add(msaProperties);
        this.printMsaProperties(msaProperties);
        System.out.println();
        int n2 = 0;
        while (this._msa.getLength() > n) {
            String string = (String)arrayList.get(n2);
            this._removed_seq_ids.add(string);
            MolecularSequence molecularSequence = this._msa.deleteRow(string, true);
            this._removed_seqs.add(molecularSequence);
            this.removeGapColumns();
            if (this.isPrintMsaStatsWriteOutfileAndRealign(n2) || this._msa.getLength() <= n) {
                msaProperties = this.printMsaStatsWriteOutfileAndRealign(this._realign, string);
                arrayList2.add(msaProperties);
                System.out.println();
            } else if (this.isPrintMsaStats(n2)) {
                msaProperties = new MsaProperties(this._msa, string, this._calculate_shannon_entropy);
                this.printMsaProperties(msaProperties);
                arrayList2.add(msaProperties);
                System.out.println();
            }
            ++n2;
        }
        if (this._removed_seqs_out_base != null) {
            String string = this.writeAndAlignRemovedSeqs();
            System.out.println();
            System.out.println(string);
        }
        if (this._phylogentic_inference) {
            void var5_8;
            MsaCompactor.decorateTree((Phylogeny)var5_8, arrayList2, false);
            this.displayTree((Phylogeny)var5_8);
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            Phylogeny phylogeny = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phylogeny);
            this.displayTree(phylogeny);
        }
        return arrayList2;
    }

    public final List<MsaProperties> removeWorstOffenders(int n) throws IOException, InterruptedException {
        GapContribution[] gapContributionArray = this.calcGapContribtionsStats(this._normalize_for_effective_seq_length);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<MsaProperties> arrayList2 = new ArrayList<MsaProperties>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(gapContributionArray[i].getId());
        }
        Phylogeny phylogeny = null;
        if (this._phylogentic_inference) {
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            phylogeny = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phylogeny);
        }
        this.printTableHeader();
        MsaProperties msaProperties = new MsaProperties(this._msa, "", this._calculate_shannon_entropy);
        arrayList2.add(msaProperties);
        this.printMsaProperties(msaProperties);
        System.out.println();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            this._removed_seq_ids.add(string);
            MolecularSequence molecularSequence = this._msa.deleteRow(string, true);
            this._removed_seqs.add(molecularSequence);
            this.removeGapColumns();
            if (this.isPrintMsaStatsWriteOutfileAndRealign(i) || i == arrayList.size() - 1) {
                msaProperties = this.printMsaStatsWriteOutfileAndRealign(this._realign, string);
                arrayList2.add(msaProperties);
                System.out.println();
                continue;
            }
            if (!this.isPrintMsaStats(i)) continue;
            msaProperties = new MsaProperties(this._msa, string, this._calculate_shannon_entropy);
            arrayList2.add(msaProperties);
            this.printMsaProperties(msaProperties);
            System.out.println();
        }
        if (this._removed_seqs_out_base != null) {
            String string = this.writeAndAlignRemovedSeqs();
            System.out.println();
            System.out.println(string);
        }
        if (this._phylogentic_inference) {
            MsaCompactor.decorateTree(phylogeny, arrayList2, false);
            this.displayTree(phylogeny);
            System.out.println("calculating phylogentic tree...");
            System.out.println();
            Phylogeny phylogeny2 = this.calcTree();
            MsaCompactor.addSeqs2Tree(this._msa, phylogeny2);
            this.displayTree(phylogeny2);
        }
        return arrayList2;
    }

    public final void setCalculateNormalizedShannonEntropy(boolean bl) {
        this._calculate_shannon_entropy = bl;
    }

    public void setInfileName(String string) {
        this._infile_name = string;
    }

    public final void setMafftOptions(String string) {
        this._maffts_opts = string;
    }

    public final void setNorm(boolean bl) {
        this._normalize_for_effective_seq_length = bl;
    }

    public final void setOutFileBase(File file) {
        this._out_file_base = file;
    }

    public final void setOutputFormat(Msa.MSA_FORMAT mSA_FORMAT) {
        this._output_format = mSA_FORMAT;
    }

    public void setPathToMafft(String string) {
        this._path_to_mafft = string;
    }

    public void setPeformPhylogenticInference(boolean bl) {
        this._phylogentic_inference = bl;
    }

    public final void setRealign(boolean bl) {
        this._realign = bl;
    }

    public final void setRemovedSeqsOutBase(File file) {
        this._removed_seqs_out_base = file;
    }

    public final void setStep(int n) {
        this._step = n;
    }

    public final void setStepForDiagnostics(int n) {
        this._step_for_diagnostics = n;
    }

    public final String writeAndAlignRemovedSeqs() throws IOException, InterruptedException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this._removed_seqs_out_base + "_" + this._removed_seqs.size() + ".fasta";
        SequenceWriter.writeSeqs(this._removed_seqs, new File(string), SequenceWriter.SEQ_FORMAT.FASTA, 100);
        stringBuilder.append("wrote " + this._removed_seqs.size() + " removed sequences to \"" + string + "\"");
        if (this._realign) {
            String string22;
            MsaInferrer msaInferrer = Mafft.createInstance(this._path_to_mafft);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string22 : this._maffts_opts.split("\\s")) {
                arrayList.add(string22);
            }
            Msa msa = msaInferrer.infer(this._removed_seqs, arrayList);
            Double d = MsaMethods.calcGapRatio(msa);
            String string3 = this._removed_seqs_out_base + "_" + msa.getNumberOfSequences() + "_" + msa.getLength() + "_" + ForesterUtil.roundToInt(d * 100.0);
            string22 = this.obtainSuffix();
            string3 = string3 + string22;
            MsaCompactor.writeMsa(msa, string3, this._output_format);
            stringBuilder.append(", and as MSA of length " + msa.getLength() + " to \"" + string3 + "\"");
        }
        return stringBuilder.toString();
    }

    public final String writeMsa(File file) throws IOException {
        Double d = MsaMethods.calcGapRatio(this._msa);
        String string = file + "_" + this._msa.getNumberOfSequences() + "_" + this._msa.getLength() + "_" + ForesterUtil.roundToInt(d * 100.0);
        MsaCompactor.writeMsa(this._msa, string + this.obtainSuffix(), this._output_format);
        return string;
    }

    final int calcNonGapResidues(MolecularSequence molecularSequence) {
        int n = 0;
        for (int i = 0; i < molecularSequence.getLength(); ++i) {
            if (molecularSequence.isGapAt(i)) continue;
            ++n;
        }
        return n;
    }

    private final GapContribution[] calcGapContribtions(boolean bl) {
        double[] dArray = this.calcGappiness();
        GapContribution[] gapContributionArray = new GapContribution[this._msa.getNumberOfSequences()];
        for (int i = 0; i < this._msa.getNumberOfSequences(); ++i) {
            gapContributionArray[i] = new GapContribution(this._msa.getIdentifier(i));
            for (int j = 0; j < this._msa.getLength(); ++j) {
                if (this._msa.isGapAt(i, j)) continue;
                gapContributionArray[i].addToValue(dArray[j]);
            }
            if (bl) {
                gapContributionArray[i].divideValue(this.calcNonGapResidues(this._msa.getSequence(i)));
                continue;
            }
            gapContributionArray[i].divideValue(this._msa.getLength());
        }
        return gapContributionArray;
    }

    private final GapContribution[] calcGapContribtionsStats(boolean bl) {
        Object[] objectArray = this.calcGapContribtions(bl);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private final double[] calcGappiness() {
        int n = this._msa.getLength();
        double[] dArray = new double[n];
        int n2 = this._msa.getNumberOfSequences();
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)MsaMethods.calcGapSumPerColumn(this._msa, i) / (double)n2;
        }
        return dArray;
    }

    private final Phylogeny collapse(Msa msa, int n) {
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcFractionalDissimilarities(msa);
        return null;
    }

    private final Phylogeny inferNJphylogeny(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD pWD_DISTANCE_METHOD, Msa msa, boolean bl, String string) {
        BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix = null;
        switch (pWD_DISTANCE_METHOD) {
            case KIMURA_DISTANCE: {
                basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcKimuraDistances(msa);
                break;
            }
            case POISSON_DISTANCE: {
                basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcPoissonDistances(msa);
                break;
            }
            case FRACTIONAL_DISSIMILARITY: {
                basicSymmetricalDistanceMatrix = PairwiseDistanceCalculator.calcFractionalDissimilarities(msa);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid pwd method");
            }
        }
        if (bl) {
            try {
                basicSymmetricalDistanceMatrix.write(ForesterUtil.createBufferedWriter(string));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        NeighborJoiningF neighborJoiningF = NeighborJoiningF.createInstance(false, 5);
        Phylogeny phylogeny = neighborJoiningF.execute(basicSymmetricalDistanceMatrix);
        return phylogeny;
    }

    private final boolean isPrintMsaStats(int n) {
        return this._step == 1 && this._step_for_diagnostics == 1 || this._step_for_diagnostics > 0 && (n + 1) % this._step_for_diagnostics == 0;
    }

    private final boolean isPrintMsaStatsWriteOutfileAndRealign(int n) {
        return this._step == 1 && this._step_for_diagnostics == 1 || this._step > 0 && (n + 1) % this._step == 0;
    }

    private final StringBuilder msaPropertiesAsSB(MsaProperties msaProperties) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(msaProperties.getNumberOfSequences());
        stringBuilder.append("\t");
        stringBuilder.append(msaProperties.getLength());
        stringBuilder.append("\t");
        stringBuilder.append(NF_4.format(msaProperties.getGapRatio()));
        stringBuilder.append("\t");
        stringBuilder.append(NF_1.format(msaProperties.getAvgNumberOfGaps()));
        if (this._calculate_shannon_entropy) {
            stringBuilder.append("\t");
            stringBuilder.append(NF_4.format(msaProperties.getEntropy7()));
            stringBuilder.append("\t");
            stringBuilder.append(NF_4.format(msaProperties.getEntropy21()));
        }
        return stringBuilder;
    }

    private String obtainSuffix() {
        if (this._output_format == Msa.MSA_FORMAT.FASTA) {
            return ".fasta";
        }
        if (this._output_format == Msa.MSA_FORMAT.PHYLIP) {
            return ".aln";
        }
        return "";
    }

    private final Phylogeny pi(String string, int n) {
        Phylogeny phylogeny = this.inferNJphylogeny(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.KIMURA_DISTANCE, this._msa, true, string);
        ResampleableMsa resampleableMsa = new ResampleableMsa(this._msa);
        int[][] nArray = BootstrapResampler.createResampledColumnPositions(this._msa.getLength(), 100, 15L);
        Phylogeny[] phylogenyArray = new Phylogeny[100];
        for (int i = 0; i < 100; ++i) {
            resampleableMsa.resample(nArray[i]);
            phylogenyArray[i] = this.inferNJphylogeny(PairwiseDistanceCalculator.PWD_DISTANCE_METHOD.KIMURA_DISTANCE, resampleableMsa, false, null);
        }
        ConfidenceAssessor.evaluate("bootstrap", phylogenyArray, phylogeny, true, 1.0);
        PhylogenyMethods.extractFastaInformation(phylogeny);
        return phylogeny;
    }

    private final void printMsaProperties(MsaProperties msaProperties) {
        if (this._step == 1 || this._step_for_diagnostics == 1) {
            System.out.print(ForesterUtil.pad(msaProperties.getRemovedSeq(), (int)this._longest_id_length, ' ', false));
            System.out.print("\t");
        }
        System.out.print(this.msaPropertiesAsSB(msaProperties));
        System.out.print("\t");
    }

    private final MsaProperties printMsaStatsWriteOutfileAndRealign(boolean bl, String string) throws IOException, InterruptedException {
        if (bl) {
            this.realignWithMafft();
        }
        MsaProperties msaProperties = new MsaProperties(this._msa, string, this._calculate_shannon_entropy);
        this.printMsaProperties(msaProperties);
        String string2 = this.writeOutfile();
        System.out.print("-> " + string2 + (bl ? "\t(realigned)" : ""));
        return msaProperties;
    }

    private final void printTableHeader() {
        if (this._step == 1 || this._step_for_diagnostics == 1) {
            System.out.print(ForesterUtil.pad("Id", (int)this._longest_id_length, ' ', false));
            System.out.print("\t");
        }
        System.out.print("Seqs");
        System.out.print("\t");
        System.out.print("Length");
        System.out.print("\t");
        System.out.print("Gap R");
        System.out.print("\t");
        System.out.print("Gaps");
        System.out.print("\t");
        if (this._calculate_shannon_entropy) {
            System.out.print("entn7");
            System.out.print("\t");
            System.out.print("entn21");
            System.out.print("\t");
        }
        System.out.println();
    }

    private final void realignWithMafft() throws IOException, InterruptedException {
        MsaInferrer msaInferrer = Mafft.createInstance(this._path_to_mafft);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this._maffts_opts.split("\\s")) {
            arrayList.add(string);
        }
        this._msa = DeleteableMsa.createInstance(msaInferrer.infer(this._msa.asSequenceList(), arrayList));
    }

    private final void removeGapColumns() {
        this._msa.deleteGapOnlyColumns();
    }

    private final String writeOutfile() throws IOException {
        String string = this.writeMsa(this._out_file_base);
        return string;
    }

    public static final String guessPathToMafft() {
        String string;
        if (ForesterUtil.OS_NAME.toLowerCase().indexOf("win") >= 0 && MsaInferrer.isInstalled(string = "C:\\Program Files\\mafft-win\\mafft.bat")) {
            return string;
        }
        string = "/home/czmasek/SOFTWARE/MSA/MAFFT/mafft-7.130-without-extensions/scripts/mafft";
        if (MsaInferrer.isInstalled(string)) {
            return string;
        }
        string = "/usr/local/bin/mafft";
        if (MsaInferrer.isInstalled(string)) {
            return string;
        }
        string = "/usr/bin/mafft";
        if (MsaInferrer.isInstalled(string)) {
            return string;
        }
        string = "/bin/mafft";
        if (MsaInferrer.isInstalled(string)) {
            return string;
        }
        string = "mafft";
        if (MsaInferrer.isInstalled(string)) {
            return string;
        }
        return null;
    }

    private static final void writeMsa(Msa msa, String string, Msa.MSA_FORMAT mSA_FORMAT) throws IOException {
        BufferedWriter bufferedWriter = ForesterUtil.createBufferedWriter(string);
        msa.write(bufferedWriter, mSA_FORMAT);
        ((Writer)bufferedWriter).close();
    }

    static {
        NF_1.setRoundingMode(RoundingMode.HALF_UP);
        NF_4.setRoundingMode(RoundingMode.HALF_UP);
        NF_3.setRoundingMode(RoundingMode.HALF_UP);
    }
}

