/*
 * Decompiled with CFR 0.152.
 */
package org.forester.evoinference.distance;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.evoinference.matrix.distance.BasicSymmetricalDistanceMatrix;

public final class Sarray {
    public static final int FACTOR = 1000000;
    private static final boolean DEBUG = true;
    private final List<SortedMap<Integer, int[]>> _data = new ArrayList<SortedMap<Integer, int[]>>();

    public final void addPairing(double d, int n, int n2) {
        Sarray.addPairing((int)(1000000.0 * d), n, this.getS(n2));
    }

    public final void addPairing(int n, int n2, int n3) {
        Sarray.addPairing(n, n2, this.getS(n3));
    }

    public final SortedMap<Integer, int[]> getS(int n) {
        return this._data.get(n);
    }

    public final int[] getValues(int n, int n2) {
        return (int[])this.getS(n2).get(n);
    }

    public final void initialize(BasicSymmetricalDistanceMatrix basicSymmetricalDistanceMatrix) {
        for (int i = 0; i < basicSymmetricalDistanceMatrix.getSize(); ++i) {
            TreeMap<Integer, int[]> treeMap = new TreeMap<Integer, int[]>();
            this._data.add(treeMap);
            for (int j = 0; j < i; ++j) {
                Sarray.addPairing((int)(1000000.0 * basicSymmetricalDistanceMatrix.getValues()[j][i]), j, treeMap);
            }
        }
    }

    public final void initialize(int n) {
        for (int i = 0; i < n; ++i) {
            TreeMap treeMap = new TreeMap();
            this._data.add(treeMap);
        }
    }

    public final void removePairing(double d, int n, int n2) {
        this.removePairing((int)(d * 1000000.0), n, n2);
    }

    public final void removePairing(int n, int n2, int n3) {
        SortedMap<Integer, int[]> sortedMap = this._data.get(n3);
        int[] nArray = (int[])sortedMap.get(n);
        if (nArray == null) {
            System.out.println();
            System.out.println("________________________________________________________________________________________");
            System.out.println(this.toString());
            throw new IllegalArgumentException("key " + n + " (->" + n2 + ") does not exist for row " + n3);
        }
        if (nArray.length == 1) {
            sortedMap.remove(n);
        } else {
            int[] nArray2 = new int[nArray.length - 1];
            int n4 = 0;
            int n5 = 0;
            while (++n5 < nArray.length) {
                int n6 = nArray[n5];
                if (n6 != n2) {
                    nArray2[n4++] = n6;
                }
                ++n5;
            }
            sortedMap.put(n, nArray2);
        }
    }

    public final int size() {
        return this._data.size();
    }

    public final Set<Integer>[] toArray(int n) {
        return this._data.get(n).values().toArray(new Set[this._data.get(n).size()]);
    }

    public final String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("0.000000");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            stringBuilder.append(i);
            stringBuilder.append(": ");
            for (Map.Entry<Integer, int[]> entry : this.getSentrySet(i)) {
                double d = entry.getKey().intValue();
                int[] nArray = entry.getValue();
                stringBuilder.append(decimalFormat.format(d / 1000000.0) + "->");
                boolean bl = true;
                for (int n : nArray) {
                    if (!bl) {
                        stringBuilder.append(",");
                    }
                    bl = false;
                    stringBuilder.append(n);
                }
                stringBuilder.append("  ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    final Set<Map.Entry<Integer, int[]>> getSentrySet(int n) {
        return this.getS(n).entrySet();
    }

    private static final void addPairing(int n, int n2, SortedMap<Integer, int[]> sortedMap) {
        if (!sortedMap.containsKey(n)) {
            int[] nArray = new int[]{n2};
            sortedMap.put(n, nArray);
        } else {
            int[] nArray = new int[((int[])sortedMap.get(n)).length + 1];
            for (int i = 0; i < nArray.length - 1; ++i) {
                nArray[i] = ((int[])sortedMap.get(n))[i];
            }
            nArray[nArray.length - 1] = n2;
            sortedMap.put(n, nArray);
        }
    }
}

