/*
 * Decompiled with CFR 0.152.
 */
package org.forester.clade_analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.forester.clade_analysis.ResultSingle;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Confidence;
import org.forester.util.ForesterUtil;

public final class AnalysisSingle {
    public static ResultSingle execute(Phylogeny phylogeny, String string, String string2) {
        String string3;
        PhylogenyNode phylogenyNode = phylogeny.getNode(string);
        if (phylogenyNode.isRoot()) {
            throw new IllegalStateException("Unexpected error: Query " + string + " is root. This should have never happened");
        }
        if (phylogenyNode.getParent().isRoot()) {
            throw new IllegalStateException("Unexpected error: Parent of query " + string + " is root. This should have never happened");
        }
        PhylogenyNode phylogenyNode2 = phylogenyNode.getParent();
        PhylogenyNode phylogenyNode3 = phylogenyNode.getParent().getParent();
        while (phylogenyNode2.getNumberOfDescendants() == 1) {
            phylogenyNode2 = phylogenyNode2.getParent();
        }
        while (phylogenyNode3.getNumberOfDescendants() == 1) {
            phylogenyNode3 = phylogenyNode3.getParent();
        }
        List<PhylogenyNode> list = phylogenyNode3.getAllExternalDescendants();
        int n = list.size() - 1;
        int n2 = phylogeny.getNumberOfExternalNodes() - 1;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PhylogenyNode object2 : list) {
            string3 = object2.getName();
            if (ForesterUtil.isEmptyTrimmed(string3)) {
                throw new IllegalArgumentException("external node(s) with empty names found");
            }
            if ((string3 = string3.trim()).equals(string)) continue;
            arrayList.add(string3);
        }
        String string4 = ForesterUtil.greatestCommonPrefix(arrayList, string2);
        ResultSingle resultSingle = new ResultSingle();
        if (string4.length() < 1) {
            resultSingle.addWarning("No greatest common prefix");
            resultSingle.setGreatestCommonPrefix("");
        } else {
            resultSingle.setGreatestCommonPrefix(string4);
        }
        if (phylogenyNode3.isRoot()) {
            resultSingle.addWarning("Least Encompassing Clade is entire tree");
        }
        resultSingle.setLeastEncompassingCladeSize(n);
        resultSingle.setTreeSize(n2);
        string3 = AnalysisSingle.obtainConfidence(phylogenyNode3);
        if (string3 != null) {
            resultSingle.setGreatestCommonCladeSubtreeConfidence(string3);
        }
        String[] stringArray = AnalysisSingle.analyzeSiblings(phylogenyNode2, phylogenyNode3, string2);
        resultSingle.setGreatestCommonPrefixUp(stringArray[0]);
        if (stringArray[1] != null) {
            resultSingle.setGreatestCommonCladeUpSubtreeConfidence(stringArray[1]);
        }
        String[] stringArray2 = AnalysisSingle.analyzeSiblings(phylogenyNode, phylogenyNode2, string2);
        resultSingle.setGreatestCommonPrefixDown(stringArray2[0]);
        if (stringArray2[1] != null) {
            resultSingle.setGreatestCommonCladeDownSubtreeConfidence(stringArray2[1]);
        }
        return resultSingle;
    }

    private static final String[] analyzeSiblings(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2, String string) {
        int n = phylogenyNode.getChildNodeIndex();
        ArrayList<String> arrayList = new ArrayList<String>();
        List<PhylogenyNode> list = phylogenyNode2.getDescendants();
        String string2 = null;
        for (int i = 0; i < list.size(); ++i) {
            if (i == n) continue;
            PhylogenyNode phylogenyNode3 = list.get(i);
            for (PhylogenyNode phylogenyNode4 : phylogenyNode3.getAllExternalDescendants()) {
                String string3 = phylogenyNode4.getName();
                if (ForesterUtil.isEmptyTrimmed(string3)) {
                    throw new IllegalArgumentException("external node(s) with empty names found");
                }
                arrayList.add(string3.trim());
            }
            if (list.size() != 2) continue;
            string2 = AnalysisSingle.obtainConfidence(phylogenyNode3);
        }
        String string4 = ForesterUtil.greatestCommonPrefix(arrayList, string);
        return new String[]{string4, string2};
    }

    private static final String obtainConfidence(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.getBranchData().getConfidences() != null && phylogenyNode.getBranchData().getConfidences().size() > 0) {
            List<Confidence> list = phylogenyNode.getBranchData().getConfidences();
            boolean bl = false;
            Collections.sort(list);
            StringBuilder stringBuilder = new StringBuilder();
            for (Confidence confidence : list) {
                double d = confidence.getValue();
                if (d == -2.147483647E9) continue;
                if (bl) {
                    stringBuilder.append(" / ");
                } else {
                    bl = true;
                }
                stringBuilder.append((ForesterUtil.isEmpty(confidence.getType()) ? "confidence: " : confidence.getType() + ": ") + d);
            }
            return stringBuilder.toString();
        }
        return null;
    }
}

