/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.forester.io.writers.SequenceWriter;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.BasicTable;
import org.forester.util.BasicTableParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class table2fasta {
    private static final String PRG_NAME = "table2fasta";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "150327";

    public static void main(String[] stringArray) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        if (stringArray.length != 3) {
            table2fasta.argumentsError();
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        int n = Integer.parseInt(commandLineArguments.getName(0));
        File file = commandLineArguments.getFile(1);
        File file2 = commandLineArguments.getFile(2);
        if (file2.exists()) {
            ForesterUtil.fatalError(PRG_NAME, file2 + " already exists");
        }
        if (!file.exists()) {
            ForesterUtil.fatalError(PRG_NAME, file + " does not exist");
        }
        BasicTable<String> basicTable = null;
        try {
            basicTable = BasicTableParser.parse(file, '\t');
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
        ArrayList<MolecularSequence> arrayList = new ArrayList<MolecularSequence>();
        System.out.println("Number of rows: " + basicTable.getNumberOfRows());
        for (int i = 0; i < basicTable.getNumberOfRows(); ++i) {
            String string;
            String string2 = null;
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < basicTable.getNumberOfColumns(); ++j) {
                if (j == n) {
                    string2 = basicTable.getValue(j, i);
                    continue;
                }
                if (j != 0 && j != 1) continue;
                stringBuilder.append(basicTable.getValue(j, i));
                stringBuilder.append(" ");
            }
            if (stringBuilder.length() < 2) {
                ForesterUtil.fatalError(PRG_NAME, "row " + i + " id is empty");
            }
            if ((string = stringBuilder.toString().trim()).startsWith(">")) {
                string = string.substring(1);
            }
            if (ForesterUtil.isEmpty(string2) && ForesterUtil.isEmpty(string2 = basicTable.getValue(n - 1, i))) {
                ForesterUtil.fatalError(PRG_NAME, "row " + i + " seq is empty");
            }
            MolecularSequence molecularSequence = null;
            try {
                molecularSequence = BasicSequence.createAaSequence(string, string2);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
            }
            if (molecularSequence == null) continue;
            arrayList.add(molecularSequence);
        }
        try {
            SequenceWriter.writeSeqs(arrayList, file2, SequenceWriter.SEQ_FORMAT.FASTA, 60);
        }
        catch (IOException iOException) {
            ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
        }
    }

    private static void argumentsError() {
        System.out.println("table2fasta <position> <infile> <outfile>");
        System.out.println();
        System.exit(-1);
    }
}

