/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.test;

import com.approximatrix.charting.ChartEncoder;
import com.approximatrix.charting.DefaultChart;
import com.approximatrix.charting.event.ChartDataModelEvent;
import com.approximatrix.charting.event.ChartDataModelListener;
import com.approximatrix.charting.model.ScatterDataModel;
import com.approximatrix.charting.render.ScatterChartRenderer;
import com.approximatrix.charting.swing.ExtendedChartPanel;
import com.approximatrix.charting.test.ImageFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class GraphFrame
extends JFrame
implements ActionListener,
ChartDataModelListener {
    ExtendedChartPanel panel;
    ScatterDataModel data;
    Timer t = new Timer(1000, this);
    double time = 3.0;
    private JPopupMenu jPopupMenu1;
    private JMenuItem jMenuItem1;

    public GraphFrame() {
        double[][] model = new double[][]{{25.0, 22.0, 23.0}, {13.0, 11.0, 12.0}};
        double[] columns = new double[]{0.0, 1.0, 2.0};
        String[] columnString = new String[]{"1998", "1999", "2000"};
        String[] rows = new String[]{"Int. Temp.", "Ext. Temp."};
        String title = "Viewing Internal & External Temperature";
        this.data = new ScatterDataModel(model, columns, rows);
        this.panel = new ExtendedChartPanel(this.data, title, DefaultChart.LINEAR_X_LINEAR_Y);
        this.panel.addChartRenderer(new ScatterChartRenderer(this.panel.getCoordSystem(), this.data), 1);
        this.data.addChartDataModelListener(this);
        this.panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent m) {
                if (SwingUtilities.isRightMouseButton(m)) {
                    GraphFrame.this.jPopupMenu1.show(m.getComponent(), m.getX(), m.getY());
                }
            }
        });
        this.initComponents();
        this.setSize(640, 480);
        this.getContentPane().add((Component)this.panel, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.data.insertValue(0, new Double(Math.random() * 10.0 + 20.0), new Double(this.time));
        this.data.insertValue(1, new Double(Math.random() * 7.0 + 10.0), new Double(this.time));
        this.time += 1.0;
    }

    @Override
    public void chartDataChanged(ChartDataModelEvent evt) {
        this.panel.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem1.setText("Export Image File ...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.jMenuItemExportActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem1.setText("Print Graph ...");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphFrame.this.jMenuItemPrintActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GraphFrame.this.exitForm(evt);
            }
        });
        this.pack();
    }

    private void jMenuItemExportActionPerformed(ActionEvent evt) {
        JFileChooser f = new JFileChooser(System.getProperty("user.home"));
        f.setFileFilter(new ImageFilter(ChartEncoder.getSupportedFormats()));
        int ret = f.showSaveDialog(this);
        if (ret != 0) {
            return;
        }
        File selected = f.getSelectedFile();
        String filename = selected.getPath();
        String fileending = filename.substring(filename.lastIndexOf(46) + 1);
        System.out.println("** filename = " + filename + " fileending = " + fileending);
        boolean equals = false;
        String[] supported = ChartEncoder.getSupportedFormats();
        int i = 0;
        while (i < supported.length) {
            if (fileending.equalsIgnoreCase(supported[i])) {
                equals = true;
            }
            ++i;
        }
        if (!equals) {
            fileending = "png";
            filename = String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + "." + fileending;
            System.out.println("** filename = " + filename + " fileending = " + fileending);
            selected = new File(filename);
        }
        try {
            ChartEncoder.createEncodedImage(new FileOutputStream(selected), this.panel, fileending);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Fehler beim Speichern", 0);
            System.out.println("** Error creating the nevilletest.png file, showing the Neville Interpolation.");
            e.printStackTrace();
            return;
        }
    }

    private void jMenuItemPrintActionPerformed(ActionEvent evt) {
        System.out.println("Printing attempted!");
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        PrintService[] printService = PrintServiceLookup.lookupPrintServices(flavor, pras);
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService service = ServiceUI.printDialog(null, 200, 200, printService, defaultService, flavor, pras);
        if (service != null) {
            DocPrintJob job = service.createPrintJob();
            HashDocAttributeSet das = new HashDocAttributeSet();
            SimpleDoc doc = new SimpleDoc(this.panel, flavor, das);
            try {
                job.print(doc, pras);
            }
            catch (PrintException pe) {
                System.err.println("Failed!");
            }
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        new GraphFrame().show();
    }
}

