/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.event.RenderChangeEvent;
import com.approximatrix.charting.event.RenderChangeListener;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.Renderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import javax.swing.event.EventListenerList;

public abstract class AbstractChartRenderer
implements Renderer {
    protected Rectangle bounds;
    protected CoordSystem coord;
    protected ChartDataModel model;
    protected RowColorModel rcm;
    private volatile boolean stopFlag = false;
    protected EventListenerList listener = new EventListenerList();

    protected AbstractChartRenderer(ChartDataModel model) {
        this.model = model;
    }

    public AbstractChartRenderer(CoordSystem cs, ChartDataModel model) {
        this(model);
        this.coord = cs;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public void render(Graphics2D g) {
        Rectangle bounds = this.getBounds();
        Shape clip = g.getClip();
        g.setClip((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        this.renderChart(g);
        g.setClip(clip);
    }

    public abstract boolean renderChart(Graphics2D var1);

    @Override
    public void setBounds(Rectangle bounds) {
        if (!bounds.equals(this.bounds)) {
            this.bounds = bounds;
            this.fireRenderChangeEvent();
        }
    }

    public void setChartDataModel(ChartDataModel model) {
        this.model = model;
        this.fireRenderChangeEvent();
    }

    public ChartDataModel getChartDataModel() {
        return this.model;
    }

    public CoordSystem getCoordSystem() {
        return this.coord;
    }

    public void setCoordSystem(CoordSystem cs) {
        this.coord = cs;
        this.fireRenderChangeEvent();
    }

    public AffineTransform getTransform(int axis) {
        return this.getCoordSystem().getTransform(axis);
    }

    public void setRowColorModel(RowColorModel rcm) {
        this.rcm = rcm;
        this.fireRenderChangeEvent();
    }

    public RowColorModel getRowColorModel() {
        return this.rcm;
    }

    @Override
    public void fireRenderChangeEvent() {
        RenderChangeEvent rce = new RenderChangeEvent(this);
        Object[] ls = this.listener.getListenerList();
        int i = ls.length - 2;
        while (i >= 0) {
            if (ls[i] == RenderChangeListener.class) {
                ((RenderChangeListener)ls[i + 1]).renderUpdateRequested(rce);
            }
            i -= 2;
        }
    }

    @Override
    public void removeRenderChangeListener(RenderChangeListener l) {
        this.listener.remove(RenderChangeListener.class, l);
    }

    @Override
    public void addRenderChangeListener(RenderChangeListener l) {
        Object[] ls = this.listener.getListenerList();
        boolean found = false;
        int i = ls.length - 1;
        while (i >= 1) {
            if (ls[i] == l) {
                found = true;
                break;
            }
            i -= 2;
        }
        if (!found) {
            this.listener.add(RenderChangeListener.class, l);
        }
    }

    @Override
    public void clearRenderChangeListeners() {
        this.listener = new EventListenerList();
    }

    public void interruptRendering() {
        this.setStopFlag(true);
    }

    public void resetStopFlag() {
        this.setStopFlag(false);
    }

    protected synchronized void setStopFlag(boolean value) {
        this.stopFlag = value;
    }

    protected synchronized boolean getStopFlag() {
        return this.stopFlag;
    }
}

