/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.model.DataSet;
import java.util.ArrayList;
import java.util.Arrays;

public class DefaultDataSet
implements DataSet {
    protected ArrayList data = new ArrayList();
    protected ArrayList columns = new ArrayList();
    protected int axis = 0;
    protected String title = "";

    public DefaultDataSet() {
    }

    public DefaultDataSet(int axis) {
        this();
        this.setYAxis(axis);
    }

    public DefaultDataSet(Object[] data, Object[] columns, int axis) {
        this(axis);
        this.data.addAll(Arrays.asList(data));
        this.columns.addAll(Arrays.asList(columns));
    }

    public DefaultDataSet(Object[] data, Object[] columns, int axis, String title) {
        this(data, columns, axis);
        this.title = title;
    }

    @Override
    public int getDataSetLength() {
        return Math.min(this.data.size(), this.columns.size());
    }

    @Override
    public Object getValueAt(int index) {
        return this.data.get(index);
    }

    @Override
    public int getYAxis() {
        return this.axis;
    }

    @Override
    public void setValueAt(int index, Object val) {
        this.data.set(index, val);
    }

    @Override
    public void setYAxis(int yaxis) {
        if (yaxis == 0 || yaxis == 1) {
            this.axis = yaxis;
        }
    }

    @Override
    public Object getColumnValueAt(int index) {
        return this.columns.get(index);
    }

    @Override
    public void setColumnValueAt(int index, Object col) {
        this.columns.set(index, col);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }
}

