/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.model;

import com.approximatrix.charting.ChartUtilities;
import com.approximatrix.charting.model.AbstractChartDataModel;
import com.approximatrix.charting.model.ChartDataModelConstraints;
import java.util.TreeSet;

public class DefaultChartDataModelConstraints
implements ChartDataModelConstraints {
    protected AbstractChartDataModel model;
    protected int axis;
    protected boolean allowManualColScale = true;

    public DefaultChartDataModelConstraints(AbstractChartDataModel model, int axis) {
        this.model = model;
        this.axis = axis;
    }

    public DefaultChartDataModelConstraints(AbstractChartDataModel model, int axis, boolean allowManualColScale) {
        this(model, axis);
        this.allowManualColScale = allowManualColScale;
    }

    @Override
    public Number getMaximumValue() {
        return this.getMaximumY();
    }

    @Override
    public Number getMaximumY() {
        TreeSet ordered_values = this.model.getOrderedValues(this.axis);
        if (ordered_values.size() == 0) {
            return new Integer(1);
        }
        if (this.model.isManualScale()) {
            return this.model.getManualMaximumY();
        }
        if (this.model.isAutoScale()) {
            double max;
            double min = ((Number)ordered_values.first()).doubleValue();
            if (min / (max = ((Number)ordered_values.last()).doubleValue()) > 0.95) {
                return new Double(ChartUtilities.performAutoScale(min / 2.0, 2.0 * max)[1]);
            }
            return new Double(ChartUtilities.performAutoScale(min, max)[1]);
        }
        return (Number)ordered_values.last();
    }

    @Override
    public Number getMinimumValue() {
        return this.getMinimumY();
    }

    @Override
    public Number getMinimumY() {
        TreeSet ordered_values = this.model.getOrderedValues(this.axis);
        if (ordered_values.size() == 0) {
            return new Integer(0);
        }
        if (this.model.isManualScale()) {
            return this.model.getManualMinimumY();
        }
        if (this.model.isAutoScale()) {
            double max;
            double min = ((Number)ordered_values.first()).doubleValue();
            if (min / (max = ((Number)ordered_values.last()).doubleValue()) > 0.95) {
                return new Double(ChartUtilities.performAutoScale(min / 2.0, 2.0 * max)[0]);
            }
            return new Double(ChartUtilities.performAutoScale(min, max)[0]);
        }
        return (Number)ordered_values.first();
    }

    @Override
    public double getMinimumColumnValue() {
        Number x = this.getMinimumX();
        if (x == null) {
            return 0.0;
        }
        return x.doubleValue();
    }

    @Override
    public Number getMinimumX() {
        if (this.model.isManualScale() && this.allowManualColScale) {
            return this.model.getManualMinimumX();
        }
        if (this.model.isAutoScale() && this.model.isColumnNumeric()) {
            return new Double(ChartUtilities.performAutoScale(this.model.getFirstColumnValue(), this.model.getLastColumnValue())[0]);
        }
        return new Double(this.model.getFirstColumnValue());
    }

    @Override
    public double getMaximumColumnValue() {
        Number x = this.getMaximumX();
        if (x == null) {
            return 0.0;
        }
        return x.doubleValue();
    }

    @Override
    public Number getMaximumX() {
        if (this.model.isManualScale() && this.allowManualColScale) {
            return this.model.getManualMaximumX();
        }
        if (this.model.isAutoScale() && this.model.isColumnNumeric()) {
            return new Double(ChartUtilities.performAutoScale(this.model.getFirstColumnValue(), this.model.getLastColumnValue())[1]);
        }
        return new Double(this.model.getLastColumnValue());
    }
}

