/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting;

import com.approximatrix.charting.AbstractChart;
import com.approximatrix.charting.Legend;
import com.approximatrix.charting.Title;
import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.coordsystem.CoordSystemUtilities;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;

public class ExtendedChart
extends AbstractChart {
    public static final int LINEAR_X_LINEAR_Y = 0;
    public static final int NO_COORDINATE_SYSTEM = 1;

    protected ExtendedChart() {
    }

    public ExtendedChart(ChartDataModel model, String title) {
        this();
        this.setChartDataModel(model);
        this.setRowColorModel(new RowColorModel(model));
        this.setLegend(new Legend(this.getRowColorModel()));
        this.setTitle(new Title(title));
    }

    public ExtendedChart(ChartDataModel model, String title, int coord) {
        this(model, title);
        if (coord == 0) {
            this.setCoordSystem(CoordSystemUtilities.BuildDefaultCoordSystem(model));
        }
    }

    public ExtendedChart(ChartDataModel model, String title, int coord, String xaxis, String yaxis) {
        this(model, title, coord);
        this.getCoordSystem().setXAxisUnit(xaxis);
        this.getCoordSystem().setYAxisUnit(yaxis);
    }

    @Override
    public Dimension getPreferredSize() {
        return null;
    }

    @Override
    public void render(Graphics2D g) {
        int width = (int)this.getBounds().getWidth();
        int height = (int)this.getBounds().getHeight();
        Title t = this.getTitle();
        Legend l = this.getLegend();
        CoordSystem c = this.getCoordSystem();
        Collection<AbstractChartRenderer> renderer = this.getChartRenderer().values();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        int titleheight = 20;
        int legendwidth = 30;
        if (t != null) {
            Dimension title = t.getPreferredSize();
            t.setBounds(new Rectangle(width / 2 - (int)(title.getWidth() / 2.0), 0, (int)title.getWidth(), (int)title.getHeight()));
            t.render(g);
            titleheight = (int)t.getBounds().getHeight();
        }
        if (l != null) {
            Dimension legend = l.getPreferredSize();
            l.setBounds(new Rectangle((int)((double)width - legend.getWidth()), (int)((double)(height / 2) - legend.getHeight() / 2.0 + (double)titleheight), (int)legend.getWidth(), (int)legend.getHeight()));
            l.render(g);
            legendwidth = (int)l.getBounds().getWidth();
        }
        if (c != null) {
            c.setBounds(new Rectangle(0, titleheight, width - legendwidth, height - titleheight));
        }
        if (!renderer.isEmpty()) {
            for (AbstractChartRenderer cr : renderer) {
                cr.setBounds(c.getInnerBounds());
                cr.render(g);
            }
        }
        if (c != null) {
            c.render(g);
        }
    }

    public void zoom(Rectangle area) {
        double[] points = new double[]{area.x, area.y, area.x + area.width, area.y + area.height};
        double[] data_points = new double[]{0.0, 0.0, 0.0, 0.0};
        if (area.width == 0 || (double)area.height == 0.0) {
            return;
        }
        Collection<AbstractChartRenderer> renderer = this.getChartRenderer().values();
        if (!renderer.isEmpty()) {
            for (AbstractChartRenderer cr : renderer) {
                AffineTransform transform = cr.getTransform(0);
                try {
                    transform.inverseTransform(points, 0, data_points, 0, 2);
                    ChartDataModel dm = cr.getChartDataModel();
                    dm.setMaximumValueX(new Double(data_points[2]));
                    dm.setMinimumValueX(new Double(data_points[0]));
                    dm.setMaximumValueY(new Double(data_points[1]));
                    dm.setMinimumValueY(new Double(data_points[3]));
                    dm.fireChartDataModelChangedEvent(this);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        }
    }
}

