/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS.attachData;

import FCSalyzer.FCS.attachData.FCSWriter;
import FCSalyzer.FCS.attachData.ImportPanel;
import FCSalyzer.FCS.attachData.ImportParameter;
import FCSalyzer.FCS.attachData.definedTick;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ImportTable
extends AbstractCellEditor
implements TableModel,
TableCellEditor,
TableCellRenderer,
FocusListener,
ActionListener {
    private File theFile;
    private RandomAccessFile ranFile;
    private ImportPanel theConverter;
    private long[] linePositions;
    private String separator;
    private boolean decimalPeriod = true;
    private int columnCount;
    private int parameterCount;
    private String[] options = new String[]{"[Name]", "[Import]", "[Event#]", "[Log Display]", "[Categorical]", "[Jitter]", "[Range]", "[Highest Value]", "[Status]", "[for #missing#]"};
    private int nameRow = 0;
    private int importRow = 1;
    private int eventRow = 2;
    private int logRow = 3;
    private int catRow = 4;
    private int jitterRow = 5;
    private int rangeRow = 6;
    private int highestRow = 7;
    private int statusRow = 8;
    private int missingRow = 9;
    private int[] booleanRows = new int[]{this.importRow, this.eventRow, this.logRow, this.catRow, this.jitterRow};
    private int[] editableRows = new int[]{this.nameRow, this.importRow, this.eventRow, this.logRow, this.catRow, this.jitterRow, this.rangeRow, this.highestRow, this.missingRow};
    private int rowOffSet = this.options.length;
    private ArrayList<TableModelListener> theListeners = new ArrayList();
    private boolean hasHeaderLine = false;
    private String[] header;
    private ImportParameter[] theParameters;
    private DecimalFormat formatter;
    public JProgressBar theProgressBar = new JProgressBar();
    private TableCellEditor booleanEditor;
    private TableCellRenderer booleanRenderer;
    private TableCellEditor regularEditor;
    private TableCellRenderer regularRenderer;
    private TableCellEditor currentEditor;
    private boolean addedListeners = false;
    private Component editorComponent;
    private int editorRow;
    private int editorColumn;
    private float[] jitterFactor;
    private int rowsToImport = 0;
    private final String MISSING = "#missing#";
    private definedTick[][] definedTicks;

    public ImportTable(ImportPanel theConverter) {
        this.theConverter = theConverter;
        this.formatter = new DecimalFormat();
        DecimalFormatSymbols ds = this.formatter.getDecimalFormatSymbols();
        if (this.decimalPeriod) {
            ds.setDecimalSeparator('.');
        } else {
            ds.setDecimalSeparator(',');
        }
        this.formatter.setDecimalFormatSymbols(ds);
        int[] count = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 25, 26, 28, 30, 31, 33, 35, 37, 39, 41, 43, 45, 48, 50, 52, 55, 57, 60, 62, 65, 67, 70, 73, 75, 78, 81, 83, 86, 89, 91, 94, 97, 99, 102, 104, 106, 109, 111, 113, 115, 117, 119, 121, 123, 124, 126, 127, 128, 129, 130, 131, 132, 132, 133, 133, 133, 133, 133, 132, 132, 131, 130, 129, 128, 127, 126, 124, 123, 121, 119, 117, 115, 113, 111, 109, 106, 104, 102, 99, 97, 94, 91, 89, 86, 83, 81, 78, 75, 73, 70, 67, 65, 62, 60, 57, 55, 52, 50, 48, 45, 43, 41, 39, 37, 35, 33, 31, 30, 28, 26, 25, 23, 22, 21, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 9, 8, 7, 7, 6, 6, 5, 5, 5, 4, 4, 3, 3, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        float[] factors = new float[]{-30.0f, -29.7f, -29.4f, -29.1f, -28.8f, -28.5f, -28.2f, -27.9f, -27.6f, -27.3f, -27.0f, -26.7f, -26.4f, -26.1f, -25.8f, -25.5f, -25.2f, -24.9f, -24.6f, -24.3f, -24.0f, -23.7f, -23.4f, -23.1f, -22.8f, -22.5f, -22.2f, -21.9f, -21.6f, -21.3f, -21.0f, -20.7f, -20.4f, -20.1f, -19.8f, -19.5f, -19.2f, -18.9f, -18.6f, -18.3f, -18.0f, -17.7f, -17.4f, -17.1f, -16.8f, -16.5f, -16.2f, -15.9f, -15.6f, -15.3f, -15.0f, -14.7f, -14.4f, -14.1f, -13.8f, -13.5f, -13.2f, -12.9f, -12.6f, -12.3f, -12.0f, -11.7f, -11.4f, -11.1f, -10.8f, -10.5f, -10.2f, -9.9f, -9.6f, -9.3f, -9.0f, -8.7f, -8.4f, -8.1f, -7.8f, -7.5f, -7.2f, -6.9f, -6.6f, -6.3f, -6.0f, -5.7f, -5.4f, -5.1f, -4.8f, -4.5f, -4.2f, -3.9f, -3.6f, -3.3f, -3.0f, -2.7f, -2.4f, -2.1f, -1.8f, -1.5f, -1.2f, -0.9f, -0.6f, -0.3f, 0.0f, 0.3f, 0.6f, 0.9f, 1.2f, 1.5f, 1.8f, 2.1f, 2.4f, 2.7f, 3.0f, 3.3f, 3.6f, 3.9f, 4.2f, 4.5f, 4.8f, 5.1f, 5.4f, 5.7f, 6.0f, 6.3f, 6.6f, 6.9f, 7.2f, 7.5f, 7.8f, 8.1f, 8.4f, 8.7f, 9.0f, 9.3f, 9.6f, 9.9f, 10.2f, 10.5f, 10.8f, 11.1f, 11.4f, 11.7f, 12.0f, 12.3f, 12.6f, 12.9f, 13.2f, 13.5f, 13.8f, 14.1f, 14.4f, 14.7f, 15.0f, 15.3f, 15.6f, 15.9f, 16.2f, 16.5f, 16.8f, 17.1f, 17.4f, 17.7f, 18.0f, 18.3f, 18.6f, 18.9f, 19.2f, 19.5f, 19.8f, 20.1f, 20.4f, 20.7f, 21.0f, 21.3f, 21.6f, 21.9f, 22.2f, 22.5f, 22.8f, 23.1f, 23.4f, 23.7f, 24.0f, 24.3f, 24.6f, 24.9f, 25.2f, 25.5f, 25.8f, 26.1f, 26.4f, 26.7f, 27.0f, 27.3f, 27.6f, 27.9f, 28.2f, 28.5f, 28.8f, 29.1f, 29.4f, 29.7f, 30.0f};
        this.jitterFactor = new float[9991];
        int curr = 0;
        for (int i = 0; i < count.length; ++i) {
            for (int j = 0; j < count[i]; ++j) {
                this.jitterFactor[curr] = factors[i];
                ++curr;
            }
        }
    }

    public void setFile(File theData) throws FileNotFoundException {
        this.theFile = theData;
        if (this.separator == null) {
            this.separator = "\t";
        }
        try {
            if (this.ranFile != null) {
                this.ranFile.close();
            }
        }
        catch (IOException io) {
            // empty catch block
        }
        this.ranFile = new RandomAccessFile(this.theFile, "r");
        this.theProgressBar.setIndeterminate(false);
        this.theProgressBar.setMinimum(0);
        this.theProgressBar.setMaximum((int)theData.length());
        this.theProgressBar.setStringPainted(true);
        this.theProgressBar.setString("scanning ...");
        this.initialise();
        this.theProgressBar.setString("completed");
        if (this.linePositions.length == 0) {
            // empty if block
        }
        boolean isNumber = false;
        for (String currValue : this.getSeparatedLine(0)) {
            boolean success = true;
            try {
                float f = Float.parseFloat(currValue);
            }
            catch (NumberFormatException nf) {
                success = false;
            }
            if (!success) continue;
            isNumber = true;
        }
        if (!isNumber) {
            this.hasHeaderLine = true;
            this.theConverter.setHasHeader();
        }
        int[] count = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 9, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 25, 26, 28, 30, 31, 33, 35, 37, 39, 41, 43, 45, 48, 50, 52, 55, 57, 60, 62, 65, 67, 70, 73, 75, 78, 81, 83, 86, 89, 91, 94, 97, 99, 102, 104, 106, 109, 111, 113, 115, 117, 119, 121, 123, 124, 126, 127, 128, 129, 130, 131, 132, 132, 133, 133, 133, 133, 133, 132, 132, 131, 130, 129, 128, 127, 126, 124, 123, 121, 119, 117, 115, 113, 111, 109, 106, 104, 102, 99, 97, 94, 91, 89, 86, 83, 81, 78, 75, 73, 70, 67, 65, 62, 60, 57, 55, 52, 50, 48, 45, 43, 41, 39, 37, 35, 33, 31, 30, 28, 26, 25, 23, 22, 21, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 9, 8, 7, 7, 6, 6, 5, 5, 5, 4, 4, 3, 3, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        float[] factors = new float[]{-30.0f, -29.7f, -29.4f, -29.1f, -28.8f, -28.5f, -28.2f, -27.9f, -27.6f, -27.3f, -27.0f, -26.7f, -26.4f, -26.1f, -25.8f, -25.5f, -25.2f, -24.9f, -24.6f, -24.3f, -24.0f, -23.7f, -23.4f, -23.1f, -22.8f, -22.5f, -22.2f, -21.9f, -21.6f, -21.3f, -21.0f, -20.7f, -20.4f, -20.1f, -19.8f, -19.5f, -19.2f, -18.9f, -18.6f, -18.3f, -18.0f, -17.7f, -17.4f, -17.1f, -16.8f, -16.5f, -16.2f, -15.9f, -15.6f, -15.3f, -15.0f, -14.7f, -14.4f, -14.1f, -13.8f, -13.5f, -13.2f, -12.9f, -12.6f, -12.3f, -12.0f, -11.7f, -11.4f, -11.1f, -10.8f, -10.5f, -10.2f, -9.9f, -9.6f, -9.3f, -9.0f, -8.7f, -8.4f, -8.1f, -7.8f, -7.5f, -7.2f, -6.9f, -6.6f, -6.3f, -6.0f, -5.7f, -5.4f, -5.1f, -4.8f, -4.5f, -4.2f, -3.9f, -3.6f, -3.3f, -3.0f, -2.7f, -2.4f, -2.1f, -1.8f, -1.5f, -1.2f, -0.9f, -0.6f, -0.3f, 0.0f, 0.3f, 0.6f, 0.9f, 1.2f, 1.5f, 1.8f, 2.1f, 2.4f, 2.7f, 3.0f, 3.3f, 3.6f, 3.9f, 4.2f, 4.5f, 4.8f, 5.1f, 5.4f, 5.7f, 6.0f, 6.3f, 6.6f, 6.9f, 7.2f, 7.5f, 7.8f, 8.1f, 8.4f, 8.7f, 9.0f, 9.3f, 9.6f, 9.9f, 10.2f, 10.5f, 10.8f, 11.1f, 11.4f, 11.7f, 12.0f, 12.3f, 12.6f, 12.9f, 13.2f, 13.5f, 13.8f, 14.1f, 14.4f, 14.7f, 15.0f, 15.3f, 15.6f, 15.9f, 16.2f, 16.5f, 16.8f, 17.1f, 17.4f, 17.7f, 18.0f, 18.3f, 18.6f, 18.9f, 19.2f, 19.5f, 19.8f, 20.1f, 20.4f, 20.7f, 21.0f, 21.3f, 21.6f, 21.9f, 22.2f, 22.5f, 22.8f, 23.1f, 23.4f, 23.7f, 24.0f, 24.3f, 24.6f, 24.9f, 25.2f, 25.5f, 25.8f, 26.1f, 26.4f, 26.7f, 27.0f, 27.3f, 27.6f, 27.9f, 28.2f, 28.5f, 28.8f, 29.1f, 29.4f, 29.7f, 30.0f};
        this.jitterFactor = new float[9991];
        int curr = 0;
        for (int i = 0; i < count.length; ++i) {
            for (int j = 0; j < count[i]; ++j) {
                this.jitterFactor[curr] = factors[i];
                ++curr;
            }
        }
        this.analyze(true);
        for (TableModelListener currList : this.theListeners) {
            currList.tableChanged(null);
        }
    }

    public void setRegulars(TableCellEditor oldEditor, TableCellRenderer oldRenderer, TableCellEditor oldBooleanEditor, TableCellRenderer oldBooleanRenderer) {
        this.regularEditor = oldEditor;
        this.regularRenderer = oldRenderer;
        this.booleanEditor = oldBooleanEditor;
        this.booleanRenderer = oldBooleanRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise() {
        int threshold;
        int nextUpdate = threshold = this.theProgressBar.getMaximum() / 100;
        try {
            RandomAccessFile randomAccessFile = this.ranFile;
            synchronized (randomAccessFile) {
                this.ranFile.seek(0L);
                ArrayList<Long> positions = new ArrayList<Long>();
                String next = null;
                do {
                    long currPos;
                    if ((currPos = this.ranFile.getFilePointer()) > (long)nextUpdate) {
                        this.theProgressBar.setValue((int)currPos);
                        this.theProgressBar.paintImmediately(0, 0, this.theProgressBar.getWidth(), this.theProgressBar.getHeight());
                        nextUpdate += threshold;
                    }
                    positions.add(currPos);
                } while ((next = this.ranFile.readLine()) != null);
                this.linePositions = new long[positions.size() - 1];
                for (int i = 0; i < this.linePositions.length; ++i) {
                    this.linePositions[i] = (Long)positions.get(i);
                }
            }
        }
        catch (IOException io) {
            this.linePositions = new long[0];
        }
    }

    private void analyze(boolean recountParameters) {
        if (this.ranFile == null) {
            return;
        }
        try {
            this.defineHeader();
            this.theProgressBar.setValue(0);
            this.theProgressBar.setMaximum(this.linePositions.length);
            this.theProgressBar.setString("analyzing ...");
            this.defineParameters(recountParameters);
            this.theProgressBar.setString("completed");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Couldn't analyze file! Please make sure that this is a text file!", "File error", 0);
            this.theProgressBar.setValue(0);
            this.theProgressBar.setString("failed");
        }
    }

    private void defineHeader() {
        this.header = this.getSeparatedLine(0);
        this.columnCount = this.header.length + 1;
        this.parameterCount = this.header.length;
    }

    private void defineParameters(boolean changeParameterCount) {
        int i;
        if (changeParameterCount) {
            this.theParameters = new ImportParameter[this.parameterCount];
            for (i = 0; i < this.parameterCount; ++i) {
                ImportParameter currParam = new ImportParameter();
                currParam.name = "Param #" + i;
                if (this.hasHeaderLine) {
                    currParam.name = this.header[i];
                }
                this.theParameters[i] = currParam;
            }
        } else {
            for (i = 0; i < this.parameterCount; ++i) {
                this.theParameters[i].reset();
            }
        }
        try {
            this.ranFile.seek(0L);
            BufferedReader bReader = new BufferedReader(new FileReader(this.ranFile.getFD()));
            int start = 0;
            if (this.hasHeaderLine) {
                ++start;
                bReader.readLine();
            }
            for (int i2 = start; i2 < this.linePositions.length; ++i2) {
                int j;
                if (i2 % 100 == 0) {
                    this.theProgressBar.setValue(i2);
                    this.theProgressBar.paintImmediately(0, 0, this.theProgressBar.getWidth(), this.theProgressBar.getHeight());
                }
                String[] currEvent = this.getSeparatedLine(bReader.readLine());
                for (j = 0; j < currEvent.length; ++j) {
                    float currValue = 0.0f;
                    if (currEvent[j].trim().isEmpty()) {
                        this.theParameters[j].hasEmptyValue = true;
                        continue;
                    }
                    boolean success = true;
                    try {
                        currValue = this.formatter.parse(currEvent[j]).floatValue();
                    }
                    catch (ParseException p) {
                        this.theParameters[j].hasNonNumericalValue = true;
                        success = false;
                    }
                    if (!success || !(this.theParameters[j].maxValue < currValue)) continue;
                    this.theParameters[j].maxValue = currValue;
                }
                for (j = currEvent.length; j < this.parameterCount; ++j) {
                    this.theParameters[j].hasEmptyValue = true;
                }
            }
        }
        catch (IOException io) {
            // empty catch block
        }
        for (ImportParameter currParam : this.theParameters) {
            if (currParam.hasEmptyValue && currParam.hasNonNumericalValue) {
                currParam.status = "not numerical, incomplete";
            }
            if (currParam.hasEmptyValue && !currParam.hasNonNumericalValue) {
                currParam.status = "incomplete";
            }
            if (currParam.hasEmptyValue || !currParam.hasNonNumericalValue) continue;
            currParam.status = "not numerical, complete";
        }
        this.theProgressBar.setValue(this.theProgressBar.getMaximum());
        this.theProgressBar.paintImmediately(0, 0, this.theProgressBar.getWidth(), this.theProgressBar.getHeight());
        for (int j = 0; j < this.parameterCount; ++j) {
            this.theParameters[j].maxValueString = String.valueOf(this.theParameters[j].maxValue);
            this.theParameters[j].range = (int)(this.theParameters[j].maxValue + 1.0f);
            this.theParameters[j].rangeString = String.valueOf(this.theParameters[j].range);
        }
    }

    public String getLine(int index) {
        try {
            this.ranFile.seek(this.linePositions[index]);
            return this.ranFile.readLine();
        }
        catch (IOException io) {
            return null;
        }
    }

    public String[] getSeparatedLine(String toSeparate) {
        if (toSeparate == null) {
            return null;
        }
        return toSeparate.split(Matcher.quoteReplacement(this.separator));
    }

    public String[] getSeparatedLine(int index) {
        String toSeparate = this.getLine(index);
        if (toSeparate == null) {
            return null;
        }
        return toSeparate.split(Matcher.quoteReplacement(this.separator));
    }

    public void setSeparator(String newSep) {
        this.separator = newSep;
        this.analyze(true);
        for (TableModelListener currList : this.theListeners) {
            currList.tableChanged(null);
        }
    }

    public void setUseDecimalPeriod(boolean usePeriod) {
        this.decimalPeriod = usePeriod;
        DecimalFormatSymbols ds = this.formatter.getDecimalFormatSymbols();
        if (this.decimalPeriod) {
            ds.setDecimalSeparator('.');
        } else {
            ds.setDecimalSeparator(',');
        }
        this.formatter.setDecimalFormatSymbols(ds);
        this.analyze(false);
        for (TableModelListener currList : this.theListeners) {
            currList.tableChanged(null);
        }
    }

    public void setHasHeader(boolean newStatus) {
        if (this.hasHeaderLine != newStatus) {
            this.hasHeaderLine = newStatus;
            String[] header = this.getSeparatedLine(0);
            for (int i = 0; i < this.parameterCount; ++i) {
                this.theParameters[i].name = header[i];
            }
            for (TableModelListener currList : this.theListeners) {
                currList.tableChanged(null);
            }
        }
    }

    @Override
    public int getRowCount() {
        if (this.linePositions == null) {
            return 0;
        }
        int result = this.rowsToImport + this.rowOffSet;
        return result;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "#";
        }
        if (this.hasHeaderLine) {
            return this.header[columnIndex - 1];
        }
        return "Param #" + (columnIndex - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        int[] arr$ = this.editableRows;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer r = arr$[i$];
            if (r != rowIndex) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < this.rowOffSet) {
            if (columnIndex == 0) {
                return this.options[rowIndex];
            }
            if (rowIndex == this.nameRow) {
                return this.theParameters[columnIndex - 1].name;
            }
            if (rowIndex == this.importRow) {
                return this.theParameters[columnIndex - 1].imp;
            }
            if (rowIndex == this.eventRow) {
                return this.theParameters[columnIndex - 1].eventNumber;
            }
            if (rowIndex == this.logRow) {
                return this.theParameters[columnIndex - 1].displayLog;
            }
            if (rowIndex == this.catRow) {
                return this.theParameters[columnIndex - 1].isCategory;
            }
            if (rowIndex == this.jitterRow) {
                return this.theParameters[columnIndex - 1].useJitter;
            }
            if (rowIndex == this.rangeRow) {
                return this.theParameters[columnIndex - 1].rangeString;
            }
            if (rowIndex == this.highestRow) {
                return this.theParameters[columnIndex - 1].maxValueString;
            }
            if (rowIndex == this.statusRow) {
                String result = this.theParameters[columnIndex - 1].status;
                if (result.equals("incomplete")) {
                    return result;
                }
                if (result.equals("not numerical, incomplete")) {
                    return result;
                }
                Object lastValue = this.getValueAt(this.getRowCount() - 1, columnIndex);
                if (lastValue == "#missing#") {
                    if (result.equals("complete")) {
                        return "incomplete";
                    }
                    return "not numerical, incomplete";
                }
                return result;
            }
            if (rowIndex == this.missingRow) {
                return this.theParameters[columnIndex - 1].forMissingString;
            }
        }
        int row = rowIndex - this.rowOffSet;
        if (columnIndex == 0) {
            return String.valueOf(row);
        }
        int rowsInFile = this.linePositions.length;
        if (this.hasHeaderLine) {
            --rowsInFile;
        }
        if (row >= rowsInFile) {
            return "#missing#";
        }
        String[] values = this.hasHeaderLine ? this.getSeparatedLine(row + 1) : this.getSeparatedLine(row);
        if (values.length > columnIndex - 1) {
            if (values[columnIndex - 1].trim().isEmpty()) {
                return "#missing#";
            }
            return values[columnIndex - 1];
        }
        return "#missing#";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        if (rowIndex == this.importRow || rowIndex == this.eventRow || rowIndex == this.logRow || rowIndex == this.catRow || rowIndex == this.jitterRow) {
            if (aValue instanceof Boolean) {
                if (rowIndex == this.importRow) {
                    this.theParameters[columnIndex - 1].imp = (Boolean)aValue;
                }
                if (rowIndex == this.eventRow) {
                    this.theParameters[columnIndex - 1].eventNumber = (Boolean)aValue;
                }
                if (rowIndex == this.logRow) {
                    this.theParameters[columnIndex - 1].displayLog = (Boolean)aValue;
                }
                if (rowIndex == this.catRow) {
                    this.theParameters[columnIndex - 1].isCategory = (Boolean)aValue;
                }
                if (rowIndex == this.jitterRow) {
                    this.theParameters[columnIndex - 1].useJitter = (Boolean)aValue;
                }
            }
        } else {
            boolean success;
            String value = aValue.toString().trim();
            if (value.isEmpty()) {
                return;
            }
            if (rowIndex == this.nameRow) {
                this.theParameters[columnIndex - 1].name = value;
            }
            if (rowIndex == this.rangeRow) {
                int x = 0;
                success = true;
                try {
                    x = Integer.parseInt(value);
                }
                catch (NumberFormatException nf) {
                    success = false;
                }
                if (success) {
                    if ((float)x <= this.theParameters[columnIndex - 1].maxValue) {
                        x = (int)(this.theParameters[columnIndex - 1].maxValue + 1.0f);
                    }
                    this.theParameters[columnIndex - 1].range = x;
                    this.theParameters[columnIndex - 1].rangeString = String.valueOf(x);
                }
            }
            if (rowIndex == this.missingRow) {
                float x = 0.0f;
                success = true;
                try {
                    x = Float.parseFloat(value);
                }
                catch (NumberFormatException nf) {
                    success = false;
                }
                if (success) {
                    this.theParameters[columnIndex - 1].missingValue = x;
                    this.theParameters[columnIndex - 1].forMissingString = String.valueOf(x);
                }
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.theListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.theListeners.remove(l);
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentEditor.getCellEditorValue();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!this.addedListeners) {
            JComponent ch;
            Component c = this.booleanEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (c instanceof JCheckBox) {
                ch = (JCheckBox)c;
                ((AbstractButton)ch).addActionListener(this);
            }
            if ((c = this.regularEditor.getTableCellEditorComponent(table, value, isSelected, row, column)) instanceof JTextField) {
                ch = (JTextField)c;
                ch.addFocusListener(this);
            }
            this.addedListeners = true;
        }
        int[] arr$ = this.booleanRows;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer r = arr$[i$];
            if (row != r) continue;
            this.currentEditor = this.booleanEditor;
            this.editorComponent = this.booleanEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            this.editorRow = row;
            this.editorColumn = column;
            return this.editorComponent;
        }
        this.currentEditor = this.regularEditor;
        this.editorComponent = this.regularEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.editorRow = row;
        this.editorColumn = column;
        return this.editorComponent;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int[] arr$ = this.booleanRows;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer r = arr$[i$];
            if (row != r || column == 0) continue;
            return this.booleanRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
        return this.regularRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() instanceof JTextField) {
            this.setValueAt(((JTextField)e.getSource()).getText(), this.editorRow, this.editorColumn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.setValueAt(((JCheckBox)e.getSource()).isSelected(), this.editorRow, this.editorColumn);
        }
    }

    public File[] convert() throws IOException {
        if (this.theParameters == null) {
            return new File[0];
        }
        boolean hasCat = false;
        for (ImportParameter currPar : this.theParameters) {
            if (!currPar.isCategory || !currPar.imp) continue;
            hasCat = true;
            currPar.catValues = new HashSet();
        }
        this.theProgressBar.setMaximum(this.linePositions.length);
        this.theProgressBar.setValue(0);
        int step = this.linePositions.length / 100;
        if (hasCat) {
            this.theProgressBar.setString("defining categories ...");
            this.ranFile.seek(0L);
            BufferedReader bReader = new BufferedReader(new FileReader(this.ranFile.getFD()));
            int start = 0;
            if (this.hasHeaderLine) {
                ++start;
                bReader.readLine();
            }
            int m = this.linePositions.length;
            for (int i = start; i < m; ++i) {
                if (i % step == 0) {
                    this.theProgressBar.setValue(i);
                    this.theProgressBar.paintImmediately(0, 0, this.theProgressBar.getWidth(), this.theProgressBar.getHeight());
                }
                String[] currS = this.getSeparatedLine(bReader.readLine());
                for (int j = 0; j < this.parameterCount; ++j) {
                    if (!this.theParameters[j].isCategory || !this.theParameters[j].imp) continue;
                    if (currS.length > j) {
                        if (currS[j].trim().isEmpty()) {
                            this.theParameters[j].catValues.add(this.theParameters[j].forMissingString);
                            continue;
                        }
                        this.theParameters[j].catValues.add(currS[j].toString());
                        continue;
                    }
                    this.theParameters[j].catValues.add(this.theParameters[j].forMissingString);
                }
            }
            for (int j = 0; j < this.parameterCount; ++j) {
                int i;
                if (!this.theParameters[j].isCategory || !this.theParameters[j].imp) continue;
                String[] theValues = this.theParameters[j].catValues.toArray(new String[0]);
                Object[] sortObjects = new sortCategory[theValues.length];
                boolean allInteger = true;
                boolean allDouble = true;
                for (i = 0; i < theValues.length; ++i) {
                    sortObjects[i] = new sortCategory(theValues[i]);
                    if (((sortCategory)sortObjects[i]).intValue == null) {
                        allInteger = false;
                    }
                    if (((sortCategory)sortObjects[i]).doubleValue != null) continue;
                    allDouble = false;
                }
                if (allInteger) {
                    for (i = 0; i < theValues.length; ++i) {
                        ((sortCategory)sortObjects[i]).setSorter("sI");
                    }
                } else if (allDouble) {
                    for (i = 0; i < theValues.length; ++i) {
                        ((sortCategory)sortObjects[i]).setSorter("sD");
                    }
                }
                Arrays.sort(sortObjects);
                this.theParameters[j].orderedCatValues = new ArrayList();
                for (i = 0; i < theValues.length; ++i) {
                    this.theParameters[j].orderedCatValues.add(((sortCategory)sortObjects[i]).value);
                }
                this.theParameters[j].catValues = null;
            }
        }
        int paramsToExport = 0;
        ImportParameter eventParam = null;
        for (int i = 0; i < this.theParameters.length; ++i) {
            ImportParameter currParam = this.theParameters[i];
            if (currParam.eventNumber) {
                eventParam = currParam;
                eventParam.index = i;
                continue;
            }
            if (!currParam.imp) continue;
            ++paramsToExport;
        }
        if (paramsToExport == 0) {
            return null;
        }
        ImportParameter[] toExport = new ImportParameter[paramsToExport];
        int current = 0;
        for (int i = 0; i < this.theParameters.length; ++i) {
            if (!this.theParameters[i].imp || this.theParameters[i].eventNumber) continue;
            toExport[current] = this.theParameters[i];
            toExport[current].index = i;
            ++current;
        }
        FCSWriter[] theWriters = new FCSWriter[paramsToExport];
        File[] toReturn = new File[paramsToExport];
        this.definedTicks = new definedTick[paramsToExport][];
        for (int i = 0; i < paramsToExport; ++i) {
            ImportParameter[] toWrite = new ImportParameter[]{toExport[i]};
            toReturn[i] = File.createTempFile("FCSalyzer", ".fcs");
            if (toExport[i].isCategory) {
                int paramIndex = toExport[i].index;
                if (this.getValueAt(this.statusRow, paramIndex + 1) == "incomplete" || this.getValueAt(this.statusRow, paramIndex + 1) == "not numerical, incomplete") {
                    toExport[i].orderedCatValues.add(0, "");
                }
                this.definedTicks[i] = new definedTick[toExport[i].orderedCatValues.size()];
                for (int j = 0; j < this.definedTicks[i].length; ++j) {
                    this.definedTicks[i][j] = new definedTick(100 * (j + 1), "[" + toExport[i].orderedCatValues.get(j) + "]");
                }
            } else {
                this.definedTicks[i] = new definedTick[0];
            }
            theWriters[i] = new FCSWriter(toReturn[i], toWrite, this.rowsToImport, this.theFile.getName());
        }
        this.theProgressBar.setString("importing ...");
        this.ranFile.seek(0L);
        BufferedReader bReader = new BufferedReader(new FileReader(this.ranFile.getFD()));
        if (this.hasHeaderLine) {
            bReader.readLine();
        }
        int currentLine = -1;
        for (int row = 0; row < this.rowsToImport; ++row) {
            ++currentLine;
            if (row % step == 0) {
                this.theProgressBar.setValue(row);
                this.theProgressBar.paintImmediately(0, 0, this.theProgressBar.getWidth(), this.theProgressBar.getHeight());
            }
            String[] currS = null;
            if (currentLine < this.linePositions.length) {
                currS = this.getSeparatedLine(bReader.readLine());
            }
            int index = -1;
            if (eventParam != null && currS != null) {
                String eventNumber = currS[eventParam.index];
                try {
                    index = Integer.parseInt(eventNumber);
                }
                catch (NumberFormatException nf) {
                    index = -1;
                }
                if (index <= row) {
                    index = 0;
                } else if (index > row) {
                    index -= row;
                }
            }
            if (index == -1) {
                index = 0;
            }
            for (int j = 0; j < paramsToExport; ++j) {
                ImportParameter currentParam = toExport[j];
                int importIndex = currentParam.index;
                float currValue = 0.0f;
                String currValueString = currentParam.forMissingString;
                if (currS != null && currS.length > importIndex && !currS[importIndex].trim().isEmpty()) {
                    currValueString = currS[importIndex].trim();
                }
                if (currentParam.isCategory) {
                    int currentParamIndex = currentParam.orderedCatValues.indexOf(currValueString);
                    if (currValueString == currentParam.forMissingString) {
                        currentParamIndex = 0;
                    }
                    currValue = 100 * (currentParamIndex + 1);
                    if (currentParam.useJitter) {
                        int jitterRandom = (int)(Math.random() * 9991.0);
                        if (jitterRandom > 9990) {
                            jitterRandom = 4995;
                        }
                        currValue += this.jitterFactor[jitterRandom];
                    }
                } else {
                    try {
                        currValue = Float.parseFloat(currValueString);
                    }
                    catch (NumberFormatException nf) {
                        currValue = 0.0f;
                    }
                }
                for (int k = 0; k < index; ++k) {
                    float bufferValue = currentParam.missingValue;
                    if (currentParam.isCategory) {
                        bufferValue = 100.0f;
                        if (currentParam.useJitter) {
                            int jitterRandom = (int)(Math.random() * 9991.0);
                            if (jitterRandom > 9990) {
                                jitterRandom = 4995;
                            }
                            bufferValue += this.jitterFactor[jitterRandom];
                        }
                    }
                    theWriters[j].write(Float.valueOf(bufferValue));
                }
                theWriters[j].write(Float.valueOf(currValue));
            }
            row += index;
        }
        for (int i = 0; i < theWriters.length; ++i) {
            theWriters[i].close();
        }
        this.theProgressBar.setValue(this.theProgressBar.getMaximum());
        this.theProgressBar.setString("completed");
        return toReturn;
    }

    public void setRowsToImport(int rows) {
        this.rowsToImport = rows;
        for (TableModelListener currList : this.theListeners) {
            currList.tableChanged(null);
        }
    }

    public definedTick[][] getDefinedTicks() {
        return this.definedTicks;
    }

    private class sortCategory
    implements Comparable<sortCategory> {
        String value;
        Integer intValue;
        Double doubleValue;
        static final String sortString = "sS";
        static final String sortInteger = "sI";
        static final String sortDouble = "sD";
        String sorter = "sS";

        public sortCategory(String param) {
            this.value = param;
            try {
                this.intValue = Integer.parseInt(this.value);
            }
            catch (NumberFormatException n) {
                this.intValue = null;
            }
            try {
                this.doubleValue = Double.parseDouble(this.value);
            }
            catch (NumberFormatException n) {
                this.doubleValue = null;
            }
        }

        @Override
        public int compareTo(sortCategory o) {
            if (this.sorter == sortString) {
                return this.value.compareTo(o.value);
            }
            if (this.sorter == sortInteger) {
                return this.intValue.compareTo(o.intValue);
            }
            if (this.sorter == sortDouble) {
                return this.doubleValue.compareTo(o.doubleValue);
            }
            return 0;
        }

        public void setSorter(String sort) {
            this.sorter = sort;
        }
    }
}

