/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS;

import FCSalyzer.FCS.FCS_RegionGatesHolder;
import FCSalyzer.FCS.FCS_data;
import FCSalyzer.FCS.FCS_gate;
import FCSalyzer.FCS.FCS_marker;
import FCSalyzer.FCS.FCS_quadrant;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class FCS_statistics {
    private int paramCount;
    public static final int LL = 0;
    public static final int LR = 1;
    public static final int UL = 2;
    public static final int UR = 3;
    public static final int ALL_EVENTS = 0;
    public static final int QUADRANTS = 1;
    public static final int REGIONS = 2;
    public static final int GATES = 3;
    public static final int MARKERS = 4;
    private int totalEvents;
    private FCS_gate theGate;
    private boolean calculateQuadrants = false;
    private boolean calculateRegions = false;
    private boolean calculateGates = false;
    private boolean calculateMarkers = false;
    private boolean calculateMedian = false;
    private boolean calculateCV = false;
    private FCS_quadrant quadrant;
    private int x_axis;
    private int y_axis;
    private ArrayList<FCS_marker> markers;
    private FCS_RegionGatesHolder theRaG;
    private String FileName;
    private String SampleDesc;
    private statHolder allEventsStats;
    private statHolder[] quadrantStats;
    private statHolder[] markerStats;
    private statHolder[] regionStats;
    private statHolder[] gateStats;
    public static final int EVENT_COUNT = 0;
    public static final int PERCENT_OF_GATED = 1;
    public static final int PERCENT_OF_TOTAL = 2;
    public static final int MEAN = 3;
    public static final int MEDIAN = 4;
    public static final int CV = 5;
    public boolean calculationSuccess = true;
    private static int count = 0;

    private FCS_statistics() {
    }

    public FCS_statistics(FCS_data paramData, FCS_quadrant paramQuadrant, ArrayList<FCS_marker> paramMarkers, FCS_RegionGatesHolder paramRaG, int paramGate, int x_axis, int y_axis, boolean calculateMedian, boolean calculateCV) throws IOException {
        this.calculateMedian = calculateMedian;
        this.calculateQuadrants = paramQuadrant != null;
        this.calculateMarkers = paramMarkers != null && !paramMarkers.isEmpty();
        this.calculateRegions = paramRaG != null;
        this.calculateGates = paramRaG != null && paramRaG.hasValidGates();
        this.calculateCV = calculateCV;
        this.quadrant = paramQuadrant;
        this.x_axis = x_axis;
        this.y_axis = y_axis;
        this.markers = paramMarkers;
        this.theRaG = paramRaG;
        if (this.theRaG != null) {
            this.theGate = this.theRaG.getGate(paramGate);
        }
        this.calculationSuccess = this.calculateBasics(paramData);
    }

    private boolean calculateBasics(FCS_data paramData) throws IOException {
        int i;
        ++count;
        this.FileName = paramData.getDataFileName();
        this.SampleDesc = paramData.getSampleDescription();
        this.totalEvents = paramData.getEventCount();
        this.paramCount = 2;
        this.allEventsStats = new statHolder();
        if (this.calculateQuadrants) {
            this.quadrantStats = new statHolder[4];
            this.quadrantStats[0] = new statHolder();
            this.quadrantStats[1] = new statHolder();
            this.quadrantStats[2] = new statHolder();
            this.quadrantStats[3] = new statHolder();
        }
        if (this.calculateGates) {
            this.gateStats = new statHolder[this.theRaG.getGatesCount()];
            for (i = 0; i < this.gateStats.length; ++i) {
                this.gateStats[i] = new statHolder();
            }
        }
        if (this.calculateRegions) {
            this.regionStats = new statHolder[this.theRaG.getRegionsCount()];
            for (i = 0; i < this.regionStats.length; ++i) {
                this.regionStats[i] = new statHolder();
            }
        }
        if (this.calculateMarkers) {
            this.markerStats = new statHolder[this.markers.size()];
            for (i = 0; i < this.markerStats.length; ++i) {
                this.markerStats[i] = new statHolder();
            }
        }
        if (this.calculateMedian) {
            this.addEventsWithMedian(paramData);
        } else {
            this.addEventsWithoutMedian(paramData);
        }
        NumberFormat numberFormatter = NumberFormat.getNumberInstance(Locale.ENGLISH);
        numberFormatter.setRoundingMode(RoundingMode.HALF_UP);
        numberFormatter.setMinimumFractionDigits(2);
        numberFormatter.setMaximumFractionDigits(2);
        numberFormatter.setGroupingUsed(false);
        int gatedEvents = this.allEventsStats.eventCount;
        boolean success = true;
        success = this.allEventsStats.calculateStats(gatedEvents, this.totalEvents, numberFormatter);
        if (this.calculateQuadrants) {
            for (statHolder currentStat : this.quadrantStats) {
                success = currentStat.calculateStats(gatedEvents, this.totalEvents, numberFormatter);
            }
        }
        if (this.calculateRegions) {
            for (statHolder currentStat : this.regionStats) {
                success = currentStat.calculateStats(gatedEvents, this.totalEvents, numberFormatter);
            }
        }
        if (this.calculateGates) {
            for (statHolder currentStat : this.gateStats) {
                success = currentStat.calculateStats(gatedEvents, this.totalEvents, numberFormatter);
            }
        }
        if (this.calculateMarkers) {
            for (statHolder currentStat : this.markerStats) {
                success = currentStat.calculateStats(gatedEvents, this.totalEvents, numberFormatter);
            }
        }
        if (this.calculateCV) {
            this.addEventsForCV(paramData);
            this.allEventsStats.calculateCV(numberFormatter);
            if (this.calculateQuadrants) {
                for (statHolder currentStat : this.quadrantStats) {
                    currentStat.calculateCV(numberFormatter);
                }
            }
            if (this.calculateRegions) {
                for (statHolder currentStat : this.regionStats) {
                    currentStat.calculateCV(numberFormatter);
                }
            }
            if (this.calculateGates) {
                for (statHolder currentStat : this.gateStats) {
                    currentStat.calculateCV(numberFormatter);
                }
            }
            if (this.calculateMarkers) {
                for (statHolder currentStat : this.markerStats) {
                    currentStat.calculateCV(numberFormatter);
                }
            }
        }
        return success;
    }

    private void addEventsWithoutMedian(FCS_data paramData) throws IOException {
        if (this.theGate != null) {
            int cacheStep = 100;
            int cachings = this.totalEvents / cacheStep;
            int rest = this.totalEvents % cacheStep;
            for (int i = 0; i < cachings; ++i) {
                double[][][] cacheEvents = paramData.getEvents(i * cacheStep, cacheStep);
                for (int m = 0; m < cacheStep; ++m) {
                    if (!this.theGate.contains(cacheEvents[0][m])) continue;
                    this.calculateEventStatsWithoutMedian(cacheEvents[0][m], cacheEvents[1][m]);
                }
            }
            double[][][] cacheEvents = paramData.getEvents(cachings * cacheStep, rest);
            for (int m = 0; m < rest; ++m) {
                if (!this.theGate.contains(cacheEvents[0][m])) continue;
                this.calculateEventStatsWithoutMedian(cacheEvents[0][m], cacheEvents[1][m]);
            }
        } else {
            int cacheStep = 100;
            int cachings = this.totalEvents / cacheStep;
            int rest = this.totalEvents % cacheStep;
            for (int i = 0; i < cachings; ++i) {
                double[][][] cacheEvents = paramData.getEvents(i * cacheStep, cacheStep);
                for (int m = 0; m < cacheStep; ++m) {
                    this.calculateEventStatsWithoutMedian(cacheEvents[0][m], cacheEvents[1][m]);
                }
            }
            double[][][] cacheEvents = paramData.getEvents(cachings * cacheStep, rest);
            for (int m = 0; m < rest; ++m) {
                this.calculateEventStatsWithoutMedian(cacheEvents[0][m], cacheEvents[1][m]);
            }
        }
    }

    private void addEventsForCV(FCS_data paramData) throws IOException {
        if (this.theGate != null) {
            int cacheStep = 100;
            int cachings = this.totalEvents / cacheStep;
            int rest = this.totalEvents % cacheStep;
            for (int i = 0; i < cachings; ++i) {
                double[][][] cacheEvents = paramData.getEvents(i * cacheStep, cacheStep);
                for (int m = 0; m < cacheStep; ++m) {
                    if (!this.theGate.contains(cacheEvents[0][m])) continue;
                    this.calculateEventStatsForCV(cacheEvents[0][m], cacheEvents[1][m]);
                }
            }
            double[][][] cacheEvents = paramData.getEvents(cachings * cacheStep, rest);
            for (int m = 0; m < rest; ++m) {
                if (!this.theGate.contains(cacheEvents[0][m])) continue;
                this.calculateEventStatsForCV(cacheEvents[0][m], cacheEvents[1][m]);
            }
        } else {
            int cacheStep = 100;
            int cachings = this.totalEvents / cacheStep;
            int rest = this.totalEvents % cacheStep;
            for (int i = 0; i < cachings; ++i) {
                double[][][] cacheEvents = paramData.getEvents(i * cacheStep, cacheStep);
                for (int m = 0; m < cacheStep; ++m) {
                    this.calculateEventStatsForCV(cacheEvents[0][m], cacheEvents[1][m]);
                }
            }
            double[][][] cacheEvents = paramData.getEvents(cachings * cacheStep, rest);
            for (int m = 0; m < rest; ++m) {
                this.calculateEventStatsForCV(cacheEvents[0][m], cacheEvents[1][m]);
            }
        }
    }

    private void addEventsWithMedian(FCS_data paramData) throws IOException {
        if (this.theGate != null) {
            int cacheStep = 100;
            int cachings = this.totalEvents / cacheStep;
            int rest = this.totalEvents % cacheStep;
            for (int i = 0; i < cachings; ++i) {
                double[][][] cacheEvents = paramData.getEvents(i * cacheStep, cacheStep);
                for (int m = 0; m < cacheStep; ++m) {
                    if (!this.theGate.contains(cacheEvents[0][m])) continue;
                    this.calculateEventStatsWithMedian(cacheEvents[0][m], cacheEvents[1][m]);
                }
            }
            double[][][] cacheEvents = paramData.getEvents(cachings * cacheStep, rest);
            for (int m = 0; m < rest; ++m) {
                if (!this.theGate.contains(cacheEvents[0][m])) continue;
                this.calculateEventStatsWithMedian(cacheEvents[0][m], cacheEvents[1][m]);
            }
        } else {
            int cacheStep = 100;
            int cachings = this.totalEvents / cacheStep;
            int rest = this.totalEvents % cacheStep;
            for (int i = 0; i < cachings; ++i) {
                double[][][] cacheEvents = paramData.getEvents(i * cacheStep, cacheStep);
                for (int m = 0; m < cacheStep; ++m) {
                    this.calculateEventStatsWithMedian(cacheEvents[0][m], cacheEvents[1][m]);
                }
            }
            double[][][] cacheEvents = paramData.getEvents(cachings * cacheStep, rest);
            for (int m = 0; m < rest; ++m) {
                this.calculateEventStatsWithMedian(cacheEvents[0][m], cacheEvents[1][m]);
            }
        }
    }

    private void calculateEventStatsWithMedian(double[] eventForDisplay, double[] eventForCalculation) throws IOException {
        this.allEventsStats.addEventWithMedian(eventForCalculation);
        if (this.calculateQuadrants) {
            int quadr = this.quadrant.getQuadrant(eventForDisplay[this.x_axis], eventForDisplay[this.y_axis]);
            this.quadrantStats[quadr].addEventWithMedian(eventForCalculation);
        }
        if (this.calculateRegions) {
            for (Integer regionNumber : this.theRaG.regionsContaining(eventForDisplay)) {
                this.regionStats[regionNumber].addEventWithMedian(eventForCalculation);
            }
        }
        if (this.calculateGates) {
            for (Integer gateNumber : this.theRaG.gatesContaining(eventForDisplay)) {
                this.gateStats[gateNumber].addEventWithMedian(eventForCalculation);
            }
        }
        if (this.calculateMarkers) {
            int m = this.markers.size();
            for (int i = 0; i < m; ++i) {
                FCS_marker currentMarker = this.markers.get(i);
                if (!currentMarker.contains(eventForDisplay[this.x_axis])) continue;
                this.markerStats[i].addEventWithMedian(eventForCalculation);
            }
        }
    }

    private void calculateEventStatsWithoutMedian(double[] eventForDisplay, double[] eventForCalculation) throws IOException {
        this.allEventsStats.addEventWithoutMedian(eventForCalculation);
        if (this.calculateQuadrants) {
            int quadr = this.quadrant.getQuadrant(eventForDisplay[this.x_axis], eventForDisplay[this.y_axis]);
            this.quadrantStats[quadr].addEventWithoutMedian(eventForCalculation);
        }
        if (this.calculateRegions) {
            for (Integer regionNumber : this.theRaG.regionsContaining(eventForDisplay)) {
                this.regionStats[regionNumber].addEventWithoutMedian(eventForCalculation);
            }
        }
        if (this.calculateGates) {
            for (Integer gateNumber : this.theRaG.gatesContaining(eventForDisplay)) {
                this.gateStats[gateNumber].addEventWithoutMedian(eventForCalculation);
            }
        }
        if (this.calculateMarkers) {
            int m = this.markers.size();
            for (int i = 0; i < m; ++i) {
                FCS_marker currentMarker = this.markers.get(i);
                if (!currentMarker.contains(eventForDisplay[this.x_axis])) continue;
                this.markerStats[i].addEventWithoutMedian(eventForCalculation);
            }
        }
    }

    private void calculateEventStatsForCV(double[] eventForDisplay, double[] eventForCalculation) throws IOException {
        this.allEventsStats.addEventForCV(eventForCalculation);
        if (this.calculateQuadrants) {
            int quadr = this.quadrant.getQuadrant(eventForDisplay[this.x_axis], eventForDisplay[this.y_axis]);
            this.quadrantStats[quadr].addEventForCV(eventForCalculation);
        }
        if (this.calculateRegions) {
            for (Integer regionNumber : this.theRaG.regionsContaining(eventForDisplay)) {
                this.regionStats[regionNumber].addEventForCV(eventForCalculation);
            }
        }
        if (this.calculateGates) {
            for (Integer gateNumber : this.theRaG.gatesContaining(eventForDisplay)) {
                this.gateStats[gateNumber].addEventForCV(eventForCalculation);
            }
        }
        if (this.calculateMarkers) {
            int m = this.markers.size();
            for (int i = 0; i < m; ++i) {
                FCS_marker currentMarker = this.markers.get(i);
                if (!currentMarker.contains(eventForDisplay[this.x_axis])) continue;
                this.markerStats[i].addEventForCV(eventForCalculation);
            }
        }
    }

    public String getStatistics(int statistics, int param, int type, int index) {
        if (param < 0 || param > this.paramCount) {
            throw new IllegalArgumentException();
        }
        if (statistics < 0 || statistics > 5) {
            throw new IllegalArgumentException();
        }
        int statToReturn = statistics;
        if (statistics == 3) {
            statToReturn = 3 + param;
        }
        if (statistics == 4) {
            statToReturn = 3 + this.paramCount + param;
        }
        if (statistics == 5) {
            statToReturn = 3 + this.paramCount + this.paramCount + param;
        }
        switch (type) {
            case 0: {
                if (index != 0) {
                    throw new IllegalArgumentException();
                }
                return this.allEventsStats.statistics[statToReturn];
            }
            case 1: {
                if (index != 0 && index != 1 && index != 2 && index != 3) {
                    throw new IllegalArgumentException();
                }
                return this.quadrantStats[index].statistics[statToReturn];
            }
            case 2: {
                if (index < 0 && index > this.regionStats.length) {
                    throw new IllegalArgumentException();
                }
                return this.regionStats[index].statistics[statToReturn];
            }
            case 3: {
                if (index < 0 && index > this.gateStats.length) {
                    throw new IllegalArgumentException();
                }
                return this.gateStats[index].statistics[statToReturn];
            }
            case 4: {
                if (index < 0 && index > this.markerStats.length) {
                    throw new IllegalArgumentException();
                }
                return this.markerStats[index].statistics[statToReturn];
            }
        }
        throw new IllegalArgumentException();
    }

    public float getParameterCount() {
        return this.paramCount;
    }

    public String getFileName() {
        return this.FileName;
    }

    public String getSampleDescription() {
        return this.SampleDesc;
    }

    public int getTotalEvents() {
        return this.totalEvents;
    }

    private class statHolder {
        private int eventCount = 0;
        private double percentOfGated;
        private double percentOfTotal;
        private final Double[] mean;
        private final Double[] CV;
        private final Double[] median;
        private BufferedOutputStream[] medianValuesOut;
        private File[] medianValuesFiles;
        private String[] statistics;
        private static final int countStringIndex = 0;
        private static final int percentOfGatedStringIndex = 1;
        private static final int percentOfTotalStringIndex = 2;
        private static final int meanStringIndex = 3;
        private int medianStringIndex;
        private int CVStringIndex;

        private statHolder() throws IOException {
            this.mean = new Double[FCS_statistics.this.paramCount];
            this.CV = new Double[FCS_statistics.this.paramCount];
            this.median = new Double[FCS_statistics.this.paramCount];
            this.medianValuesOut = new BufferedOutputStream[FCS_statistics.this.paramCount];
            this.medianValuesFiles = new File[FCS_statistics.this.paramCount];
            for (int i = 0; i < FCS_statistics.this.paramCount; ++i) {
                this.mean[i] = 0.0;
                this.CV[i] = 0.0;
                if (!FCS_statistics.this.calculateMedian) continue;
                this.medianValuesFiles[i] = File.createTempFile("FCSalyzer", null);
                this.medianValuesOut[i] = new BufferedOutputStream(new FileOutputStream(this.medianValuesFiles[i]));
            }
        }

        private void addEventWithMedian(double[] event) throws IOException {
            this.mean[0] = this.mean[0] + event[FCS_statistics.this.x_axis];
            BufferedOutputStream o = this.medianValuesOut[0];
            Long ev = Double.doubleToRawLongBits(event[FCS_statistics.this.x_axis]);
            ((OutputStream)o).write((int)(ev >>> 56) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 48) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 40) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 32) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 24) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 16) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 8) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 0) & 0xFF);
            this.mean[1] = this.mean[1] + event[FCS_statistics.this.y_axis];
            ev = Double.doubleToRawLongBits(event[FCS_statistics.this.y_axis]);
            o = this.medianValuesOut[1];
            ((OutputStream)o).write((int)(ev >>> 56) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 48) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 40) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 32) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 24) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 16) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 8) & 0xFF);
            ((OutputStream)o).write((int)(ev >>> 0) & 0xFF);
            ++this.eventCount;
        }

        private void addEventWithoutMedian(double[] event) throws IOException {
            this.mean[0] = this.mean[0] + event[FCS_statistics.this.x_axis];
            this.mean[1] = this.mean[1] + event[FCS_statistics.this.y_axis];
            ++this.eventCount;
        }

        private void addEventForCV(double[] event) throws IOException {
            double x = this.mean[0] - event[FCS_statistics.this.x_axis];
            double y = this.mean[1] - event[FCS_statistics.this.y_axis];
            x *= x;
            y *= y;
            this.CV[0] = this.CV[0] + x;
            this.CV[1] = this.CV[1] + y;
        }

        private boolean calculateStats(int gatedEvents, int totalEvents, NumberFormat numberFormatter) throws IOException {
            int i;
            boolean OutOfMemory = false;
            if (gatedEvents != 0) {
                this.percentOfGated = (double)this.eventCount / (double)gatedEvents * 100.0;
            }
            if (totalEvents != 0) {
                this.percentOfTotal = (double)this.eventCount / (double)totalEvents * 100.0;
            }
            for (i = 0; i < this.medianValuesOut.length; ++i) {
                if (this.medianValuesOut[i] == null) continue;
                this.medianValuesOut[i].close();
            }
            for (i = 0; i < FCS_statistics.this.paramCount; ++i) {
                if (this.eventCount == 0) {
                    this.mean[i] = null;
                    this.median[i] = null;
                    continue;
                }
                this.mean[i] = this.mean[i] / (double)this.eventCount;
                if (!FCS_statistics.this.calculateMedian) continue;
                try {
                    double[] medianValuesArray = new double[this.eventCount];
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.medianValuesFiles[i]));
                    for (int j = 0; j < this.eventCount; ++j) {
                        int ch1 = ((InputStream)in).read();
                        int ch2 = ((InputStream)in).read();
                        int ch3 = ((InputStream)in).read();
                        int ch4 = ((InputStream)in).read();
                        long lo1 = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
                        ch1 = ((InputStream)in).read();
                        ch2 = ((InputStream)in).read();
                        ch3 = ((InputStream)in).read();
                        ch4 = ((InputStream)in).read();
                        long lo2 = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
                        long lo3 = (lo1 << 32) + (lo2 & 0xFFFFFFFFL);
                        medianValuesArray[j] = Double.longBitsToDouble(lo3);
                    }
                    Arrays.sort(medianValuesArray);
                    this.median[i] = this.eventCount % 2 == 1 ? Double.valueOf(medianValuesArray[this.eventCount / 2]) : Double.valueOf((medianValuesArray[this.eventCount / 2 - 1] + medianValuesArray[this.eventCount / 2]) / 2.0);
                    ((InputStream)in).close();
                    continue;
                }
                catch (OutOfMemoryError o) {
                    OutOfMemory = true;
                }
            }
            for (i = 0; i < this.medianValuesFiles.length; ++i) {
                if (this.medianValuesOut[i] != null) {
                    this.medianValuesOut[i].close();
                }
                if (this.medianValuesFiles[i] == null) continue;
                this.medianValuesFiles[i].delete();
            }
            this.medianValuesOut = null;
            this.medianValuesFiles = null;
            this.statistics = new String[3 + FCS_statistics.this.paramCount + FCS_statistics.this.paramCount + FCS_statistics.this.paramCount];
            this.statistics[0] = String.valueOf(this.eventCount);
            this.statistics[1] = gatedEvents != 0 ? numberFormatter.format(this.percentOfGated) : "N/A";
            this.statistics[2] = totalEvents != 0 ? numberFormatter.format(this.percentOfTotal) : "N/A";
            this.medianStringIndex = 3 + FCS_statistics.this.paramCount;
            this.CVStringIndex = this.medianStringIndex + FCS_statistics.this.paramCount;
            for (i = 0; i < FCS_statistics.this.paramCount; ++i) {
                this.statistics[3 + i] = this.mean[i] == null ? "N/A" : numberFormatter.format(this.mean[i]);
                this.statistics[this.medianStringIndex + i] = this.median[i] == null ? "N/A" : numberFormatter.format(this.median[i]);
            }
            return !OutOfMemory;
        }

        private void calculateCV(NumberFormat numberFormatter) throws IOException {
            int i;
            for (i = 0; i < FCS_statistics.this.paramCount; ++i) {
                this.CV[i] = this.eventCount == 0 ? null : Double.valueOf(Math.sqrt(this.CV[i] / (double)this.eventCount) / Math.abs(this.mean[i]));
            }
            for (i = 0; i < FCS_statistics.this.paramCount; ++i) {
                this.statistics[this.CVStringIndex + i] = this.CV[i] == null ? "N/A" : numberFormatter.format(this.CV[i] * 100.0);
            }
        }
    }
}

