/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.GUI;

import FCSalyzer.FACS_objects.FACS_plot;
import FCSalyzer.FCS.FCS_data;
import FCSalyzer.GUI.mainFrame;
import FCSalyzer.Transform.Compensation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import staticStuff.Fileservice;
import staticStuff.staticImages;

public class plotFormatDialog
implements ActionListener,
WindowListener {
    private FACS_plot thePlot;
    private JTable theTable;
    private TableModel theTableModel;
    private final JButton CLOSE_Button = new JButton("OK");
    private final JButton ADD_Button = new JButton("Add overlay(s)");
    private final JButton REMOVE_Button = new JButton("Remove overlay");
    private final JDialog theDialog = new JDialog();
    private static final String CLOSE = "CLOSE";
    private static final String ADD = "ADD";
    private static final String REMOVE = "REMOVE";
    private static final String FILLED = "filled";
    private static final String MANUAL = "Manual value";
    private final JButton UP_Button = new JButton("Up");
    private final JButton DOWN_Button = new JButton("Down");
    private static final String UP = "UP";
    private static final String DOWN = "DOWN";
    private ArrayList<FCS_data> documentDatafiles;
    private List<Compensation> documentCompensations;
    private String[] colorTypes;
    private String[] scaleTypes = new String[]{"Local Maximum", "Global Maximum", "Manual Scale"};
    private String[] densityTypes = new String[]{"Event count", "One parameter value", "Three parameter values"};

    private plotFormatDialog() {
    }

    public plotFormatDialog(FACS_plot paramPlot, ArrayList<FCS_data> documentDatafiles, List<Compensation> documentCompensations, String[] gradients) {
        int i;
        this.documentDatafiles = documentDatafiles;
        this.documentCompensations = documentCompensations;
        this.thePlot = paramPlot;
        this.theDialog.setModal(true);
        this.theDialog.setTitle("Format plot");
        this.theDialog.setLayout(new BorderLayout());
        this.theDialog.addWindowListener(this);
        JPanel leftButtonPanel = new JPanel();
        leftButtonPanel.setLayout(new BoxLayout(leftButtonPanel, 1));
        leftButtonPanel.add(Box.createVerticalGlue());
        leftButtonPanel.add(this.UP_Button);
        this.UP_Button.addActionListener(this);
        this.UP_Button.setActionCommand(UP);
        leftButtonPanel.add(Box.createVerticalGlue());
        leftButtonPanel.add(this.DOWN_Button);
        this.DOWN_Button.addActionListener(this);
        this.DOWN_Button.setActionCommand(DOWN);
        leftButtonPanel.add(Box.createVerticalGlue());
        this.theDialog.add((Component)leftButtonPanel, "West");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.ADD_Button);
        this.ADD_Button.setActionCommand(ADD);
        this.ADD_Button.addActionListener(this);
        buttonPanel.add(this.CLOSE_Button);
        this.CLOSE_Button.setActionCommand(CLOSE);
        this.CLOSE_Button.addActionListener(this);
        buttonPanel.add(this.REMOVE_Button);
        this.REMOVE_Button.setActionCommand(REMOVE);
        this.REMOVE_Button.addActionListener(this);
        this.theDialog.add((Component)buttonPanel, "South");
        this.theDialog.setDefaultCloseOperation(2);
        this.theTable = new JTable();
        plotTableCellEditor pT = null;
        if (this.thePlot.isDensityPlot()) {
            this.colorTypes = new String[gradients.length + 2];
            this.colorTypes[0] = "Applied Gate Color -> White";
            this.colorTypes[1] = "User-defined Color -> White";
            for (i = 0; i < gradients.length; ++i) {
                this.colorTypes[i + 2] = gradients[i];
            }
            this.theTable.setModel(new densityTableModel());
            pT = new plotTableCellEditor(2);
        } else if (this.thePlot.isHistogram()) {
            this.colorTypes = new String[]{"Applied Gate Color", "User-defined Color"};
            this.theTable.setModel(new histogramTableModel());
            pT = new plotTableCellEditor(3);
        } else {
            this.colorTypes = new String[]{"Multigate Color", "Applied Gate Color", "User-defined Color"};
            this.theTable.setModel(new dotTableModel());
            pT = new plotTableCellEditor(0);
        }
        this.theTableModel = this.theTable.getModel();
        for (i = 0; i < this.theTableModel.getColumnCount(); ++i) {
            String col = this.theTableModel.getColumnName(i);
            if (col.equals(FILLED) || col.equals(MANUAL)) continue;
            this.theTable.getColumn(this.theTableModel.getColumnName(i)).setCellEditor(pT);
        }
        this.theTable.setSelectionMode(0);
        this.theTable.setColumnSelectionAllowed(false);
        this.theTable.setRowHeight(this.theTable.getRowHeight() + 5);
        JScrollPane theScroller = new JScrollPane(this.theTable);
        this.theDialog.add((Component)theScroller, "Center");
        this.theDialog.setLocationByPlatform(true);
        this.theDialog.setSize(800, 300);
    }

    public boolean showDialog() {
        this.theDialog.setVisible(true);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index;
        if (e.getActionCommand().equals(CLOSE)) {
            this.theDialog.setVisible(false);
            return;
        }
        if (e.getActionCommand().equals(ADD)) {
            ArrayList<FCS_data> correctFiles = new ArrayList<FCS_data>();
            File[] toOpen = Fileservice.getFiles();
            if (toOpen != null) {
                boolean couldntOpen = false;
                boolean notFCS = false;
                for (File current : toOpen) {
                    if (!current.isFile()) continue;
                    FCS_data theData = null;
                    try {
                        theData = FCS_data.openFCS_data(current, this.documentDatafiles, this.documentCompensations, true);
                    }
                    catch (IOException io) {
                        theData = null;
                        couldntOpen = true;
                    }
                    catch (DataFormatException de) {
                        theData = null;
                        notFCS = true;
                    }
                    if (theData == null) continue;
                    correctFiles.add(theData);
                }
                if (couldntOpen || notFCS) {
                    String message = "";
                    if (couldntOpen) {
                        message = "One or more file(s) could not be opened!";
                    }
                    if (notFCS) {
                        message = "Fileformat of one or more file(s) not supported!";
                    }
                    if (couldntOpen && notFCS) {
                        message = "One or more file(s) could not be opened!\nFileformat of one or more file(s) not supported!";
                    }
                    JOptionPane.showMessageDialog(null, message, "File Error", 0);
                }
                if (correctFiles.size() > 0) {
                    for (FCS_data currentData : correctFiles) {
                        this.thePlot.addOverlay(currentData);
                    }
                    this.theTable.tableChanged(new TableModelEvent(this.theTableModel));
                }
            }
        }
        if (e.getActionCommand().equals(REMOVE)) {
            int index2 = this.theTable.getSelectedRow();
            if (this.theTable.getRowCount() > 1 && index2 > -1) {
                this.thePlot.removeOverlay(index2);
                this.theTable.tableChanged(new TableModelEvent(this.theTableModel));
            }
        }
        if (e.getActionCommand().equals(UP) && (index = this.theTable.getSelectedRow()) > -1) {
            this.thePlot.moveOverlay(index, index - 1);
            this.theTable.tableChanged(new TableModelEvent(this.theTableModel));
        }
        if (e.getActionCommand().equals(DOWN) && (index = this.theTable.getSelectedRow()) > -1) {
            this.thePlot.moveOverlay(index, index + 1);
            this.theTable.tableChanged(new TableModelEvent(this.theTableModel));
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.theDialog.setVisible(false);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private class plotTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final int DOT = 0;
        private static final int DENSITY = 2;
        private static final int HISTOGRAMM = 3;
        private int type = 0;
        private final JColorChooser colorChooser = new JColorChooser();
        private final JButton colorButton = new JButton();
        private final JDialog colorDialog = JColorChooser.createDialog(this.colorButton, "Choose a Color", true, this.colorChooser, this, null);
        private int result = -1;
        private final JComboBox gateCombo;
        private final JComboBox eventCombo;
        private final JComboBox colorTypeCombo;
        private final JComboBox densityCombo;
        private final JComboBox scaleCombo;
        String[] allRegions;
        private final JComboBox stringCombo = new JComboBox();
        private final JComboBox imagesCombo = new JComboBox();
        private JComboBox multipleCombo;
        private JCheckBox filledBox = new JCheckBox();
        private JTextField manualInput = new JTextField();

        public plotTableCellEditor(int type) {
            this.type = type;
            String[] gates = plotFormatDialog.this.thePlot.getGates();
            String[] gateList = new String[gates.length + 1];
            gateList[0] = "-";
            for (int i = 0; i < gates.length; ++i) {
                gateList[i + 1] = gates[i];
            }
            this.gateCombo = new JComboBox<String>(gateList);
            this.gateCombo.setEditable(false);
            this.gateCombo.addActionListener(this);
            int regionsCount = plotFormatDialog.this.thePlot.getRaG().getRegionsCount();
            this.allRegions = new String[regionsCount];
            for (int i = 0; i < regionsCount; ++i) {
                this.allRegions[i] = plotFormatDialog.this.thePlot.getRaG().getRegion(i).getName();
            }
            this.eventCombo = new JComboBox<String>(mainFrame.stepStrings);
            this.eventCombo.setEditable(false);
            this.eventCombo.addActionListener(this);
            this.colorTypeCombo = new JComboBox<String>(plotFormatDialog.this.colorTypes);
            this.colorTypeCombo.setEditable(false);
            this.colorTypeCombo.addActionListener(this);
            this.densityCombo = new JComboBox<String>(plotFormatDialog.this.densityTypes);
            this.densityCombo.setEditable(false);
            this.densityCombo.addActionListener(this);
            this.scaleCombo = new JComboBox<String>(plotFormatDialog.this.scaleTypes);
            this.scaleCombo.setEditable(false);
            this.scaleCombo.addActionListener(this);
            this.stringCombo.setEditable(false);
            this.stringCombo.addActionListener(this);
            this.imagesCombo.setEditable(false);
            this.imagesCombo.addActionListener(this);
            this.colorButton.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            int toReturn = this.result;
            this.result = -1;
            return toReturn;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.type == 0) {
                switch (column) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        this.gateCombo.setSelectedItem(value);
                        return this.gateCombo;
                    }
                    case 2: {
                        ArrayList toDraw = plotFormatDialog.this.thePlot.getRegionToDraw();
                        JCheckBox[] j = new JCheckBox[this.allRegions.length];
                        for (int i = 0; i < this.allRegions.length; ++i) {
                            j[i] = new JCheckBox(this.allRegions[i]);
                            if (toDraw.contains(plotFormatDialog.this.thePlot.getRaG().getRegion(i))) {
                                j[i].setSelected(true);
                            }
                            int x = plotFormatDialog.this.thePlot.getParamX(0);
                            int y = plotFormatDialog.this.thePlot.getParamY(0);
                            if (plotFormatDialog.this.thePlot.getRaG().getRegion(i).getParamX() != x) {
                                j[i].setEnabled(false);
                            }
                            if (plotFormatDialog.this.thePlot.getRaG().getRegion(i).getParamY() == y) continue;
                            j[i].setEnabled(false);
                        }
                        this.multipleCombo = new JComboCheckBox(j);
                        this.multipleCombo.addActionListener(this);
                        this.multipleCombo.setActionCommand("Regions");
                        return this.multipleCombo;
                    }
                    case 3: {
                        this.eventCombo.setSelectedItem(value);
                        return this.eventCombo;
                    }
                    case 4: {
                        this.multipleCombo = this.stringCombo;
                        this.multipleCombo.removeAllItems();
                        for (String curr : plotFormatDialog.this.thePlot.getParameters(row)) {
                            this.multipleCombo.addItem(curr);
                        }
                        this.multipleCombo.setActionCommand("X");
                        this.multipleCombo.setSelectedItem(value);
                        return this.multipleCombo;
                    }
                    case 5: {
                        this.multipleCombo = this.stringCombo;
                        this.multipleCombo.removeAllItems();
                        for (String curr : plotFormatDialog.this.thePlot.getParameters(row)) {
                            this.multipleCombo.addItem(curr);
                        }
                        this.multipleCombo.setActionCommand("Y");
                        this.multipleCombo.setSelectedItem(value);
                        return this.multipleCombo;
                    }
                    case 6: {
                        this.colorTypeCombo.setSelectedItem(value);
                        return this.colorTypeCombo;
                    }
                    case 7: {
                        this.colorButton.setIcon((ImageIcon)value);
                        Image img = ((ImageIcon)value).getImage();
                        if (img instanceof BufferedImage) {
                            this.result = ((BufferedImage)img).getRGB(0, 0);
                        }
                        this.colorButton.setActionCommand("User color");
                        return this.colorButton;
                    }
                }
            } else if (this.type == 2) {
                switch (column) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        this.gateCombo.setSelectedItem(value);
                        return this.gateCombo;
                    }
                    case 2: {
                        ArrayList toDraw = plotFormatDialog.this.thePlot.getRegionToDraw();
                        JCheckBox[] j = new JCheckBox[this.allRegions.length];
                        for (int i = 0; i < this.allRegions.length; ++i) {
                            j[i] = new JCheckBox(this.allRegions[i]);
                            if (toDraw.contains(i)) {
                                j[i].setSelected(true);
                            }
                            int x = plotFormatDialog.this.thePlot.getParamX(0);
                            int y = plotFormatDialog.this.thePlot.getParamY(0);
                            if (plotFormatDialog.this.thePlot.getRaG().getRegion(i).getParamX() != x) {
                                j[i].setEnabled(false);
                            }
                            if (plotFormatDialog.this.thePlot.getRaG().getRegion(i).getParamY() == y) continue;
                            j[i].setEnabled(false);
                        }
                        this.multipleCombo = new JComboCheckBox(j);
                        this.multipleCombo.addActionListener(this);
                        this.multipleCombo.setActionCommand("Regions");
                        return this.multipleCombo;
                    }
                    case 3: {
                        this.multipleCombo = this.stringCombo;
                        this.multipleCombo.removeAllItems();
                        for (String curr : plotFormatDialog.this.thePlot.getParameters(row)) {
                            this.multipleCombo.addItem(curr);
                        }
                        this.multipleCombo.setActionCommand("X");
                        this.multipleCombo.setSelectedItem(value);
                        return this.multipleCombo;
                    }
                    case 4: {
                        this.multipleCombo = this.stringCombo;
                        this.multipleCombo.removeAllItems();
                        for (String curr : plotFormatDialog.this.thePlot.getParameters(row)) {
                            this.multipleCombo.addItem(curr);
                        }
                        this.multipleCombo.setActionCommand("Y");
                        this.multipleCombo.setSelectedItem(value);
                        return this.multipleCombo;
                    }
                    case 5: {
                        this.colorTypeCombo.setSelectedItem(value);
                        return this.colorTypeCombo;
                    }
                    case 6: {
                        this.colorButton.setIcon((ImageIcon)value);
                        Image img = ((ImageIcon)value).getImage();
                        if (img instanceof BufferedImage) {
                            this.result = ((BufferedImage)img).getRGB(0, 0);
                        }
                        this.colorButton.setActionCommand("User color");
                        return this.colorButton;
                    }
                    case 7: {
                        this.densityCombo.setSelectedItem(value);
                        return this.densityCombo;
                    }
                    case 8: {
                        this.multipleCombo = this.stringCombo;
                        this.multipleCombo.removeAllItems();
                        this.multipleCombo.addItem("-");
                        for (String curr : plotFormatDialog.this.thePlot.getParameters(row)) {
                            this.multipleCombo.addItem(curr);
                        }
                        this.multipleCombo.setActionCommand("D1");
                        this.multipleCombo.setSelectedItem(value);
                        return this.multipleCombo;
                    }
                    case 9: {
                        this.multipleCombo = this.stringCombo;
                        this.multipleCombo.removeAllItems();
                        this.multipleCombo.addItem("-");
                        for (String curr : plotFormatDialog.this.thePlot.getParameters(row)) {
                            this.multipleCombo.addItem(curr);
                        }
                        this.multipleCombo.setActionCommand("D2");
                        this.multipleCombo.setSelectedItem(value);
                        return this.multipleCombo;
                    }
                    case 10: {
                        this.multipleCombo = this.stringCombo;
                        this.multipleCombo.removeAllItems();
                        this.multipleCombo.addItem("-");
                        for (String curr : plotFormatDialog.this.thePlot.getParameters(row)) {
                            this.multipleCombo.addItem(curr);
                        }
                        this.multipleCombo.setActionCommand("D3");
                        this.multipleCombo.setSelectedItem(value);
                        return this.multipleCombo;
                    }
                }
            } else if (this.type == 3) {
                switch (column) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        this.gateCombo.setSelectedItem(value);
                        return this.gateCombo;
                    }
                    case 2: {
                        this.multipleCombo = this.stringCombo;
                        this.multipleCombo.removeAllItems();
                        for (String curr : plotFormatDialog.this.thePlot.getParameters(row)) {
                            this.multipleCombo.addItem(curr);
                        }
                        this.multipleCombo.setActionCommand("X");
                        this.multipleCombo.setSelectedItem(value);
                        return this.multipleCombo;
                    }
                    case 3: {
                        this.multipleCombo = this.imagesCombo;
                        this.multipleCombo.removeAllItems();
                        for (ImageIcon curr : staticImages.getInstance().lineStyles) {
                            this.multipleCombo.addItem(curr);
                        }
                        this.multipleCombo.setActionCommand("Line type");
                        this.multipleCombo.setSelectedItem(value);
                        return this.multipleCombo;
                    }
                    case 4: {
                        this.multipleCombo = this.imagesCombo;
                        this.multipleCombo.removeAllItems();
                        for (ImageIcon curr : staticImages.getInstance().lineWidths) {
                            this.multipleCombo.addItem(curr);
                        }
                        this.multipleCombo.setActionCommand("Line width");
                        this.multipleCombo.setSelectedItem(value);
                        return this.multipleCombo;
                    }
                    case 5: {
                        this.colorTypeCombo.setSelectedItem(value);
                        return this.colorTypeCombo;
                    }
                    case 6: {
                        this.colorButton.setIcon((ImageIcon)value);
                        Image img = ((ImageIcon)value).getImage();
                        if (img instanceof BufferedImage) {
                            this.result = ((BufferedImage)img).getRGB(0, 0);
                        }
                        this.colorButton.setActionCommand("Line color");
                        return this.colorButton;
                    }
                    case 8: {
                        this.colorButton.setIcon((ImageIcon)value);
                        Image img = ((ImageIcon)value).getImage();
                        if (img instanceof BufferedImage) {
                            this.result = ((BufferedImage)img).getRGB(0, 0);
                        }
                        this.colorButton.setActionCommand("Fill color");
                        return this.colorButton;
                    }
                    case 9: {
                        this.scaleCombo.setSelectedItem(value);
                        return this.scaleCombo;
                    }
                }
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("User color") || e.getActionCommand().equals("Line color") || e.getActionCommand().equals("Fill color")) {
                this.colorChooser.setColor(this.result);
                this.colorDialog.setVisible(true);
                this.result = this.colorChooser.getColor().getRGB();
                this.fireEditingStopped();
            } else if (e.getActionCommand().equals("OK")) {
                this.result = this.colorChooser.getColor().getRGB();
                this.fireEditingStopped();
            } else if (e.getActionCommand().equals("Regions")) {
                JComboCheckBox check;
                JCheckBox jcb;
                this.result = -1;
                Object source = e.getSource();
                if (source instanceof JComboCheckBox && (jcb = (JCheckBox)(check = (JComboCheckBox)source).getSelectedItem()).isEnabled()) {
                    this.result = check.getSelectedIndex();
                    jcb.setSelected(!jcb.isSelected());
                }
                this.fireEditingStopped();
            } else if (e.getSource() == this.gateCombo) {
                this.result = this.gateCombo.getSelectedIndex();
                this.fireEditingStopped();
            } else if (e.getSource() == this.eventCombo) {
                this.result = this.eventCombo.getSelectedIndex();
                this.fireEditingStopped();
            } else if (e.getSource() == this.colorTypeCombo) {
                this.result = this.colorTypeCombo.getSelectedIndex();
                this.fireEditingStopped();
            } else if (e.getSource() == this.densityCombo) {
                this.result = this.densityCombo.getSelectedIndex();
                this.fireEditingStopped();
            } else if (e.getSource() == this.scaleCombo) {
                this.result = this.scaleCombo.getSelectedIndex();
                this.fireEditingStopped();
            } else {
                this.result = this.multipleCombo.getSelectedIndex();
                this.fireEditingStopped();
            }
        }

        private class JComboCheckBox
        extends JComboBox {
            private int clickedItem;

            public JComboCheckBox(JCheckBox[] items) {
                super(items);
                this.clickedItem = -1;
                this.init();
            }

            private void init() {
                this.setRenderer(new ComboBoxRenderer());
            }

            private class ComboBoxRenderer
            implements ListCellRenderer {
                private JLabel label = new JLabel();

                public ComboBoxRenderer() {
                    JComboCheckBox.this.setOpaque(true);
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value instanceof Component) {
                        Component c = (Component)value;
                        if (isSelected) {
                            c.setBackground(list.getSelectionBackground());
                            c.setForeground(list.getSelectionForeground());
                        } else {
                            c.setBackground(list.getBackground());
                            c.setForeground(list.getForeground());
                        }
                        return c;
                    }
                    this.label.setText(value.toString());
                    return this.label;
                }
            }
        }
    }

    private class densityTableModel
    implements TableModel {
        private final ArrayList<TableModelListener> listener = new ArrayList();
        private final String[] colNames = new String[]{"File Name", "Gate", "Visible Regions", "X-Axis", "Y-Axis", "Gradient type", "User color", "Density Value", "Density Parameter 1", "Density Parameter 2", "Density Parameter 3"};

        private densityTableModel() {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listener.add(l);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 6) {
                return ImageIcon.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.colNames[columnIndex];
        }

        @Override
        public int getRowCount() {
            return plotFormatDialog.this.thePlot.getOverlayCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return plotFormatDialog.this.thePlot.getFileName(rowIndex);
                }
                case 1: {
                    int gateIndex = plotFormatDialog.this.thePlot.getGateIndex(rowIndex);
                    if (gateIndex < 0) {
                        return "-";
                    }
                    return plotFormatDialog.this.thePlot.getGates()[gateIndex];
                }
                case 2: {
                    if (rowIndex > 0) {
                        return "N/A";
                    }
                    return plotFormatDialog.this.thePlot.getRegionNamesToDraw();
                }
                case 3: {
                    return plotFormatDialog.this.thePlot.getParamXLabel(rowIndex);
                }
                case 4: {
                    return plotFormatDialog.this.thePlot.getParamYLabel(rowIndex);
                }
                case 5: {
                    return plotFormatDialog.this.colorTypes[plotFormatDialog.this.thePlot.getColorType(rowIndex) - 1];
                }
                case 6: {
                    return plotFormatDialog.this.thePlot.getUserColor(rowIndex);
                }
                case 7: {
                    switch (plotFormatDialog.this.thePlot.getDensityType(rowIndex)) {
                        case -1: {
                            return plotFormatDialog.this.densityTypes[0];
                        }
                        case -2: {
                            return plotFormatDialog.this.densityTypes[1];
                        }
                        case -3: {
                            return plotFormatDialog.this.densityTypes[2];
                        }
                    }
                    return "";
                }
                case 8: {
                    int param = plotFormatDialog.this.thePlot.getDensityParam(1, rowIndex);
                    if (param == -1) {
                        return "-";
                    }
                    return plotFormatDialog.this.thePlot.getParameters(rowIndex)[param];
                }
                case 9: {
                    int param = plotFormatDialog.this.thePlot.getDensityParam(2, rowIndex);
                    if (param == -1) {
                        return "-";
                    }
                    return plotFormatDialog.this.thePlot.getParameters(rowIndex)[param];
                }
                case 10: {
                    int param = plotFormatDialog.this.thePlot.getDensityParam(3, rowIndex);
                    if (param == -1) {
                        return "-";
                    }
                    return plotFormatDialog.this.thePlot.getParameters(rowIndex)[param];
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return false;
                }
                case 2: {
                    if (rowIndex <= 0 && plotFormatDialog.this.thePlot.getRaG().getRegionsCount() != 0) break;
                    return false;
                }
            }
            return true;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listener.remove(l);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return;
                }
                case 1: {
                    plotFormatDialog.this.thePlot.setGate(rowIndex, (Integer)aValue - 1);
                    return;
                }
                case 2: {
                    plotFormatDialog.this.thePlot.toggleRegionVisibility(rowIndex, (Integer)aValue);
                    return;
                }
                case 3: {
                    plotFormatDialog.this.thePlot.setXParameter(rowIndex, (Integer)aValue);
                    return;
                }
                case 4: {
                    plotFormatDialog.this.thePlot.setYParameter(rowIndex, (Integer)aValue);
                    return;
                }
                case 5: {
                    plotFormatDialog.this.thePlot.setColorType(rowIndex, (Integer)aValue + 1);
                    return;
                }
                case 6: {
                    plotFormatDialog.this.thePlot.setUserColor(rowIndex, (Integer)aValue);
                    return;
                }
                case 7: {
                    plotFormatDialog.this.thePlot.setDensityType(rowIndex, -1 - (Integer)aValue);
                    return;
                }
                case 8: {
                    plotFormatDialog.this.thePlot.setDensityParam(1, rowIndex, (Integer)aValue - 1);
                    return;
                }
                case 9: {
                    plotFormatDialog.this.thePlot.setDensityParam(2, rowIndex, (Integer)aValue - 1);
                    return;
                }
                case 10: {
                    plotFormatDialog.this.thePlot.setDensityParam(3, rowIndex, (Integer)aValue - 1);
                    return;
                }
            }
        }
    }

    private class dotTableModel
    implements TableModel {
        private final ArrayList<TableModelListener> listener = new ArrayList();
        private final String[] colNames = new String[]{"File Name", "Gate", "Visible Regions", "Events", "X-Axis", "Y-Axis", "Color type", "User color"};

        private dotTableModel() {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listener.add(l);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 7) {
                return ImageIcon.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.colNames[columnIndex];
        }

        @Override
        public int getRowCount() {
            return plotFormatDialog.this.thePlot.getOverlayCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return plotFormatDialog.this.thePlot.getFileName(rowIndex);
                }
                case 1: {
                    int gateIndex = plotFormatDialog.this.thePlot.getGateIndex(rowIndex);
                    if (gateIndex < 0) {
                        return "-";
                    }
                    return plotFormatDialog.this.thePlot.getGates()[gateIndex];
                }
                case 2: {
                    if (rowIndex > 0) {
                        return "N/A";
                    }
                    return plotFormatDialog.this.thePlot.getRegionNamesToDraw();
                }
                case 3: {
                    int percentage = plotFormatDialog.this.thePlot.getStep(rowIndex);
                    int indexForPercentage = 0;
                    int[] steps = mainFrame.step;
                    for (int i = 0; i < steps.length; ++i) {
                        if (percentage != steps[i]) continue;
                        indexForPercentage = i;
                    }
                    return mainFrame.stepStrings[indexForPercentage];
                }
                case 4: {
                    return plotFormatDialog.this.thePlot.getParamXLabel(rowIndex);
                }
                case 5: {
                    return plotFormatDialog.this.thePlot.getParamYLabel(rowIndex);
                }
                case 6: {
                    switch (plotFormatDialog.this.thePlot.getColorType(rowIndex)) {
                        case 0: {
                            return plotFormatDialog.this.colorTypes[0];
                        }
                        case 1: {
                            return plotFormatDialog.this.colorTypes[1];
                        }
                    }
                    return plotFormatDialog.this.colorTypes[2];
                }
                case 7: {
                    return plotFormatDialog.this.thePlot.getUserColor(rowIndex);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return false;
            }
            if (columnIndex == 2 && rowIndex > 0) {
                return false;
            }
            return columnIndex != 2 || plotFormatDialog.this.thePlot.getRaG().getRegionsCount() != 0;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listener.remove(l);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return;
                }
                case 1: {
                    plotFormatDialog.this.thePlot.setGate(rowIndex, (Integer)aValue - 1);
                    return;
                }
                case 2: {
                    plotFormatDialog.this.thePlot.toggleRegionVisibility(rowIndex, (Integer)aValue);
                    return;
                }
                case 3: {
                    Integer newStepIndex = (Integer)aValue;
                    plotFormatDialog.this.thePlot.setStepToShow(rowIndex, mainFrame.step[newStepIndex]);
                    return;
                }
                case 4: {
                    plotFormatDialog.this.thePlot.setXParameter(rowIndex, (Integer)aValue);
                    return;
                }
                case 5: {
                    plotFormatDialog.this.thePlot.setYParameter(rowIndex, (Integer)aValue);
                    return;
                }
                case 6: {
                    plotFormatDialog.this.thePlot.setColorType(rowIndex, (Integer)aValue);
                    return;
                }
                case 7: {
                    plotFormatDialog.this.thePlot.setUserColor(rowIndex, (Integer)aValue);
                    return;
                }
            }
        }
    }

    private class histogramTableModel
    implements TableModel {
        private final ArrayList<TableModelListener> listener = new ArrayList();
        private final String[] colNames = new String[]{"File Name", "Gate", "X-Axis", "Line Type", "Line Width", "Color Type", "Line Color", "filled", "Fill Color", "Scale Type", "Manual value"};

        private histogramTableModel() {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listener.add(l);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    return String.class;
                }
                case 3: 
                case 4: {
                    return ImageIcon.class;
                }
                case 5: {
                    return String.class;
                }
                case 6: {
                    return ImageIcon.class;
                }
                case 7: {
                    return Boolean.class;
                }
                case 8: {
                    return ImageIcon.class;
                }
                case 9: {
                    return String.class;
                }
                case 10: {
                    return Integer.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.colNames[columnIndex];
        }

        @Override
        public int getRowCount() {
            return plotFormatDialog.this.thePlot.getOverlayCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return plotFormatDialog.this.thePlot.getFileName(rowIndex);
                }
                case 1: {
                    int gateIndex = plotFormatDialog.this.thePlot.getGateIndex(rowIndex);
                    if (gateIndex < 0) {
                        return "-";
                    }
                    return plotFormatDialog.this.thePlot.getGates()[gateIndex];
                }
                case 2: {
                    return plotFormatDialog.this.thePlot.getParamXLabel(rowIndex);
                }
                case 3: {
                    return staticImages.getInstance().lineStyles[plotFormatDialog.this.thePlot.getLineType(rowIndex)];
                }
                case 4: {
                    return staticImages.getInstance().lineWidths[plotFormatDialog.this.thePlot.getLineWidth(rowIndex)];
                }
                case 5: {
                    if (plotFormatDialog.this.thePlot.getColorType(rowIndex) - 1 == 0) {
                        return plotFormatDialog.this.colorTypes[0];
                    }
                    return plotFormatDialog.this.colorTypes[1];
                }
                case 6: {
                    return plotFormatDialog.this.thePlot.getUserColor(rowIndex);
                }
                case 7: {
                    return plotFormatDialog.this.thePlot.isHistogramFilled(rowIndex);
                }
                case 8: {
                    return plotFormatDialog.this.thePlot.getFillColor(rowIndex);
                }
                case 9: {
                    switch (plotFormatDialog.this.thePlot.getScaleType(rowIndex)) {
                        case 0: {
                            return plotFormatDialog.this.scaleTypes[0];
                        }
                        case 1: {
                            return plotFormatDialog.this.scaleTypes[1];
                        }
                    }
                    return plotFormatDialog.this.scaleTypes[2];
                }
                case 10: {
                    return plotFormatDialog.this.thePlot.getManualScale(rowIndex);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listener.remove(l);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return;
                }
                case 1: {
                    plotFormatDialog.this.thePlot.setGate(rowIndex, (Integer)aValue - 1);
                    return;
                }
                case 2: {
                    plotFormatDialog.this.thePlot.setXParameter(rowIndex, (Integer)aValue);
                    return;
                }
                case 3: {
                    plotFormatDialog.this.thePlot.setLinePattern(rowIndex, (Integer)aValue);
                    return;
                }
                case 4: {
                    plotFormatDialog.this.thePlot.setLineWidth(rowIndex, (Integer)aValue);
                    return;
                }
                case 5: {
                    plotFormatDialog.this.thePlot.setColorType(rowIndex, (Integer)aValue + 1);
                    return;
                }
                case 6: {
                    plotFormatDialog.this.thePlot.setUserColor(rowIndex, (Integer)aValue);
                    return;
                }
                case 7: {
                    plotFormatDialog.this.thePlot.setHistogramFilled(rowIndex, (Boolean)aValue);
                    return;
                }
                case 8: {
                    plotFormatDialog.this.thePlot.setFillColor(rowIndex, (Integer)aValue);
                    return;
                }
                case 9: {
                    plotFormatDialog.this.thePlot.setScaleType(rowIndex, (Integer)aValue);
                    return;
                }
                case 10: {
                    plotFormatDialog.this.thePlot.setManualScale(rowIndex, (Integer)aValue);
                    return;
                }
            }
        }
    }
}

