/*
 * Decompiled with CFR 0.152.
 */
package FCSalyzer.FCS;

import FCSalyzer.FCS.attachData.definedTick;
import FCSalyzer.FCS.rawData.FCS_data_factory;
import FCSalyzer.FCS.rawData.FCS_datafile;
import FCSalyzer.GUI.FACS_document;
import FCSalyzer.Transform.ChannelTransform;
import FCSalyzer.Transform.Compensation;
import FCSalyzer.Transform.FCStransformer;
import FCSalyzer.Transform.LogicleTransformer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import javax.swing.JFileChooser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import staticStuff.staticMethods;

public class FCS_data {
    public static final int EVENT_FOR_DISPLAY = 0;
    public static final int EVENT_FOR_CALCULATION = 1;
    public static final int PARAM_ADD = 0;
    public static final int PARAM_SUBTRACT = 1;
    public static final int PARAM_MULTIPLY = 2;
    public static final int PARAM_DIVIDE = 3;
    private static final String[] parameterOps = new String[]{" + ", " - ", " x ", " / "};
    private ArrayList<FCS_data> documentFiles = null;
    private FCS_datafile theRawData = null;
    private Compensation comp = null;
    private ArrayList<parameterInfos> paramInfos = new ArrayList();
    public int saveOrder = -1;
    public static final String XML_name = "FCS_data";
    public static final String XML_index = "Index";
    private static final String XML_filename = "Name";
    private static final String XML_path = "Path";
    private static final String XML_comp = "Compensation";
    private static final String XML_att_params = "Attached_Parameters";
    private static final String XML_der_params = "Derived_Parameters";
    private static final String XML_params = "Parameters";
    private static final String XML_param_count = "Parameter_count";

    private FCS_data(FCS_datafile theFile, ArrayList<FCS_data> documentData) {
        this.theRawData = theFile;
        this.documentFiles = documentData;
        int paramCount = this.theRawData.getParameterCount();
        for (int i = 0; i < paramCount; ++i) {
            parameterInfos current = new parameterInfos();
            current.setup(this.theRawData, i);
            this.paramInfos.add(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FCS_data openFCS_data(File toOpen, ArrayList<FCS_data> documentDatafiles, List<Compensation> existingCompensations, boolean deriveInternalCompensation) throws IOException, DataFormatException {
        FCS_data toReturn = null;
        if (documentDatafiles != null) {
            ArrayList<FCS_data> arrayList = documentDatafiles;
            synchronized (arrayList) {
                FCS_datafile newFile = FCS_data_factory.getFCS_data(toOpen);
                for (FCS_data currDatafile : documentDatafiles) {
                    if (currDatafile.theRawData != newFile) continue;
                    toReturn = currDatafile;
                }
                if (toReturn == null) {
                    toReturn = new FCS_data(newFile, documentDatafiles);
                    if (deriveInternalCompensation && toReturn.hasInternalSpillover()) {
                        Compensation fileComp = null;
                        for (Compensation currComp : existingCompensations) {
                            if (!currComp.compareSpillover(toReturn.getInternalSpillover())) continue;
                            fileComp = currComp;
                        }
                        if (fileComp == null) {
                            fileComp = Compensation.generateCompensation("File Comp [" + newFile.getFileName() + "]", toReturn.getInternalSpillover());
                            existingCompensations.add(fileComp);
                        }
                        toReturn.setCompensation(fileComp);
                    }
                    documentDatafiles.add(toReturn);
                }
            }
        } else {
            FCS_datafile newFile = FCS_data_factory.getFCS_data(toOpen);
            toReturn = new FCS_data(newFile, null);
        }
        return toReturn;
    }

    public static FCS_data getDummyData(String name, String path, int i, ArrayList<FCS_data> documentDatafiles) {
        FCS_data toReturn = new FCS_data(FCS_data_factory.getDummyData(name, path, i), documentDatafiles);
        documentDatafiles.add(toReturn);
        return toReturn;
    }

    public boolean attachParameters(File[] toAttach, definedTick[][] defTicks) {
        int i;
        boolean toReturn = true;
        ArrayList<FCS_datafile> newParams = new ArrayList<FCS_datafile>();
        ArrayList<definedTick[]> newTicks = new ArrayList<definedTick[]>();
        for (i = 0; i < toAttach.length; ++i) {
            FCS_datafile newParam = null;
            try {
                newParam = FCS_data_factory.getFCS_data(toAttach[i]);
            }
            catch (DataFormatException df) {
                newParam = null;
            }
            catch (IOException ex) {
                newParam = null;
            }
            if (newParam == null) continue;
            newParams.add(newParam);
            newTicks.add(defTicks[i]);
        }
        if (!newParams.isEmpty()) {
            for (i = 0; i < newParams.size(); ++i) {
                parameterInfos newParamInfo = new parameterInfos();
                newParamInfo.attachedParam((FCS_datafile)newParams.get(i), 0);
                definedTick[] currTicks = (definedTick[])newTicks.get(i);
                for (int j = 0; j < currTicks.length; ++j) {
                    newParamInfo.addDefinedTick(currTicks[j].tick, currTicks[j].label);
                }
                this.paramInfos.add(newParamInfo);
            }
        }
        return toReturn;
    }

    public int getAttachedParameterCount() {
        int count = 0;
        for (parameterInfos currParam : this.paramInfos) {
            if (currParam.attachedParam == null) continue;
            ++count;
        }
        return count;
    }

    private void setAttachedParameters(int toAdd) {
        for (int i = 0; i < toAdd; ++i) {
            this.paramInfos.add(new parameterInfos());
        }
    }

    public int getDerivedParameterCount() {
        int count = 0;
        for (parameterInfos currParam : this.paramInfos) {
            if (currParam.derivParam == null) continue;
            ++count;
        }
        return count;
    }

    public String getAttachedParameterDescription(int index) {
        int count = -1;
        for (parameterInfos currParam : this.paramInfos) {
            if (currParam.attachedParam != null) {
                ++count;
            }
            if (count != index) continue;
            return currParam.description;
        }
        return "";
    }

    public double getAttachedParameterValue(int index, int event) {
        int count = -1;
        for (parameterInfos currParam : this.paramInfos) {
            if (currParam.attachedParam != null) {
                ++count;
            }
            if (count != index) continue;
            return currParam.attachedParam.getEvents(event, 1)[0][0];
        }
        return 0.0;
    }

    public double[][][] getEvents(int index, int count) {
        int currParam;
        int event;
        int event2;
        int currParam2;
        if (index + count > this.theRawData.getEventCount()) {
            throw new IndexOutOfBoundsException("One or more requested events do not exist in the data file");
        }
        if (count == 0) {
            return new double[2][0][0];
        }
        int rawDataParamCount = this.theRawData.getParameterCount();
        double[][] forCalculation = this.theRawData.getEvents(index, count);
        for (currParam2 = 0; currParam2 < rawDataParamCount; ++currParam2) {
            int mult = this.paramInfos.get((int)currParam2).multiplyBy;
            if (mult == 1) continue;
            for (event2 = 0; event2 < count; ++event2) {
                forCalculation[event2][currParam2] = forCalculation[event2][currParam2] * (double)mult;
            }
        }
        for (currParam2 = 0; currParam2 < rawDataParamCount; ++currParam2) {
            if (!this.paramInfos.get((int)currParam2).storedAsLog) continue;
            FCStransformer transformer = this.paramInfos.get((int)currParam2).deLogStoredData;
            for (event2 = 0; event2 < count; ++event2) {
                forCalculation[event2][currParam2] = transformer.inverse(forCalculation[event2][currParam2]);
            }
        }
        if (this.comp != null) {
            for (event = 0; event < count; ++event) {
                forCalculation[event] = this.comp.compensate(forCalculation[event]);
            }
        }
        if (this.getTotalParameterCount() > rawDataParamCount) {
            for (event = 0; event < count; ++event) {
                double[] currentEvent = forCalculation[event];
                double[] resultEvent = new double[this.getTotalParameterCount()];
                for (int currParam3 = 0; currParam3 < rawDataParamCount; ++currParam3) {
                    resultEvent[currParam3] = currentEvent[currParam3];
                }
                forCalculation[event] = resultEvent;
            }
            int m = this.getTotalParameterCount();
            for (currParam2 = this.getRawParameterCount(); currParam2 < m; ++currParam2) {
                if (this.paramInfos.get((int)currParam2).derivParam != null) {
                    derived_parameter currentP = this.paramInfos.get((int)currParam2).derivParam;
                    for (int k = 0; k < count; ++k) {
                        forCalculation[k][currParam2] = currentP.deriveParam(forCalculation[k]);
                    }
                    continue;
                }
                if (this.paramInfos.get((int)currParam2).attachedParam != null) {
                    FCS_datafile currentP = this.paramInfos.get((int)currParam2).attachedParam;
                    double[][] data = currentP.getEvents(index, count);
                    for (int event3 = 0; event3 < count; ++event3) {
                        forCalculation[event3][currParam2] = data[event3][0];
                    }
                    continue;
                }
                for (int event4 = 0; event4 < count; ++event4) {
                    forCalculation[event4][currParam2] = 0.0;
                }
            }
        }
        int totalParameterCount = forCalculation[0].length;
        double[][] forDisplay = new double[count][totalParameterCount];
        for (currParam = 0; currParam < totalParameterCount; ++currParam) {
            if (this.paramInfos.get((int)currParam).displayAsLog) {
                double range = this.getRange(currParam);
                FCStransformer transformer = this.paramInfos.get((int)currParam).transformerForDisplay;
                for (int event5 = 0; event5 < count; ++event5) {
                    forDisplay[event5][currParam] = transformer.scale(forCalculation[event5][currParam]) * range;
                }
                continue;
            }
            for (int event6 = 0; event6 < count; ++event6) {
                forDisplay[event6][currParam] = forCalculation[event6][currParam];
            }
        }
        for (currParam = 0; currParam < totalParameterCount; ++currParam) {
            double range = this.getRange(currParam);
            double factor = 4096.0 / range;
            for (int event7 = 0; event7 < count; ++event7) {
                forDisplay[event7][currParam] = forDisplay[event7][currParam] * factor;
                if (forDisplay[event7][currParam] < 0.0) {
                    forDisplay[event7][currParam] = 0.0;
                }
                if (!(forDisplay[event7][currParam] > 4095.0)) continue;
                forDisplay[event7][currParam] = 4095.0;
            }
        }
        double[][][] toReturn = new double[2][][];
        toReturn[1] = forCalculation;
        toReturn[0] = forDisplay;
        return toReturn;
    }

    public double[][] getRawEvents(int index, int count) {
        int eventCount = this.theRawData.getEventCount();
        if (index + count > eventCount) {
            throw new IndexOutOfBoundsException("One or more requested events do not exist in the data file");
        }
        if (count == 0) {
            return new double[0][0];
        }
        double[][] toReturn = this.theRawData.getEvents(index, count);
        return toReturn;
    }

    public double[] getRawEvent(int index) {
        int eventCount = this.theRawData.getEventCount();
        if (index > eventCount - 1) {
            throw new IndexOutOfBoundsException("One or more requested events do not exist in the data file");
        }
        return this.theRawData.getEvents(index, 1)[0];
    }

    public int getEventCount() {
        return this.theRawData.getEventCount();
    }

    public long getRange(int parameter) {
        return this.paramInfos.get((int)parameter).range;
    }

    public long getChannels(int parameter) {
        return this.paramInfos.get((int)parameter).channels;
    }

    public String getFileName() {
        return this.theRawData.getFileName();
    }

    public String getParameterName(int index) {
        return this.paramInfos.get((int)index).name;
    }

    public String getParameterDesc(int index) {
        String toReturn = this.paramInfos.get((int)index).description;
        if (index >= this.getRawParameterCount() && this.paramInfos.get((int)index).derivParam == null && this.paramInfos.get((int)index).attachedParam == null) {
            toReturn = "not found: " + toReturn;
        }
        return toReturn;
    }

    public String[] getParameterLabels() {
        String[] toReturn = new String[this.paramInfos.size()];
        for (int i = 0; i < toReturn.length; ++i) {
            toReturn[i] = this.getParameterDesc(i);
        }
        return toReturn;
    }

    public String getParameterLabel(int index) {
        return this.getParameterDesc(index);
    }

    public float getLogDecades(int index) {
        return this.paramInfos.get((int)index).logDecades;
    }

    public float getOffset(int index) {
        return this.paramInfos.get((int)index).offset;
    }

    public int getTotalParameterCount() {
        return this.paramInfos.size();
    }

    public String getDataFileName() {
        return this.theRawData.getDataFileName();
    }

    public String getDataFilePath() {
        return this.theRawData.getDataFilePath();
    }

    public ArrayList<String> getKeywordsDescription() {
        return this.theRawData.getKeywordsDescription();
    }

    public ArrayList<String> getKeywordsTEXT() {
        return this.theRawData.getKeywordsTEXT();
    }

    public ArrayList<String> getValuesTEXT() {
        return this.theRawData.getValuesTEXT();
    }

    public String getValueTEXT(int index) {
        return this.theRawData.getValueTEXT(index);
    }

    public String getValueTEXT(String annotationKeyword) {
        return this.theRawData.getValueTEXT(annotationKeyword);
    }

    public FCS_data getNextData(List<Compensation> existingComps, int step) {
        FCS_data toReturn = null;
        JFileChooser newChooser = new JFileChooser(this.getDataFilePath());
        Object[] filesInDir = newChooser.getCurrentDirectory().listFiles();
        Arrays.sort(filesInDir);
        int startIndex = 0;
        for (int i = 0; i < filesInDir.length; ++i) {
            if (!((File)filesInDir[i]).getName().equals(this.getDataFileName())) continue;
            startIndex = i;
            i = filesInDir.length;
        }
        int currentIndex = startIndex + step;
        while (toReturn == null) {
            if (currentIndex >= filesInDir.length) {
                currentIndex -= filesInDir.length;
            }
            try {
                toReturn = FCS_data.openFCS_data((File)filesInDir[currentIndex], this.documentFiles, existingComps, true);
            }
            catch (IOException ex) {
            }
            catch (DataFormatException ex) {
                // empty catch block
            }
            ++currentIndex;
        }
        return toReturn;
    }

    public FCS_data getPreviousDatafile(List<Compensation> existingComps, int step) {
        FCS_data toReturn = null;
        JFileChooser newChooser = new JFileChooser(this.getDataFilePath());
        Object[] filesInDir = newChooser.getCurrentDirectory().listFiles();
        Arrays.sort(filesInDir);
        int startIndex = 0;
        for (int i = 0; i < filesInDir.length; ++i) {
            if (!((File)filesInDir[i]).getName().equals(this.getDataFileName())) continue;
            startIndex = i;
            i = filesInDir.length;
        }
        int currentIndex = startIndex - step;
        while (toReturn == null) {
            if (currentIndex < 0) {
                currentIndex = filesInDir.length + currentIndex;
            }
            try {
                toReturn = FCS_data.openFCS_data((File)filesInDir[currentIndex], this.documentFiles, existingComps, true);
            }
            catch (IOException ex) {
            }
            catch (DataFormatException ex) {
                // empty catch block
            }
            --currentIndex;
        }
        return toReturn;
    }

    public String getSampleDescription() {
        String toReturn = this.getValueTEXT("SAMPLE ID");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        toReturn = this.getValueTEXT("TUBE NAME");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        toReturn = this.getValueTEXT("$SRC");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        toReturn = this.getValueTEXT("$SMNO");
        if (toReturn != null && !toReturn.isEmpty()) {
            return toReturn;
        }
        return this.getFileName();
    }

    public boolean isFloatData() {
        return this.theRawData.isFloatData();
    }

    public double getTransform(int param, double value) {
        return this.paramInfos.get((int)param).transformerForDisplay.scale(value) * (double)this.getRange(param);
    }

    public int getApproximateNegativeRange(int param) {
        if (this.paramInfos.get((int)param).displayAsLog) {
            return this.paramInfos.get((int)param).transformerForDisplay.getApproximateNegativeRange();
        }
        return 0;
    }

    public void removeAttachedParameters(Integer[] toRemove) {
        Arrays.sort((Object[])toRemove);
        block0: for (int i = toRemove.length - 1; i > -1; --i) {
            int count = -1;
            for (parameterInfos currParam : this.paramInfos) {
                if (currParam.attachedParam != null) {
                    ++count;
                }
                if (count != toRemove[i]) continue;
                this.paramInfos.remove(currParam);
                continue block0;
            }
        }
    }

    public void saveAttachedData(BufferedOutputStream out) throws IOException {
        out.write(staticMethods.intAsBytes(this.getAttachedParameterCount()));
        for (int i = 0; i < this.paramInfos.size(); ++i) {
            parameterInfos currParam = this.paramInfos.get(i);
            if (currParam.attachedParam == null) continue;
            out.write(i);
            currParam.attachedParam.saveTo(out);
        }
    }

    public boolean usesLogTransformation(int param) {
        if (this.paramInfos.get((int)param).transformerForDisplay == null) {
            return false;
        }
        return this.paramInfos.get((int)param).transformerForDisplay instanceof ChannelTransform;
    }

    public int getLogicle(int param) {
        if (this.paramInfos.get((int)param).displayAsLog) {
            return this.paramInfos.get((int)param).transformerForDisplay.getNegativePercentageIndex();
        }
        return -1;
    }

    public void setLogicle(int param, int new_index) {
        if (new_index < 0 || new_index >= LogicleTransformer.Zero_percentages.length) {
            return;
        }
        this.paramInfos.get((int)param).displayAsLog = true;
        long r = this.paramInfos.get((int)param).range;
        this.paramInfos.get((int)param).transformerForDisplay = LogicleTransformer.getLogicleTransformer(r, new_index);
    }

    public void setLog(int param) {
        long range = this.getRange(param);
        this.paramInfos.get((int)param).displayAsLog = true;
        if (this.paramInfos.get((int)param).deLogStoredData != null) {
            this.paramInfos.get((int)param).transformerForDisplay = this.paramInfos.get((int)param).deLogStoredData;
        } else {
            float logDecades = (float)Math.log10(range);
            int channels = (int)(Math.pow(10.0, logDecades) + 1.0);
            this.paramInfos.get((int)param).transformerForDisplay = ChannelTransform.getTransformer(1.0f, logDecades, channels);
        }
    }

    public void setLinear(int param) {
        this.paramInfos.get((int)param).displayAsLog = false;
        this.paramInfos.get((int)param).transformerForDisplay = null;
    }

    public boolean setCompensation(Object newComp) {
        if (newComp == null) {
            this.comp = null;
            return true;
        }
        if (newComp instanceof Compensation) {
            Compensation c = (Compensation)newComp;
            if (c.getParamCount() != this.getRawParameterCount()) {
                return false;
            }
            this.comp = (Compensation)newComp;
            return true;
        }
        return false;
    }

    public void removeComp(Compensation compensation) {
        if (this.comp == compensation) {
            this.comp = null;
        }
    }

    public Compensation getCompensation() {
        return this.comp;
    }

    public boolean displayAsLog(int param) {
        return this.paramInfos.get((int)param).displayAsLog;
    }

    public boolean hasInternalSpillover() {
        return this.theRawData.hasSpillover();
    }

    public int[][] getInternalSpillover() {
        return this.theRawData.getSpillover();
    }

    public void toXML(Node parent, int index, List<Compensation> documentComps) {
        Node d = staticMethods.addNode(parent, XML_name, null);
        staticMethods.addNode(d, XML_index, index);
        staticMethods.addNode(d, XML_filename, this.getDataFileName());
        staticMethods.addNode(d, XML_path, this.getDataFilePath());
        staticMethods.addNode(d, XML_comp, documentComps.indexOf(this.getCompensation()));
        Node derived = staticMethods.addNode(d, XML_der_params, null);
        staticMethods.addNode(derived, XML_param_count, this.getDerivedParameterCount());
        int m = this.getTotalParameterCount();
        for (int i = this.getRawParameterCount(); i < m; ++i) {
            if (this.paramInfos.get((int)i).derivParam == null) continue;
            this.paramInfos.get((int)i).derivParam.toXML(derived, i);
        }
        Node attached = staticMethods.addNode(d, XML_att_params, null);
        staticMethods.addNode(attached, XML_param_count, this.getAttachedParameterCount());
        int m2 = this.getTotalParameterCount();
        for (int i = this.getRawParameterCount(); i < m2; ++i) {
            if (this.paramInfos.get((int)i).attachedParam == null) continue;
            staticMethods.addNode(attached, XML_index, i);
        }
        Node params = staticMethods.addNode(d, XML_params, null);
        staticMethods.addNode(params, XML_param_count, this.getTotalParameterCount());
        int m3 = this.getTotalParameterCount();
        for (int i = 0; i < m3; ++i) {
            this.paramInfos.get(i).toXML(params, i);
        }
    }

    public static FCS_data fromXML(Node sourceNode, String oldPath, String oldFileSeparator, String currentPath, ArrayList<Compensation> theCompensations, ArrayList<FCS_data> documentData, ArrayList<FACS_document.attachedDataHolder> attachedData) {
        FCS_data toReturn;
        block38: {
            int i;
            NodeList nL;
            block37: {
                int i2;
                int i3;
                int k;
                int count;
                toReturn = null;
                nL = sourceNode.getChildNodes();
                Node oldFileNode = null;
                for (int i4 = 0; i4 < nL.getLength(); ++i4) {
                    if (!nL.item(i4).getNodeName().equals("File")) continue;
                    oldFileNode = nL.item(i4);
                }
                if (oldFileNode != null) {
                    nL = oldFileNode.getChildNodes();
                }
                String name = "";
                String path = "";
                int index = -1;
                for (int i5 = 0; i5 < nL.getLength(); ++i5) {
                    Node current = nL.item(i5);
                    if (current.getNodeName().equals(XML_filename)) {
                        name = staticMethods.getNodeText(current);
                        continue;
                    }
                    if (current.getNodeName().equals(XML_path)) {
                        path = staticMethods.getNodeText(current);
                        continue;
                    }
                    if (!current.getNodeName().equals(XML_index)) continue;
                    index = staticMethods.getNodeInteger(current, -1);
                }
                String currentFileSeparator = File.separator;
                if (!currentFileSeparator.equals(oldFileSeparator)) {
                    oldPath = oldPath.replaceAll(Matcher.quoteReplacement(oldFileSeparator), Matcher.quoteReplacement(currentFileSeparator));
                    path = path.replaceAll(Matcher.quoteReplacement(oldFileSeparator), Matcher.quoteReplacement(currentFileSeparator));
                }
                String[] oldPathParts = oldPath.split(Pattern.quote(currentFileSeparator));
                String[] filePathParts = path.split(Pattern.quote(currentFileSeparator));
                String[] currentPathParts = currentPath.split(Pattern.quote(currentFileSeparator));
                currentPathParts = Arrays.copyOf(currentPathParts, currentPathParts.length - 1);
                int partsCount = oldPathParts.length;
                if (partsCount > filePathParts.length) {
                    partsCount = filePathParts.length;
                }
                for (count = 0; count < partsCount && oldPathParts[count].equals(filePathParts[count]); ++count) {
                }
                int differenceOld = oldPathParts.length - count;
                int keepOfNew = currentPathParts.length - differenceOld;
                String newPath = "";
                for (k = 0; k < keepOfNew; ++k) {
                    newPath = newPath + currentFileSeparator + currentPathParts[k];
                }
                for (k = count; k < filePathParts.length; ++k) {
                    newPath = newPath + currentFileSeparator + filePathParts[k];
                }
                File toData = new File(newPath = newPath.substring(currentFileSeparator.length()), name);
                if (!toData.isFile()) {
                    currentPath = "";
                    for (String currentPathPart : currentPathParts) {
                        currentPath = currentPath + currentFileSeparator + currentPathPart;
                    }
                    toData = new File(currentPath = currentPath.substring(currentFileSeparator.length()), name);
                    if (!toData.isFile()) {
                        toData = new File(path, name);
                    }
                }
                if (toData.isFile()) {
                    try {
                        toReturn = FCS_data.openFCS_data(toData, documentData, theCompensations, false);
                    }
                    catch (IOException ex) {
                        toReturn = FCS_data.getDummyData(name, oldPath, 100, documentData);
                    }
                    catch (DataFormatException ex) {
                        toReturn = FCS_data.getDummyData(name, oldPath, 100, documentData);
                    }
                } else {
                    toReturn = FCS_data.getDummyData(name, oldPath, 100, documentData);
                }
                toReturn.saveOrder = index;
                ArrayList<Integer> derivedIndices = new ArrayList<Integer>();
                ArrayList<parameterInfos> derivedParams = new ArrayList<parameterInfos>();
                for (int i6 = 0; i6 < nL.getLength(); ++i6) {
                    Node current = nL.item(i6);
                    if (!current.getNodeName().equals(XML_der_params)) continue;
                    NodeList nL2 = nL.item(i6).getChildNodes();
                    for (int j = 0; j < nL2.getLength(); ++j) {
                        Node curr2 = nL2.item(j);
                        if (!curr2.getNodeName().equals("Derived_Parameter")) continue;
                        toReturn.deriveParameter(derived_parameter.fromXML(curr2));
                        derivedParams.add(toReturn.paramInfos.get(toReturn.paramInfos.size() - 1));
                        NodeList nL3 = curr2.getChildNodes();
                        for (int k2 = 0; k2 < nL3.getLength(); ++k2) {
                            Node curr3 = nL3.item(k2);
                            if (!curr3.getNodeName().equals(XML_index)) continue;
                            derivedIndices.add(staticMethods.getNodeInteger(curr3, -1));
                        }
                    }
                }
                ArrayList<parameterInfos> attachedParams = new ArrayList<parameterInfos>();
                for (i3 = 0; i3 < nL.getLength(); ++i3) {
                    Node current = nL.item(i3);
                    if (!current.getNodeName().equals(XML_att_params)) continue;
                    NodeList nL2 = nL.item(i3).getChildNodes();
                    for (int j = 0; j < nL2.getLength(); ++j) {
                        Node curr2 = nL2.item(j);
                        if (!curr2.getNodeName().equals(XML_param_count)) continue;
                        int paramCount = staticMethods.getNodeInteger(curr2, 0);
                        int startParam = toReturn.paramInfos.size();
                        toReturn.setAttachedParameters(paramCount);
                        for (int k3 = startParam; k3 < toReturn.paramInfos.size(); ++k3) {
                            attachedParams.add(toReturn.paramInfos.get(k3));
                        }
                    }
                }
                for (i3 = toReturn.getRawParameterCount(); i3 < toReturn.paramInfos.size(); ++i3) {
                    if (derivedIndices.contains(i3)) {
                        int d = derivedIndices.indexOf(i3);
                        parameterInfos currParam = (parameterInfos)derivedParams.get(d);
                        toReturn.paramInfos.set(i3, currParam);
                        continue;
                    }
                    parameterInfos currParam = (parameterInfos)attachedParams.get(0);
                    toReturn.paramInfos.set(i3, currParam);
                    attachedParams.remove(0);
                }
                for (i3 = 0; i3 < nL.getLength(); ++i3) {
                    int comp;
                    Node current = nL.item(i3);
                    if (!current.getNodeName().equals(XML_comp) || (comp = staticMethods.getNodeInteger(current, -1).intValue()) <= -1) continue;
                    toReturn.setCompensation(theCompensations.get(comp));
                }
                if (oldFileNode == null) break block37;
                Node transf = null;
                for (i2 = 0; i2 < nL.getLength(); ++i2) {
                    if (!nL.item(i2).getNodeName().equals("Transformations")) continue;
                    transf = nL.item(i2);
                }
                if (transf == null) break block38;
                nL = transf.getChildNodes();
                for (i2 = 0; i2 < nL.getLength(); ++i2) {
                    Node current = nL.item(i2);
                    if (!current.getNodeName().startsWith("Parameter_") || current.getNodeName().startsWith(XML_param_count)) continue;
                    int param = Integer.valueOf(current.getNodeName().substring(10));
                    int currT = staticMethods.getNodeInteger(current, -1);
                    if (currT == -1) {
                        toReturn.setLinear(param);
                        continue;
                    }
                    if (currT == -2) {
                        toReturn.setLog(param);
                        continue;
                    }
                    toReturn.setLogicle(param, currT);
                }
                break block38;
            }
            Node params = null;
            for (i = 0; i < nL.getLength(); ++i) {
                if (!nL.item(i).getNodeName().equals(XML_params)) continue;
                params = nL.item(i);
            }
            if (params != null) {
                nL = params.getChildNodes();
                for (i = 0; i < nL.getLength(); ++i) {
                    Node current = nL.item(i);
                    if (!current.getNodeName().equals("Parameter")) continue;
                    NodeList currL = current.getChildNodes();
                    int currP = 0;
                    for (int j = 0; j < currL.getLength(); ++j) {
                        if (!currL.item(j).getNodeName().equals(XML_index)) continue;
                        currP = staticMethods.getNodeInteger(currL.item(j), 0);
                    }
                    if (toReturn.paramInfos.get((int)currP).derivParam == null && currP >= toReturn.getRawParameterCount()) {
                        for (FACS_document.attachedDataHolder currHolder : attachedData) {
                            if (!currHolder.indicesCorrect(toReturn.saveOrder, currP)) continue;
                            parameterInfos currParam = toReturn.paramInfos.get(currP);
                            currParam.attachedParam(currHolder.getData(), 0);
                        }
                    }
                    toReturn.paramInfos.get(currP).setInfos(current);
                }
            }
        }
        return toReturn;
    }

    public void setParameterDesc(int param, String newDesc) {
        this.paramInfos.get((int)param).description = newDesc;
    }

    public int getMultiplyBy(int param) {
        return this.paramInfos.get((int)param).multiplyBy;
    }

    public void setMultiplyBy(int param, int newValue) {
        this.paramInfos.get((int)param).multiplyBy = newValue;
    }

    public void deriveParameter(int param1, int param2, double manual, int type, long range, double adjust, double div_zero, String desc) {
        derived_parameter newP = new derived_parameter(param1, param2, manual, type, div_zero, range, adjust, desc);
        this.deriveParameter(newP);
    }

    public void deriveParameter(derived_parameter newParam) {
        parameterInfos newP = new parameterInfos();
        newP.derivParam = newParam;
        newP.range = newP.derivParam.range;
        newP.description = newP.derivParam.description;
        newP.name = newP.derivParam.description;
        this.paramInfos.add(newP);
    }

    public void removeDerivedParameter(int toDelete) {
        int count = -1;
        for (parameterInfos currParam : this.paramInfos) {
            if (currParam.derivParam != null) {
                ++count;
            }
            if (count != toDelete) continue;
            this.paramInfos.remove(currParam);
            return;
        }
    }

    public int getRawParameterCount() {
        return this.theRawData.getParameterCount();
    }

    public String[] getDerivedParameterDefinitions() {
        ArrayList<String> collection = new ArrayList<String>();
        for (parameterInfos currParam : this.paramInfos) {
            if (currParam.derivParam == null) continue;
            derived_parameter currP = currParam.derivParam;
            String param2 = "";
            param2 = currP.param_2 != -1 ? this.getParameterDesc(currP.param_2) : String.valueOf(currP.manual);
            collection.add(currP.description + ": (" + this.getParameterDesc(currP.param_1) + parameterOps[currP.operation] + param2 + ")/" + currP.rangeFactor + "; max=" + currP.range);
        }
        String[] desc = new String[collection.size()];
        for (int i = 0; i < desc.length; ++i) {
            desc[i] = (String)collection.get(i);
        }
        return desc;
    }

    public int getParameterTransformationValue(int param) {
        return this.paramInfos.get(param).getTransformationValue();
    }

    public void setParameterTransformationByValue(int param, int transformation) {
        this.paramInfos.get(param).setTransformation(param, transformation);
    }

    public definedTick[] getDefinedTicks(int param) {
        if (param < 0 || param >= this.getTotalParameterCount()) {
            return new definedTick[0];
        }
        return this.paramInfos.get(param).getDefinedTicks().toArray(new definedTick[0]);
    }

    public void addDefinedTick(int param, float tick, String label) {
        if (param < 0 || param >= this.getTotalParameterCount()) {
            return;
        }
        this.paramInfos.get(param).addDefinedTick(tick, label);
    }

    private class parameterInfos {
        public FCStransformer deLogStoredData = null;
        public FCStransformer transformerForDisplay = null;
        public boolean storedAsLog = false;
        public boolean displayAsLog = false;
        public String description = "";
        public String name = "";
        public int multiplyBy = 1;
        public long range = 0L;
        public long channels = 0L;
        public derived_parameter derivParam = null;
        public FCS_datafile attachedParam = null;
        public float logDecades;
        public float offset;
        public static final String XML_name = "Parameter";
        public static final String XML_index = "Index";
        public static final String XML_transf = "Transformation";
        public static final String XML_param_desc = "Parameter_Description";
        public static final String XML_param_mult = "Parameter_Multiplier";
        public static final String XML_def_tick = "Defined_Ticks";
        public static final String XML_def_count = "Count";
        public ArrayList<definedTick> definedTicks = new ArrayList();

        private void attachedParam(FCS_datafile currParam, int i) {
            this.setup(currParam, i);
            this.attachedParam = currParam;
        }

        private void addDefinedTick(float tick, String label) {
            this.definedTicks.add(new definedTick(tick, label));
        }

        private ArrayList<definedTick> getDefinedTicks() {
            return this.definedTicks;
        }

        private void setup(FCS_datafile theRawData, int i) {
            this.description = theRawData.getParameterLabel(i);
            this.name = theRawData.getParameterName(i);
            this.channels = this.range = theRawData.getRange(i);
            if (theRawData.parameterIsStoredAsLog(i)) {
                this.logDecades = theRawData.getLogDecades(i);
                this.offset = theRawData.getOffset(i);
            }
            if (!theRawData.parameterIsStoredAsLog(i)) {
                if (theRawData.isFloatData()) {
                    this.transformerForDisplay = LogicleTransformer.getLogicleTransformer(this.range);
                } else {
                    this.displayAsLog = true;
                    float logD = (float)Math.log10(this.range);
                    int chann = (int)(Math.pow(10.0, this.logDecades) + 1.0);
                    this.transformerForDisplay = ChannelTransform.getTransformer(1.0f, logD, chann);
                }
            } else {
                this.transformerForDisplay = this.deLogStoredData = ChannelTransform.getTransformer(this.offset, this.logDecades, this.range);
            }
            this.storedAsLog = theRawData.parameterIsStoredAsLog(i);
            this.displayAsLog = theRawData.displayParamAsLog(i);
            this.logDecades = theRawData.getLogDecades(i);
            this.offset = theRawData.getOffset(i);
            if (theRawData.getParameterName(i).startsWith("FL")) {
                this.displayAsLog = true;
            }
            this.multiplyBy = 1;
            if (theRawData.isMQD()) {
                this.multiplyBy = 1000;
            }
            this.range = theRawData.getRange(i);
            if (theRawData.parameterIsStoredAsLog(i)) {
                double decades = theRawData.getLogDecades(i);
                double toReturn = Math.pow(10.0, decades);
                this.range = (int)(toReturn *= (double)theRawData.getOffset(i));
                if ((double)this.range < toReturn) {
                    ++this.range;
                }
            }
        }

        public void toXML(Node parent, int index) {
            Node der = staticMethods.addNode(parent, XML_name, null);
            staticMethods.addNode(der, "Index", index);
            staticMethods.addNode(der, XML_transf, this.getTransformationValue());
            staticMethods.addNode(der, XML_param_desc, this.description);
            staticMethods.addNode(der, XML_param_mult, this.multiplyBy);
            Node def = staticMethods.addNode(der, XML_def_tick, null);
            staticMethods.addNode(def, XML_def_count, this.definedTicks.size());
            for (definedTick currentTick : this.definedTicks) {
                currentTick.toXML(def);
            }
        }

        public int getTransformationValue() {
            int t = -1;
            if (this.displayAsLog) {
                t = this.transformerForDisplay.getNegativePercentageIndex();
            }
            return t;
        }

        public void setInfos(Node theData) {
            NodeList nL = theData.getChildNodes();
            for (int i = 0; i < nL.getLength(); ++i) {
                Node curr2;
                int j;
                Node current = nL.item(i);
                if (current.getNodeName().equals(XML_param_desc)) {
                    this.description = staticMethods.getNodeText(current);
                    continue;
                }
                if (current.getNodeName().equals(XML_param_mult)) {
                    this.multiplyBy = staticMethods.getNodeInteger(current, this.multiplyBy);
                    continue;
                }
                if (current.getNodeName().equals(XML_transf)) {
                    int param = 0;
                    for (j = 0; j < nL.getLength(); ++j) {
                        curr2 = nL.item(j);
                        if (!curr2.getNodeName().equals("Index")) continue;
                        param = staticMethods.getNodeInteger(curr2, param);
                    }
                    int currT = staticMethods.getNodeInteger(current, 0);
                    this.setTransformation(param, currT);
                    continue;
                }
                if (!current.getNodeName().equals(XML_def_tick)) continue;
                NodeList nL2 = current.getChildNodes();
                for (j = 0; j < nL2.getLength(); ++j) {
                    curr2 = nL2.item(j);
                    if (!curr2.getNodeName().equals("Defined_Tick")) continue;
                    definedTick currentTick = definedTick.fromXML(curr2);
                    this.addDefinedTick(currentTick.tick, currentTick.label);
                }
            }
        }

        public void setTransformation(int param, int currT) {
            if (currT == -1) {
                FCS_data.this.setLinear(param);
            } else if (currT == -2) {
                FCS_data.this.setLog(param);
            } else {
                FCS_data.this.setLogicle(param, currT);
            }
        }
    }

    private static class derived_parameter {
        public static final int ADD = 0;
        public static final int SUBTRACT = 1;
        public static final int MULTIPLY = 2;
        public static final int DIVIDE = 3;
        public static final int PCA = 4;
        private int param_1 = 0;
        private int param_2 = 0;
        private double manual = 0.0;
        private int operation = 0;
        private double div_zero = Double.MAX_VALUE;
        private String description = "";
        private long range = 0L;
        private double rangeFactor = 1.0;
        private double[] PCA_factors = null;
        public static final String XML_name = "Derived_Parameter";
        private static final String XML_index = "Index";
        private static final String XML_param1 = "Param_1";
        private static final String XML_param2 = "Param_2";
        private static final String XML_manual = "Manual_Value";
        private static final String XML_operation = "Operation";
        private static final String XML_divZero = "Division_by_Zero";
        private static final String XML_desc = "Description";
        private static final String XML_range = "Range";
        private static final String XML_rangeFactor = "Range_Factor";
        private static final String XML_PCA_Factors = "PCA_factors";
        private static final String XML_PCA_Factor = "PCA_factor_";

        public derived_parameter(int firstParameter, int secondParameter, double manual, int type, double div_zero_value, long range, double adjust, String desc) {
            this.param_1 = firstParameter;
            this.param_2 = secondParameter;
            if (type == 1 || type == 2 || type == 3) {
                this.operation = type;
            }
            this.div_zero = div_zero_value;
            this.description = desc;
            this.range = range;
            this.rangeFactor = adjust;
            this.manual = manual;
        }

        public derived_parameter(double[] factors, long range, double adjust, String desc) {
            this.operation = 4;
            this.description = desc;
            this.range = range;
            this.rangeFactor = adjust;
            this.PCA_factors = Arrays.copyOf(factors, factors.length);
        }

        public double deriveParam(double[] event) {
            if (this.operation == 4) {
                double resultEvent = 0.0;
                if (event.length != this.PCA_factors.length) {
                    return resultEvent;
                }
                for (int i = 0; i < event.length; ++i) {
                    resultEvent += event[i] * this.PCA_factors[i];
                }
                return resultEvent;
            }
            double resultEvent = 0.0;
            if (this.param_1 >= event.length || this.param_2 >= event.length) {
                return resultEvent;
            }
            double use = this.manual;
            if (this.param_2 != -1) {
                use = event[this.param_2];
            }
            switch (this.operation) {
                case 0: {
                    resultEvent = event[this.param_1] + use;
                    break;
                }
                case 1: {
                    resultEvent = event[this.param_1] - use;
                    break;
                }
                case 2: {
                    resultEvent = event[this.param_1] * use;
                    break;
                }
                case 3: {
                    resultEvent = use == 0.0 ? this.div_zero : event[this.param_1] / use;
                }
            }
            resultEvent /= this.rangeFactor;
            if (resultEvent > (double)this.range) {
                resultEvent = this.range;
            }
            return resultEvent;
        }

        public int getType() {
            return this.operation;
        }

        public int getFirstParam() {
            return this.param_1;
        }

        public int getSecondParam() {
            return this.param_1;
        }

        public double getManual() {
            return this.manual;
        }

        public double getDivisionByZeroValue() {
            return this.div_zero;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String newDescr) {
            this.description = newDescr;
        }

        public void toXML(Node parent, int index) {
            Node der = staticMethods.addNode(parent, XML_name, null);
            staticMethods.addNode(der, XML_operation, this.operation);
            staticMethods.addNode(der, "Index", index);
            staticMethods.addNode(der, XML_desc, this.description);
            staticMethods.addNode(der, XML_range, this.range);
            staticMethods.addNode(der, XML_rangeFactor, this.rangeFactor);
            if (this.operation == 4) {
                Node PCA = staticMethods.addNode(der, XML_PCA_Factors, null);
                for (int i = 0; i < this.PCA_factors.length - 1; ++i) {
                    staticMethods.addNode(PCA, XML_PCA_Factor + i, this.PCA_factors[i]);
                }
            } else {
                staticMethods.addNode(der, XML_param1, this.param_1);
                staticMethods.addNode(der, XML_param2, this.param_2);
                staticMethods.addNode(der, XML_manual, this.manual);
                staticMethods.addNode(der, XML_divZero, this.div_zero);
            }
        }

        public static derived_parameter fromXML(Node sourceNode) {
            NodeList nL = sourceNode.getChildNodes();
            int p1 = 0;
            int p2 = 0;
            int op = 0;
            double m = 0.0;
            double dz = 0.0;
            double rf = 0.0;
            String desc = "";
            long r = 0L;
            ArrayList<Double> factors = new ArrayList<Double>();
            for (int i = 0; i < nL.getLength(); ++i) {
                Node current = nL.item(i);
                if (current.getNodeName().equals(XML_param1)) {
                    p1 = staticMethods.getNodeInteger(current, 0);
                    continue;
                }
                if (current.getNodeName().equals(XML_param2)) {
                    p2 = staticMethods.getNodeInteger(current, 0);
                    continue;
                }
                if (current.getNodeName().equals(XML_manual)) {
                    m = staticMethods.getNodeDouble(current, 0.0);
                    continue;
                }
                if (current.getNodeName().equals(XML_operation)) {
                    op = staticMethods.getNodeInteger(current, 0);
                    continue;
                }
                if (current.getNodeName().equals(XML_divZero)) {
                    dz = staticMethods.getNodeDouble(current, 0.0);
                    continue;
                }
                if (current.getNodeName().equals(XML_desc)) {
                    desc = staticMethods.getNodeText(current);
                    continue;
                }
                if (current.getNodeName().equals(XML_range)) {
                    r = staticMethods.getNodeLong(current, 0L);
                    continue;
                }
                if (current.getNodeName().equals(XML_rangeFactor)) {
                    rf = staticMethods.getNodeDouble(current, 0.0);
                    continue;
                }
                if (!current.getNodeName().equals(XML_PCA_Factors)) continue;
                NodeList nL2 = current.getChildNodes();
                for (int j = 0; j < nL2.getLength(); ++j) {
                    Node c2 = nL2.item(j);
                    if (!c2.getNodeName().startsWith(XML_PCA_Factor)) continue;
                    factors.add(staticMethods.getNodeDouble(c2, 0.0));
                }
            }
            if (op == 4) {
                double[] facs = new double[factors.size()];
                for (int i = 0; i < facs.length; ++i) {
                    facs[i] = (Double)factors.get(i);
                }
                return new derived_parameter(facs, r, rf, desc);
            }
            return new derived_parameter(p1, p2, m, op, dz, r, rf, desc);
        }
    }
}

