/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.http;

import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class CookieUtility {
    private final Map<String, String> map = new HashMap<String, String>();

    public Map<String, String> getMap() {
        return this.map;
    }

    public void loadCookies(URLConnection http) {
        String str;
        int n = 1;
        do {
            if ((str = http.getHeaderFieldKey(n)) != null && str.equalsIgnoreCase("Set-Cookie")) {
                str = http.getHeaderField(n);
                StringTokenizer tok = new StringTokenizer(str, "=");
                String name = tok.nextToken();
                String value = tok.nextToken();
                this.map.put(name, value);
            }
            ++n;
        } while (str != null);
    }

    public void saveCookies(URLConnection http) {
        StringBuilder str = new StringBuilder();
        Set<String> set = this.map.keySet();
        for (String key : set) {
            String value = this.map.get(key);
            if (str.length() > 0) {
                str.append("; ");
            }
            str.append(key + "=" + value);
        }
        http.setRequestProperty("Cookie", str.toString());
    }
}

