/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.rbf.training;

import org.encog.mathutil.rbf.RadialBasisFunction;

public class SVD {
    public static double svdfit(double[][] x, double[][] y, double[][] a, RadialBasisFunction[] funcs) {
        int j;
        int i;
        double TOL = 1.0E-13;
        double[][] u = new double[x.length][funcs.length];
        double[][] v = new double[funcs.length][funcs.length];
        double[] w = new double[funcs.length];
        for (i = 0; i < x.length; ++i) {
            for (j = 0; j < funcs.length; ++j) {
                u[i][j] = funcs[j].calculate(x[i]);
            }
        }
        SVD.svdcmp(u, w, v);
        double wmax = 0.0;
        for (j = 0; j < funcs.length; ++j) {
            if (!(w[j] > wmax)) continue;
            wmax = w[j];
        }
        double thresh = TOL * wmax;
        for (j = 0; j < funcs.length; ++j) {
            if (!(w[j] < thresh)) continue;
            w[j] = 0.0;
        }
        SVD.svdbksb(u, w, v, y, a);
        double chisq = 0.0;
        for (int k = 0; k < y[0].length; ++k) {
            for (i = 0; i < y.length; ++i) {
                double sum = 0.0;
                for (j = 0; j < funcs.length; ++j) {
                    sum += a[j][k] * funcs[j].calculate(x[i]);
                }
                double tmp = y[i][k] - sum;
                chisq += tmp * tmp;
            }
        }
        return Math.sqrt(chisq / (double)(y.length * y[0].length));
    }

    public static void svdbksb(double[][] u, double[] w, double[][] v, double[][] b, double[][] x) {
        int m = u.length;
        int n = u[0].length;
        double[] temp = new double[n];
        for (int k = 0; k < b[0].length; ++k) {
            double s;
            int j;
            for (j = 0; j < n; ++j) {
                s = 0.0;
                if (w[j] != 0.0) {
                    for (int i = 0; i < m; ++i) {
                        s += u[i][j] * b[i][k];
                    }
                    s /= w[j];
                }
                temp[j] = s;
            }
            for (j = 0; j < n; ++j) {
                s = 0.0;
                for (int jj = 0; jj < n; ++jj) {
                    s += v[j][jj] * temp[jj];
                }
                x[j][k] = s;
            }
        }
    }

    public static void svdcmp(double[][] a, double[] w, double[][] v) {
        int j;
        double h;
        double f;
        int k;
        double s;
        int i;
        int l = 0;
        int nm = 0;
        int m = a.length;
        int n = a[0].length;
        double[] rv1 = new double[n];
        double anorm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        for (i = 0; i < n; ++i) {
            l = i + 2;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m) {
                for (k = i; k < m; ++k) {
                    scale += Math.abs(a[k][i]);
                }
                if (scale != 0.0) {
                    for (k = i; k < m; ++k) {
                        double[] dArray = a[k];
                        int n2 = i;
                        dArray[n2] = dArray[n2] / scale;
                        s += a[k][i] * a[k][i];
                    }
                    f = a[i][i];
                    g = -SVD.SIGN(Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][i] = f - g;
                    for (j = l - 1; j < n; ++j) {
                        s = 0.0;
                        for (k = i; k < m; ++k) {
                            s += a[k][i] * a[k][j];
                        }
                        f = s / h;
                        for (k = i; k < m; ++k) {
                            double[] dArray = a[k];
                            int n3 = j;
                            dArray[n3] = dArray[n3] + f * a[k][i];
                        }
                    }
                    for (k = i; k < m; ++k) {
                        double[] dArray = a[k];
                        int n4 = i;
                        dArray[n4] = dArray[n4] * scale;
                    }
                }
            }
            w[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i + 1 <= m && i + 1 != n) {
                for (k = l - 1; k < n; ++k) {
                    scale += Math.abs(a[i][k]);
                }
                if (scale != 0.0) {
                    for (k = l - 1; k < n; ++k) {
                        double[] dArray = a[i];
                        int n5 = k;
                        dArray[n5] = dArray[n5] / scale;
                        s += a[i][k] * a[i][k];
                    }
                    f = a[i][l - 1];
                    g = -SVD.SIGN(Math.sqrt(s), f);
                    h = f * g - s;
                    a[i][l - 1] = f - g;
                    for (k = l - 1; k < n; ++k) {
                        rv1[k] = a[i][k] / h;
                    }
                    for (j = l - 1; j < m; ++j) {
                        s = 0.0;
                        for (k = l - 1; k < n; ++k) {
                            s += a[j][k] * a[i][k];
                        }
                        for (k = l - 1; k < n; ++k) {
                            double[] dArray = a[j];
                            int n6 = k;
                            dArray[n6] = dArray[n6] + s * rv1[k];
                        }
                    }
                    k = l - 1;
                    while (k < n) {
                        double[] dArray = a[i];
                        int n7 = k++;
                        dArray[n7] = dArray[n7] * scale;
                    }
                }
            }
            anorm = SVD.MAX(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0) {
                    for (j = l; j < n; ++j) {
                        v[j][i] = a[i][j] / a[i][l] / g;
                    }
                    for (j = l; j < n; ++j) {
                        s = 0.0;
                        for (k = l; k < n; ++k) {
                            s += a[i][k] * v[k][j];
                        }
                        for (k = l; k < n; ++k) {
                            double[] dArray = v[k];
                            int n8 = j;
                            dArray[n8] = dArray[n8] + s * v[k][i];
                        }
                    }
                }
                for (j = l; j < n; ++j) {
                    v[j][i] = 0.0;
                    v[i][j] = 0.0;
                }
            }
            v[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = SVD.MIN(m, n) - 1;
        while (i >= 0) {
            l = i + 1;
            g = w[i];
            for (j = l; j < n; ++j) {
                a[i][j] = 0.0;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                for (j = l; j < n; ++j) {
                    s = 0.0;
                    for (k = l; k < m; ++k) {
                        s += a[k][i] * a[k][j];
                    }
                    f = s / a[i][i] * g;
                    for (k = i; k < m; ++k) {
                        double[] dArray = a[k];
                        int n9 = j;
                        dArray[n9] = dArray[n9] + f * a[k][i];
                    }
                }
                for (j = i; j < m; ++j) {
                    double[] dArray = a[j];
                    int n10 = i;
                    dArray[n10] = dArray[n10] * g;
                }
            } else {
                for (j = i; j < m; ++j) {
                    a[j][i] = 0.0;
                }
            }
            double[] dArray = a[i];
            int n11 = i--;
            dArray[n11] = dArray[n11] + 1.0;
        }
        block27: for (k = n - 1; k >= 0; --k) {
            for (int its = 0; its < 30; ++its) {
                double z;
                double y;
                double c;
                boolean flag = true;
                for (l = k; l >= 0; --l) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) + anorm == anorm) break;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    for (i = l; i < k + 1; ++i) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) + anorm == anorm) break;
                        g = w[i];
                        w[i] = h = SVD.pythag(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        for (j = 0; j < m; ++j) {
                            y = a[j][nm];
                            z = a[j][i];
                            a[j][nm] = y * c + z * s;
                            a[j][i] = z * c - y * s;
                        }
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!(z < 0.0)) continue block27;
                    w[k] = -z;
                    for (j = 0; j < n; ++j) {
                        v[j][k] = -v[j][k];
                    }
                    continue block27;
                }
                if (its == 29) {
                    // empty if block
                }
                double x = w[l];
                nm = k - 1;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = SVD.pythag(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + SVD.SIGN(g, f)) - h)) / x;
                s = 1.0;
                c = 1.0;
                for (j = l; j <= nm; ++j) {
                    int jj;
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = SVD.pythag(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    for (jj = 0; jj < n; ++jj) {
                        x = v[jj][j];
                        z = v[jj][i];
                        v[jj][j] = x * c + z * s;
                        v[jj][i] = z * c - x * s;
                    }
                    w[j] = z = SVD.pythag(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    for (jj = 0; jj < m; ++jj) {
                        y = a[jj][j];
                        z = a[jj][i];
                        a[jj][j] = y * c + z * s;
                        a[jj][i] = z * c - y * s;
                    }
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w[k] = x;
            }
        }
    }

    public static int MIN(int m, int n) {
        return m < n ? m : n;
    }

    public static double MAX(double a, double b) {
        return a > b ? a : b;
    }

    public static double SIGN(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    public static double pythag(double a, double b) {
        double absb;
        double absa = Math.abs(a);
        if (absa > (absb = Math.abs(b))) {
            return absa * Math.sqrt(1.0 + absb / absa * (absb / absa));
        }
        return absb == 0.0 ? 0.0 : absb * Math.sqrt(1.0 + absa / absb * (absa / absb));
    }
}

